/*  -*-objc-*-
 *  FileWatchers.m: Implementation of the GWorkspace (FileWatchers) Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "GWorkspace.h"
#include "FileOperation.h"
#include "Watchers/Watcher.h"
#include "Dialogs/Dialogs.h"
#include "Inspectors/InspectorsWin.h"
#include "Processes/Processes.h"
#include "Finder/Finder.h"
#include "Preferences/PreferencesWin.h"
#include "Fiend/Fiend.h"
#include "Viewers/ViewersWindow.h"
#include "Desktop/DesktopWindow.h"
#include "Desktop/DesktopView.h"
#include "Functions.h"
#include "GNUstep.h"

@implementation GWorkspace (FileWatchers)

- (void)addWatcherForPath:(NSString *)path
{
  Watcher *watcher = [self watcherForPath: path];
	  
  if ((watcher != nil) && ([watcher isOld] == NO)) { 
    [watcher addListener];   
    return;
  } else {
		NSTimer *timer = [NSTimer scheduledTimerWithTimeInterval: 1.0 
												target: self selector: @selector(watcherTimeOut:) 
																								userInfo: path repeats: YES];
		[watchTimers addObject: timer];
																								
  	watcher = [[Watcher alloc] initForWatchAtPath: path];      
  	[watchers addObject: watcher];
  	RELEASE (watcher);  
	}
}

- (void)removeWatcherForPath:(NSString *)path
{
  Watcher *watcher = [self watcherForPath: path];
	
  if ((watcher != nil) && ([watcher isOld] == NO)) {
  	[watcher removeListener];   
  }
}

- (void)removeWatcher:(Watcher *)awatcher
{
	NSString *watchedPath = [awatcher watchedPath];
	NSTimer *timer = [self timerForPath: watchedPath];

	if (timer && [timer isValid]) {
		[timer invalidate];
		[watchTimers removeObject: timer];
	}
	
	[watchers removeObject: awatcher];
}

- (Watcher *)watcherForPath:(NSString *)path
{
  int i;

  for (i = 0; i < [watchers count]; i++) {
    Watcher *watcher = [watchers objectAtIndex: i];    
    if ([watcher isWathcingPath: path]) { 
      return watcher;
    }
  }
  
  return nil;
}

- (NSTimer *)timerForPath:(NSString *)path
{
	int i;

  for (i = 0; i < [watchTimers count]; i++) {
		NSTimer *t = [watchTimers objectAtIndex: i];    
	
		if (([t isValid]) && ([(NSString *)[t userInfo] isEqual: path])) {
			return t;
		}
	}
	
	return nil;
}

- (void)watcherTimeOut:(id)sender
{
	NSString *watchedPath = (NSString *)[sender userInfo];
	
	if (watchedPath != nil) {
		Watcher *watcher = [self watcherForPath: watchedPath];
	
		if (watcher != nil) {
			if ([watcher isOld]) {
				[self removeWatcher: watcher];
			} else {
				[watcher watchFile];
			}
		}
	}
}

@end





