 /*
 *  IconsPanel.h: Interface and declarations for the IconsPanel Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef ICONSPANEL_H
#define ICONSPANEL_H

#import <AppKit/NSView.h>

@class NSString;
@class NSMutableString;
@class NSArray;
@class NSMutableArray;
@class NSNotification;
@class NSFileManager;

@interface IconsPanel : NSView 
{
  id delegate;
  NSString *currentPath;

	NSMutableArray *icons; 
	BOOL isDragTarget;
  BOOL isShiftClick;
  int iconsperrow;
  int cellsWidth;
  
  NSMutableString *keysBuff;
  
  NSFileManager *fm;
}

- (id)initAtPath:(NSString *)path
        delegate:(id)adelegate;

- (void)setPath:(NSString *)path;

- (NSString *)currentPath;

- (void)makeFileIcons;

- (void)selectIconsWithPaths:(NSArray *)paths;

- (void)removeIconsWithNames:(NSArray *)names;

- (void)cellsWidthChanged:(NSNotification *)notification;

- (void)selectAllIcons;

- (void)selectNextIcon;

- (void)selectPrevIcon;

- (void)selectIconInNextLine;

- (void)selectIconInPrevLine;

- (void)selectIconWithPrefix:(NSString *)prefix;

- (void)addCharToKeysBuff:(char)c;

- (void)clearKeysBuff:(id)sender;

- (void)addIconWithPaths:(NSArray *)iconpaths;

- (void)removeIcon:(id)anIcon;

- (void)setLabelRectOfIcon:(id)anIcon;

- (void)unselectOtherIcons:(id)anIcon;

- (void)setShiftClick:(BOOL)value;

- (void)setCurrentSelection:(NSArray *)paths;

- (void)openCurrentSelection:(NSArray *)paths newViewer:(BOOL)newv;

- (NSArray *)currentSelection;

- (NSPoint)locationOfIconWithName:(NSString *)name;

- (int)cellsWidth;

- (id)delegate;

- (void)setDelegate:(id)anObject;

@end

@interface IconsPanel (DraggingDestination)

- (unsigned int)draggingEntered:(id <NSDraggingInfo>)sender;

- (unsigned int)draggingUpdated:(id <NSDraggingInfo>)sender;

- (void)draggingExited:(id <NSDraggingInfo>)sender;

- (BOOL)prepareForDragOperation:(id <NSDraggingInfo>)sender;

- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender;

- (void)concludeDragOperation:(id <NSDraggingInfo>)sender;

@end

//
// Methods Implemented by the Delegate 
//

@interface NSObject (IconsPanelDelegateMethods)

- (void)setTheSelectedPaths:(id)paths;

- (void)openTheCurrentSelection:(id)paths newViewer:(BOOL)newv;

- (void)performFileOperationWithDictionary:(id)opdict;

- (int)sortTypeForDirectoryAtPath:(id)path;

- (NSString *)getTrashPath;

- (int)getIconViewCellsWidth;

@end

//
// IconsViewerIcon Delegate Methods
//

@interface IconsPanel (IconsViewerIconDelegateMethods)

- (int)getCellsWidth;

- (void)setLabelFrameOfIcon:(id)aicon;

- (void)unselectIconsDifferentFrom:(id)aicon;

- (void)setShiftClickValue:(BOOL)value;

- (void)setTheCurrentSelection:(id)paths;

- (NSArray *)getTheCurrentSelection;

- (void)openTheCurrentSelection:(id)paths newViewer:(BOOL)newv;

- (void)performFileOperationWithDictionary:(id)opdict;

- (NSString *)getTrashPath;

@end

#endif // ICONSPANEL_H

