/*
 *  Finder.h: Interface and declarations for the Finder Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef FINDER_H
#define FINDER_H

#import <Foundation/NSObject.h>
#import <AppKit/NSView.h>

@class NSString;
@class NSArray;
@class NSTask;
@class NSPipe;
@class NSNotification;
@class NSWindow;
@class NSPanel;
@class NSSplitView;
@class FinderShelf;
@class NSButton;
@class NSTextField;
@class NSPopUpButton;
@class NSScrollView;
@class NSMatrix;
@class GWorkspace;

@interface ControlsView : NSView
{}
@end

@interface FileIconView : NSView
{
  NSImage *icon, *highlightImage;
  NSTextField *nameField;
  BOOL isactive;
}

- (void)activateForFileAtPath:(NSString *)fpath;

- (void)deactivate;

@end

@interface Finder : NSObject 
{
  NSPanel *fWin;
  NSSplitView *split;
  FinderShelf *shelf;
  ControlsView *controlsView;
  NSButton *findButt; 
  NSTextField *findField;
  NSPopUpButton *findPopUp; 
  FileIconView *fileIconView;
  NSScrollView *scrollView;
  NSMatrix *foundMatrix;
  NSArray *currentSelection;
  NSArray *fullFoundPaths;
  NSString *infoString;
  NSTask *task;
  NSPipe *pipe;
  GWorkspace *gw;
}

- (void)activate;

- (void)adjustSubviews;

- (void)startFind:(id)sender;

- (void)dataFromTask:(NSNotification *)notification;

- (void)endOfTask:(NSNotification *)notification;

- (void)popUpAction:(id)sender;

- (void)choseFile:(id)sender;

- (void)openFile:(id)sender;

- (void)emptyFoundMatrix;

- (void)updateDefaults;

- (NSWindow *)myWin;

- (void)updateInfoString;

- (NSString *)infoString;

@end

#endif // FINDER_H

