/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef PIXMAPWIDGET_H
#define PIXMAPWIDGET_H

// Qt includes
#include <qwidgetstack.h>

class KConfig;

class FullScreenView;
class GVPixmap;
class ScrollPixmapView;


class PixmapView : public QWidgetStack {
Q_OBJECT
	QPixmap mPixmap;
	ScrollPixmapView* mScrollPixmapView;
	FullScreenView* mFullScreenView;
	bool mFullScreen;

public:
	PixmapView(QWidget* parent,GVPixmap*);
	~PixmapView();

	void readConfig(KConfig*,const QString&);
	void writeConfig(KConfig*,const QString&) const;

// Accessors
	const QPixmap& pixmap() const { return mPixmap; }
	FullScreenView* fullScreenView() const { return mFullScreenView; }
	ScrollPixmapView* scrollPixmapView() const { return mScrollPixmapView; }

public slots:
	void setFullScreen(bool);

signals:
	void selectPrevious();
	void selectNext();
	void escapePressed(); // Currently only emitted in fullscreen mode
};


#endif
