/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef DIRVIEWITEM_H
#define DIRVIEWITEM_H

// Qt includes
#include <qlistview.h>

// KDE includes
#include <kfileitem.h>
#include <kurl.h>


class DirView;


class DirViewItem : public QListViewItem {
public:
	DirViewItem(DirView* folderWidget, const QString& label);
	DirViewItem(DirView* folderWidget, QListViewItem* parent, const QString& label);

	void initExpandable();
	void setIsDropTarget(bool);

// Overriden from QListViewItem
	void setOpen(bool);
	void paintCell(QPainter *, const QColorGroup &, int column, int width, int align);

// Accessors
	DirViewItem* find(const QString& label) const;
	virtual QString folder() const=0;
	virtual const KURL& url() const=0;

protected:
	bool mIsDropTarget;
	DirView* mDirView;
};




class RootDirViewItem : public DirViewItem {
public:
	RootDirViewItem(DirView* folderWidget, const QString& label)
		: DirViewItem(folderWidget,label) {}

	QString folder() const { return "/"; }
	const KURL& url() const;
};




class SubDirViewItem : public DirViewItem {
public:
	SubDirViewItem(DirView* folderWidget,QListViewItem* parent,const QString& label, KFileItem* item)
		: DirViewItem(folderWidget, parent, label), mFileItem(item) {}

// Accessors
	KFileItem* fileItem() const { return mFileItem; }
	QString folder() const { return mFileItem->url().path(); }
	const KURL& url() const { return mFileItem->url(); }

// Refresh the label according to the url
	void refreshLabel();

private:
	KFileItem* mFileItem;
};


#endif
