/* this file implements Gnometoaster's native mp3 functionality.
 * Currently, this functionality is limited to calculating the
 * tracksize of mp3 files with special emphasis put on it's ability
 * to deliver the tracksize in bytes of raw audio data in
 * 16bit/44.1khz/stereo and the capability to estimate the playing
 * time of broken mp3 files and variable bitrate mp3s.
 * To accomplish those goals, this function scans through the whole
 * mp3 file which is quite naturally taking longer than other methods
 * of mp3 playing time calculation */

#ifndef MP3FUNC_H
#define MP3FUNC_H

unsigned int mp3func_playingtime_rawbytes(char *filename);
#define mp3func_playingtime_seconds(filename) \
   mp3func_playingtime_rawbytes(filename)/(44100*4)

#endif // MP3FUNC_H   
   
