/* The Gtk Implementation of Gnometoasters menu system */

#include "int.h"

#include <gtk/gtk.h>

#include "main.h"
#include "menusys.h"

GtkWidget *menusys_buildmenu(menusys_menu *menu,gpointer data);

/* if data !=NULL,data will be handed down to the callback functions instead
 * of what is defined within their menu structure */
GtkWidget *menusys_item(menusys_menu *menu,gpointer data)
{
	GtkWidget *item;

        char *withoutunderscore = helpings_removecharacters(_(menu->title),'_');
	item=gtk_menu_item_new_with_label(withoutunderscore);
        free(withoutunderscore);
	if (menu->callback==NULL)
	    gtk_menu_item_set_submenu(GTK_MENU_ITEM(item),
				      menusys_buildmenu(menu->data,data));
	else	    
	    gtk_signal_connect(GTK_OBJECT(item),"activate",
			       GTK_SIGNAL_FUNC(menu->callback),
			       (data!=NULL)?data:menu->data);
	gtk_widget_show(item);
	return item;
}
;

/* if data !=NULL,data will be handed down to the callback functions instead
 * of what is defined within their menu structure */
GtkWidget *menusys_buildmenu(menusys_menu *menu,gpointer data)
{
	GtkWidget *menuw;
	GtkWidget *item;
	int x;
	
	menuw=gtk_menu_new();
	for (x=0;menu[x].title!=NULL;x++)
	  {
		  
		  item=menusys_item(&menu[x],data);
		  gtk_menu_append(GTK_MENU(menuw),
				  item);
	  }
	;
	return menuw;
}
;	

void menusys_setmenubar(menusys_menu *menu)
{
	GtkWidget *menubar;
	GtkWidget *item;
	int x;
	
	menubar=gtk_menu_bar_new();
	for (x=0;menu[x].title!=NULL;x++)
	  {
		  
		  item=menusys_item(&menu[x],NULL);
		  gtk_menu_bar_append(GTK_MENU_BAR(menubar),
				      item);
	  }
	;
	gtk_widget_show(menubar);
	gtk_box_pack_start(GTK_BOX(surroundings),
			   menubar,0,0,0);
}
;	

void menusys_popuphandler(GtkWidget *w,GdkEventButton *event,gpointer data)
{
	if (event->button==3)
	  {
		  gtk_menu_popup(GTK_MENU(data),
				 NULL,NULL,
				 NULL,NULL,
				 3,0);
	  }
	;
}
;

void menusys_setpopuphandler(GtkWidget*w,GtkWidget*m)
{
	gtk_signal_connect(GTK_OBJECT(w),"button_press_event",
			   GTK_SIGNAL_FUNC(menusys_popuphandler),(gpointer)m);
}
;
			   
void menusys_attachpopupmenu(GtkWidget *w,menusys_menu *m,gpointer data)
{
	menusys_setpopuphandler(w,menusys_buildmenu(m,data));
}
;

void menusys_dopopup(menusys_menu *m,gpointer data)
{
   gtk_menu_popup(GTK_MENU(menusys_buildmenu(m,data)),
		  NULL,NULL,
		  NULL,NULL,
		  3,0);
};
