#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>

#include "main.h"
#include "dndsetup.h"
#include "selectlist.h"
#include "filelist.h"
#include "dirlow.h"
#include "helpings.h"
#include "menusys.h"
#include "colors.h"
#include "vfs.h"
#include "getdir.h"
#include "preview.h"
#include "fileman.h"

/* uncomment for debugging */
// #define DEBUG

const char *filelist_headings[]=
{
   N_("Filename"),
   "",
     N_("Filesize"),
   NULL
};

int filelist_doubleclickfile(char *s,
			     char *p,
			     fileman_mkdircall mkdir,
			     fileman_addfilecall addfile,
			     gpointer data)
{
   filelist_info *info=(filelist_info*)data;
   char *filename=strdup(s);
   vfs_filesystem *fs=vfs_parseuri(s,filename);
   int isdir=0;
#ifdef DEBUG
   printf("filelist_doubleclickfile: vfs=%p,filename=%s\n",fs,filename);
#endif   
   if (vfs_islink(fs,filename))
     {
	char *ld=vfs_getlinkdestination(fs,filename);
	if (ld)
	  {
	     if (vfs_isdirectory(fs,ld))
	       isdir=1;
	     free(ld);
	  };
     };
   if (vfs_isdirectory(fs,filename))
     isdir=1;
   if (isdir)
     {
	char *dirname=helpings_rpathcomponent(filename);
	getdir_selectsubdir(GTK_WIDGET(info->treeentry),dirname);
	free(dirname);
     }
   else
     preview_playtrack(s,&preview_info);
   free(filename);
   return 1;
};

void filelist_doubleclick(selectlist_info *info,gpointer data)
{
   fileman_selectionhandler(selectlist_getselection(info),
			    NULL,filelist_doubleclickfile,
			    NULL,NULL,data);
};

static int filelist_resize(GtkWidget *column,
			   GtkAllocation *alloc,
			   gpointer data)
{
#ifdef DEBUG
   printf ("filelist_resize: got resize event for clist\n");
#endif
   /* current column configuration:
    * 85% Filename, 50 pixels "<DIR>", 10% Filesize */
   gtk_clist_set_column_width(GTK_CLIST(column),0,
			      (int)((float)(alloc->width-150)*0.85));
   gtk_clist_set_column_width(GTK_CLIST(column),1,50);
   gtk_clist_set_column_width(GTK_CLIST(column),2,
			      (int)((float)(alloc->width-100)*0.10));

   return TRUE;
};

void filelist_keyboardcommands(GtkWidget *widget, GdkEventKey *event, gpointer data)
{
   if ((event->keyval==GDK_Escape)&&data)
     {
	filelist_info *info=(filelist_info*)data;
	if (info->treeentry)
	  getdir_selectparentdir(GTK_WIDGET(info->treeentry));
     };
};

void filelist_focus(GtkContainer *container, int nth)
{
   GList *child = gtk_container_children(container);
   while (child&&(nth>0))
     {
	child=child->next;
	--nth;
     };
   if (child)
     gtk_container_set_focus_child(container,GTK_WIDGET(child->data));
};

filelist_info *filelist_create(char *path,
			       vfs_filesystem *fs,
			       selectlist_dropcallback drophandler,
			       int send,
			       menusys_menu *popup,
			       GtkTreeItem *treeentry,
			       GtkSignalFunc doubleclick
			       )
{
   filelist_info *fi;
   GtkWidget *column;
   char header[1024];

   int dir;

   char *file[3];
   char fsbuf[25];

   fi=(filelist_info*)malloc(sizeof(filelist_info));
   strcpy(fi->path,path);
   fi->fs=fs;

   fi->treeentry=treeentry;
   fi->entries=0;

   fi->widget=gtk_scrolled_window_new(NULL,NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(fi->widget),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);
   strcpy(header,"");

   fi->selectlistinfo=selectlist_info_create(header,
					     -1,
					     drophandler,
					     send,
					     popup,
					     ((doubleclick)
					      ?doubleclick
					      :filelist_doubleclick),
					     fi,
					     filelist_headings);
   column=selectlist_create(fi->selectlistinfo,
			    3);       /* create 3 columns*/

   gtk_signal_connect(GTK_OBJECT(column),"size_allocate",
		      GTK_SIGNAL_FUNC(filelist_resize),NULL);
   gtk_signal_connect(GTK_OBJECT(column),"key_press_event",
		      GTK_SIGNAL_FUNC(filelist_keyboardcommands),fi);

   gtk_clist_set_selection_mode(GTK_CLIST(column),GTK_SELECTION_EXTENDED);

   gtk_clist_set_column_justification(GTK_CLIST(column),
				      0,
				      GTK_JUSTIFY_LEFT);
   gtk_clist_set_column_justification(GTK_CLIST(column),
				      1,
				      GTK_JUSTIFY_CENTER);
   gtk_clist_set_column_justification(GTK_CLIST(column),
				      2,
				      GTK_JUSTIFY_RIGHT);

   file[2]=fsbuf;

#ifdef DEBUG
   printf ("filelist: showing directory %s\n",path);
#endif
   dir=vfs_opendir(fs,path);
   if (dir)
     {
	char *name;
#ifdef DEBUG
	printf("filelist: opened directory, now trying to read it\n");
#endif	
	while ((name=vfs_readdirentry(fs,dir))!=NULL)
	  {
	     vfs_direntry *entry=vfs_filestat(fs,name,0);
#ifdef DEBUG
	     printf("filelist: + %s\n",
		    name);
#endif	     
	     if (entry)
	       {
		  char *uri=NULL;

		  char *destination=NULL;
		  if ((entry->islink)&&(destination=vfs_getlinkdestination(fs,name)))
		    {
		       file[0]=(char*)malloc(sizeof(entry->name)+sizeof(destination)+sizeof(" -> ")+2);
		       sprintf(file[0],"@%s -> %s",entry->name,destination);
		    }
		  else
		    file[0]=entry->name;
		  file[1]=entry->isdir?"<DIR>":"";
		  helpings_formatnumber(file[2],sizeof(fsbuf),
					entry->filesize);

		  gtk_clist_append(GTK_CLIST(column),file);

		  uri=vfs_buildvfsuri(fs,name);

		  gtk_clist_set_row_data(GTK_CLIST(column),fi->entries,uri);

		  if (entry->islink)
		    gtk_clist_set_foreground(GTK_CLIST(column),
					     fi->entries,
					     &Red);
		  
		  if (entry->is_reference)
		    gtk_clist_set_foreground(GTK_CLIST(column),
					     fi->entries,
					     &Blue);

		  if (destination)
		    {
		       free(file[0]);
		       free(destination);
		    };

		  ++fi->entries;
		  free(entry);
	       };
	     free(name);
	  }
	;
	vfs_closedir(fs,dir);
     }
   ;

   /* Sort the list. First by name, then by <DIR>/!<DIR> */
   gtk_clist_set_sort_column (GTK_CLIST(column),0);
   gtk_clist_sort (GTK_CLIST(column));
   gtk_clist_set_sort_column (GTK_CLIST(column),1);
   gtk_clist_set_sort_type (GTK_CLIST(column), 1);
   gtk_clist_sort (GTK_CLIST(column));

   gtk_widget_show(column);
   gtk_container_add(GTK_CONTAINER(fi->widget),column); /* Damn the Documentation.
							 * Quite difficult - Documentation is nonexistant */
   filelist_focus(GTK_CONTAINER(column),1);
   
   return fi;
}
;

void filelist_clear(filelist_info *fi)
{
   int i;

   gtk_clist_unselect_all(GTK_CLIST(fi->selectlistinfo->self));
   for (i=0;i<fi->entries;i++)
     {
	gpointer uri=gtk_clist_get_row_data(fi->selectlistinfo->self,i);
	if (uri)
	  free(uri);
     };
};

void filelist_destroy(filelist_info *fi)
{
   filelist_clear(fi);
   gtk_widget_destroy(fi->widget);
   selectlist_info_destroy(fi->selectlistinfo);
   free(fi);
}
;
