/*  grecover
 *  Copyright (C) 1999, 2000 by Tom Pycke <Tom.Pycke@advalvas.be>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include "grecover.h"
#include "ui.h"

extern inode *get_inodes (char *device);
extern void strtoupper (char *str);
extern FILE* get_output (char *command);
void *dump_where(int matches);

char	*ask_device,
    *ask_year,
    *ask_month,
    *month_eg,
    *ask_weekd,
    *weekd_eg,
    *ask_day1,
    *ask_day2,
    *ask_minsize,
    *ask_maxsize,
    *ask_hour1,
    *ask_hour2,
    *ask_min1,
    *ask_min2,
    *ask_id,
    *ask_dump,
    *ask_refilter;

GtkWidget *device_entry;
GtkWidget *month_combo;
GtkWidget *weekd_combo;
GtkWidget *year_scale;
GtkObject *year_adj;
GtkWidget *minday_scale;
GtkObject *minday_adj;
GtkWidget *maxday_scale;
GtkObject *maxday_adj;
GtkWidget *minhour_scale;
GtkObject *minhour_adj;
GtkWidget *maxhour_scale;
GtkObject *maxhour_adj;
GtkWidget *minmin_scale;
GtkObject *minmin_adj;
GtkWidget *maxmin_scale;
GtkObject *maxmin_adj;
GtkWidget *id_entry;
GtkWidget *msgdlg;
GtkWidget *msg_label;
GtkWidget *okbut;
GtkWidget *minsize_entry;
GtkWidget *maxsize_entry;


char device_list[10][9]= { "/dev/hda", "/dev/hdb", "/dev/hdc", "/dev/hdd", "/dev/sda", "/dev/sdb", "/dev/sdc", "/dev/sdd", "/dev/sde", "/dev/sdf" };


inode *firstinode;
inode_list *startinode;
char *gdevice;

extern int num_del_inodes;

int chcmp (char *a, char *b)
{
    if (a[0]==b[0] && a[1]==b[1] && a[2]==b[2])
    return 0;
    return 1;
}

int
filter_inode (	inode * firstinode,
    inode_list * inodestart,
    int userid,
    int minsize,
    int maxsize,
    char *month,
    char *weekd,
    int minday,
    int maxday,
    int minhour,
    int maxhour,
    int minmin,
    int maxmin,
    int minsec,
    int maxsec,
    int year )
{
    int x,
    count = 0;
    inode *cur_inode;
    inode_list	*nextstart = inodestart,
	*thisstart = inodestart;

    cur_inode = firstinode;
#ifdef DEBUG
    if (strlen (cur_inode->month)!=3)
    {
    printf ("memory error\n");
    }
#endif
    for (x = 0; cur_inode != NULL; x++)
    {
    if ((cur_inode->UID != userid && userid != -1) ||
    cur_inode->size < minsize ||
    cur_inode->size > maxsize ||
    (chcmp (cur_inode->month, month) != 0 &&
     chcmp (month, "-1") != 0) ||
    (chcmp (cur_inode->weekd, weekd) != 0 &&
     chcmp (weekd, "-1") != 0) ||
    cur_inode->day < minday ||
    cur_inode->day > maxday ||
    cur_inode->hour < minhour ||
    cur_inode->hour > maxhour ||
    cur_inode->min < minmin ||
    cur_inode->min > maxmin ||
    cur_inode->sec < minsec ||
    cur_inode->sec > maxsec ||
    (cur_inode->year != year && year != -1))
    {
    }
    else
    {
/*  printf ("=> %d %d %s %s %d %d:%d:%d %d\n",
	cur_inode->number,
	cur_inode->size,
	cur_inode->month,
	cur_inode->weekd,
	cur_inode->day,
	cur_inode->hour,
	cur_inode->min,
	cur_inode->sec,
	cur_inode->year);*/
    thisstart->next_inode = nextstart;
    thisstart = nextstart;
    thisstart->number = cur_inode->number;
    thisstart->mem_location = cur_inode;
    thisstart->next_inode = NULL;
    nextstart = new inode_list;
    count++;
    }
    cur_inode = cur_inode->next_inode;
    }
    return count;
}


void get_inodes_first (char *device)
{
    int matches, id, year1;
    char *month = (char *)malloc (9), *weekd = (char*)malloc (9);
    startinode = new inode_list;
    gdevice = (char*)malloc(18);
    strcpy (gdevice ,gtk_entry_get_text (GTK_ENTRY(device_entry)));
    firstinode = get_inodes (gdevice);

    gtk_widget_destroy (msgdlg);
    id = atoi (gtk_entry_get_text (GTK_ENTRY(id_entry)));
    if (gtk_entry_get_text (GTK_ENTRY (id_entry))==NULL ||
    gtk_entry_get_text (GTK_ENTRY (id_entry))[0]=='\0')
    id = -1;
    strcpy(month,gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(month_combo)->entry)));
    strtoupper (month);
    if (strcmp (month, "UNKNOWN") == 0)
    {
    month[0] = '-'; month[1] = '1'; month[2] = '\0';
    }
    strcpy(weekd,gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(weekd_combo)->entry)));
    strtoupper (weekd);
    if (strcmp (weekd, "UNKNOWN") == 0)
    {
    weekd[0] = '-'; weekd[1] = '1'; weekd[2] = '\0';
    }
    year1 = int(GTK_ADJUSTMENT(year_adj)->value);
    if (year1 == 1980)
    year1 = -1;
    printf ("#: %d\n", num_del_inodes);
    printf ("id: %d   month: %s   weekd: %s", id, month, weekd);
    printf ("\nminday: %d   maxday: %d, minhour: %d, maxhour: %d",
    int(GTK_ADJUSTMENT(minday_adj)->value),
    int(GTK_ADJUSTMENT(maxday_adj)->value),
    int(GTK_ADJUSTMENT(minhour_adj)->value),
    int(GTK_ADJUSTMENT(maxhour_adj)->value));
    printf ("\nminmin: %d, maxmin: %d, year: %d",
    int(GTK_ADJUSTMENT(minmin_adj)->value),
    int(GTK_ADJUSTMENT(maxmin_adj)->value), year1);
    
    matches = filter_inode (firstinode, startinode,
    id,
    atoi (gtk_entry_get_text (GTK_ENTRY(minsize_entry))),
    atoi (gtk_entry_get_text (GTK_ENTRY(maxsize_entry))), month, weekd,
    int(GTK_ADJUSTMENT(minday_adj)->value),
    int(GTK_ADJUSTMENT(maxday_adj)->value),
    int(GTK_ADJUSTMENT(minhour_adj)->value),
    int(GTK_ADJUSTMENT(maxhour_adj)->value),
    int(GTK_ADJUSTMENT(minmin_adj)->value),
    int(GTK_ADJUSTMENT(maxmin_adj)->value),
    0, 60, year1);
//  inode_start = startinode;
    printf ("\n%d\n", matches);
    if (matches == 0 || startinode == NULL)
    prn_error ("Sorry, no matches found!", "Results");
    else
    dump_where (matches);
}
  
GtkWidget *dir_ui;
GtkWidget *direntry;

void on_dump_clicked ()
{
    int inode_numb;
    FILE *tmp;
    char *command = (char*) malloc (256);
    char *directory = (char *) malloc (128);
    strcpy (directory, gtk_entry_get_text (GTK_ENTRY (direntry)));
    gtk_widget_destroy (dir_ui);
    inode_list *tmp_inode;
    if (startinode != NULL)
    {
      printf ("\n%s\n", directory);
//    scanf ("%125s", &dir);
      //    sprintf (command, "mkdir %s &> /dev/null", directory);
      //    tmp = popen (command, "r");
      //    pclose (tmp);

    mkdir (directory, S_IRUSR | S_IWUSR);
    tmp_inode=startinode;

     for (;tmp_inode!=NULL; tmp_inode=tmp_inode->next_inode)
     {
    //printf ("=> %d\n", startinode->number);
    inode_numb=tmp_inode->number;
    sprintf (command, "debugfs %s -R \'dump <%d> %s/dump%d\' > /dev/null &> /dev/null",
	gdevice, inode_numb, directory, inode_numb);
//  printf ("-> %s\n", command);
    printf ("\nDumping inode %d to %s", inode_numb, directory);
    tmp = get_output (command);
    wait ((void *)0);
    fclose (tmp);
    sprintf (command, "%s/dump%d", directory, inode_numb);
    // restore the original user and mode (if possible)
    chown (command, tmp_inode->mem_location->UID, 0);
    chmod (command, tmp_inode->mem_location->mode);
    }


    /*	for (;startinode!=NULL; startinode=startinode->next_inode)
    {
	inode_numb=startinode->number;
	printf ("Dumping inode %d...\n", inode_numb);

	sprintf (command, "debugfs %s -R \'dump <%d> %s/dump%d\'",
	    gdevice, inode_numb, directory, inode_numb);

	tmp = get_output (command);
	wait ((void *)0);
	fclose (tmp);
	sprintf (command, "%s/dump%d", directory, inode_numb);
	chown (command, startinode->mem_location->UID, 0);
	chmod (command, startinode->mem_location->mode);
    */
    }

}

void *dump_where(int matches)
{
    char *dir = (char *) malloc (128);
    char *question = (char *)malloc (128);
  GtkWidget *vbox;
  GtkWidget *label1;

  GtkWidget *ok;

  dir_ui = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (dir_ui), "dir_ui", dir_ui);
  gtk_window_set_title (GTK_WINDOW (dir_ui), "Dump where?");
  gtk_window_set_policy (GTK_WINDOW (dir_ui), TRUE, TRUE, FALSE);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (dir_ui), "vbox", vbox);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (dir_ui), vbox);
sprintf (question, "%d %s", matches, ask_dump);
  label1 = gtk_label_new (question);
  gtk_object_set_data (GTK_OBJECT (dir_ui), "label1", label1);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox), label1, TRUE, TRUE, 0);

  direntry = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (dir_ui), "direntry", direntry);
  gtk_widget_show (direntry);
  gtk_box_pack_start (GTK_BOX (vbox), direntry, TRUE, TRUE, 0);
  
  ok = gtk_button_new_with_label ("Dump it!");
  gtk_object_set_data (GTK_OBJECT (dir_ui), "ok", ok);
  gtk_widget_show (ok);
  gtk_box_pack_start (GTK_BOX (vbox), ok, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok), "clicked",
      GTK_SIGNAL_FUNC (on_dump_clicked),
      NULL);
  gtk_widget_show (dir_ui);
  
}

void
on_findit_clicked      (GtkButton   *button,
    gpointer	 user_data)
{
  GtkWidget *dialog_vbox1;
  GtkWidget *error_label;
  GtkWidget *dialog_action_area1;

  msgdlg = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (msgdlg), "msgdlg", msgdlg);
  GTK_WINDOW (msgdlg)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_title (GTK_WINDOW (msgdlg), "Message");
  gtk_window_set_policy (GTK_WINDOW (msgdlg), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (msgdlg)->vbox;
  gtk_object_set_data (GTK_OBJECT (msgdlg), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  msg_label = gtk_label_new ("	I'm going to fetch the inodes!	");
  gtk_object_set_data (GTK_OBJECT (msgdlg), "msg_label", msg_label);
  gtk_widget_show (msg_label);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), msg_label, TRUE, TRUE, 10);

  dialog_action_area1 = GTK_DIALOG (msgdlg)->action_area;
  gtk_object_set_data (GTK_OBJECT (msgdlg), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  okbut = gtk_button_new_with_label ("OK");
  gtk_object_set_data (GTK_OBJECT (msgdlg), "okbut", okbut);
  gtk_widget_show (okbut);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), okbut, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (okbut), "clicked",
      GTK_SIGNAL_FUNC(get_inodes_first), NULL);
  gtk_widget_show (msgdlg);
    
//tmp = prn_error ("Please wait while fetching inodes...", "Message");
//  gtk_widget_show (tmp);
//  get_inodes (gtk_entry_get_text (GTK_ENTRY(device_entry)));
  //	printf ("%s\n" , gtk_entry_get_text (GTK_ENTRY(device_entry)));
  //	printf ("%s\n" , gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(month_combo)->entry)));
  //	printf ("%d\n", int(GTK_ADJUSTMENT(year_adj)->value));

}

void print_uid(GtkWidget *list)
{
    char name[100], number[50];
    int x, y, z, temp;
    char login[]="Name", uid[]="User ID", line[]="----------------------";
    char *val[1][2];
    FILE *passwd_file;
    passwd_file = fopen ("/etc/passwd", "r");
    for (x=0;temp!=EOF;x++)
    {
    for (y=0;temp!=EOF && y<3;y++)
    {
    temp = getc(passwd_file);
    for (z=0;temp!=EOF && temp!=':';z++)
    {
    if (y==0)
    name[z] = temp;
    else if (y==2)
    number[z]=temp;
    temp = getc(passwd_file);
    }
    if (y==0)
    name[z] = 0;
    else if (y==2)
    number[z] = 0;
    }
    for (; temp!='\n' && temp!=EOF;)
    temp = getc (passwd_file);
    val[0][1] = name;
    val[0][0] = number;
    gtk_clist_append ((GtkCList*)list, val[0]);

//    printf ("%12s : %s\t|", name, number);
    if (x%3==2)
    printf("\n");
    temp=getc(passwd_file);
    if (temp==EOF)
    break;
    ungetc (temp, passwd_file);
    }
    fclose (passwd_file);
    printf ("\n");
}

int print_devices(GtkWidget *list)
{
/*  char tmp[128], *dev[2][1];
    int y1,y2,id, count=0;
    FILE *file = popen ("fdisk -l", "r");
    dev[1][0]=malloc (18);
    for (;;)
    {
    if (fgets (tmp, 126, file) == NULL || tmp[0] == EOF)
    {
    pclose(file); 
    return 0;
    }
    if (tmp[0] == '/')
    {
    sscanf (tmp, "%s%8c%d %d %s %d\n", dev[1][0],&tmp,&y1,&y2,&tmp,&id);
    if (id == 83)
    {
    gtk_clist_append ((GtkCList*)list, dev[1]);
    count++;
    }
    }
    }
    if (count == 0)
    prn_error ("No valid devices found; are you a privileged user?\n");
    pclose (file);*/
    char    *tmp=(char*) malloc(125),
	*buf=(char*) malloc(101),
	ext2_fs[256][10],
	ext2_fs_root[256][100],
	fs_type[20];
    int count=0,
    part,
    dev,
    ext2_fs_count=0,
    counter=1;
    FILE *file;
    printf ("Scanning devices...\n");
    
    file = fopen ("/etc/fstab", "r");
    for (;counter!= EOF;)
    {
    counter=fscanf (file, "%s%s%s", &ext2_fs[ext2_fs_count],
		&ext2_fs_root[ext2_fs_count], &fs_type);
    if (strcmp (fs_type, "ext2") == 0)
	ext2_fs_count++;
//  printf ("%s\n", ext2_fs[ext2_fs_count]);
    }
    fclose (file);

    for (dev=0; dev<10; dev++)
    for (part=0;part<15;part++)
    {
	sprintf (tmp,"%s%d", device_list[dev], part);
	file = fopen (tmp, "r");
	if (file == NULL)
	continue;
	if (fread (buf, 99, 1, file)!=1)
	continue;
	gtk_clist_append ((GtkCList*)list, &tmp);
	//	   printf ("%s: Valid partition", tmp);
    /*	    for (counter=0; counter<=ext2_fs_count; counter++)
	{
	if (strcmp (tmp, ext2_fs[counter]) == 0)
	  //printf ("	type: ext2  mount point: %s", ext2_fs_root[counter]);
	}*/
	count++;
	//printf ("\n");
    }
    if (count == 0)
    prn_error ("No valid standard devices found; are you a privileged user?\n");
    free (tmp);
    free (buf);
    if (file != NULL)
    fclose (file);
    printf ("done\n");

}


GtkWidget*
get_widget     (GtkWidget   *widget,
    gchar   *widget_name)
{
  GtkWidget *found_widget;

  if (widget->parent)
    widget = gtk_widget_get_toplevel (widget);
  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
       widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}

/* This is an internally used function to set notebook tab widgets. */
void
set_notebook_tab       (GtkWidget   *notebook,
    gint     page_num,
    GtkWidget	*widget)
{
  GtkNotebookPage *page;
  GtkWidget *notebook_page;

  page = (GtkNotebookPage*) g_list_nth (GTK_NOTEBOOK (notebook)->children, page_num)->data;
  notebook_page = page->child;
  gtk_widget_ref (notebook_page);
  gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
  gtk_notebook_insert_page (GTK_NOTEBOOK (notebook), notebook_page,
    widget, page_num);
  gtk_widget_unref (notebook_page);
}

GtkWidget*
create_recover_ui ()
{
  GtkWidget *recover_ui;
  GtkWidget *vbox2;
  GtkWidget *vbox3;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *hseparator1;
  GtkWidget *vbox4;
  GtkWidget *list1;
  GtkWidget *device_label;
  GtkWidget *vbox5;
  GtkWidget *year_label;
  GtkWidget *vbox6;
  GtkWidget *month_label;

  GList *month_combo_items = NULL;
  GtkWidget *vbox7;
  GtkWidget *weekd_label;
  GList *weekd_combo_items = NULL;
  GtkWidget *vbox8;
  GtkWidget *minday_label;
  GtkWidget *vbox9;
  GtkWidget *maxday_label;
  GtkWidget *vbox10;
  GtkWidget *minhour_label;
  GtkWidget *vbox11;
  GtkWidget *maxhour_label;
  GtkWidget *vbox12;
  GtkWidget *minmin_label;
  GtkWidget *vbox13;
  GtkWidget *maxmin_label;
  GtkWidget *vbox14;
  GtkWidget *id_label;
  GtkWidget *minsize_label;
  GtkWidget *maxsize_label;
  GtkWidget *id_list;
  GtkWidget *hseparator2;
  GtkWidget *hbox1;
  GtkWidget *quit;
  GtkWidget *findit;
  GtkWidget *year_unknown;
  GtkWidget *scroll;
  GtkWidget *scroll2;
  GtkWidget *hboxtxt;
  GtkWidget *mainwindow;
  GtkWidget *scrollbox;
  GtkWidget *mainvbox;
  GtkWidget *q_frame;

  mainwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (mainwindow), "mainwindow", mainwindow);
  gtk_signal_connect (GTK_OBJECT (mainwindow), "delete_event",
      GTK_SIGNAL_FUNC (on_recover_ui_destroy_event),
      NULL);
  gtk_window_set_title (GTK_WINDOW (mainwindow), "Recover");
  gtk_window_set_policy (GTK_WINDOW (mainwindow), TRUE, TRUE, FALSE);
 

  mainvbox = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (mainwindow), "mainvbox", mainvbox);
  gtk_widget_show (mainvbox);
  gtk_container_add (GTK_CONTAINER (mainwindow), mainvbox);


/*  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox3", vbox3);
  gtk_widget_show (vbox3);
  gtk_box_pack_start (GTK_BOX (mainvbox), vbox3, TRUE, TRUE, 0);*/

  label1 = gtk_label_new ("GtkRecover V0.2 based on recover-1.0a");
  gtk_object_set_data (GTK_OBJECT (mainvbox), "label1", label1);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (mainvbox), label1, TRUE, FALSE, 0);

  label2 = gtk_label_new ("(C) 1999, 2000 by Tom Pycke");
  gtk_object_set_data (GTK_OBJECT (mainvbox), "label2", label2);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (mainvbox), label2, TRUE, FALSE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (mainvbox), "hseparator1", hseparator1);
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (mainvbox), hseparator1, TRUE, TRUE, 5);


 


  q_frame = gtk_frame_new (" Filter parameters: ");
  gtk_object_set_data (GTK_OBJECT (mainvbox), "q_frame", q_frame);
  gtk_widget_show (q_frame);
  gtk_container_add (GTK_CONTAINER (mainvbox), q_frame);
//  gtk_box_pack_start (GTK_BOX (mainvbox), q_frame, TRUE, FALSE, 5);
  gtk_container_border_width (GTK_CONTAINER (q_frame), 5);
  //gtk_frame_set_label_align (GTK_FRAME (q_frame), 0.1, 0.5);
 


  scrollbox = gtk_scrolled_window_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (q_frame/*mainvbox*//*mainwindow*/), "scrollbox", scrollbox);
  gtk_widget_set_usize (scrollbox, 300,200);
  gtk_widget_show (scrollbox);
    gtk_container_add (GTK_CONTAINER (/*mainwindow*//*mainvbox*/q_frame), scrollbox);
//  gtk_box_pack_start (GTK_BOX (vbox3), scrollbox, TRUE, FALSE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrollbox), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
  
  recover_ui = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (scrollbox), "recover_ui", recover_ui);
  gtk_widget_show (recover_ui);
  gtk_widget_set_usize (scrollbox, 600,350);
  gtk_scrolled_window_add_with_viewport (
	      GTK_SCROLLED_WINDOW (scrollbox), recover_ui);
//  gtk_container_add (GTK_CONTAINER (scrollbox), recover_ui);
/*  recover_ui = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "recover_ui", recover_ui);
  gtk_signal_connect (GTK_OBJECT (recover_ui), "delete_event",
      GTK_SIGNAL_FUNC (on_recover_ui_destroy_event),
      NULL);
  gtk_window_set_title (GTK_WINDOW (recover_ui), "Recover");
  gtk_window_set_policy (GTK_WINDOW (recover_ui), TRUE, TRUE, FALSE);*/

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox2", vbox2);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (recover_ui), vbox2);

/*  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox3", vbox3);
  gtk_widget_show (vbox3);
  gtk_box_pack_start (GTK_BOX (vbox2), vbox3, TRUE, TRUE, 0);

  label1 = gtk_label_new ("GtkRecover V0.2 based on recover-1.0a");
  gtk_object_set_data (GTK_OBJECT (recover_ui), "label1", label1);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox3), label1, TRUE, TRUE, 0);

  label2 = gtk_label_new ("(C) 1999, 2000 by Tom Pycke");
  gtk_object_set_data (GTK_OBJECT (recover_ui), "label2", label2);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox3), label2, TRUE, TRUE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (recover_ui), "hseparator1", hseparator1);
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox3), hseparator1, TRUE, TRUE, 0);*/

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox4", vbox4);
  gtk_widget_show (vbox4);
  gtk_box_pack_start (GTK_BOX (vbox2), vbox4, TRUE, TRUE, 0);

  device_label = gtk_label_new (ask_device);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "device_label", device_label);
  gtk_widget_show (device_label);
  gtk_box_pack_start (GTK_BOX (vbox4), device_label, TRUE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (device_label), 1, 0);

  device_entry = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (recover_ui), "device_entry", device_entry);
  gtk_widget_show (device_entry);
  gtk_box_pack_start (GTK_BOX (vbox4), device_entry, TRUE, TRUE, 0);

  scroll2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll2),
      GTK_POLICY_AUTOMATIC,
      GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize (scroll2, 100,52);
  gtk_box_pack_start (GTK_BOX(vbox4), scroll2, FALSE, TRUE, 0);
  gtk_widget_show (scroll2);

  list1 = gtk_clist_new (1);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "list1", list1);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(scroll2),
     list1);
//  gtk_box_pack_start (GTK_BOX (vbox4), list1, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (list1), 3);
  gtk_signal_connect (GTK_OBJECT (list1), "select_row",
      GTK_SIGNAL_FUNC (on_list1_selection_changed),
      (gpointer) device_entry);
  gtk_widget_show (list1);
  //gtk_clist_append ((GtkCList*)list1, tmp[0]);
  print_devices (list1);
  /*   */

  

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox5", vbox5);
  gtk_widget_show (vbox5);
  gtk_box_pack_start (GTK_BOX (vbox2), vbox5, TRUE, TRUE, 0);


  hboxtxt = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "hboxtxt", hboxtxt);
  gtk_widget_show (hboxtxt);
  gtk_box_pack_start (GTK_BOX (vbox5), hboxtxt, TRUE, TRUE, 0);
  
  year_label = gtk_label_new (ask_year);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "year_label", year_label);
  gtk_widget_show (year_label);
  gtk_box_pack_start (GTK_BOX (hboxtxt), year_label, TRUE, TRUE, 0);
  
  
  year_unknown = gtk_label_new ("(1980 = unknown)");
//  gtk_object_set_data (GTK_OBJECT (recover_ui), "(1980 = unknown)", year_label);
  gtk_widget_show (year_unknown);
  gtk_box_pack_start (GTK_BOX (hboxtxt), year_unknown, TRUE, TRUE, 0);

  year_adj = gtk_adjustment_new (1980, 1980, 2050, 1, 5, 0);
  year_scale = gtk_hscale_new (GTK_ADJUSTMENT (year_adj));
  gtk_scale_set_value_pos (GTK_SCALE (year_scale), GTK_POS_BOTTOM);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "year_scale", year_scale);
  gtk_widget_show (year_scale);
  gtk_box_pack_start (GTK_BOX (vbox5), year_scale, TRUE, TRUE, 0);
  gtk_scale_set_digits (GTK_SCALE (year_scale), 0);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox6", vbox6);
  gtk_widget_show (vbox6);
  gtk_box_pack_start (GTK_BOX (vbox2), vbox6, TRUE, TRUE, 0);

  month_label = gtk_label_new (ask_month);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "month_label", month_label);
  gtk_widget_show (month_label);
  gtk_box_pack_start (GTK_BOX (vbox6), month_label, TRUE, TRUE, 0);

  month_combo = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (recover_ui), "month_combo", month_combo);
  gtk_widget_show (month_combo);
  gtk_box_pack_start (GTK_BOX (vbox6), month_combo, TRUE, TRUE, 0);
  month_combo_items = g_list_append (month_combo_items, (char *)"unknown");
  month_combo_items = g_list_append (month_combo_items, (char *)"Jan");
  month_combo_items = g_list_append (month_combo_items, (char *)"Feb");
  month_combo_items = g_list_append (month_combo_items, (char *)"Mar");
  month_combo_items = g_list_append (month_combo_items, (char *)"Apr");
  month_combo_items = g_list_append (month_combo_items, (char *)"May");
  month_combo_items = g_list_append (month_combo_items, (char *)"Jun");
  month_combo_items = g_list_append (month_combo_items, (char *)"Jul");
  month_combo_items = g_list_append (month_combo_items, (char *)"Aug");
  month_combo_items = g_list_append (month_combo_items, (char *)"Sep");
  month_combo_items = g_list_append (month_combo_items, (char *)"Oct");
  month_combo_items = g_list_append (month_combo_items, (char *)"Nov");
  month_combo_items = g_list_append (month_combo_items, (char *)"Dec");
  gtk_combo_set_popdown_strings (GTK_COMBO (month_combo), month_combo_items);
  g_list_free (month_combo_items);

  vbox7 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox7", vbox7);
  gtk_widget_show (vbox7);
  gtk_box_pack_start (GTK_BOX (vbox2), vbox7, TRUE, TRUE, 0);

  weekd_label = gtk_label_new (ask_weekd);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "weekd_label", weekd_label);
  gtk_widget_show (weekd_label);
  gtk_box_pack_start (GTK_BOX (vbox7), weekd_label, TRUE, TRUE, 0);

  weekd_combo = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (recover_ui), "weekd_combo", weekd_combo);
  gtk_widget_show (weekd_combo);
  gtk_box_pack_start (GTK_BOX (vbox7), weekd_combo, TRUE, TRUE, 0);
  weekd_combo_items = g_list_append (weekd_combo_items, (char *)"unknown");
  weekd_combo_items = g_list_append (weekd_combo_items, (char *)"Mon");
  weekd_combo_items = g_list_append (weekd_combo_items, (char *)"Tue");
  weekd_combo_items = g_list_append (weekd_combo_items, (char *)"Wed");
  weekd_combo_items = g_list_append (weekd_combo_items, (char *)"Thu");
  weekd_combo_items = g_list_append (weekd_combo_items, (char *)"Fri");
  weekd_combo_items = g_list_append (weekd_combo_items, (char *)"Sat");
  weekd_combo_items = g_list_append (weekd_combo_items, (char *)"Sun");
  gtk_combo_set_popdown_strings (GTK_COMBO (weekd_combo), weekd_combo_items);
  g_list_free (weekd_combo_items);

  vbox8 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox8", vbox8);
  gtk_widget_show (vbox8);
  gtk_box_pack_start (GTK_BOX (vbox2), vbox8, TRUE, TRUE, 0);

  minday_label = gtk_label_new (ask_day1);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "minday_label", minday_label);
  gtk_widget_show (minday_label);
  gtk_box_pack_start (GTK_BOX (vbox8), minday_label, TRUE, TRUE, 0);

  minday_adj = gtk_adjustment_new (1, 1, 31, 1, 5, 0); 
  minday_scale = gtk_hscale_new (GTK_ADJUSTMENT (minday_adj));
  gtk_scale_set_value_pos (GTK_SCALE (minday_scale), GTK_POS_BOTTOM);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "minday_scale", minday_scale);
  gtk_widget_show (minday_scale);
  gtk_box_pack_start (GTK_BOX (vbox8), minday_scale, TRUE, TRUE, 0);
  gtk_scale_set_digits (GTK_SCALE (minday_scale), 0);

  vbox9 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox9", vbox9);
  gtk_widget_show (vbox9);
  gtk_box_pack_start (GTK_BOX (vbox2), vbox9, TRUE, TRUE, 0);

  maxday_label = gtk_label_new (ask_day2);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "maxday_label", maxday_label);
  gtk_widget_show (maxday_label);
  gtk_box_pack_start (GTK_BOX (vbox9), maxday_label, TRUE, TRUE, 0);

  maxday_adj = gtk_adjustment_new (31, 1, 31, 1, 5, 0);
  maxday_scale = gtk_hscale_new(GTK_ADJUSTMENT (maxday_adj));
  gtk_scale_set_value_pos (GTK_SCALE (maxday_scale), GTK_POS_BOTTOM);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "maxday_scale", maxday_scale);
  gtk_widget_show (maxday_scale);
  gtk_box_pack_start (GTK_BOX (vbox9), maxday_scale, TRUE, TRUE, 0);
  gtk_scale_set_digits (GTK_SCALE (maxday_scale), 0);

  vbox10 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox10", vbox10);
  gtk_widget_show (vbox10);
  gtk_box_pack_start (GTK_BOX (vbox2), vbox10, TRUE, TRUE, 0);

  minhour_label = gtk_label_new (ask_hour1);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "minhour_label", minhour_label);
  gtk_widget_show (minhour_label);
  gtk_box_pack_start (GTK_BOX (vbox10), minhour_label, TRUE, TRUE, 0);

  minhour_adj = gtk_adjustment_new (0, 0, 23, 1, 5, 0);
  minhour_scale = gtk_hscale_new (GTK_ADJUSTMENT (minhour_adj));
  gtk_scale_set_value_pos (GTK_SCALE (minhour_scale), GTK_POS_BOTTOM);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "minhour_scale", minhour_scale);
  gtk_widget_show (minhour_scale);
  gtk_box_pack_start (GTK_BOX (vbox10), minhour_scale, TRUE, TRUE, 0);
  gtk_scale_set_digits (GTK_SCALE (minhour_scale), 0);

  vbox11 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox11", vbox11);
  gtk_widget_show (vbox11);
  gtk_box_pack_start (GTK_BOX (vbox2), vbox11, TRUE, TRUE, 0);

  maxhour_label = gtk_label_new (ask_hour2);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "maxhour_label", maxhour_label);
  gtk_widget_show (maxhour_label);
  gtk_box_pack_start (GTK_BOX (vbox11), maxhour_label, TRUE, TRUE, 0);

  maxhour_adj = gtk_adjustment_new (23, 0, 23, 0, 0, 0);
  maxhour_scale = gtk_hscale_new (GTK_ADJUSTMENT (maxhour_adj));
  gtk_scale_set_value_pos (GTK_SCALE (maxhour_scale), GTK_POS_BOTTOM);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "maxhour_scale", maxhour_scale);
  gtk_widget_show (maxhour_scale);
  gtk_box_pack_start (GTK_BOX (vbox11), maxhour_scale, TRUE, TRUE, 0);
  gtk_scale_set_digits (GTK_SCALE (maxhour_scale), 0);

  vbox12 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox12", vbox12);
  gtk_widget_show (vbox12);
  gtk_box_pack_start (GTK_BOX (vbox2), vbox12, TRUE, TRUE, 0);

  minmin_label = gtk_label_new (ask_min1);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "minmin_label", minmin_label);
  gtk_widget_show (minmin_label);
  gtk_box_pack_start (GTK_BOX (vbox12), minmin_label, TRUE, TRUE, 0);

  minmin_adj = gtk_adjustment_new (0, 0, 59, 0, 0, 0);
  minmin_scale = gtk_hscale_new (GTK_ADJUSTMENT (minmin_adj));
  gtk_scale_set_value_pos (GTK_SCALE (minmin_scale), GTK_POS_BOTTOM);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "minmin_scale", minmin_scale);
  gtk_widget_show (minmin_scale);
  gtk_box_pack_start (GTK_BOX (vbox12), minmin_scale, TRUE, TRUE, 0);
  gtk_scale_set_digits (GTK_SCALE (minmin_scale), 0);

  vbox13 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox13", vbox13);
  gtk_widget_show (vbox13);
  gtk_box_pack_start (GTK_BOX (vbox2), vbox13, TRUE, TRUE, 0);

  maxmin_label = gtk_label_new (ask_min2);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "maxmin_label", maxmin_label);
  gtk_widget_show (maxmin_label);
  gtk_box_pack_start (GTK_BOX (vbox13), maxmin_label, TRUE, TRUE, 0);

  maxmin_adj = gtk_adjustment_new (59, 0, 59, 0, 0, 0);
  maxmin_scale = gtk_hscale_new (GTK_ADJUSTMENT (maxmin_adj));
  gtk_scale_set_value_pos (GTK_SCALE (maxmin_scale), GTK_POS_BOTTOM);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "maxmin_scale", maxmin_scale);
  gtk_widget_show (maxmin_scale);
  gtk_box_pack_start (GTK_BOX (vbox13), maxmin_scale, TRUE, TRUE, 0);
  gtk_scale_set_digits (GTK_SCALE (maxmin_scale), 0);

  minsize_label = gtk_label_new (ask_minsize);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "minsize_label", minsize_label);
  gtk_widget_show (minsize_label);
  gtk_box_pack_start (GTK_BOX (vbox13), minsize_label, TRUE, TRUE, 0);

  minsize_entry = gtk_entry_new();
  gtk_entry_set_text (GTK_ENTRY(minsize_entry), "0");
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox13", vbox13);
  gtk_widget_show (minsize_entry);
  gtk_box_pack_start (GTK_BOX (vbox13), minsize_entry, FALSE, TRUE, 0);
  
  maxsize_label = gtk_label_new (ask_maxsize);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "maxsize_label", maxsize_label);
  gtk_widget_show (maxsize_label);
  gtk_box_pack_start (GTK_BOX (vbox13), maxsize_label, TRUE, TRUE, 0);

  maxsize_entry = gtk_entry_new();
  gtk_entry_set_text (GTK_ENTRY(maxsize_entry), "2147483640");
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox13", vbox13);
  gtk_widget_show (maxsize_entry);
  gtk_box_pack_start (GTK_BOX (vbox13), maxsize_entry, FALSE, TRUE, 0);

  vbox14 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "vbox14", vbox14);
  gtk_widget_show (vbox14);
  gtk_box_pack_start (GTK_BOX (vbox2), vbox14, FALSE, TRUE, 0);

  id_label = gtk_label_new (ask_id);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "id_label", id_label);
  gtk_widget_show (id_label);
  gtk_box_pack_start (GTK_BOX (vbox14), id_label, TRUE, TRUE, 0);
  
  id_entry = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (recover_ui), "id_entry", id_entry);
  gtk_box_pack_start (GTK_BOX (vbox14), id_entry, TRUE, TRUE, 0);
  gtk_widget_show (id_entry);
  
  gchar *titles[2]={"UID","Name"};

  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
      GTK_POLICY_AUTOMATIC,
      GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize (scroll, 150,80);
  gtk_box_pack_start (GTK_BOX(vbox14), scroll, FALSE, TRUE, 0);
  gtk_widget_show (scroll);

  id_list = gtk_clist_new_with_titles (2, titles);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "id_list", id_list);
  gtk_container_border_width (GTK_CONTAINER (id_list), 3);
  gtk_signal_connect (GTK_OBJECT (id_list), "select_row",
      GTK_SIGNAL_FUNC (on_list_selection_changed),
      (gpointer) id_entry);
//  gtk_box_pack_start (GTK_BOX (vbox14), id_list, FALSE, TRUE , 0);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(scroll),
     id_list);

  gtk_clist_set_column_width (GTK_CLIST(id_list),0,100);
  gtk_widget_show (id_list);
  print_uid (id_list);
/*  id_combo = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (recover_ui), "id_combo", id_combo);
  gtk_widget_show (id_combo);
  gtk_box_pack_start (GTK_BOX (vbox14), id_combo, TRUE, TRUE, 0);*/

  hseparator2 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (recover_ui), "hseparator2", hseparator2);
  gtk_widget_show (hseparator2);
  gtk_box_pack_start (GTK_BOX (vbox2), hseparator2, TRUE, TRUE, 0);
  
  hseparator1 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (mainvbox), "hseparator1", hseparator1);
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (mainvbox), hseparator1, TRUE, TRUE, 7);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (recover_ui), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (mainvbox), hbox1, TRUE, TRUE, 0);

  quit = gtk_button_new_with_label ("Quit");
  gtk_object_set_data (GTK_OBJECT (recover_ui), "quit", quit);
  gtk_widget_show (quit);
  gtk_box_pack_start (GTK_BOX (hbox1), quit, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (quit), "clicked",
      GTK_SIGNAL_FUNC (quit_clicked),
      NULL);

  findit = gtk_button_new_with_label ("Find it");
  gtk_object_set_data (GTK_OBJECT (recover_ui), "findit", findit);
  gtk_widget_show (findit);
  gtk_box_pack_start (GTK_BOX (hbox1), findit, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (findit), "clicked",
      GTK_SIGNAL_FUNC (on_findit_clicked),
      NULL);

  gtk_widget_show (mainwindow);

  return recover_ui;
}

GtkWidget*
prn_error (char *errortxt, char *title = "ERROR", int quit=0)
{
  GtkWidget *error;
  GtkWidget *dialog_vbox1;
  GtkWidget *error_label;
  GtkWidget *dialog_action_area1;
  GtkWidget *ok;

  error = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (error), "error", error);
  GTK_WINDOW (error)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_title (GTK_WINDOW (error), title);
  gtk_window_position (GTK_WINDOW (error), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (error), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (error)->vbox;
  gtk_object_set_data (GTK_OBJECT (error), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  error_label = gtk_label_new (errortxt);
  gtk_object_set_data (GTK_OBJECT (error), "error_label", error_label);
  gtk_widget_show (error_label);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), error_label, TRUE, TRUE, 10);

  dialog_action_area1 = GTK_DIALOG (error)->action_area;
  gtk_object_set_data (GTK_OBJECT (error), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  ok = gtk_button_new_with_label ("OK");
  gtk_object_set_data (GTK_OBJECT (error), "ok", ok);
  gtk_widget_show (ok);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), ok, TRUE, TRUE, 0);
  if (quit)
      gtk_signal_connect (GTK_OBJECT (ok), "clicked",
      GTK_SIGNAL_FUNC (quit_clicked), error);
  else
      gtk_signal_connect (GTK_OBJECT (ok), "clicked",
      GTK_SIGNAL_FUNC (on_ok_clicked), error);
  gtk_widget_show (error);

  return error;
}


    
