/***************************************************************************
                          ball.cpp  -  description
                             -------------------
    begin                : Tue Jan 8 2002
    copyright            : (C) 1999-2002 by Jacques Fortier & Brian Ashe
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ball.h"

class Point2D;

int udt, udb, udl, udr;

void update_dirty(int ludl, int ludr, int ludt, int ludb)
{
	if(ludl > ludr)
	{
		int temp = ludl;
		ludl = ludr; ludr = temp;
	}
	if(ludt > ludb)
	{
		int temp = ludt;
		ludt = ludb; ludb = temp;
	}
	if(udl == -1)
	{
		udl = ludl; udr = ludr;
		udt = ludt; udb = ludb;
	}
	else
	{
		if(ludl < udl) udl = ludl;
		if(ludr > udr) udr = ludr;
		if(ludt < udt) udt = ludt;
		if(ludb > udb) udb = ludb;
	}
}

Ball::Ball(void){
	vel.dx = 0;
	vel.dy = 0;
	radius = diam = 0;
}

Ball::Ball (double x, double y, int d, GdkColor *c, bool isq = false, bool ise = false, bool isn = false, bool isso = false, bool isst = false) : Point2D(x, y), vel(0, 0), bnc(0, 0), tvec(0, 0) {
	radius = (diam = d) / 2;
	clr = c;
	is_cue = isq; is_eight = ise;
	picture = (GdkPixmap *)NULL;
	ball_num = 15;
}

Ball::Ball (double x, double y, int d, int bn, GdkPixmap *pixmap, GdkBitmap *c_bmp, GdkPixmap *b_pixmap, GdkBitmap *b_clip_bmp, bool isq = false, bool ise = false, bool isn = false, bool isso = false, bool isst = false) : Point2D(x, y), vel(0, 0), bnc(0, 0), tvec(0, 0) {
	radius = (diam = d) / 2;
	clr = (GdkColor *)NULL;
	is_cue = isq; is_eight = ise;
	picture = pixmap;
	clip_bmp = c_bmp;
	big_picture = b_pixmap;
	big_clip_bmp = b_clip_bmp;
	ball_num = bn;
}

bool Ball::moving () {
	return vel.dx != 0  ||  vel.dy != 0;
}

void Ball::decel (double val) {
	if (val >= vel.mag())
		vel.setVec(0, 0);
	else
		vel.subVec(tvec.setVec(vel).unitVec().mulVec(val));
}

double Ball::pathIntercept (Ball b) {
	double d = radius + b.radius;
	double ddx = vel.dx - b.vel.dx;
	double ddy = vel.dy - b.vel.dy;
	double dx = x - b.x;
	double dy = y - b.y;
	double A = ddx * ddx + ddy * ddy;
	double B = 2 * (dx * ddx + dy * ddy);
	double C = dx * dx + dy * dy - d * d;
	return (-B - sqrt(B * B - 4 * A * C)) / (2 * A);
}

void Ball::collide (Ball *b, double COLLIDE_DRAG = 0.95) {
	// Calculate collision in b's reference frame
	vel.subVec(b->vel);
	double mv = vel.mag();
	Vec2D v12(*this, *b); v12.unitVec();
	Vec2D v1c(vel); v1c.unitVec();
	double cos = v1c.dotProd(v12);
	v12.mulVec(cos * mv);
	vel.subVec(v12);
	vel.addVec(b->vel);
	b->vel.addVec(v12);
	b->vel.dx *= COLLIDE_DRAG;
	b->vel.dy *= COLLIDE_DRAG;
	vel.dx *= COLLIDE_DRAG;
	vel.dy *= COLLIDE_DRAG;
}

double Ball::edgeIntercept (GdkRectangle table) {
	if (vel.dx >= 0)
		hCol = (table.width + table.x - x - radius) / vel.dx;
	else
		hCol = (table.x - x + radius) / vel.dx;
	if (vel.dy >= 0)
		vCol = (table.height + table.y - y - radius) / vel.dy;
	else
		vCol = (table.y - y + radius) / vel.dy;
	if(vel.dx == 0)
		return vCol;
	if(vel.dy == 0)
		return hCol;
	return hCol <= vCol ? hCol : vCol;
}

void Ball::bounce (double t, double BUMPER_DRAG = 0.8) {
	if (t == hCol)
		vel.dx = -vel.dx;
	if (t == vCol)
		vel.dy = -vel.dy;
	vel.dx *= BUMPER_DRAG; vel.dy *= BUMPER_DRAG;
}

void Ball::move (double t) {
	if (moving())
	{
		// move the ball, then update the dirty rectangle
		int oldx = int(x), oldy = int(y);
		int newx, newy;
//		int newx, newy, ludl, ludr, ludt, ludb;
		addPos(vel.copy().mulVec(t));
		newx = int(x); newy = int(y);
		if(newx != oldx || newy != oldy) // ie, ball has moved perceptibly
		{
/*			ludl = oldx < newx ? oldx : newx; ludl -= (BALL_SIZE / 2 + 0.5);
			ludr = oldx > newx ? oldx : newx; ludr += (BALL_SIZE / 2 + 0.5);
			ludt = oldy < newy ? oldy : newy; ludt -= (BALL_SIZE / 2 + 0.5);
			ludb = oldy > newy ? oldy : newy; ludb += (BALL_SIZE / 2 + 0.5);
			update_dirty(ludl, ludr, ludt, ludb);*/
	
			udl = 29; udr = 751;
			udt = 29; udb = 391;
			//update_dirty(ludl, ludr, ludt, ludb);
		}
	}
}

void Ball::draw (GdkDrawable *pixmap, GdkGC *gc) const {
		if(picture)
		{
			gdk_gc_set_clip_mask(gc, clip_bmp);
			gdk_gc_set_clip_origin(gc, int(x - diam / 2), int(y - diam / 2));
			gdk_draw_pixmap(pixmap, gc, picture, 0, 0, int(x - diam / 2),
			                int (y - diam / 2), BALL_SIZE, BALL_SIZE);
			gdk_gc_set_clip_origin(gc, 0, 0);
			gdk_gc_set_clip_mask(gc, (GdkWindow *)NULL);
		}
		else
		{
			gdk_gc_set_foreground(gc, clr);
			gdk_gc_set_background(gc, clr);
			gdk_draw_arc(pixmap, gc, 1, int(x - radius), int(y - radius),
			             diam, diam, 0, 360 * 64);
		}
}

void Ball::shoot (Point2D ptr) {
	vel.setVec((x - ptr.x) / 5, (y - ptr.y) / 5);
}

bool Ball::touches (int mx, int my) {
	return Point2D(mx, my).dist(*this) < radius;
}

Ball::~Ball(){
}
