/* ----------------------------------------------------------------------------
 * session.c 
 * Functions to integrate GtkPbbuttons into GNOME session management
 * This will also work with KDE.
 * 
 * GtkPbbuttons
 * Daemon to put the Apple Powerbook special keys into action.
 * This version has an GTK interface and needs X.
 *
 * Copyright 2004 Sven Herzberg (herzi@gnome-de.org).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef ENABLE_GNOME
#include <unistd.h>
#include <glib.h>
#include <libgnomeui/libgnomeui.h>

#include "session.h"

void
session_init (int argc, char *argv[])
{	
	GnomeClient *sm_client;
	GtkPbArgv *pb_argv = g_new0 (GtkPbArgv, 1);
	
	pb_argv->argc = &argc;
	pb_argv->argv = &argv;
	
	sm_client = gnome_master_client ();
	gnome_client_set_restart_style (sm_client, GNOME_RESTART_ANYWAY);
	g_signal_connect (G_OBJECT(sm_client), "save_yourself",
	                  G_CALLBACK(session_save), pb_argv);
	g_signal_connect (G_OBJECT(sm_client), "die",
	                  G_CALLBACK(session_die), NULL);
}

void
session_die (GnomeClient *client, gpointer user_data)
{
	gtk_main_quit ();
}

gboolean
session_save (GnomeClient *client, int phase, GnomeSaveStyle save_style,
              int end, GnomeInteractStyle interact_style, int fast,
              gpointer user_data)
{
	GtkPbArgv *pb_argv = (GtkPbArgv*)user_data;

	gnome_client_set_clone_command (gnome_master_client(), 1, *(pb_argv->argv));
	gnome_client_set_restart_command (gnome_master_client(), *(pb_argv->argc),
	                                    *(pb_argv->argv));
	return TRUE;
}

#endif /* ENABLE_GNOME */

