// Copyright (C) 2000-2005, Luca Padovani <luca.padovani@cs.unibo.it>.
//
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://helm.cs.unibo.it/mml-widget/, or send a mail to
// <lpadovan@cs.unibo.it>

#include "TFM.hh"

static TFM::Font font = {
"CMBX",

  0xf0,
  "TeX text",
  0x00700000,
  0x661724d8,
  7,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00000000 },
  { 0x02, "space", 0x0006f22e },
  { 0x03, "space_stretch", 0x000368d7 },
  { 0x04, "space_shrink", 0x000245e5 },
  { 0x05, "x_height", 0x00071c72 },
  { 0x06, "quad", 0x0014b609 },
  { 0x07, "extra_space", 0x000245e5 }
};


static TFM::Kerning C_0b_Kerning[] = {
  { 0x21, 0x0001f027 },
  { 0x27, 0x0001f027 },
  { 0x29, 0x0001f027 },
  { 0x3f, 0x0001f027 },
  { 0x5d, 0x0001f027 }
};

static TFM::Kerning C_20_Kerning[] = {
  { 0x4c, 0xfff942a5 },
  { 0x6c, 0xfffa30c5 }
};

static TFM::Kerning C_27_Kerning[] = {
  { 0x21, 0x000245e5 },
  { 0x3f, 0x000245e5 }
};

static TFM::Kerning C_41_Kerning[] = {
  { 0x43, 0xffff6e87 },
  { 0x47, 0xffff6e87 },
  { 0x4f, 0xffff6e87 },
  { 0x51, 0xffff6e87 },
  { 0x54, 0xfffe4b95 },
  { 0x55, 0xffff6e87 },
  { 0x56, 0xfffdba1b },
  { 0x57, 0xfffdba1b },
  { 0x59, 0xfffe4b95 },
  { 0x74, 0xffff6e87 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x41, 0xffff6e87 },
  { 0x56, 0xffff6e87 },
  { 0x57, 0xffff6e87 },
  { 0x58, 0xffff6e87 },
  { 0x59, 0xffff6e87 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x41, 0xfffdba1b },
  { 0x43, 0xffff6e87 },
  { 0x47, 0xffff6e87 },
  { 0x4f, 0xffff6e87 },
  { 0x51, 0xffff6e87 },
  { 0x61, 0xfffe4b95 },
  { 0x65, 0xfffe4b95 },
  { 0x6f, 0xfffe4b95 },
  { 0x72, 0xfffe4b95 },
  { 0x75, 0xfffe4b95 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x49, 0x00009179 }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x43, 0xffff6e87 },
  { 0x47, 0xffff6e87 },
  { 0x4f, 0xffff6e87 },
  { 0x51, 0xffff6e87 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x54, 0xfffe4b95 },
  { 0x56, 0xfffdba1b },
  { 0x57, 0xfffdba1b },
  { 0x59, 0xfffe4b95 }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x41, 0xffff6e87 },
  { 0x56, 0xffff6e87 },
  { 0x57, 0xffff6e87 },
  { 0x58, 0xffff6e87 },
  { 0x59, 0xffff6e87 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x2c, 0xfffe4b95 },
  { 0x2e, 0xfffe4b95 },
  { 0x41, 0xfffe4b95 },
  { 0x61, 0xffff6e87 },
  { 0x65, 0xffff6e87 },
  { 0x6f, 0xffff6e87 }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x43, 0xffff6e87 },
  { 0x47, 0xffff6e87 },
  { 0x4f, 0xffff6e87 },
  { 0x51, 0xffff6e87 },
  { 0x54, 0xfffe4b95 },
  { 0x55, 0xffff6e87 },
  { 0x56, 0xfffdba1b },
  { 0x57, 0xfffdba1b },
  { 0x59, 0xfffe4b95 },
  { 0x74, 0xffff6e87 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x41, 0xfffe4b95 },
  { 0x61, 0xfffe4b95 },
  { 0x65, 0xfffe4b95 },
  { 0x6f, 0xfffe4b95 },
  { 0x72, 0xfffe4b95 },
  { 0x75, 0xfffe4b95 },
  { 0x79, 0xffff6e87 }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x41, 0xfffdba1b },
  { 0x43, 0xffff6e87 },
  { 0x47, 0xffff6e87 },
  { 0x4f, 0xffff6e87 },
  { 0x51, 0xffff6e87 },
  { 0x61, 0xfffe4b95 },
  { 0x65, 0xfffe4b95 },
  { 0x6f, 0xfffe4b95 },
  { 0x72, 0xfffe4b95 },
  { 0x75, 0xfffe4b95 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x41, 0xfffdba1b },
  { 0x43, 0xffff6e87 },
  { 0x47, 0xffff6e87 },
  { 0x4f, 0xffff6e87 },
  { 0x51, 0xffff6e87 },
  { 0x61, 0xfffe4b95 },
  { 0x65, 0xfffe4b95 },
  { 0x6f, 0xfffe4b95 },
  { 0x72, 0xfffe4b95 },
  { 0x75, 0xfffe4b95 }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x43, 0xffff6e87 },
  { 0x47, 0xffff6e87 },
  { 0x4f, 0xffff6e87 },
  { 0x51, 0xffff6e87 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x41, 0xfffe4b95 },
  { 0x61, 0xfffe4b95 },
  { 0x65, 0xfffe4b95 },
  { 0x6f, 0xfffe4b95 },
  { 0x72, 0xfffe4b95 },
  { 0x75, 0xfffe4b95 }
};

static TFM::Kerning C_61_Kerning[] = {
  { 0x6a, 0x000122f2 },
  { 0x76, 0xffff6e87 },
  { 0x77, 0xffff6e87 },
  { 0x79, 0xffff6e87 }
};

static TFM::Kerning C_62_Kerning[] = {
  { 0x63, 0x00009179 },
  { 0x64, 0x00009179 },
  { 0x65, 0x00009179 },
  { 0x6a, 0x000122f2 },
  { 0x6f, 0x00009179 },
  { 0x71, 0x00009179 },
  { 0x76, 0xffff6e87 },
  { 0x77, 0xffff6e87 },
  { 0x78, 0xffff6e87 },
  { 0x79, 0xffff6e87 }
};

static TFM::Kerning C_63_Kerning[] = {
  { 0x68, 0xffff6e87 },
  { 0x6b, 0xffff6e87 }
};

static TFM::Kerning C_66_Kerning[] = {
  { 0x21, 0x0001f027 },
  { 0x27, 0x0001f027 },
  { 0x29, 0x0001f027 },
  { 0x3f, 0x0001f027 },
  { 0x5d, 0x0001f027 }
};

static TFM::Kerning C_67_Kerning[] = {
  { 0x6a, 0x00009179 }
};

static TFM::Kerning C_68_Kerning[] = {
  { 0x62, 0xffff6e87 },
  { 0x74, 0xffff6e87 },
  { 0x75, 0xffff6e87 },
  { 0x76, 0xffff6e87 },
  { 0x77, 0xffff6e87 },
  { 0x79, 0xffff6e87 }
};

static TFM::Kerning C_6b_Kerning[] = {
  { 0x61, 0xfffedd0e },
  { 0x61, 0xffff6e87 },
  { 0x63, 0xffff6e87 },
  { 0x65, 0xffff6e87 },
  { 0x6f, 0xffff6e87 }
};

static TFM::Kerning C_6d_Kerning[] = {
  { 0x62, 0xffff6e87 },
  { 0x74, 0xffff6e87 },
  { 0x75, 0xffff6e87 },
  { 0x76, 0xffff6e87 },
  { 0x77, 0xffff6e87 },
  { 0x79, 0xffff6e87 }
};

static TFM::Kerning C_6e_Kerning[] = {
  { 0x62, 0xffff6e87 },
  { 0x74, 0xffff6e87 },
  { 0x75, 0xffff6e87 },
  { 0x76, 0xffff6e87 },
  { 0x77, 0xffff6e87 },
  { 0x79, 0xffff6e87 }
};

static TFM::Kerning C_6f_Kerning[] = {
  { 0x63, 0x00009179 },
  { 0x64, 0x00009179 },
  { 0x65, 0x00009179 },
  { 0x6a, 0x000122f2 },
  { 0x6f, 0x00009179 },
  { 0x71, 0x00009179 },
  { 0x76, 0xffff6e87 },
  { 0x77, 0xffff6e87 },
  { 0x78, 0xffff6e87 },
  { 0x79, 0xffff6e87 }
};

static TFM::Kerning C_70_Kerning[] = {
  { 0x63, 0x00009179 },
  { 0x64, 0x00009179 },
  { 0x65, 0x00009179 },
  { 0x6a, 0x000122f2 },
  { 0x6f, 0x00009179 },
  { 0x71, 0x00009179 },
  { 0x76, 0xffff6e87 },
  { 0x77, 0xffff6e87 },
  { 0x78, 0xffff6e87 },
  { 0x79, 0xffff6e87 }
};

static TFM::Kerning C_74_Kerning[] = {
  { 0x77, 0xffff6e87 },
  { 0x79, 0xffff6e87 }
};

static TFM::Kerning C_75_Kerning[] = {
  { 0x77, 0xffff6e87 }
};

static TFM::Kerning C_76_Kerning[] = {
  { 0x61, 0xfffedd0e },
  { 0x61, 0xffff6e87 },
  { 0x63, 0xffff6e87 },
  { 0x65, 0xffff6e87 },
  { 0x6f, 0xffff6e87 }
};

static TFM::Kerning C_77_Kerning[] = {
  { 0x61, 0xffff6e87 },
  { 0x63, 0xffff6e87 },
  { 0x65, 0xffff6e87 },
  { 0x6f, 0xffff6e87 }
};

static TFM::Kerning C_79_Kerning[] = {
  { 0x2c, 0xfffe4b95 },
  { 0x2e, 0xfffe4b95 },
  { 0x61, 0xffff6e87 },
  { 0x65, 0xffff6e87 },
  { 0x6f, 0xffff6e87 }
};

static TFM::Ligature C_0b_Ligature[] = {
  { 0x69, 0x00, 0x0e },
  { 0x6c, 0x00, 0x0f }
};

static TFM::Ligature C_21_Ligature[] = {
  { 0x60, 0x00, 0x3c }
};

static TFM::Ligature C_27_Ligature[] = {
  { 0x27, 0x00, 0x22 }
};

static TFM::Ligature C_2d_Ligature[] = {
  { 0x2d, 0x00, 0x7b }
};

static TFM::Ligature C_3f_Ligature[] = {
  { 0x60, 0x00, 0x3e }
};

static TFM::Ligature C_60_Ligature[] = {
  { 0x60, 0x00, 0x5c }
};

static TFM::Ligature C_66_Ligature[] = {
  { 0x66, 0x00, 0x0b },
  { 0x69, 0x00, 0x0c },
  { 0x6c, 0x00, 0x0d }
};

static TFM::Ligature C_7b_Ligature[] = {
  { 0x2d, 0x00, 0x7c }
};


static TFM::Character character[] = {
  { 0x00, 0x000c5fe5, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x01, 0x00112cb2, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x001009c0, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x03, 0x000e5965, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000dc3db, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x00100820, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x06, 0x000ee6ce, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x07, 0x001009c0, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x08, 0x000ee6ce, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x09, 0x001009c0, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0a, 0x000ee6ce, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0b, 0x000c2ff0, 0x000b1c72, 0x00000000, 0x0001f027, 5, C_0b_Kerning, 2, C_0b_Ligature },
  { 0x0c, 0x000b9e77, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0d, 0x000b9e77, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0e, 0x00116db2, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0f, 0x00116db2, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x10, 0x0005cf3b, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x11, 0x000660b5, 0x00071c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x12, 0x000a5b05, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x000a5b05, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x14, 0x000a5b05, 0x000a1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x000a5b05, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x000a5b05, 0x0009b39b, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x17, 0x000f7c57, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x00093812, 0x00000000, 0x0002b8e5, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x000ab39b, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1a, 0x000ee6ce, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x001009c0, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x000a5b05, 0x0008aaab, 0x00018e39, 0x00000000, 0, 0, 0, 0 },
  { 0x1d, 0x00129a69, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1e, 0x0014e04e, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1f, 0x001009c0, 0x000bc16e, 0x0000c71e, 0x00000000, 0, 0, 0, 0 },
  { 0x20, 0x0005cf3b, 0x00071c72, 0x00000000, 0x00000000, 2, C_20_Kerning, 0, 0 },
  { 0x21, 0x00065b05, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 1, C_21_Ligature },
  { 0x22, 0x000aaf89, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x00112cb2, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x24, 0x000a5b05, 0x000c0000, 0x0000e38e, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x00112cb2, 0x000c0000, 0x0000e38e, 0x00000000, 0, 0, 0, 0 },
  { 0x26, 0x001009c0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x27, 0x0005cf3b, 0x000b1c72, 0x00000000, 0x00000000, 2, C_27_Kerning, 1, C_27_Ligature },
  { 0x28, 0x00081520, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x00081520, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x000a5b05, 0x000c0000, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x001009c0, 0x000ad1ae, 0x0002d1ae, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x0005cf3b, 0x00029a69, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x0006f22e, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 1, C_2d_Ligature },
  { 0x2e, 0x0005cf3b, 0x00029a69, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x000a5b05, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x000a5b05, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x000a5b05, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x000a5b05, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x000a5b05, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x000a5b05, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x000a5b05, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x000a5b05, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x000a5b05, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x000a5b05, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x000a5b05, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x0005cf3b, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x0005cf3b, 0x00071c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x00065b05, 0x00080000, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x001009c0, 0x000692f0, 0xfffe92f0, 0x00000000, 0, 0, 0, 0 },
  { 0x3e, 0x0009c98b, 0x00080000, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x0009c98b, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 1, C_3f_Ligature },
  { 0x40, 0x001009c0, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x41, 0x000f7c57, 0x000afa50, 0x00000000, 0x00000000, 10, C_41_Kerning, 0, 0 },
  { 0x42, 0x000ea019, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x43, 0x000ee6ce, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x44, 0x000fc30b, 0x000afa50, 0x00000000, 0x00000000, 5, C_44_Kerning, 0, 0 },
  { 0x45, 0x000d82d7, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x46, 0x000cf15e, 0x000afa50, 0x00000000, 0x00000000, 10, C_46_Kerning, 0, 0 },
  { 0x47, 0x00102f22, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x48, 0x00100820, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x49, 0x0007ab79, 0x000afa50, 0x00000000, 0x00000000, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x000aa5c9, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4b, 0x00100dd0, 0x000afa50, 0x00000000, 0x00000000, 4, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000c5fe5, 0x000afa50, 0x00000000, 0x00000000, 4, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x001370f7, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4e, 0x00100820, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4f, 0x000f7df7, 0x000afa50, 0x00000000, 0x00000000, 5, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000e0ea0, 0x000afa50, 0x00000000, 0x00000000, 6, C_50_Kerning, 0, 0 },
  { 0x51, 0x000f7df7, 0x000afa50, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x52, 0x000f5bd5, 0x000afa50, 0x00000000, 0x00000000, 10, C_52_Kerning, 0, 0 },
  { 0x53, 0x000b7df7, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x54, 0x000e5b05, 0x000afa50, 0x00000000, 0x00000000, 7, C_54_Kerning, 0, 0 },
  { 0x55, 0x000fc23b, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x56, 0x000f7c57, 0x000afa50, 0x00000000, 0x000048be, 10, C_56_Kerning, 0, 0 },
  { 0x57, 0x00152b12, 0x000afa50, 0x00000000, 0x000048be, 10, C_57_Kerning, 0, 0 },
  { 0x58, 0x000f7c57, 0x000afa50, 0x00000000, 0x00000000, 4, C_58_Kerning, 0, 0 },
  { 0x59, 0x000f7c57, 0x000afa50, 0x00000000, 0x000082ee, 6, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000ca0e9, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5b, 0x0005d2f9, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x000aaf89, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x0005d2f9, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x000a5b05, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x0005cf3b, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x0005cf3b, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 1, C_60_Ligature },
  { 0x61, 0x000a1247, 0x00071c72, 0x00000000, 0x00000000, 4, C_61_Kerning, 0, 0 },
  { 0x62, 0x000b7df7, 0x000b1c72, 0x00000000, 0x00000000, 10, C_62_Kerning, 0, 0 },
  { 0x63, 0x00093812, 0x00071c72, 0x00000000, 0x00000000, 2, C_63_Kerning, 0, 0 },
  { 0x64, 0x000b7df7, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x65, 0x00097a50, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x66, 0x000660b5, 0x000b1c72, 0x00000000, 0x0001f027, 5, C_66_Kerning, 3, C_66_Ligature },
  { 0x67, 0x000a5b05, 0x00071c72, 0x00031c72, 0x000048be, 1, C_67_Kerning, 0, 0 },
  { 0x68, 0x000b7df7, 0x000b1c72, 0x00000000, 0x00000000, 6, C_68_Kerning, 0, 0 },
  { 0x69, 0x0005cf3b, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x000660b5, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x000aec7e, 0x000b1c72, 0x00000000, 0x00000000, 5, C_6b_Kerning, 0, 0 },
  { 0x6c, 0x0005cf3b, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6d, 0x00112cb2, 0x00071c72, 0x00000000, 0x00000000, 6, C_6d_Kerning, 0, 0 },
  { 0x6e, 0x000b7df7, 0x00071c72, 0x00000000, 0x00000000, 6, C_6e_Kerning, 0, 0 },
  { 0x6f, 0x000a5b05, 0x00071c72, 0x00000000, 0x00000000, 10, C_6f_Kerning, 0, 0 },
  { 0x70, 0x000b7df7, 0x00071c72, 0x00031c72, 0x00000000, 10, C_70_Kerning, 0, 0 },
  { 0x71, 0x000aec7e, 0x00071c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x72, 0x00088d69, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x73, 0x00083239, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x74, 0x00081520, 0x000a28a5, 0x00000000, 0x00000000, 2, C_74_Kerning, 0, 0 },
  { 0x75, 0x000b7df7, 0x00071c72, 0x00000000, 0x00000000, 1, C_75_Kerning, 0, 0 },
  { 0x76, 0x000aec7e, 0x00071c72, 0x00000000, 0x000048be, 5, C_76_Kerning, 0, 0 },
  { 0x77, 0x000ee6ce, 0x00071c72, 0x00000000, 0x000048be, 4, C_77_Kerning, 0, 0 },
  { 0x78, 0x000aec7e, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x79, 0x000aec7e, 0x00071c72, 0x00031c72, 0x000048be, 5, C_79_Kerning, 0, 0 },
  { 0x7a, 0x00093812, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x000a5b05, 0x00071c72, 0x00000000, 0x00009179, 0, 0, 1, C_7b_Ligature },
  { 0x7c, 0x0014b609, 0x00071c72, 0x00000000, 0x00009179, 0, 0, 0, 0 },
  { 0x7d, 0x000a5b05, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7e, 0x000a5b05, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7f, 0x000a5b05, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 }
};

void
cmbx7_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
