/* remote_control.c
 * For use with GTKeyboard
 * written by David Allen <s2mdalle@titan.vcu.edu>
 * http://opop.nols.com/
 *
 * This sets up all of the remote control stuff, but it does make some calls
 * to the window moving functions and functions to hide/show/raise/lower that
 * are found in ui.c.
 */
/* GTKeyboard - A Graphical Keyboard For X
 * Copyright (C) 1999, 2000 David Allen  
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

#define REMOTE_CONTROL_C

#include "master.h"

#ifndef REMOTE_CONTROL_H
#  include "include/remote_control.h"
#endif /* REMOTE_CONTROL_H */

#ifndef UI_H
#  include "include/ui.h"
#endif /* UI_H */

/* XPM images for the various arrow keys */
#include "share/ur.xpm"
#include "share/ul.xpm"
#include "share/center.xpm"
#include "share/br.xpm"
#include "share/bl.xpm"
#include "share/up.xpm"
#include "share/left.xpm"
#include "share/right.xpm"
#include "share/down.xpm"

static GtkWidget *new_button_xpm(char *xpm_name[])
{
     GtkWidget *button = gtk_button_new();
     GtkWidget *pixmap = xpm_to_widget(window, (gchar **)xpm_name);
     gtk_container_add(GTK_CONTAINER(button), pixmap);
     return(button);
} /* End new_button_xpm */

void window_set_pos(void)
{
     XWindowAttributes attribs;
     
     gtk_widget_realize(window);
     XFlush(GDK_DISPLAY());
     XGetWindowAttributes(GDK_DISPLAY(), GUI.xwindow, &attribs);
     gdk_window_move(window->window, attribs.x, attribs.y);
     return;
} /* End window_set_pos */

void bump_window(GtkWidget *foo, gpointer data)
{
     int bumpval = (int)data;
     int finalx=0, finaly=0;
     
     finalx = 0;
     finaly = 0;
     
     switch(bumpval)
     {
     case BUMP_C:
	  move_window((GtkWidget *)NULL, WIN_CENTER);
	  return;   /* We're done */
	  break;
     case BUMP_NW:
	  finalx -= GUI.BUMP_AMOUNT;
	  finaly -= GUI.BUMP_AMOUNT;
	  break;
     case BUMP_N:
	  finaly -= GUI.BUMP_AMOUNT;
	  finalx = 1;
	  break;
     case BUMP_NE:
	  finalx += GUI.BUMP_AMOUNT;
	  finaly -= GUI.BUMP_AMOUNT;
	  break;
     case BUMP_W:
	  finalx -= GUI.BUMP_AMOUNT;
	  finaly = 0;
	  break;
     case BUMP_E:
	  finalx += GUI.BUMP_AMOUNT;
	  finaly = 0;
	  break;
     case BUMP_SW:
	  finalx -= GUI.BUMP_AMOUNT;
	  finaly += GUI.BUMP_AMOUNT;
	  break;
     case BUMP_S:
	  finaly += GUI.BUMP_AMOUNT;
	  finalx = 1;
	  break;
     case BUMP_SE:
	  finaly += GUI.BUMP_AMOUNT;
	  finalx += GUI.BUMP_AMOUNT;
	  break;
     default:
	  move_window((GtkWidget *)NULL, WIN_CENTER);
	  return;  /* We're done */
	  break;
     } /* End case */

     /* Move the keyboard */
     move_gtkeyboard_offset(finalx, finaly);

     return;
} /* End bump_window */

/* Builds the remote control and displays it on the screen */
void gtkeyboard_remote_control(GtkWidget *emitter, gpointer data)
{
     GtkWidget *table, *arrows[9], *win;
     GtkWidget *title = gtk_label_new("GTKeyboard\nRemote Control");
     GtkWidget *bumpl = gtk_label_new("Move in\na direction");
     GtkWidget *movel = gtk_label_new("Move to\nlocation");
     GtkWidget *raise, *lower, *hide, *show, *sep, *sep2, *sep3;
     GtkWidget *radio_buttons[9], *hb;
     GtkWidget *ttable;
     GtkWidget *center = gtk_alignment_new(0.5, 0.5, 0, 0);
     GtkWidget *center2 = gtk_alignment_new(0.5, 0.5, 0, 0);
     GtkWidget *tcenter = gtk_alignment_new(0.5, 0.5, 0, 0);
     GtkWidget *table2;
     GtkWidget *ok;
     GSList *group = NULL;
     register int x=0;
     int passers[] = { UL_CORNER, T_CENTER, UR_CORNER,
		       L_CENTER,  WIN_CENTER, R_CENTER,
		       BL_CORNER, B_CENTER, BR_CORNER              };
     char *labels[] = { "NW", "N", "NE",
			"W ", "C", "E",
			"SW", "S", "SE"  };

     win    = gtk_dialog_new();
     ok     = create_ok_button(GTK_SIGNAL_FUNC(smack), win);
     table  = gtk_table_new((gint)3, (gint)3, TRUE);
     ttable = gtk_table_new((gint)2, (gint)2, TRUE);
     hb     = gtk_hbox_new(FALSE, 0);
     sep    = gtk_hseparator_new();
     sep2   = gtk_hseparator_new();
     sep3   = gtk_hseparator_new();
     raise  = gtk_button_new_with_label("Raise");
     lower  = gtk_button_new_with_label("Lower");
     hide   = gtk_button_new_with_label("Hide");
     show   = gtk_button_new_with_label("Show");

     gtk_table_attach(GTK_TABLE(ttable), raise, 0, 1, 0, 1,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(ttable), lower, 0, 1, 1, 2,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(ttable), hide, 1, 2, 0, 1,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(ttable), show, 1, 2, 1, 2,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);

     gtk_container_add(GTK_CONTAINER(tcenter), ttable);

     gtk_signal_connect(GTK_OBJECT(raise), "clicked",
			GTK_SIGNAL_FUNC(gtkeyboard_raise), NULL);
     gtk_signal_connect(GTK_OBJECT(lower), "clicked",
			GTK_SIGNAL_FUNC(gtkeyboard_lower), NULL);
     gtk_signal_connect(GTK_OBJECT(hide), "clicked",
			GTK_SIGNAL_FUNC(gtkeyboard_hide), NULL);
     gtk_signal_connect(GTK_OBJECT(show), "clicked",
			GTK_SIGNAL_FUNC(gtkeyboard_show), NULL);

     /* Make the radio buttons and connect signals to them.  Packing into
      * tables is done a bit later...
      */
     for(x=0; x<9; x++)
     {
	  radio_buttons[x] = gtk_radio_button_new_with_label(group, 
							     labels[x]);

	  group = gtk_radio_button_group(GTK_RADIO_BUTTON(radio_buttons[x]));
	  gtk_signal_connect(GTK_OBJECT(radio_buttons[x]), "clicked",
			     GTK_SIGNAL_FUNC(move_window), 
			     (gpointer)passers[x]);
     } /* End for */
     
     table2 = gtk_table_new((gint)3, (gint)3, TRUE);

     gtk_table_attach(GTK_TABLE(table2), radio_buttons[0], 0, 1, 0, 1,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table2), radio_buttons[1], 1, 2, 0, 1,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table2), radio_buttons[2], 2, 3, 0, 1,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table2), radio_buttons[3], 0, 1, 1, 2,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table2), radio_buttons[4], 1, 2, 1, 2,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table2), radio_buttons[5], 2, 3, 1, 2,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table2), radio_buttons[6], 0, 1, 2, 3,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table2), radio_buttons[7], 1, 2, 2, 3,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table2), radio_buttons[8], 2, 3, 2, 3,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);

     /* Create pixmap buttons for al directions. */
     arrows[0] = new_button_xpm(ul_xpm);
     add_tooltip(arrows[0],"Move the window to the upper left");
     arrows[1] = new_button_xpm(up_xpm);
     add_tooltip(arrows[1],"Move the window up");
     arrows[2] = new_button_xpm(ur_xpm);
     add_tooltip(arrows[2], "Move the window to the upper right");
     arrows[3] = new_button_xpm(left_xpm);
     add_tooltip(arrows[3], "Move the window to the left");
     arrows[4] = new_button_xpm(center_xpm);
     add_tooltip(arrows[4], "Center the main window on the screen");
     arrows[5] = new_button_xpm(right_xpm);
     add_tooltip(arrows[5], "Move the window to the right");
     arrows[6] = new_button_xpm(bl_xpm);
     add_tooltip(arrows[6], "Move the window to the bottom left");
     arrows[7] = new_button_xpm(down_xpm);
     add_tooltip(arrows[7], "Move the window down.");
     arrows[8] = new_button_xpm(br_xpm);
     add_tooltip(arrows[8], "Move the window to the bottom right");

     /* Attach signals for the pixmap buttons */
     gtk_signal_connect(GTK_OBJECT(arrows[0]), "clicked",
			GTK_SIGNAL_FUNC(bump_window), (gpointer)BUMP_NW);
     gtk_signal_connect(GTK_OBJECT(arrows[1]), "clicked",
			GTK_SIGNAL_FUNC(bump_window), (gpointer)BUMP_N);
     gtk_signal_connect(GTK_OBJECT(arrows[2]), "clicked",
			GTK_SIGNAL_FUNC(bump_window), (gpointer)BUMP_NE);
     gtk_signal_connect(GTK_OBJECT(arrows[3]), "clicked",
			GTK_SIGNAL_FUNC(bump_window), (gpointer)BUMP_W);
     gtk_signal_connect(GTK_OBJECT(arrows[4]), "clicked",
			GTK_SIGNAL_FUNC(bump_window), (gpointer)BUMP_C);
     gtk_signal_connect(GTK_OBJECT(arrows[5]), "clicked",
			GTK_SIGNAL_FUNC(bump_window), (gpointer)BUMP_E);
     gtk_signal_connect(GTK_OBJECT(arrows[6]), "clicked",
			GTK_SIGNAL_FUNC(bump_window), (gpointer)BUMP_SW);
     gtk_signal_connect(GTK_OBJECT(arrows[7]), "clicked",
			GTK_SIGNAL_FUNC(bump_window), (gpointer)BUMP_S);
     gtk_signal_connect(GTK_OBJECT(arrows[8]), "clicked",
			GTK_SIGNAL_FUNC(bump_window), (gpointer)BUMP_SE);

     gtk_table_attach(GTK_TABLE(table), arrows[0], 0, 1, 0, 1,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table), arrows[1], 1, 2, 0, 1,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table), arrows[2], 2, 3, 0, 1,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table), arrows[3], 0, 1, 1, 2,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table), arrows[4], 1, 2, 1, 2,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table), arrows[5], 2, 3, 1, 2,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table), arrows[6], 0, 1, 2, 3,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table), arrows[7], 1, 2, 2, 3,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);
     gtk_table_attach(GTK_TABLE(table), arrows[8], 2, 3, 2, 3,
		      GTK_SHRINK | GTK_FILL,
		      GTK_SHRINK | GTK_FILL, 0, 0);

     gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox), title,
			FALSE, FALSE, 0);
     gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox), sep3,
			FALSE, FALSE, 0);
     gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox), bumpl,
			FALSE, FALSE, 0);
     
     gtk_box_pack_start(GTK_BOX(hb), table, FALSE, FALSE, 0);
     gtk_container_add(GTK_CONTAINER(center), hb);

     gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox), center, 
			TRUE, TRUE, 0);
     gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox), sep,
			FALSE, FALSE, 0);
     gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox), tcenter,
			FALSE, FALSE, 0);
     gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox), sep2,
			FALSE, FALSE, 0);
     gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox), movel,
			FALSE, FALSE, 0);
     
     gtk_container_add(GTK_CONTAINER(center2), table2);

     gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox), center2,
			FALSE, FALSE, 0);
     gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->action_area), ok,
			FALSE, FALSE, 0);

     gtkeyboard_window_common_setup(win);
     gtk_widget_show_all(win);
} /* End gtkeyboard_remote_control */
