/*
 * GUI misc module
 * This module is for generic GUI functions.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <gnome.h>
#include "guimisc.h"


/**
 * ask_yes_no:
 * Show a modal dialog box that has yes, no, cancel buttons.
 **/
QDialogReply
ask_yes_no(const char *msg)
{
	GnomeMessageBox *mbox;

	mbox = GNOME_MESSAGE_BOX(gnome_message_box_new(msg, GNOME_MESSAGE_BOX_QUESTION,
												   GNOME_STOCK_BUTTON_YES, GNOME_STOCK_BUTTON_NO, GNOME_STOCK_BUTTON_CANCEL,
												   NULL));
	gnome_dialog_set_default(GNOME_DIALOG(mbox), 2);
	gtk_window_set_modal(GTK_WINDOW(mbox), TRUE);
	gtk_window_set_position(GTK_WINDOW(mbox), GTK_WIN_POS_MOUSE);
	
	return gnome_dialog_run_and_close(GNOME_DIALOG(mbox));
}
