/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef VIEWER_CONTROL
#define VIEWER_CONTROL


#include "image-viewer.h"


#define VIEWER_CONTROL_TYPE        (viewer_control_get_type ())
#define VIEWER_CONTROL(o)          (GTK_CHECK_CAST ((o), VIEWER_CONTROL_TYPE, ViewerControl))
#define VIEWER_CONTROL_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), VIEWER_CONTROL_TYPE, ViewerControlClass))
#define IS_VIEWER_CONTROL(o)       (GTK_CHECK_TYPE ((o), VIEWER_CONTROL_TYPE))
#define IS_VIEWER_CONTROL_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), VIEWER_CONTROL_TYPE))


typedef struct _ViewerControl       ViewerControl;
typedef struct _ViewerControlClass  ViewerControlClass;


struct _ViewerControl {
	BonoboControl control;

	/* private */

	BonoboZoomable *zoomable;
	ImageViewer *viewer;
};

struct _ViewerControlClass {
	BonoboControlClass parent_class;
};


GtkType         viewer_control_get_type   (void);

BonoboControl  *viewer_control_new        (ImageViewer *viewer);


#endif /* VIEWER_CONTROL */
