//*****************************************************************************
//                              DlgNgSpiceOPT.cpp                             *
//                             -------------------                            *
//  Started     : 03/03/2006                                                  *
//  Last Update : 12/12/2007                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "ngspice/dialogs/DlgNgSpiceOPT.hpp"

//*****************************************************************************
// Implement an event table.

BEGIN_EVENT_TABLE( DlgNgSpiceOPT, wxDialog )

  EVT_BUTTON( ID_BTN_OK,       DlgNgSpiceOPT::OnBtnOk       )
  EVT_BUTTON( ID_BTN_DEFAULTS, DlgNgSpiceOPT::OnBtnDefaults )
  EVT_BUTTON( ID_BTN_CANCEL,   DlgNgSpiceOPT::OnBtnCancel   )

END_EVENT_TABLE( )

//*****************************************************************************
// Constructor.
//
// Argument List:
//   poWin - A pointer to the dialog parent window

DlgNgSpiceOPT::DlgNgSpiceOPT( wxWindow * poWin ) :
                wxDialog( poWin, -1, wxT(""), wxDefaultPosition, wxDefaultSize,
                          wxDEFAULT_DIALOG_STYLE, wxDialogNameStr ),
                CmdNgSpiceOPT( )
{
  SetTitle( wxT(" NG-Spice OPTIONS Line Setup") );
  Initialize( );
  bClear( );
}

//*****************************************************************************
// Destructor.

DlgNgSpiceOPT::~DlgNgSpiceOPT( )
{
}

//*****************************************************************************
// Initialize object attributes.

void  DlgNgSpiceOPT::Initialize( void )
{
  // Call all the initialization functions
  Create( );
  ToolTips( );

  // Layout the of the display objects
  DoLayout( );
}

//*****************************************************************************
// Create the display objects.

void  DlgNgSpiceOPT::Create( void )
{
  wxPanel * poPnl, * poPnlLHS, * poPnlRHS, * poPnl1;

  // Create the necessary panel objects
  poPnlLHS = new wxPanel( this );
  poPnlRHS = new wxPanel( this );
  poPnl1   = new wxPanel( poPnlRHS );

  // Create the PnlValue controls
  m_oPnlABSTOL.bCreate( poPnlLHS, ID_PNL_ABSTOL, 75 );
  m_oPnlCHGTOL.bCreate( poPnlLHS, ID_PNL_CHGTOL, 75 );
  m_oPnlDEFAD .bCreate( poPnlLHS, ID_PNL_DEFAD,  75 );
  m_oPnlDEFAS .bCreate( poPnlLHS, ID_PNL_DEFAS,  75 );
  m_oPnlDEFL  .bCreate( poPnlLHS, ID_PNL_DEFL,   75 );
  m_oPnlDEFW  .bCreate( poPnlLHS, ID_PNL_DEFW,   75 );
  m_oPnlGMIN  .bCreate( poPnlLHS, ID_PNL_GMIN,   75 );
  m_oPnlITL1  .bCreate( poPnlLHS, ID_PNL_ITL1,   75 );
  m_oPnlITL2  .bCreate( poPnlLHS, ID_PNL_ITL2,   75 );
  m_oPnlITL4  .bCreate( poPnlLHS, ID_PNL_ITL4,   75 );
  m_oPnlPIVREL.bCreate( poPnlLHS, ID_PNL_PIVREL, 75 );
  m_oPnlPIVTOL.bCreate( poPnl1,   ID_PNL_PIVTOL, 75 );
  m_oPnlRELTOL.bCreate( poPnl1,   ID_PNL_RELTOL, 75 );
  m_oPnlTEMP  .bCreate( poPnl1,   ID_PNL_TEMP,   75 );
  m_oPnlTNOM  .bCreate( poPnl1,   ID_PNL_TNOM,   75 );
  m_oPnlTRTOL .bCreate( poPnl1,   ID_PNL_TRTOL,  75 );
  m_oPnlVNTOL .bCreate( poPnl1,   ID_PNL_VNTOL,  75 );

  m_oPnlABSTOL.bSetName( wxT("ABSTOL") );
  m_oPnlCHGTOL.bSetName( wxT("CHGTOL") );
  m_oPnlDEFAD .bSetName( wxT("DEFAD")  );
  m_oPnlDEFAS .bSetName( wxT("DEFAS")  );
  m_oPnlDEFL  .bSetName( wxT("DEFL")   );
  m_oPnlDEFW  .bSetName( wxT("DEFW")   );
  m_oPnlGMIN  .bSetName( wxT("GMIN")   );
  m_oPnlITL1  .bSetName( wxT("ITL1")   );
  m_oPnlITL2  .bSetName( wxT("ITL2")   );
  m_oPnlITL4  .bSetName( wxT("ITL4")   );
  m_oPnlPIVREL.bSetName( wxT("PIVREL") );
  m_oPnlPIVTOL.bSetName( wxT("PIVTOL") );
  m_oPnlRELTOL.bSetName( wxT("RELTOL") );
  m_oPnlTEMP  .bSetName( wxT("TEMP")   );
  m_oPnlTNOM  .bSetName( wxT("TNOM")   );
  m_oPnlTRTOL .bSetName( wxT("TRTOL")  );
  m_oPnlVNTOL .bSetName( wxT("VNTOL")  );

  m_oPnlTEMP  .bSetUnitsType( ChoUnits::eUNITS_TEMP );
  m_oPnlTNOM  .bSetUnitsType( ChoUnits::eUNITS_TEMP );
  m_oPnlVNTOL .bSetUnitsType( ChoUnits::eUNITS_VOLT );

  m_oPnlVNTOL .bSetDefUnits( wxT("uV") );

  m_oPnlABSTOL.bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlCHGTOL.bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDEFAD .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDEFAS .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDEFL  .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDEFW  .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlGMIN  .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlITL1  .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlITL2  .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlITL4  .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlPIVTOL.bSetVarType( SpinCtrl::eVAR_SCI );

  m_oPnlABSTOL.bShowUnits( FALSE );
  m_oPnlCHGTOL.bShowUnits( FALSE );
  m_oPnlDEFAD .bShowUnits( FALSE );
  m_oPnlDEFAS .bShowUnits( FALSE );
  m_oPnlDEFL  .bShowUnits( FALSE );
  m_oPnlDEFW  .bShowUnits( FALSE );
  m_oPnlGMIN  .bShowUnits( FALSE );
  m_oPnlITL1  .bShowUnits( FALSE );
  m_oPnlITL2  .bShowUnits( FALSE );
  m_oPnlITL4  .bShowUnits( FALSE );
  m_oPnlPIVREL.bShowUnits( FALSE );
  m_oPnlPIVTOL.bShowUnits( FALSE );
  m_oPnlRELTOL.bShowUnits( FALSE );
  m_oPnlTRTOL .bShowUnits( FALSE );

  m_oPnlABSTOL.bSetParms( NG_ABSTOL,       1.00E-14, 9.99E-10 );
  m_oPnlCHGTOL.bSetParms( NG_CHGTOL,       1.00E-15, 9.99E-09 );
  m_oPnlDEFAD .bSetParms( NG_DEFAD,        1.00E-14, 9.99E-10 );
  m_oPnlDEFAS .bSetParms( NG_DEFAS,        1.00E-14, 9.99E-10 );
  m_oPnlDEFL  .bSetParms( NG_DEFL,         1.00E-08, 9.99E-02 );
  m_oPnlDEFW  .bSetParms( NG_DEFW,         1.00E-08, 9.99E-02 );
  m_oPnlGMIN  .bSetParms( NG_GMIN,         1.00E-14, 9.99E-10 );
  m_oPnlITL1  .bSetParms( NG_ITL1,         0,        1000,    1,    10    );
  m_oPnlITL2  .bSetParms( NG_ITL2,         0,        1000,    1,    10    );
  m_oPnlITL4  .bSetParms( NG_ITL4,         0,        1000,    1,    10    );
  m_oPnlPIVREL.bSetParms( NG_PIVREL*100.0, 0.01,     100.0,   0.01, 10.0  );
  m_oPnlPIVTOL.bSetParms( NG_PIVTOL,       1.00E-15, 9.99E-11 );
  m_oPnlRELTOL.bSetParms( NG_RELTOL*100.0, 0.01,     100.0,   0.01, 10.0  );
  m_oPnlTRTOL .bSetParms( NG_TRTOL,        0.01,     100.0,   0.01, 10.0  );
  m_oPnlVNTOL .bSetParms( NG_VNTOL,        0.00,     1000.0,  0.01, 100.0 );

  m_oPnlABSTOL.bSetUnits( wxT("Amp")       );
  m_oPnlDEFAD .bSetUnits( wxT("Sq. Meter") );
  m_oPnlDEFAS .bSetUnits( wxT("Sq. Meter") );
  m_oPnlDEFL  .bSetUnits( wxT("Meter")     );
  m_oPnlDEFW  .bSetUnits( wxT("Meter")     );
  m_oPnlGMIN  .bSetUnits( wxT("Ohm")       );
  m_oPnlPIVREL.bSetUnits( wxT("%")         );
  m_oPnlRELTOL.bSetUnits( wxT("%")         );

  // Create the choice box control
  poPnl = new wxPanel( poPnl1 );
  m_oLblMETHOD.Create( poPnl, ID_UNUSED, wxT("METHOD"), wxDefaultPosition,
                       wxSize( 80, PNLVALUE_HT ), wxST_NO_AUTORESIZE );
  m_oChoMETHOD.Create( poPnl, ID_CHO_METHOD, wxDefaultPosition,
                       wxSize( 95, -1 ) );
  m_oChoMETHOD.Append( wxT("Trap") );
  m_oChoMETHOD.Append( wxT("Gear") );

  // Create the check box control
  m_oCbxBADMOS3.Create( poPnl1, ID_CBX_BADMOS3, wxT("  BADMOS3   \t  "),
                        wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                        wxALIGN_RIGHT );

  // Create the buttons
  poPnl = new wxPanel( poPnlRHS );
  m_oBtnOk      .Create( poPnl, ID_BTN_OK,       wxT("OK")       );
  m_oBtnDefaults.Create( poPnl, ID_BTN_DEFAULTS, wxT("Defaults") );
  m_oBtnCancel  .Create( poPnl, ID_BTN_CANCEL,   wxT("Cancel")   );
}

//*****************************************************************************
// Initialize the tool tips.

void  DlgNgSpiceOPT::ToolTips( void )
{
  // Define tool tips for each control
  m_oPnlABSTOL.SetToolTip( wxT("Absolute current error tolerance") );
  m_oPnlCHGTOL.SetToolTip( wxT("Charge tolerance") );
  m_oPnlDEFAD .SetToolTip( wxT("MOS drain diffusion area") );
  m_oPnlDEFAS .SetToolTip( wxT("MOS source diffusion area") );
  m_oPnlDEFL  .SetToolTip( wxT("MOS channel length") );
  m_oPnlDEFW  .SetToolTip( wxT("MOS channel width") );
  m_oPnlGMIN  .SetToolTip( wxT("Minimum allowable conductance") );
  m_oPnlITL1  .SetToolTip( wxT("DC iteration limit") );
  m_oPnlITL2  .SetToolTip( wxT("DC transfer curve iteration limit") );
  m_oPnlITL4  .SetToolTip( wxT("Transient analysis timepoint iteration limit") );
  m_oPnlPIVREL.SetToolTip( wxT("Relative ratio between largest column entry and an acceptable pivot value") );
  m_oPnlPIVTOL.SetToolTip( wxT("Absolute minimum value for matrix entry as pivot") );
  m_oPnlRELTOL.SetToolTip( wxT("Relative error tolerance") );
  m_oPnlTEMP  .SetToolTip( wxT("Operating temperature of circuit") );
  m_oPnlTNOM  .SetToolTip( wxT("Nominal temperature at which device parameters measured") );
  m_oPnlTRTOL .SetToolTip( wxT("Transient error tolerance") );
  m_oPnlVNTOL .SetToolTip( wxT("Absolute voltage error tolerance") );

  m_oCbxBADMOS3.SetToolTip( wxT("Use MOS3 model with \"kappa\" discontinuity") );

  m_oChoMETHOD.GetParent( )->SetToolTip( wxT("Numerical integration method") );
}

//*****************************************************************************
// Layout the dialog display objects.

void  DlgNgSpiceOPT::DoLayout( void )
{
  wxBoxSizer  * poSzrDlg;
  wxBoxSizer  * poSzrLHS, * poSzrRHS, * poSzr1, * poSzrMETHOD, * poSzrBtns;
  wxPanel     * poPnlLHS, * poPnlRHS, * poPnl1, * poPnlMETHOD, * poPnlBtns;
  wxSizerFlags  oFlags;

  // Create the necessary panels and associated sizers
  poPnlBtns   = (wxPanel *) m_oBtnOk    .GetParent( );
  poPnlMETHOD = (wxPanel *) m_oChoMETHOD.GetParent( );
  poPnl1      = (wxPanel *) m_oPnlVNTOL .GetParent( );
  poPnlRHS    = (wxPanel *) poPnlBtns  ->GetParent( );
  poPnlLHS    = (wxPanel *) m_oPnlABSTOL.GetParent( );
  poSzrDlg    = new wxBoxSizer      ( wxHORIZONTAL );
#if wxCHECK_VERSION( 2,8,0 )
  poSzrLHS    = new wxStaticBoxSizer( wxVERTICAL, poPnlLHS );
  poSzr1      = new wxStaticBoxSizer( wxVERTICAL, poPnl1 );
#else
  poSzrLHS    = new wxStaticBoxSizer( wxVERTICAL, poPnlLHS, wxT(" ") );
  poSzr1      = new wxStaticBoxSizer( wxVERTICAL, poPnl1,   wxT(" ") );
#endif
  poSzrRHS    = new wxBoxSizer      ( wxVERTICAL );
  poSzrMETHOD = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrBtns   = new wxBoxSizer      ( wxHORIZONTAL );
               SetSizer( poSzrDlg );
  poPnlLHS   ->SetSizer( poSzrLHS );
  poPnlRHS   ->SetSizer( poSzrRHS );
  poPnl1     ->SetSizer( poSzr1 );
  poPnlMETHOD->SetSizer( poSzrMETHOD );
  poPnlBtns  ->SetSizer( poSzrBtns );

  // Add the controls to the choice panel
  oFlags.Align( wxALIGN_CENTER ); // ??? 04/06/2007 This seems be ignored
  oFlags.Border( wxTOP, 7 );      // ??? 26/05/2007
  poSzrMETHOD->Add( &m_oLblMETHOD, oFlags );
  oFlags.Border( wxTOP | wxBOTTOM, 1 );
  poSzrMETHOD->Add( &m_oChoMETHOD, oFlags );
  poSzrMETHOD->SetSizeHints( poPnlMETHOD );

  // Add the controls to the left hand panel
  oFlags.Border( wxTOP, 5 );
  poSzrLHS->Add( &m_oPnlABSTOL, oFlags );
  oFlags.Border( wxLEFT | wxRIGHT, 10 );
  poSzrLHS->Add( &m_oPnlCHGTOL, oFlags );
  poSzrLHS->Add( &m_oPnlDEFAD,  oFlags );
  poSzrLHS->Add( &m_oPnlDEFAS,  oFlags );
  poSzrLHS->Add( &m_oPnlDEFL,   oFlags );
  poSzrLHS->Add( &m_oPnlDEFW,   oFlags );
  poSzrLHS->Add( &m_oPnlGMIN,   oFlags );
  poSzrLHS->Add( &m_oPnlITL1,   oFlags );
  poSzrLHS->Add( &m_oPnlITL2,   oFlags );
  poSzrLHS->Add( &m_oPnlITL4,   oFlags );
  oFlags.Border( wxBOTTOM, 5 );
  poSzrLHS->Add( &m_oPnlPIVREL, oFlags );
  poSzrLHS->SetSizeHints( poPnlLHS );

  // Add the controls to the right hand panel
  oFlags.Border( wxTOP, 5 );
  poSzr1->Add( &m_oPnlPIVTOL,  oFlags );
  oFlags.Border( wxLEFT | wxRIGHT, 10 );
  poSzr1->Add( &m_oPnlRELTOL,  oFlags );
  poSzr1->Add( &m_oPnlTEMP,    oFlags );
  poSzr1->Add( &m_oPnlTNOM,    oFlags );
  poSzr1->Add( &m_oPnlTRTOL,   oFlags );
  poSzr1->Add( &m_oPnlVNTOL,   oFlags );
  oFlags.Align( wxALIGN_LEFT );
  oFlags.Border( wxLEFT | wxRIGHT, 10 );
  poSzr1->Add( poPnlMETHOD,    oFlags );
  oFlags.Border( wxTOP | wxBOTTOM, 5 );
  poSzr1->Add( &m_oCbxBADMOS3, oFlags );
  poSzr1->SetSizeHints( poPnl1 );

  // Add the controls to the buttons panel
  oFlags.Border( wxTOP | wxBOTTOM, 5 );
  oFlags.Align( wxALIGN_RIGHT );
  poSzrBtns->Add( &m_oBtnOk,       oFlags );
  poSzrBtns->AddSpacer( 10 );
  oFlags.Align( wxALIGN_CENTER );
  poSzrBtns->Add( &m_oBtnDefaults, oFlags );
  poSzrBtns->AddSpacer( 10 );
  oFlags.Align( wxALIGN_LEFT );
  poSzrBtns->Add( &m_oBtnCancel,   oFlags );
  poSzrBtns->SetSizeHints( poPnlBtns );

  // Put it all together
  oFlags.Align( wxALIGN_TOP );
  oFlags.Border( wxALL, 0 );
  poSzrRHS->Add( poPnl1,    oFlags );
  oFlags.Align( wxALIGN_CENTER_HORIZONTAL | wxALIGN_BOTTOM );
  oFlags.Border( wxTOP, 45 );
  poSzrRHS->Add( poPnlBtns, oFlags );
  poSzrRHS->SetSizeHints( poPnlRHS );
  oFlags.Border( wxALL, 15 );
  poSzrDlg->Add( poPnlLHS,  oFlags );
  oFlags.Align( wxALIGN_TOP );
  oFlags.Border( wxTOP | wxRIGHT | wxBOTTOM, 15 );
  poSzrDlg->Add( poPnlRHS,  oFlags );
  poSzrDlg->SetSizeHints( this );
}

//*****************************************************************************
// Get a pointer to a value panel associated with a control ID number.
//
// Argument List:
//   iPnlID - The control ID number
//
// Return Values:
//   Success - A pointer to the value panel
//   Failure - NULL

PnlValue * DlgNgSpiceOPT::poGetPanel( int iPnlID )
{
  switch( iPnlID )
  {
    case ID_PNL_ABSTOL : return( &m_oPnlABSTOL );
    case ID_PNL_CHGTOL : return( &m_oPnlCHGTOL );
    case ID_PNL_DEFAD  : return( &m_oPnlDEFAD  );
    case ID_PNL_DEFAS  : return( &m_oPnlDEFAS  );
    case ID_PNL_DEFL   : return( &m_oPnlDEFL   );
    case ID_PNL_DEFW   : return( &m_oPnlDEFW   );
    case ID_PNL_GMIN   : return( &m_oPnlGMIN   );
    case ID_PNL_ITL1   : return( &m_oPnlITL1   );
    case ID_PNL_ITL2   : return( &m_oPnlITL2   );
    case ID_PNL_ITL4   : return( &m_oPnlITL4   );
    case ID_PNL_PIVREL : return( &m_oPnlPIVREL );
    case ID_PNL_PIVTOL : return( &m_oPnlPIVTOL );
    case ID_PNL_RELTOL : return( &m_oPnlRELTOL );
    case ID_PNL_TEMP   : return( &m_oPnlTEMP   );
    case ID_PNL_TNOM   : return( &m_oPnlTNOM   );
    case ID_PNL_TRTOL  : return( &m_oPnlTRTOL  );
    case ID_PNL_VNTOL  : return( &m_oPnlVNTOL  );
    default            : return( NULL );
  }
}

//*****************************************************************************
// Set the values in the spin controls from temporary storage.

void  DlgNgSpiceOPT::SetValues( void )
{
  int  i1;

  SetEvtHandlerEnabled( FALSE );

  m_oPnlABSTOL.bSetValue( (double) m_fABSTOL );
  m_oPnlCHGTOL.bSetValue( (double) m_fCHGTOL );
  m_oPnlDEFAD .bSetValue( (double) m_fDEFAD  );
  m_oPnlDEFAS .bSetValue( (double) m_fDEFAS  );
  m_oPnlDEFL  .bSetValue( (double) m_fDEFL   );
  m_oPnlDEFW  .bSetValue( (double) m_fDEFW   );
  m_oPnlGMIN  .bSetValue( (double) m_fGMIN   );
  m_oPnlITL1  .bSetValue( (long)   m_iITL1   );
  m_oPnlITL2  .bSetValue( (long)   m_iITL2   );
  m_oPnlITL4  .bSetValue( (long)   m_iITL4   );
  m_oPnlPIVREL.bSetValue( (double) m_fPIVREL * 100.0 );
  m_oPnlPIVTOL.bSetValue( (double) m_fPIVTOL );
  m_oPnlRELTOL.bSetValue( (double) m_fRELTOL * 100.0 );
  m_oPnlTEMP  .bSetValue( (double) m_fTEMP   );
  m_oPnlTNOM  .bSetValue( (double) m_fTNOM   );
  m_oPnlTRTOL .bSetValue( (double) m_fTRTOL  );
  m_oPnlVNTOL .bSetValue( (double) m_fVNTOL  );

  m_oCbxBADMOS3.SetValue( m_bBADMOS3 );

  for( i1=0; i1<(int)m_oChoMETHOD.GetCount( ); i1++ )
    if( m_oChoMETHOD.GetString( i1 ).IsSameAs( m_osMETHOD, FALSE ) )
      { m_oChoMETHOD.SetSelection( i1 ); break; }

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Get the values from the spin controls and put them in temporary storage.

void  DlgNgSpiceOPT::GetValues( void )
{
  SetEvtHandlerEnabled( FALSE );

  m_fABSTOL  = (float) m_oPnlABSTOL.dfGetValue( );
  m_fCHGTOL  = (float) m_oPnlCHGTOL.dfGetValue( );
  m_fDEFAD   = (float) m_oPnlDEFAD .dfGetValue( );
  m_fDEFAS   = (float) m_oPnlDEFAS .dfGetValue( );
  m_fDEFL    = (float) m_oPnlDEFL  .dfGetValue( );
  m_fDEFW    = (float) m_oPnlDEFW  .dfGetValue( );
  m_fGMIN    = (float) m_oPnlGMIN  .dfGetValue( );
  m_iITL1    = (int)   m_oPnlITL1  .liGetValue( );
  m_iITL2    = (int)   m_oPnlITL2  .liGetValue( );
  m_iITL4    = (int)   m_oPnlITL4  .liGetValue( );
  m_fPIVREL  = (float) m_oPnlPIVREL.dfGetValue( ) / 100.0;
  m_fPIVTOL  = (float) m_oPnlPIVTOL.dfGetValue( );
  m_fRELTOL  = (float) m_oPnlRELTOL.dfGetValue( ) / 100.0;
  m_fTEMP    = (float) m_oPnlTEMP  .dfGetValue( );
  m_fTNOM    = (float) m_oPnlTNOM  .dfGetValue( );
  m_fTRTOL   = (float) m_oPnlTRTOL .dfGetValue( );
  m_fVNTOL   = (float) m_oPnlVNTOL .dfGetValue( );

  m_bBADMOS3 = m_oCbxBADMOS3.GetValue( );

  m_osMETHOD = m_oChoMETHOD.GetStringSelection( ).Upper( );

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Reset all dialog settings to defaults.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  DlgNgSpiceOPT::bClear( void )
{
  CmdNgSpiceOPT::bClear( );

  SetValues( );

  return( TRUE );
}

//*****************************************************************************
// Set the OPTIONS command string.
//
// Argument List:
//   rosCmd - A string reference containing the command
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  DlgNgSpiceOPT::bSetCmd( const wxString & rosCmd )
{
  CmdNgSpiceOPT::bClear( );
  *((wxString *) this) = rosCmd;
  if( ! CmdNgSpiceOPT::bParse( ) ) return( FALSE );

  SetValues( );

  return( TRUE );
}

//*****************************************************************************
// Get a value panel control's value.
//
// Argument List:
//   iPnlID   - Value panel control identifier
//
// Return Values:
//   Success - The panel value
//   Failure - 0.0

double  DlgNgSpiceOPT::dfGetValue( int iPnlID )
{
  PnlValue * poPnlValue;

  poPnlValue = poGetPanel( iPnlID );
  if( poPnlValue == NULL ) return( 0.0 );

  return( poPnlValue->dfGetValue( ) );
}

//*****************************************************************************
// Set a value panel control's value.
//
// Argument List:
//   iPnlID   - Value panel control identifier
//   dfValue  - The value to set the spin control
//   rosUnits - The units to display
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  DlgNgSpiceOPT::bSetValue( int iPnlID, double dfValue,
                                const wxString & rosUnits )
{
  PnlValue * poPnlValue;

  // Get a pointer to the appropriate value panel
  poPnlValue = poGetPanel( iPnlID );
  if( poPnlValue == NULL )                  return( FALSE );

  // Set the panel value
  if( ! poPnlValue->bSetValue( dfValue ) )  return( FALSE );

  // Set the units
  if( ! poPnlValue->bSetUnits( rosUnits ) ) return( FALSE );

  return( TRUE );
}

//*****************************************************************************
//
//                             Event Handlers
//
//*****************************************************************************
// Ok button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgNgSpiceOPT::OnBtnOk( wxCommandEvent & roEvtCmd )
{
  GetValues( );
  EndModal( wxID_OK );
}

//*****************************************************************************
// Cancel button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgNgSpiceOPT::OnBtnCancel( wxCommandEvent & roEvtCmd )
{
  SetValues( );
  EndModal( wxID_CANCEL );
}

//*****************************************************************************
// Defaults button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgNgSpiceOPT::OnBtnDefaults( wxCommandEvent & roEvtCmd )
{
  m_oPnlABSTOL.bSetValue( NG_ABSTOL );
  m_oPnlCHGTOL.bSetValue( NG_CHGTOL );
  m_oPnlDEFAD .bSetValue( NG_DEFAD  );
  m_oPnlDEFAS .bSetValue( NG_DEFAS  );
  m_oPnlDEFL  .bSetValue( NG_DEFL   );
  m_oPnlDEFW  .bSetValue( NG_DEFW   );
  m_oPnlGMIN  .bSetValue( NG_GMIN   );
  m_oPnlITL1  .bSetValue( NG_ITL1   );
  m_oPnlITL2  .bSetValue( NG_ITL2   );
  m_oPnlITL4  .bSetValue( NG_ITL4   );
  m_oPnlPIVREL.bSetValue( NG_PIVREL * 100.0 );
  m_oPnlPIVTOL.bSetValue( NG_PIVTOL );
  m_oPnlRELTOL.bSetValue( NG_RELTOL * 100.0 );
  m_oPnlTEMP  .bSetValue( NG_TEMP   );
  m_oPnlTNOM  .bSetValue( NG_TNOM   );
  m_oPnlTRTOL .bSetValue( NG_TRTOL  );
  m_oPnlVNTOL .bSetValue( NG_VNTOL  );

  m_oCbxBADMOS3.SetValue( NG_BADMOS3 );

  m_oChoMETHOD.SetStringSelection( NG_METHOD );
}

//*****************************************************************************
