//*****************************************************************************
//                                 NetList.hpp                                *
//                                -------------                               *
//  Description : Class to provide an interface to the circuit description    *
//                (net list). The raw net list data is loaded from file into  *
//                memory and stored as a string array which this class        *
//                derives from. The individual net list types (component      *
//                definitions, etc.) are extracted and stored as object       *
//                attributes.                                                 * 
//  Started     : 01/09/2003                                                  *
//  Last Update : 07/12/2006                                                  *
//  Copyright   : (C) 2003 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef NETLIST_HPP
#define NETLIST_HPP

// System Includes

#include <iostream>
//#include <cctype>

// wxWindows Includes

#include <wx/wx.h>
#include <wx/filename.h>
#include <wx/textfile.h>
#include <wx/tokenzr.h>

// Application Includes

#include "Version.hpp"
#include "netlist/Component.hpp"

// Local Constant Declarations


//*****************************************************************************

class NetList : public wxArrayString
{
  protected:

    // File names
    wxFileName     m_ofnLoad;
    wxFileName     m_ofnSave;
    wxString       m_osSchems;

    // String arrays containing the various raw line types
    wxArrayString  m_oasTitle;
    wxArrayString  m_oasIncludes;
    wxArrayString  m_oasCpnts;
    wxArrayString  m_oasModels;
    wxArrayString  m_oasSubCcts;

    // String arrays containing labels only
    wxArrayString  m_oasNodeLbls;
    wxArrayString  m_oasCpntLbls;

    // Function which provides the string sorting criterion
    static  int  iCompare( const wxString & ros1, const wxString & ros2 );

  private:

    // Functions to extract information from the circuit description
    bool  bIsSubCkt( wxString & roLine );
    bool  bExtractTitle   ( void );
    bool  bExtractIncludes( void );
    bool  bExtractCpnts   ( void );
    bool  bExtractModels  ( void );
    bool  bExtractSubCcts ( void );
    bool  bExtractNodeLbls( void );
    bool  bExtractCpntLbls( void );
    bool  bExtractSchems  ( void );
    bool  bExtract        ( void );

  public:

    NetList( void );
    ~NetList( );

    bool  bClear( void );
    bool  bEmpty( void );

    bool  bLoadFile( const wxString & rosFName=wxT("") );
    bool  bSaveFile( const wxString & rosFName=wxT("") );

    bool  bSetLoadFile( const wxString & rosFName );
    bool  bSetSaveFile( const wxString & rosFName );
    bool  bSetSchems  ( const wxString & rosFNames );

    const wxFileName & rofnGetLoadFile( void )    { return( m_ofnLoad ); }
    const wxFileName & rofnGetSaveFile( void )    { return( m_ofnSave ); }
    const wxString   &  rosGetSchems  ( void )    { return( m_osSchems ); }

    const wxArrayString & roasGetTitle  ( void )  { return( m_oasTitle ); }
    const wxArrayString & roasGetCpnts  ( void )  { return( m_oasCpnts ); }
    const wxArrayString & roasGetModels ( void )  { return( m_oasModels ); }
    const wxArrayString & roasGetSubCcts( void )  { return( m_oasSubCcts ); }

    const wxArrayString & roasGetNodeLbls( void ) { return( m_oasNodeLbls ); }
    const wxArrayString & roasGetCpntLbls( void ) { return( m_oasCpntLbls ); }

    const wxString & rosGetCpnt( const wxChar * psName );

    // Debug functions
    void  PrintCpntLines( void );

    friend  class  PrcGnuCap;
    friend  class  PrcNgSpice;
};

//*****************************************************************************

#endif // NETLIST_HPP
