//*****************************************************************************
//                                TypeDefs.hpp                                *
//                               --------------                               *
//  Description : This header file mostly contains enumerated type            *
//                definitions which may be used anywhere in the application.  *
//  Started     : 06/09/2007                                                  *
//  Last Update : 23/01/2008                                                  *
//  Copyright   : (C) 2007 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef TYPEDEFS_HPP
#define TYPEDEFS_HPP

#include <wx/filename.h>
#include <wx/dynarray.h>

//*****************************************************************************
// Fonts

#define FONT_NORM   wxFont( 9, wxFONTFAMILY_SWISS,  wxFONTSTYLE_NORMAL, wxFONTWEIGHT_LIGHT )
#define FONT_BOLD   wxFont( 9, wxFONTFAMILY_SWISS,  wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD  )
#define FONT_SLANT  wxFont( 9, wxFONTFAMILY_SWISS,  wxFONTSTYLE_SLANT,  wxFONTWEIGHT_LIGHT )
#define FONT_MONO   wxFont( 8, wxFONTFAMILY_MODERN, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_LIGHT )

//*****************************************************************************
// Enumerated types

// Enumerated type for the various simulator engine types
enum eSimrType
{
  eSIMR_GNUCAP,   // GNU-Cap
  eSIMR_NGSPICE,  // NG-Spice

  eSIMR_NONE,     // Used if a simulation engine has not yet been selected

  eSIMR_FST = eSIMR_GNUCAP,
  eSIMR_LST = eSIMR_NGSPICE
};

// Enumerated type for the various waveform viewers types
enum eViewType
{
  eVIEW_GWAVE,  // GWave
  eVIEW_GAW,    // Gaw

  eVIEW_NONE,   // Used if a waveform viewer has not yet been selected

  eVIEW_FST = eVIEW_GWAVE,
  eVIEW_LST = eVIEW_GAW
};

// Enumerated type for the various analyses types which may be performed
enum eAnaType
{
  eANA_OP = 0,  // Quiescent operating point analysis
  eANA_DC,      // DC analysis
  eANA_AC,      // AC analysis
  eANA_TR,      // Transient analysis
  eANA_FO,      // Fourier analysis
  eANA_DI,      // Distortion analysis
  eANA_NO,      // Noise analysis
  eANA_PZ,      // Pole-zero analysis
  eANA_SE,      // Sensitivity analysis
  eANA_TF,      // Transfer function analysis

  eANA_NONE,    // Analysis type not set

  eANA_FST = eANA_OP,
  eANA_LST = eANA_TF
};

// Enumerated type for the various parameters which may be determined by analysis
enum eParType
{
  ePAR_VLT = 0,  // Node or component voltage
  ePAR_CUR,      // Node or component current
  ePAR_PWR,      // Node or component power
  ePAR_RES,      // Input and output resistance

  ePAR_NONE,

  ePAR_FST = ePAR_VLT,
  ePAR_LST = ePAR_RES
};

// Enumerated type for the various sub-parameters which may be determined (AC analysis only)
enum eCpxType
{
  eCPX_MAG = 0,  // Magnitude      of the complex node or component parameter
  eCPX_PHASE,    // Phase          of the complex node or component parameter
  eCPX_REAL,     // Real part      of the complex node or component parameter
  eCPX_IMAG,     // Imaginary part of the complex node or component parameter
  eCPX_MAGDB,    // Convert the magnitude to dBV

  eCPX_NONE,

  eCPX_FST = eCPX_MAG,
  eCPX_LST = eCPX_MAGDB
};

// Enumerated type for the various step scale types
enum  eScaleType
{
  eSCALE_LIN,
  eSCALE_LOG,
  eSCALE_DEC,
  eSCALE_OCT,

  eSCALE_NONE,

  eSCALE_FST = eSCALE_LIN,
  eSCALE_LST = eSCALE_OCT
};

// Enumerated type for the initial conditions for a transient analysis
enum  eInitCType
{
  eINITC_WARM = 0,  // Warm start
  eINITC_UICS,      // Use initial conditions
  eINITC_COLD,      // Cold start

  eINITC_NONE,

  eINITC_FST = eINITC_WARM,
  eINITC_LST = eINITC_COLD
};

//*****************************************************************************

WX_DECLARE_OBJARRAY( wxFileName, ArrayFileName );

//*****************************************************************************

#endif // TYPEDEFS_HPP
