/* sms.h --- SmsSend definitions */

/* Copyright (c) E. Lassauge, 2000-2001.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * mailto:lassauge@mail.dotcom.fr
 * http://lassauge.free.fr/
 *
 * REVISION HISTORY: see Changelog
 *
 */

#ifndef _SMS_H
#define _SMS_H

/* created from smssend.c */
#include <skyutils.h>
#define DEF_LENGTH	30
#define P_LENGTH	51

#define SMSSEND_URL_SCRIPTS "http://zekiller.skytech.org/fichiers/smssend/"
#define SMSSEND_SHAREPATH   PACKAGE_SHARE_DIR "smssend"
#define SMSSEND_SUF	    "sms"

/* typedefs */
typedef struct
{
    gchar *Name;
    gchar *Value;
    gchar *Help;
    gchar *Alias;		/* used only by smssend */
    gint Hidden;
    gint Size;
    gint Convert;		/* used only by smssend */
    GtkWidget *Widget;		/* value field widget */
}
Param_t, *PParam_t;

typedef struct
{
    gchar     *Filename;
    gchar     *Label;
    gint      NbParams;
    Param_t   *Params;
    GtkWidget *MessageWidget;	/* notebook message widget */
    GtkWidget *PageWidget;	/* notebook main widget of provider */
}
Provider_t, *PProvider_t;

typedef struct
{
    PProvider_t Pv;     /* These 3 options can't be set together */
    gboolean    Help;
    gboolean    Update;
    gint        Callback, Callback2;
    gint        Done;
    pid_t       SmsId;
    gint        argc;  /* For delayed calls */
    gchar       **argv;
}
cmdParam_t, *PcmdParam_t;

/* configuration variables */
extern gboolean UseProxy;
extern gchar ProxyHost[P_LENGTH];
extern gint ProxyPort;
extern gchar ProxyUser[P_LENGTH];
extern gchar ProxyPass[P_LENGTH];
extern gchar *HeaderFile;
extern gint DebugLevel;
extern gint TimeOut;
extern gboolean AutoCheck;
extern gboolean KeepPass;
extern gboolean DelaySend;
extern gint Retries;

/* global variables */
extern GHashTable *AliasHash;
extern GSList *DelayList;
extern gint NumProvider;
extern GHashTable *SavedProviderHash;
extern GHashTable *ShownProviderHash;
extern GHashTable *ProviderHash;

/* args variables */
extern gchar *ScriptPath;
extern gchar *ScriptFilename;
extern gint MyScripts;

/* global functions */
PProvider_t CreateProviderFromFile(const char FileName[]);
void DeleteProvider(PProvider_t Pv);
void CreateArgv( PcmdParam_t sms_param );
void LaunchSms(PProvider_t Pv, gboolean Help, gboolean Update);
void DelayedSms(gpointer data, gpointer user_data);
#endif
