/*************************************************************************
 * Misc. functions we need, portability stuff etc
 * Copyright (c) 1998-9    Andy Kempling (aurikan@hotmail.com),
 * Copyright (c) 1998-2001 Colin Phipps <cphipps@doomworld.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *************************************************************************/

/* $Id: lib.c,v 1.7 2001/07/21 10:18:18 cph Exp $ */

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "ircstats.h"

#ifndef HAVE_STRLWR

char* strlwr(char* s)
{
  char *t = s;
  while (*t) {
    *t = tolower(*t);
    t++;
  }
  return s;
}

#endif

#ifndef HAVE_STRLCPY

/* Safe string handling functions */

/* As per the standard, strlcpy copies at most len bytes from the source
 * into the destination, zero-terminates, and returns the number of 
 * bytes copied. I think that's right anyway.
 */
size_t strlcpy(char* dest, const char* source, size_t len)
{
   size_t done = 0;
   while (*source && --len)
     done++, *dest++ = *source++;

   *dest++ = 0;
   return done;
}

#endif

#ifndef HAVE_STRLCAT

/* As per the standard, strlcpy copies at most len bytes from the source
 * into the destination, zero-terminates, and returns the number of 
 * bytes copied. I think that's right anyway.
 */
size_t strlcat(char* dest, const char* source, size_t len)
{
   int n = strlen(dest);
   return strlcpy(dest+n, source, len-n);
}

#endif

/* strcasestr - case insensitive version of strstr */
char* strcasestr(char* haystack, const char* needle)
{
  const char *p = needle;
  while (*haystack) {
    if (tolower(*haystack++) == tolower(*p)) {
      if (!*++p) return (haystack - strlen(needle));
    } else p = needle;                              
  }
  return NULL;
}

/* stripansi - removes ansi escape codes from a string */
void stripansi(char* str)
{
  char *p = str, ch;

  while (*str) {
    /* While there are characters and no ESC, copy them */
    while ((ch = *str++) && (ch != 033))
      *p++ = ch;
    /* Skip all characters to end of string or ESC sequence */
    while (ch && (ch != 'm'))
      ch = *str++;
  }
  *p = 0;
}

char* strdup_from_rmatch(const char* str, const regmatch_t* prm)
{
  char *p = calloc(sizeof(char), prm->rm_eo - prm->rm_so + 1);
  memcpy(p, str + prm->rm_so, prm->rm_eo - prm->rm_so);
  return p;
}
