/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/ 

/*
 * Date:	March 4, 2002
 * Edited by:	Ledio Ago
 * Description:	Previosly this code didn't work with binary data.  From
 *		now on, this code will also process binary data using
 *		the new client archive.
 */

#include "PutProtocol.h"

using namespace std;

PutProtocol::PutProtocol(ClientDB *cDB,Communication * new_comm,char * contents,char *tags,char *new1,
			 char *preprocess,char *redirects,char *distracts)
	: PutParser(distracts)
{
	this->cDB = cDB;
	comm = new_comm;
	this->contents = contents;
	this->tags = tags;
	this->new1 = new1;
	this->preprocess = preprocess;
	this->redirects = redirects;

}

void PutProtocol::putNewURL()
{
  char outword[30];
  int cnt;

  cnt = 2;

  sprintf(outword,"URLS-NEW COUNT=%d",cnt);
  send(outword, strlen(outword));

  for(;cnt>0;cnt--) {
	char *tmp = "<new-url>";
  	send(tmp, strlen(tmp));  // DB.NewURL
  }
}

void PutProtocol::putDueURL()
{
  char outword[SEND_LINE_LENGTH];
  string str;
  int ret;
  int cnt;
  // string URL;
  // string contents;
  // unsigned long size;
  // unsigned long CRC;
  // unsigned int st;
  // status_t status;
  // string mime;
  // string redirURL;
  URLHandler *url_info = NULL;

#ifdef LOG		
  log = fopen("putlog.log","a");
#endif

  /* Turn Compression On */
#ifdef COMM_COMPRESSION
  comm->init_compression();
#endif

  cnt = cDB->recordCount();

  sprintf(outword,"URLS-DUE COUNT=%d",cnt);
  send(outword, strlen(outword));

  for(;cnt>0;cnt--,contents="") {
	try {
		/* Retrieving from the CDB url infomation:
		 * URL, size, CRC, contents, MIME, redirURL, status
		 */
		ret = cDB->CrawlRetrieve( &url_info );	
	}
	catch ( GrubExp& exp ) {

		clog(GCLOG_CRIT, "PutProtocol: CrawlRetrieve failed: %s",exp.what());
		exit(1);
	}	

	if (ret == CRAWLED_URLS_TBL_EMPTY) {

		clog(GCLOG_CRIT, "PutProtocol%d: Less URLs found in CDB than rec_count reported!!!!",ret);
		if ( url_info ) { delete url_info; url_info = NULL; }
		exit(1);
	}
	str = url_info->URL;
	str += " STATUS=";
	// <with-contents>
	if (url_info->status == UPDATE) {
		sprintf(outword,"UPDATE DATE=%lu SIZE=%lu CRC32=%lu" " MIME=%s",(unsigned long) time(NULL),
			url_info->size,url_info->CRC,url_info->MIME);

 		str += outword;
		send(str.c_str(), str.length());
#ifdef LOG	
		fprintf(log,"%s\n",str.c_str());		
#endif	
		Verboseprintf("%s\n",str.c_str());
		send(url_info->content, url_info->size);
		if ( url_info ) { delete url_info; url_info = NULL; }
		continue;	
	}
	else if (url_info->status == REDIRECT) {
		sprintf(outword,"REDIRECT URL=%s DATE=%lu SIZE=%lu CRC32=%lu" " MIME=%s",url_info->redirURL,
			(unsigned long) time(NULL),url_info->size,url_info->CRC,url_info->MIME);

	 	str += outword;
		send(str.c_str(), str.length());
#ifdef LOG			
		fprintf(log,"%s\n",str.c_str());		
#endif			
		Verboseprintf("%s\n",str.c_str());         
		send(url_info->content, url_info->size);
		if ( url_info ) { delete url_info; url_info = NULL; }
		continue;
	}
	// <no-contents>	
	switch (url_info->status) {
		case UNCHANGED:
			str += "UNCHANGED";
			break;
		case NOTFOUND:
			str += "NOT-FOUND";
			break;
		case DOWN:
			str += "DOWN";
			break;
		case NOCRAWL:
			str += "NO-CRAWL";
	}

        Verboseprintf("%s\n",str.c_str()); 
	#ifdef LOG	
		fprintf(log,"%s\n",str.c_str());
	#endif
	send(str.c_str(), str.length());

	// delete url_info handle
	if ( url_info ) { delete url_info; url_info = NULL; }
  }

#ifdef LOG		
  fclose(log);
#endif

  //Flush the output after all data has been written
  flush();

  /* Stop Compression */
#ifdef COMM_COMPRESSION
  comm->end_compression();
#endif

}

int PutProtocol::protocol() throw (ProtocolExp)
{	
	try {
		
		parse();
	}
	catch (ParseExp& e) { throw ProtocolExp(e.what(),e.getcode()); }

	return 0;
}


void PutProtocol::flush()
{
  int ret;
 
  ret = comm->flush();
  if (ret<0) {
        throw ParseExp("Communication Error (flush)",COMM_ERROR);
  }                                                          
}


int PutProtocol::send(const char *msg, int msg_len)
{
  int ret;

  /*Comm's write method provides a buffered write*/
  ret = comm->write(msg, msg_len);
  if (ret<0) {
  	throw ParseExp("Communication Error (send msg)",COMM_ERROR);
  }

  //Output a newline char after each line sent 
  ret = comm->write("\n",1);
  if (ret<0) {
	throw ParseExp("Communication Error (send msg return)",COMM_ERROR);
  }  

  return ret;
}
