/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/  

#ifndef _Parser_H_
#define _Parser_H_

#include <GrubExp.h>

// Error Codes used within ParseExp
#define PERFORM_GET_CAPTION 12
#define PERFORM_GET_URL 13
#define OK_PUT_ERROR 33
#define COMM_ERROR 25
#define NO_URLS 26

// Exception used when an error in parsing the protocol has occured.
class ParseExp : public GrubExp {
public:
	ParseExp() throw();
	ParseExp( const char *msg, int code = 0 ) throw();
	ParseExp( const ParseExp& ) throw();
	virtual ParseExp& operator=( const ParseExp& exp ) throw();
	virtual int getcode() throw();
private:
	int code;
};

/* class Parser
 * This class should be derived, and its parse() method must be implemented.
 * The parse() method should now how to parse the protocol, and call the
 * appropriate methods that correspond to the particular part of the protocol.
 * Those methods in the class deriving this class should not do anything.
 * This "callback" methods must all be decrared virtual (not pure virtual).
 * A new class that will derive this derived class will then provide new
 * implementation for the empty methods (if necessary).
 * Also, read Protocol.h for more on the usage.
 */
class Parser {
public:
	virtual ~Parser() { }

	/* parse()
	 * This method will start validating the correctness of the protocol,
	 * and will call the appropriate virtual methods, that should be
	 * implemented by the deriving class, which correspond to the correct
	 * piece of the protocol.
	 */
	virtual void parse() throw(ParseExp) = 0;
};

#endif   // _Parser_H_
