/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/  

#include "GetProtocol.h"

using namespace std;

GetProtocol::GetProtocol(ClientDB *cDB,Communication *new_comm)
	: GetParser(new_comm)
{
  this->cDB = cDB;
}


void GetProtocol::getNewURL(string URL, unsigned long size, unsigned long CRC)
{

#ifdef DEBUG
	cout << "getNewURL called: " << URL << " " << size << " " << CRC << endl;
#endif

	if (onSuperVerbose())
	{
		Verboseprintf("%s: size=%lu, CRC=%lu\n",URL.c_str(),size,CRC);
	}

	int ret = cDB->GetInsert(URL.c_str(),size,CRC);

	if (ret==OUT_OF_MEM_CDB) 
	{
		clog(GCLOG_CRIT, "GetProtocol::getNewUrl: !!!CDB OUT OF MEMORY!!!!");
		exit(1);
	}

#ifdef DEBUG
	printf("GetProtocol::getNewURL(): reccount %d\n", cDB->recordCount() );
#endif
}

void GetProtocol::getOldURL(string URL)
{

#ifdef DEBUG
	cout << "getOldURL called: " << URL << endl;
#endif

}

int GetProtocol::protocol() throw (ProtocolExp)
{
	try {
		parse();
	}
	catch (ParseExp& e) { throw ProtocolExp(e.what(),e.getcode()); }

	return 0;
}
