#include "XmlWrapper.h"
#include <cstdio>
#include <cstdlib>

void test_creating_xml()
{
	XmlWrapper xml;

	xml.addSimpleHeader();
	xml.openElement("root");
		xml.openElement("user");
			xml.addElementString("firstName", "Igor");
			xml.addElementString("lastName", "Stojanovski");
			xml.addElementInt("age", 23);
			xml.addElementDouble("GPA", 3.55);
		xml.closeElement("user");
		xml.openElement("user");
			xml.addElementString("firstName", "Ledio");
			xml.addElementString("lastName", "Ago");
			xml.addElementInt("age", 22);
			xml.addElementDouble("GPA", 3.45);
		xml.closeElement("user");
	xml.closeElement("root");
	printf("---BEGIN---\n%s\n---END---\n", xml.getData() );
}

const char *test_parsing_str =
	"<?xml version=\"1.0\"?>\n"
	"\n"
	"<root>\n"
	"        <user>\n"
	"                <firstName>Igor</firstName>\n"
	"                <lastName>Stojanovski</lastName>\n"
	"                <age>23</age>\n"
	"                <GPA>3.550000</GPA>\n"
	"        </user>\n"
	"        <user>\n"
	"                <firstName>Ledio</firstName>\n"
	"                <lastName>Ago</lastName>\n"
	"                <age>22</age>\n"
	"                <GPA>3.450000</GPA>\n"
	"        </user>\n"
	"</root>\n";

const char *bad_test_parsing_str =
	"<?xml version=\"1.0\"?>\n"
	"\n"
	"<root\n"
	"        <user>\n"
	"                <firstName>Igor</firstName>\n"
	"                <lastName>Stojanovski</lastName>\n"
	"                <age>23</age>\n"
	"                <GPA>3.550000</GPA>\n"
	"        </user>\n"
	"        <user>\n"
	"                <firstName>Ledio</firstName>\n"
	"                <lastName>Ago</lastName>\n"
	"                <age>22</age>\n"
	"                <GPA>3.450000</GPA>\n"
	"        </user>\n"
	"</root>\n";

#define PARSE_DATA_ERRORCHECK() \
	do { \
		if ( ret != 0 ) { \
			printf("ERROR parsing XML: %s (%d)\n", \
				xml.lastErrorMsg(), \
				xml.lastErrorLineNumber() ); \
			exit(1); \
		} \
	} while (0)

#define PARSED_VALUE_ERRORCHECK(ret) \
	do { \
		if ( ret == 1 ) \
			printf("OK\n"); \
		else if ( ret == 0 ) \
			printf("NOT FOUND\n"); \
		else if ( ret == -1 ) \
			printf("BAD FORMAT\n"); \
		else \
			printf("BUG -- BAD RETURN VALUE\n"); \
	} while (0)

#define PARSED_VALUE_STRING(tag, index) \
	do { \
		char *buf; \
		int ret; \
		ret = xml.parsedValueString(tag, index, buf); \
		printf("\n%s[%d]: '%s' - ", tag, index, buf); \
		PARSED_VALUE_ERRORCHECK(ret); \
	} while (0)

#define PARSED_VALUE_INT(tag, index) \
	do { \
		int val; \
		int ret; \
		ret = xml.parsedValueInteger(tag, index, val); \
		printf("\n%s[%d]: %d - ", tag, index, val); \
		PARSED_VALUE_ERRORCHECK(ret); \
	} while (0)

#define PARSED_VALUE_DOUBLE(tag, index) \
	do { \
		double val; \
		int ret; \
		ret = xml.parsedValueDouble(tag, index, val); \
		printf("\n%s[%d]: %lf - ", tag, index, val); \
		PARSED_VALUE_ERRORCHECK(ret); \
	} while (0)

void test_parsing()
{
	XmlWrapper xml;
	int ret;
	
	ret = xml.parseData( test_parsing_str );
//	ret = xml.parseData( bad_test_parsing_str );
	PARSE_DATA_ERRORCHECK();

	// testing string stuff
	printf("String tests:\n\n");

	PARSED_VALUE_STRING(".root.user.firstName", 0);
	PARSED_VALUE_STRING(".root.user.lastName", 0);
	PARSED_VALUE_STRING(".root.user.GPA", 0);
	PARSED_VALUE_STRING(".root.user", 0);
	PARSED_VALUE_STRING(".root", 0);
	PARSED_VALUE_STRING("", 0);
	PARSED_VALUE_STRING(".", 0);

	PARSED_VALUE_STRING(".root.user.firstName", 1);
	PARSED_VALUE_STRING(".root.user.lastName", 1);
	PARSED_VALUE_STRING(".root.user.GPA", 1);
	PARSED_VALUE_STRING(".root.user", 1);
	PARSED_VALUE_STRING(".root", 1);
	PARSED_VALUE_STRING("", 1);
	PARSED_VALUE_STRING(".", 1);

	PARSED_VALUE_STRING(".root.user.firstName", 12);
	PARSED_VALUE_STRING(".root.user.lastName", 321);
	PARSED_VALUE_STRING(".root.user.GPA", 32);
	PARSED_VALUE_STRING(".root.user", 213);
	PARSED_VALUE_STRING(".root", 12334);
	PARSED_VALUE_STRING("", 234534);
	PARSED_VALUE_STRING(".", 1231);

	// testing integer stuff
	printf("\n\nInteger tests:\n\n");

	PARSED_VALUE_INT(".root.user.firstName", 0);
	PARSED_VALUE_INT(".root.user.age", 0);
	PARSED_VALUE_INT(".root.user.GPA", 0);
	PARSED_VALUE_INT(".root.user", 0);
	PARSED_VALUE_INT(".root", 0);
	PARSED_VALUE_INT("", 0);
	PARSED_VALUE_INT(".", 0);

	PARSED_VALUE_INT(".root.user.firstName", 1);
	PARSED_VALUE_INT(".root.user.age", 1);
	PARSED_VALUE_INT(".root.user.GPA", 1);
	PARSED_VALUE_INT(".root.user", 1);
	PARSED_VALUE_INT(".root", 1);
	PARSED_VALUE_INT("", 1);
	PARSED_VALUE_INT(".", 1);

	PARSED_VALUE_INT(".root.user.firstName", 12);
	PARSED_VALUE_INT(".root.user.age", 321);
	PARSED_VALUE_INT(".root.user.GPA", 32);
	PARSED_VALUE_INT(".root.user", 213);
	PARSED_VALUE_INT(".root", 12334);
	PARSED_VALUE_INT("", 234534);
	PARSED_VALUE_INT(".", 1231);

	// testing double stuff
	printf("\n\nDouble tests:\n\n");

	PARSED_VALUE_DOUBLE(".root.user.firstName", 0);
	PARSED_VALUE_DOUBLE(".root.user.age", 0);
	PARSED_VALUE_DOUBLE(".root.user.GPA", 0);
	PARSED_VALUE_DOUBLE(".root.user", 0);
	PARSED_VALUE_DOUBLE(".root", 0);
	PARSED_VALUE_DOUBLE("", 0);
	PARSED_VALUE_DOUBLE(".", 0);

	PARSED_VALUE_DOUBLE(".root.user.firstName", 1);
	PARSED_VALUE_DOUBLE(".root.user.age", 1);
	PARSED_VALUE_DOUBLE(".root.user.GPA", 1);
	PARSED_VALUE_DOUBLE(".root.user", 1);
	PARSED_VALUE_DOUBLE(".root", 1);
	PARSED_VALUE_DOUBLE("", 1);
	PARSED_VALUE_DOUBLE(".", 1);

	PARSED_VALUE_DOUBLE(".root.user.firstName", 12);
	PARSED_VALUE_DOUBLE(".root.user.age", 321);
	PARSED_VALUE_DOUBLE(".root.user.GPA", 32);
	PARSED_VALUE_DOUBLE(".root.user", 213);
	PARSED_VALUE_DOUBLE(".root", 12334);
	PARSED_VALUE_DOUBLE("", 234534);
	PARSED_VALUE_DOUBLE(".", 1231);
}

int main()
{

//	test_creating_xml();
	test_parsing();

	return 0;
}

