#include <grubface.h>
#ifndef GRUB_UNIX
#include <winsock.h>
#endif
#include <cstdio>
#include <testgui.h>
#include <msgface.h>
#include <SocketComm.h>

#define PORTNUM 5123

void do_action3();

int read_fn( void *arg, const char *buf, unsigned int len )
{
	printf( "read_fn(%d): '%s'\n", len, buf );

	return 0;
}

void error_fn( void *ptr, const char *msg )
{
	printf("error_fn: ptr (%p); msg '%s'\n", msg, msg );
}


int main()
{
#ifndef GRUB_UNIX
	WSADATA info;
#endif
//	int ret;

#ifndef GRUB_UNIX
	/* initialize the socket library */
	if (WSAStartup(MAKELONG(1, 1), &info) == SOCKET_ERROR) {
		return 1;
	}
#endif

#ifdef FIRST_TEST
	ret = grub_attach( "localhost", PORTNUM );
	if ( ret != GF_SUCCESS ) {

		fprintf( stderr, "grub_attach() returned %d\n", ret );
		exit(1);
	}

	test_loop(1);

	grub_detach();
#else  /* FIRST_TEST */
#ifdef SEC_TEST
//	ret = grub_attach( "localhost", PORTNUM );
//	if ( ret != GF_SUCCESS ) {
//
//		fprintf( stderr, "grub_attach() returned %d\n", ret );
//		exit(1);
//	}

	SocketComm scomm( "localhost", PORTNUM, read_fn, error_fn );

	scomm.initSock();

//	Sleep(10000);

	ret = scomm.send( "first", 5 );
	if ( ret )
		printf( "send failed: %d: %s\n", ret, scomm.getError() );
	else
		printf( "send success\n" );

	Sleep(10000);
	ret = scomm.send( "third", 5 );
	if ( ret )
		printf( "send failed: %d: %s\n", ret, scomm.getError() );
	else
		printf( "send success\n" );


	Sleep(1000000);

	grub_detach();
#else  /* SEC_TEST */
	/* THIRD_TEST */
//	do_action3();

//	test_loop_MsgManager(1);
//	test_loop_ConsoleFace(1);
	test_server_simulator(1, NULL);

#endif  /* ! SEC_TEST */
#endif  /* ! FIRST_TEST */

#ifndef GRUB_UNIX
	WSACleanup();
#endif

	return 0;
}

void do_action3()
{
	test_loop2(1);
}
