#ifndef LOG_FILE_H
#define LOG_FILE_H
#include <stdio.h> 
#ifdef USE_THREADS
#include <TThread.h>
#endif
#include "filename.h" 
#include <deque>  
#define PERMS 			0660 // default permissons for creating log file
#define DEFAULT_MAX_SIZE 	1000000000// the default max size of the log file 10Mb?
#define MAX_STRING_LEN 		2048 // enough ?
#define MAX_PATH_LEN 		1024 // system dependent. But it is not critical here.
#define DEFAULT_LOG_PATH 	"."  // the default path where log files are kept
			     	     // don't end with a PATH_DELIMITOR
#define DEFAULT_NUM_LOG_FILES 	15   // the default max num of log files at the 
				     // default path
extern "C" 
{

// With the addition of class GrubCLog levels DEBUG and above make sense
// also defined in clog.h
#define GCLOG_TRACE 1
#define GCLOG_DEBUG 2
#define GCLOG_INFO  4
#define GCLOG_ERR   8
#define GCLOG_ALERT 16 
#define GCLOG_CRIT  32
#define GCLOG_EMERG 64

#define GCLOG_NOERRNO     (GCLOG_EMERG + 1)

#ifndef DEFAULT_LOGLEVEL 
#define DEFAULT_LOGLEVEL GCLOG_WARNING
#endif
}

class GC_Log 
{
	private:
		FILE *log_stream; //the stream the log will be written to
		int MAX_SIZE; //the max size of the log file
		unsigned log_mask;
		bool open_failed; //a flag for open/create log file
		bool LOG_TO_STDOUT_ALSO;
		bool open_by_me; //true = log stream is opened by this file 
#ifdef USE_THREADS
		Mutex *mutex_log; //a mutex of the class
#endif
		unsigned max_num_of_logfiles;
		std::deque<filename> logfile_queue; //maintain the logfiles 
		char* default_path; //the default path where the log files are kept
		char orig_filename[MAX_STRING_LEN]; // the given name of log file
		bool remove_onmax; // true if remove-on-max feature is turned on
	public:
		//open log stream for writing/reading
		GC_Log(FILE *stream, int max_size, bool log_to_stdout_also,
				unsigned mask);

		//open a log file for writing/reading
		/* ozra's addition */
		/* when remove on max is turned on, after max size is reached
		 * the big log file will be removed, and a new one with the same
		 * name will be opened.
		 */
		GC_Log(char *file, int max_size, bool log_to_stdout_also,
				unsigned mask, bool remove_on_max = false); 

		~GC_Log(); //close the log stream if necessary
		/* check the size of the file if the stream is a regular file. 
		 * open a new log file if the size of the file exceeds 
		 * max_size. The oldest log file will be deleted if the number
		 * of log files exceed the max_num_of_logfiles
		 * return false if there is error*/
		bool check_log_file();
		void enableLog(unsigned mask);
		//this method can be used to configure the size of the log file
		void changeMaxSize(int size);
		//append a log record to the stream
		int logprintf(int level, char *information);
		//set the max num of log files that can be kept
		void setMaxNumOfLogfiles(int num);
		/* get the list of log files at the default directory 
		 * (it can be changed anyway). */
		bool get_logfile_list();
		void setDefaultPath(char *path);	
};

#endif
