/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2001 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _TUBE_H_
#define _TUBE_H_

#include "element.h"

class Ball;

class Tube : public Element {
protected:
   Element* _start;
   Element* _end;
public:
   Tube() : _start(0), _end(0) {}
   Tube(const Tube& tube) {_start = tube._start; _end = tube._end;}
   void ConnectLeft(Element* element) {_start = element;}
   virtual void ConnectTop(Element* element) = 0;
   void ConnectRight(Element* element) {_end = element;}
   virtual void ConnectBottom(Element* element) = 0;
   void ToggleDirection();
   virtual void MoveBall(Ball* ball) = 0;
   Element* GetStart() {return _start;}
   Element* GetEnd() {return _end;}
};

class RightTube : public Tube {
public:
   RightTube() {}
   RightTube(const Tube& tube) : Tube(tube) {}   
   void ConnectTop(Element* element) {_end = element;}
   void ConnectBottom(Element* element) {_start = element;}
   void MoveBall(Ball* ball);
};

class LeftTube : public Tube {
public:
   LeftTube() {}
   LeftTube(const Tube& tube) : Tube(tube) {}   
   void ConnectTop(Element* element) {_start = element;}
   void ConnectBottom(Element* element) {_end = element;}
   void MoveBall(Ball* ball);
};

#endif // _TUBE_H_
