/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Chat rooms.  See also: OscarChatNav.
 */

#import <Oscar/OscarChat.h>
#import <Oscar/OscarHandlers.h>
#import <Oscar/OscarFlap.h>
#import <Oscar/OscarBuffer.h>
#import <Oscar/OscarEncoding.h>
#import <Grouch/GrouchClient.h>

#import <Foundation/NSRunLoop.h>
#import <Foundation/NSData.h>

#include <time.h>

@interface OscarChatSnacHandler : OscarSnacHandler
+ get;
- init;
@end
@implementation OscarChatSnacHandler : OscarSnacHandler
+ get
{
	static id r = nil;
	if( r )
		return r;
	else
		return r = [self new];
}

- init
{
	[super init];
	[self addFamily:[OscarServiceHandler get]];
	[self addFamily:[OscarChatHandler get]];
	return self;
}
@end

@implementation OscarChat

+ chatForHost:(NSString*)host withCredentials:(id<OscarCredentials>)cred
  andClient:(OscarClient*)cli underName:(NSString*)chan
{
	id r = [self new];
	[r initForHost:host withCredentials:cred andClient:cli underName:chan];
	return r;
}

- initForHost:(NSString*)host withCredentials:(id<OscarCredentials>)cred
  andClient:(OscarClient*)cli underName:(NSString*)chan
{
	[name=chan retain];
	[OscarDetachedFlapInitializer go:self host:host creds:cred
	 snac:[OscarChatSnacHandler get] client:cli
	 loop:[NSRunLoop currentRunLoop] fatal:NO];
	return self;
}

- init
{
	[super init];
	name = nil;
	online = NO;
	return self;
}
- (void)dealloc
{
	if( name )
		[name release];
	[super dealloc];
}

- (NSString*)name
{
	return name;
}

- (void)welcome
{
	online = YES;
	[[self client] gotChannel:self];
}

- (void)connectionClosed:sock
{
	if( online )
		[[self client] lostChannel:self];
	[self release];
}

- (void)sendMessage:(NSString*)msg withFlags:(GrouchMessageFlags)fl
{
	OscarBuffer *outb = [OscarBuffer snacWithFamily:0x0e andType:0x05
	andFlags:0 andTag:nil];
	static int ok = 0;

	[outb addInt32:time(NULL)];	// Msg cookie
	[outb addInt32:++ok];		// (cont)
	[outb addInt16:0x03];		// Channel
	if( (fl & GrouchMessageReflect) )
		[outb addTLV:0x06 withBuffer:NULL andLength:0];

	{
		OscarBuffer *out2 = [OscarBuffer new];
		NSString *encoding;
		NSStringEncoding use;
		int dontcare;
		NSData *buf;

		[OscarEncoding encodeString:msg encodingName:&encoding
		 encodingID:&use intFlag:&dontcare and:&dontcare];

		buf = [msg dataUsingEncoding:use];

		[out2 addTLV:0x01 withBuffer:[buf bytes]
		      andLength:[buf length]];
		[out2 addTLV:0x02 withString:encoding];
		[out2 addTLV:0x03 withString:@"lang"];

		[outb addTLV:0x05 with:out2];
		[out2 release];
	}

	[self write:outb];
	[outb release];
}

@end

