/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * A TLV is this wonderful encapsulation method from the kind folks at AOL.
 *
 * We'll encounter to types of TLVs:
 * 1. the "assume the rest of the message is a TLV"
 * 2. the "we'll give you a word N, and then N tlvs"
 */

#import <Oscar/OscarBuffer.h>
#import <Oscar/OscarIncomingSnac.h>

// This handles reading both types #1 and #2 above.
// The constructors are a bit funny; let OscarIncomingSnac handle
// them for you, because they're not meant for general consumption ;-)
@interface OscarTlvListIn : NSObject
{
	const char *buf;
	size_t len;
}

// if "n" is NULL, it is assumed that this is type #1 above.
// otherwise, "n" should point to the number of TLVs in the buffer,
// i.e. the first word in (2), then the count of these TLVs is stored
// back at "n" so that OscarIncomingSnac and skip that many bytes
// and continue parsing like there wasn't a TLV list there.
+ listFromBuffer:(const void*)buf andLength:(size_t)l andTLVs:(size_t*)n;
- initWithBuffer:(const void*)buf andLength:(size_t)l andTLVs:(size_t*)n;

// may return NULL.
// this is autoreleased.
- (OscarIncomingSnac*)getTLV:(int)type;

- (const void*)buffer;
- (size_t)length;
@end

// This class is for generating TLV lists of type (2) in the comment
// above.  Use it as an arg to OscarBuffer-add:, and it will automatically
// calculate the first word N at write-time.
// Note that I said at write-time, meaning when the socket writes.  So
// you can continue adding TLVs to the list after you've added it to the
// OscarBuffer, and the socket will get your updated TLVs.

@interface OscarTlvListOut : OscarBuffer
{
	unsigned int n;
}

// use +new to instantiate.

- init;

- createHeapBuffer:(void**)ptrptr withLength:(size_t*)len;

- addTLV: (int)type;
- addTLV: (int)type with:obj;
- addTLV: (int)type withBuffer:(const void *)buf andLength:(size_t)l;
- addTLV: (int)type withInt16:(int) i;
- addTLV: (int)type withInt32:(int) i;
- addTLV: (int)type withString:(NSString*)s;
@end

