/*
 *  cddb implementation routines are contained in here.
 *  
 *  the disc id computation routines were taken from the cddb implementation
 *  document.  it's a wonderful world we have.  the internet rules. :)
 *
 *							- Mark
 *
 */

#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <dirent.h>

#include "gcd.h"

#define READ_WRITE	0x01
#define READ_ONLY	0x02

extern struct cdinfo thiscd;
extern char *prog_name, *prog_ver;

int code = 0;		/* Return value for sending data to the server */
char cddb_msg[255];	/* Return message of server info */
int sock = 0;		/* Descriptor for our socket */
int sock_mode = 0;	/* Server read/write status */
FILE *sk;		/* Stream descriptor for our socket */
FILE *ldb;		/* Local database stream */

#define SEND(x)		fprintf(sk, "%s\n", x); \
                	fflush(sk);


void parse_trails(char *ss)
{
   int i;
   
   
   for (i=0; i<strlen(ss); i++)
   {
      if (ss[i] == '\r' || ss[i] == '\n')
        ss[i] = 0;
   }
}

/**** START CALCULATION ROUTINES FOR DISC ID *****************************/
 
int cddb_sum(int n)
{
   char    buf[12],
           *p;
   int     ret = 0;

                             
   /* For backward compatibility this algorithm must not change */
   sprintf(buf, "%lu", (unsigned long) n);
   for (p = buf; *p != '\0'; p++)
      ret += (*p - '0');
                        
   return (ret);
}
                                
unsigned long cddb_discid(int tot_trks)
{
   int     i,
           t = 0,
           n = 0;
   struct trackinfo *cdtoc = thiscd.trk;
                                                                        
   /* For backward compatibility this algorithm must not change */
   for (i = 0; i < tot_trks; i++)
      n += cddb_sum((cdtoc[i].min * 60) + cdtoc[i].sec);
                        
   t = ((cdtoc[tot_trks].min * 60) + cdtoc[tot_trks].sec) -
       ((cdtoc[0].min * 60) + cdtoc[0].sec);
                                             
   return ((n % 0xff) << 24 | t << 8 | tot_trks);
}

/**** END CALCULATION ROUTINES *******************************************/

/**** START GENERAL NETWORK CODE *****************************************/

void cddb_code()
{
   char s[255];


   code = 0;

   if (fgets(s, 255, sk) == NULL)
     return;
   
   s[3] = 0;
   
   code = atoi(s);
   strcpy(cddb_msg, &s[4]);
}  

FILE *get_entry(char *dir, int idx, unsigned int id, int tracks)
{
   struct dirent *entry;
   struct stat st;
   FILE *fd;
   DIR *dfd;

   /* id + tracks */
   sprintf(&dir[idx],"/%08x", id);

   fd = fopen(dir, "r");
   if (fd)
     return fd;

   fd = fopen(dir, "r");
   if (fd)
     return fd;

   /* recurse subdirectories */
   dir[idx] = 0;
   dfd = opendir(dir);
   dir[idx++] = '/';

   while((entry = readdir(dfd)))
   {
     /* ignore dot-files (inc current and parent dirs) */
     if (entry->d_name[0] == '.')
       continue;

     strcpy(&dir[idx], entry->d_name);
     if(!stat(dir, &st) && S_ISDIR(st.st_mode))
     {
       fd = get_entry(dir, idx + strlen(&dir[idx]), id, tracks);
       if (fd)
         return fd;
     }
   }
   closedir(dfd);
   return 0;
}


int cddb_connect(char *host, int port)
{
   char *dir, s[PATH_MAX+NAME_MAX+1];
   struct sockaddr_in sin;
   struct hostent *h;
   DIR *d;
   int idx;


   /* Before connecting, let's check to make sure we don't already
      have a match in the local CD database
   */

   idx = 0;
   dir = CDDB_DIR;
   if (*dir == '~')
   {
     dir++;
     strcpy(s, getenv("HOME"));
     idx = strlen(s);
   }
   strcpy(&s[idx], dir);
   if ((d=opendir(s)) == NULL)
     mkdir(s, S_IRUSR|S_IWUSR|S_IXUSR);
   else
     closedir(d);

  
   attrset(COLOR_PAIR(C_BLUE_HL)|A_BOLD);

   idx = strlen(s);
   ldb = get_entry(s, idx, (unsigned int) thiscd.cddb_id, thiscd.ntracks);

   if (ldb)     /* If the file exists, no need to login */
   {
     mvprintw(23, 1, "Reading CD info from cache...");
     refresh();
     
     code = 69;
     cddb_readcdinfo(ldb);
     fclose(ldb);
     return(-1);
   } 

// printf("Connecting to %s: ",host);

   mvprintw(23, 1, "Resolving host...");
   refresh();

   if ((h = gethostbyname(host)) == NULL)
     return(0);
 
   bcopy(h->h_addr, (char *) &sin.sin_addr, h->h_length);
                    
   sin.sin_family = h->h_addrtype;
   sin.sin_port   = htons(port);

   mvprintw(23, 1, "Connecting to CDDB server...");
   refresh();
                            
   if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
     return(0);
                                               
   if (connect(sock, (struct sockaddr *) &sin, sizeof(sin)) < 0)
     return(0);
   
   sk = fdopen(sock, "r+");
   if (sk == NULL)
   {
     close(sock);
     return(0);
   }
    
   cddb_code();
   if (code == 200)
     sock_mode = READ_WRITE;
   else {
     if (code == 201)
       sock_mode = READ_ONLY;
     else {
       printf("Connection refused after connect: %d\n",code);
       fflush(stdout);
       getchar();
       return(0);
     }
   }
   
   return(1);   
}

void cddb_disconnect()
{
   SEND("quit");
   close(sock);
   fclose(sk);
}

int cddb_login()
{
   char *hostname, *logname, s[255];
   
    
   mvprintw(23, 1, "%-40s", "Logging in...");
   refresh();
     
   hostname = getenv("HOSTNAME");
   logname  = getenv("LOGNAME");
   if (hostname == NULL || logname == NULL)
   {
     default_track_info(1);
     return(0);
   }
   
     
   sprintf(s,"cddb hello %s %s %s %s", logname, hostname, prog_name, prog_ver);
   SEND(s);
   
   cddb_code();
   if (code == 200 || code == 402)
     return(1);
   else {
     mvprintw(24, 1, "CDDB access denied (code %d).",code);
     refresh();
     getchar();
   }
   
   default_track_info(2);
   return(0);
}

/**** END GENERAL NETWORK CODE *******************************************/

/**** START CDDB INTENSIVE ROUTINES **************************************/

/* Sends query to server -- this is the first thing to be done */
void cddb_query()
{
   char s[255], s1[81], *ss;
   int i;
   
   
  
   mvprintw(23, 1, "%-40s", "Querying database...");
   refresh();
   
   sprintf(s,"cddb query %08x %d ",(unsigned int) thiscd.cddb_id, thiscd.ntracks);
   for (i=0; i<thiscd.ntracks; i++)
   {
      sprintf(s1,"%d ", thiscd.trk[i].start);
      strcat(s, s1);
   }
   
   sprintf(s1,"%d", thiscd.length);
   strcat(s, s1);
     
   SEND(s);
   cddb_code();
   
   switch(code)
   {
     case 200:  /* Success, get the catagory ID */
       ss = strchr(cddb_msg, 32);
       *ss = 0;
       strcpy(thiscd.catagory, cddb_msg);
      
       break;
     default:
       default_track_info(3);
       
       cddb_msg[strlen(cddb_msg)-1] = 0;
       
       attrset(COLOR_PAIR(C_BLUE_HL));
       mvprintw(24, 1, "(%02d): %s", code, cddb_msg);
       refresh();
       getchar();
       
       return;
   }
  
   cddb_readcdinfo(sk);
}

/* Ask the server to send the entire CD information (track names, ect) 
 * This can ONLY be called directly after cddb_query(), since it uses
 * the same return code from the server as cddb_query().
 */


void default_track_info(int i)
{
   int t;
   char s[255];
   

   strcpy(thiscd.cdnames,"CD Artist / CD Name (Change Me!)");
   
   for (t=0; t<thiscd.ntracks; t++)
   {
      sprintf(s, "Track %02d", t+1);
      if ((thiscd.trk[t].songname = malloc(strlen(s)+1)) == NULL)
      {
        perror("allocate_trackname");
        exit(0);
      }        
      strcpy(thiscd.trk[t].songname, s);
   } 
}
 
void cddb_readcdinfo(FILE *desc)
{
   char s[255], *ss;
   int t;
   FILE *f = NULL;

   
   if (code != 69)
   {
     if (code == 200)  // cddb_query was a success, request info
     {
       mvprintw(23, 1, "%-40s", "Downloading CD info...");
       refresh();
       
       sprintf(s,"cddb read %s %08x",thiscd.catagory, (unsigned int) thiscd.cddb_id);
       SEND(s);   
       cddb_code();
 
       if (code != 210) 
       {   
         printf("(%d): %s",code,cddb_msg);
         default_track_info(4);       
         return;
       }
     } else
       default_track_info(5);
   }
   
   if (ldb == NULL)
   {
     sprintf(s,"%s/.groovycd/%08x",getenv("HOME"), 
                (unsigned int) thiscd.cddb_id);
     f = fopen(s,"w");
   }
   
   s[0] = 0;
   while (strncmp(s,".", 1)!=0)
   {
     if (!fgets(s, 255, desc))
       break;
     
     if (f)
       fputs(s, f);
     
     if ((ss=strstr(s, "DTITLE")) != NULL)
     { 
       ss += 7;
       ss[strlen(ss)-2] = 0;
       strcpy(thiscd.cdnames, ss);
              
       ss = strchr(s,'/');
       *ss = 0;
       strcpy(thiscd.artist,&s[7]);
       strcpy(thiscd.cdname,ss+2);
     }
     
       
     
     if ((ss=strstr(s, "TTITLE")) == NULL)
       continue;
     
     /* Yeah, yeah. Cheap hack, but it's guarenteed to work! :)
      * The following just hacks the returned track name into the variable 
      */
     
     ss += 6;
     t = atoi(ss);
     if (t < 100)
       ss += t < 10 ? 2 : 3;
     else
       ss += 4;    
       
     parse_trails(ss);
     
     if (thiscd.trk[t].songname)
     {       
       if ((thiscd.trk[t].songname = realloc(thiscd.trk[t].songname, 
                                     strlen(thiscd.trk[t].songname)+strlen(ss)+1)) != NULL)       
         strcat(thiscd.trk[t].songname, ss);
     } else {
       if ((thiscd.trk[t].songname = malloc(strlen(ss)+1)) == NULL)
       {
         perror("allocate_trackname");
         exit(0);
       }
       strcpy(thiscd.trk[t].songname, ss);
     }
   }
   
   if (f)
     fclose(f);
}
