# $Id: WhoisClient.pm,v 1.3 2003/02/11 11:57:15 jodrell Exp $
package Greenwich::WhoisClient;

use IO::Socket;
use FileHandle;
use strict;

sub new {
	my $self		= {};
	$self->{PACKAGE}	= shift;
	bless($self, $self->{PACKAGE});
	return $self;
}

sub whois {
	my $self = shift;
	$self->{fh} = FileHandle->new();
	my %args = @_;
	my ($response, $error) = ($args{program} ne '' ? $self->whois_external(%args) : $self->whois_native(%args));
	if ($error ne '') {
		$error =~ s/IO::Socket::INET: //ig;
		return ($response, $error);
	} elsif ($response =~ /whois server(:|=)(\s*)(.*)/i && $args{follow} eq 'true') {
		my $newserver = $3;
		$newserver =~ s/[\r\n]//g;
		$args{server} = $newserver;
		my ($new_response, $error) = $self->whois(%args);
		$response.= $new_response;
	}
	$self->{fh}->close();
	return ($response, $error);
}

sub whois_external {
	my $self = shift;
	my %args = @_;
	my $output;
	my $socket = $self->{fh};
	my $command = $args{program};
	$command =~ s/\%s/$args{server}/ig;
	$command =~ s/\%q/$args{query}/ig;
	open($socket, "$command 2>&1 |");
	print $socket "$args{query}\r\n";
	while (<$socket>) {
		$output .= $_;
	}
	return ($output, undef);
}

sub whois_native {
	my $self = shift;
	my %args = @_;
	my $output = sprintf("[%s]\n", $args{server});
	my $socket = $self->{fh};
	$socket = IO::Socket::INET->new(
		PeerAddr	=> $args{server},
		PeerPort	=> $args{port},
		Proto		=> 'tcp',
		Type		=> SOCK_STREAM,
		Timeout		=> $args{timeout}
	) or return ($output, $@);
	print $socket "$args{query}\r\n";
	while (<$socket>) {
		$output .= $_;
	}
	return ($output, undef);
}

1;