/*
 * GQmpeg
 * (C) 2002 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#include "gqmpeg.h"
#include "io_radio.h"

#include "rcfile.h"

static GtkWidget *radio_vbox = NULL;

/*
 *----------------------------------------------------------------------------
 * load / save routines
 *----------------------------------------------------------------------------
 */

void radio_config_load(FILE *f, const gchar *option, const gchar *value, const gchar *value_all)
{
	/* no-op */
}

void radio_config_save(FILE *f)
{
	/* no-op */
}

/*
 *----------------------------------------------------------------------------
 * config window routines
 *----------------------------------------------------------------------------
 */

void radio_config_apply(void)
{
	if (!radio_vbox) return;

	/* no-op */
}

void radio_config_close(void)
{
	radio_vbox = NULL;
}

static const gchar *detected_text(gint detected)
{
	if (detected) return _("Radio tuner found");

	return _("Radio tuner not found");
}

static void radio_config_redetect_cb(GtkWidget *button, gpointer data)
{
	GtkWidget *label = data;
	gint detected;

	detected = radio_test(TRUE);

	gtk_widget_set_sensitive(button, !detected);
	gtk_label_set_text(GTK_LABEL(label), detected_text(detected));
}

GtkWidget *radio_config_init(void)
{
	GtkWidget *vbox;
	GtkWidget *frame;
	GtkWidget *label;
	GtkWidget *button;
	gint detected;

	radio_vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(radio_vbox), 5);

	frame = gtk_frame_new(_("Options"));
	gtk_container_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(radio_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	detected = radio_test(FALSE);

	label = gtk_label_new(detected_text(detected));
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 5);
	gtk_widget_show(label);

	button = gtk_button_new_with_label(_("Detect radio"));
	gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 5);
	gtk_widget_show(button);

	if (detected)
		{
		gtk_widget_set_sensitive(button, FALSE);
		}
	else
		{
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(radio_config_redetect_cb), label);
		}

	if (!radio_enabled) gtk_widget_set_sensitive(radio_vbox, FALSE);

	return radio_vbox;
}


