/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <stdio.h>

#include "debug.h"
#include "configfile.h"
#include "common.h"

int num_mallocs = 0;
int max_mallocs = 0;

extern struct gq_config config;


void *gq_malloc(size_t size, char *msg)
{

     void *newmem;

     newmem = malloc(size);
     printf("+ gq_malloc: %s (%d bytes @ 0x%x)\n", msg, size,
	    (unsigned int) newmem);

     num_mallocs++;
     max_mallocs++;

     return(newmem);
}


void gq_free(void *mem, char *msg)
{

     printf("- gq_free: %s (0x%x)\n", msg, (unsigned int) mem);
     num_mallocs--;

     free(mem);

}


void report_num_mallocs(void)
{

     printf("==============================================\n");
     printf("Total number of mallocs: %d\n", max_mallocs);
     printf("Number of mallocs left : %d\n", num_mallocs);

     if(num_mallocs)
	  printf("memory allocation mismatch: %d allocations left\n",
		 num_mallocs);

}


void dump_ldapservers(void)
{
     struct ldapserver *server;
     int i;

     i = 1;
     server = config.ldapservers;
     while(server) {
	  printf("server %d: %s\n", i, server->name);
	  server = server->next;
	  i++;
     }

}



