#
#  gpsman --- GPS Manager: a manager for GPS receiver data
#
#  Copyright (c) 2006 Miguel Filgueiras (mig@ncc.up.pt) / Universidade do Porto
#
#    This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program.
#
#  File: langes.tcl
#  Last change:  12 April 2006
#
# Spanish language file by Alberto Morales (amd77@gulic.org)
#  last input from him: 8 April 2006
#

# file langengl.tcl is consulted first; no need for duplicating entries here

# only 3 chars long names; check also ALLMONTH in file gpsman
set MONTHNAMES "Ene Feb Mar Abr May Jun Jul Ago Sep Oct Nov Dic"

set DLUNIT(KM,dist) km
set DLUNIT(KM,subdist) m
set DLUNIT(KM,speed) "km/h"
set DLUNIT(KM,area) "km2"
set DLUNIT(NAUTMILE,dist) "nm"
set DLUNIT(NAUTMILE,subdist) ft
set DLUNIT(NAUTMILE,speed) knot
set DLUNIT(NAUTMILE,area) "sq nm"
set DLUNIT(STATMILE,dist) "st ml"
set DLUNIT(STATMILE,subdist) ft
set DLUNIT(STATMILE,speed) mph
set DLUNIT(STATMILE,area) "section"

set DLUNIT(M,dist) $DLUNIT(KM,subdist)
set DLUNIT(FT,dist) $DLUNIT(STATMILE,subdist)

set DTUNIT $DLUNIT($DISTUNIT,dist)
set SPUNIT $DLUNIT($DISTUNIT,speed)
set ARUNIT $DLUNIT($DISTUNIT,area)
set ARUNIT $DLUNIT($DISTUNIT,area)

set MESS(RTcomp) "#\tPT\t\t$DTUNIT\tgrados\t$ALUNIT"
set MESS(TRcomp) "#\t$DTUNIT\t$DTUNIT\t$ALUNIT\th:m:s\t$SPUNIT\tgraus"
set MESS(WPNearest) "PT\t\t$DTUNIT\tgrados"

array set MESS {
    badscale   "Valor incorecto para la escala del mapa"
    oktoexit   "Ok para terminar (datos no guardados se perdern)"
    okclrmap   "Ok para borrar el mapa"
    namelgth   "Nombre no puede tener ms de %d caracteres"
    cmmtlgth   "Comentario no puede tener ms de %d caracteres"
    namevoid   "Nombre no puede ser vaco"
    baddate   "Fecha incorrecta"
    badhdg   "Direccin incorrecta %s: debe ser %s o +/-"
    badcoord "Coordenada con valor o formato incorrecto: \"%s\" debe ser %s"
    outofrng   "Nmero fuera de lmites"
    UTMZN   "Debe ser una letra entre A..H, J..N, o P..Z"
    badstrg   "Caracter(es) incorrecto(s)"
    strgvoid   "Cadena debe tener por lo menos un caracter"
    nan   "\"%s\" no es un nmero"
    written   "Escrito por"
    undefWP   "Ruta %s tiene puntos no definidos; no guardada/exportada"
    bigRT   "Ruta %s > mximo permitido; no exportada"
    unkndatum   "Datum desconocido"
    badcommdWP   "Comando incorrecto al leer puntos; lnea"
    notabsWP   "Punto mal definido (sin tabuladores); lnea"
    undefinedWP   "Referencia a punto desconocido: %s"
    nofieldsWP   "Punto mal definido (faltan campos); lnea"
    excfieldsWP  "Punto mal definido (demasiados campos); lnea"
    badWPsRT   "Ruta con lista incorrecta de puntos; lnea"
    toomuchWPs   "Aviso: mas de %d puntos en ruta"
    badcommdTP   "Comando incorrecto a leer puntos de trayecto; lnea"
    badTP   "Punto incorrecto en trayecto; lnea"
    badTPsTR   "Trayecto con lista incorrecta de puntos; lnea"
    noheader   "Fichero no tiene cabecera"
    loaderr   "Error al leer fichero; lnea"
    unkncommd   "Comando desconocido al leer fichero; lnea"
    noformat   "Fichero no comienza con lnea de formato"
    badformat   "Especificacin de formato incorrecta"
    badRT   "Ruta mal especificada; lnea"
    badRTargs   "Parmetros incorrectos para ruta; lnea"
    badTR   "Trayecto mal especificado; lnea"
    fileact   "%s fichero (%s)"
    filexists   "Fichero existente!"
    GPSok   "Conexin correcta"
    toomany   "Demasiados %ss (> %d)"
    cantfgt   "No puedo olvidar %s: pertenece a algo dibujado"
    cantfgted   "No puedo olvidar %s: est siendo editado"
    cantmapRTunkn   "Ruta no dibujada; punto desconocido"
    cantmapRTed   "Ruta no dibujada; punto en edicin"
    cantrun   "No puedo ejecutar"
    inprogr   "Operacin ya iniciada"
    cantread   "No puedo leer del fichero auxiliar"
    cantwrtopt   "No puedo escribir en el fichero de opciones"
    voidRT   "Ruta sin puntos"
    activeRT   "Ruta 0 es la ruta activa; continuar?"
    voidTR   "Trayecto sin puntos"
    idinuse   "Identificador ya est siendo usado"
    cantunmap   "Imposible desvincular %s; pertence a objeto dibujado"
    askrevert   "Volver a datos inciales?"
    askforget   "Olvidarse de este %s?"
    notimpl   "No implementado"
    forgetall   "Olvidar toda la lista de %ss?"
    counted   "Hay %d %ss en la lista"
    notlisted   "Elemento no est en la lista"
    wrgval   "Valor incorrecto para"
    voidGR   "Grupo no tiene elementos"
    initselfGR   "Grupo contiene a si mismo a travs de"
    GRelout   "Comando para elemento fuera de definicin de GR; lnea"
    badGRels   "Grupo con lista de elementos incorrecta; lnea"
    badcommdGRel   "Comando incorrecto al leer elementos de grupo; lnea"
    notypeforGRel   "Elemento sin tipo; lnea"
    badGRel   "Definicin de elemento incorrecta; lnea"
    check   "Intentando conectar"
    toomanyerr   "Demasiados errores; cancelando..."
    getWP   "Recibiendo Puntos"
    getRT   "Recibiendo Rutas"
    getTR   "Recibiendo Trayectos"
    putWP   "Enviando Puntos"
    putRT   "Enviando Rutas"
    putTR   "Enviando Trayectos"
    fillbuffWP  "Cargando conjunto de PTs"
    fillbuffRT  "Cargando conjunto de RTs"
    noACKNAK  "Recibido paquete en vez de ACK/NAK; verifique la conexin con el GPS"
    badplatform   "Esta plataforma no permite E/S con el puerto serie"
    badserial "No puedo acceder al puerto serie %s"
    nodata    "El receptor no tiene %ss"
    badimage "Fichero de imagen incorrecto"
    mapadjust "Coloque los PTs en el mapa; pulse Ok al acabar"
    duplicate "%s ya elegido"
    clrcurrmap "Borrar mapa existente?"
    mbkbaddatum "Sin datum vlido"
    mbkbadscale "La escala no puede ser negativa"
    mbkbadat "Argumentos incorrectos"
    edityourrisk "Edite bajo su responsabilidad!"
    okclrbkmap   "Ok para borrar fondo del mapa"
    okclrbkim   "Ok para borrar imagen en"
    badattrval "Campo opcional invlido (%s): %s"
    badattr "Nombre de campo opcional desconocido (%s): %s"
    badSYMBOLcode "Cdigo de smbolo incorrecto"
    badDISPOPTcode "Cdigo de forma de mostrar incorrecto"
    goingdown "Opciones guardadas; por favor reinicie"
    putwhat "Colocar qu tipos de datos?"
    readwhat "Leer que tipos de datos?"
    noWPinx "Demasiados PTs para el receptor"
    noICinx "Demasiados ICs para el receptor"
    getIC "Recibiendo iconos"
    serial1 "Prembulo de cabecera incorrecto"
    serial2 "Recibido comando incorrecto"
    checksum1 "Suma de verificacin de cabecera incorrecta"
    checksum2 "Suma de verificacin de datos incorrecta"
    receiver "No se ha establecido conexin serie!" 
    importonly1 "Slo puede importar 1 tipo de datos"
    exportonly1 "Slo puede exportar 1 tipo de datos"
    outdatedprefs "Fichero de opciones tiene que ser actualizado"
    mustchoose1type "Seleccione al menos 1 tipo de datos"
    nosuchitems "Ningn elemento tiene esa descripcin"
    resultsin "Resultados en el Grupo"
    badWP "Falta punto por definir"
    badangle "ngulo debe ser >0 y <360 grados"
    georefhow  "Mtodo para geo-referenciar"
    cantsolve  "Ecuaciones sin solucin"
    transfcantscale "Transformacin actual no permite alterar escala"
    oldfilefmt "Formato antiguo; por favor, guardar con formato nuevo!"
    unknProj "Proyeccin desconocida"
    unknTransf "Transformacin desconocida"
    badProjargs "Parmetros de proyeccin incorrectos"
    badTransfargs "Parmetros de transformacin incorrectos"
    badfield "Pareja atributo=valor incorrecta"
    badattr "Nombre de atributo incorrecto"
    missattrs "Faltan atributo(s)"
    mbkbadproj "Proyeccin incorrecta"
    mbkbadtransf "Transformacin incorrecta"
    notUTMproj "Informacin salvada para UTM; continuar con proyeccin"
    projchg    "Confirme parmetros de proyeccin"
    badparam "Valor incorrecto para %s"
    connectedto "Conectado a %s"
    recnotsuppd "Modelo de receptor no reconocido"
    gotprots "Recibida informacin sobre protocolos"
    badprots "Informacin sobre protocolos incorrecta"
    defprots "Usando tabla de protocolos"
    nohidden "Descartar datos ocultos?"
    badRS "Etapa de ruta fuera de definicin de RT; lnea"
    badWPsRSs "Etapa de RT antes del primer o despues del ltimo PT; lnea"
    windowdestr "La ventana ha sido destruida!"
    badhidden "Formato incorrecto del valor oculto"
    replname "Substituya \"%s\" por un nombre que tenga al menos %d de los siguientes caracteres: %s"
    badalt "Valor incorrecto para altitude"
    baddistunit "Unidad de distancia incorrecta para escala de mapa en opciones"
    badgridzone "Cuadrcula incorrecta"
    outofgrid "Posicin fuera de la cuadrcula"
    timeoffnotint "Diferencia horaria debe ser entera"
    cantchkprot "Este protocolo no permite verificacin"
    mustconn1st "Primero verifique la conexin con el receptor"
    rltmnotsupp "Este protocolo en este receptor no permite registro en tiempo real"
    createdir "Necesita crear directorio %s y reiniciar"
    oktomkdir "Puedo crear el directorio %s?"
    projnameabbr "Por favor, dar un nombre y una abreviatura para la nueva proyeccin"
    abbrevinuse "Abreviatura ya usada"
    nameinuse "Nombre ya usado"
    projinuse "Proyeccin est siendo usada; los cambios no tendrn efecto"
    gridneedsdatum "Definicin incorrecta de cuadrcula %s; datum por definir"
    badgriddatum "El datum para la cuadrcula %s debe ser %s"
    cantchggriddatum "Esta cuadrcula debe usar el datum %s"
    gridinuse "Cuadrcula usada por %s, no puede borrarse; continuar?"
    gridinusenochg "Cuadrcula usada por %s; cambios sin efecto"
    cantwrtprgr "No puedo escribir en fichero de proyecciones"
    cantwrtdtel "No puedo escribir en fichero de datums"
    movingWP "Colocar %s con botn izquierdo\nCancelar con botn derecho"
    missingdata "Informacin insuficiente!"
    needs1wp "Una ruta debe tener al menos 1 punto"
    emptypos "Posicin con campo(s) vaco(s)"
    cantwrtsstate "No puedo escribir el fichero de estado: %s"
    cantrdsstate "No puedo leer del fichero de estado: %s"
    corruptsstate "Fichero de estado %s con errores"
    editrisk "Edite bajo su responsabilidad!"
    savestate "Guardar estado actual?"
    delsstate "Borrar ficheros de estado?"
    badmapinfo "Error en fichero de parmetros de mapa"
    badMHloc "Posicin Maidenhead incorrecta"
    areais "rea del polgono (no intersectado): %.3f%s"
    areatoosmall "rea es demasiado pequea (<%s km2)"
    projarea "Calculando rea proyectada"
    selfintsct "PTs repetidos: un RT no puede intersectarse!"
    badinvmdist "Error de aproximacin al invertir distancia sobre meridiano"
    badinvproj "Error de aproximacin al invertir la proyeccin %s"
    negdlatlong "Diferencia entre lat/long no puede ser negativa!"
    allundef "No hay definiciones para los PTs del GR"
    badfloats "Hay errores en las conversiones de nmeros decimales; conectar as mismo?"
    noprintcmd "Falta comando para imprimir; definirlo en las opciones"
    cantexecasroot "GPSMan no puede ser ejecutado por root"
    badargtofunc "Argumento incorrecto a la funcin %s"
    redefproj "Abreviatura de proyeccin %s coincide con una proyeccin predefinida; renombre su definicin!"
    couldntcd "Imposible cambiarse al directorio %s"
    shpext "Extensin %s incorrecta; ok para usar .shp, .shx, .dbf?"
    shpcntopen "Imposible crear/abrir ficheros Shapefile"
    shpcntcrtfs "Imposible crear campos Shapefile .dbf"
    shpcntwrtfs "Imposible escribir campos Shapefile .dbf"
    shpoutmem "Memoria agotada!"
    shpemptyfile "Fichero vaco"
    shpwrongfile "Tipo de fichero incorrecto"
    shplessdim "Dimensin en fichero menor que la solicitada; continuar?"
    shpbadWPinRT "WP nmero %d de coordenadas incorrectas ignorado en RT %s"
    errorGTMread "Error al leer de fichero de GTrackMaker"
    badGTMvers "Versin no soportada de fichero de GTrackMaker"
    badGTMfile "Inicio incorrecto de fichero de GTrackMaker"
    badGTMcounts "Contador(es) negativos en fichero de GTrackMaker"
    badGTMlat "Latitud incorrecta en fichero de GTrackMaker"
    badGTMlong "Longitud incorrecta en fichero de GTrackMaker"
    badGTMdatum "Datum invlido en fichero de GTrackMaker"
    unobscmap "Error tal vez por haber una ventana/icono sobre el mapa; esperar y volver a intentar?"
    cantwrtimg "Error al guardar imagen a fichero en formato %s"
    TRsimplres "TR resultante de simplificacin creado con nombre %s"
    cantsaveRTid "%d RT(s) no guardada: identificador no numrico"
    cantsaveTRid "%d TR(s) no guardado: identificador no numrico"
    badtrvconf "Configuracin inconsistente sustituida por una vaca"
    drvsimoff "Simulador de conduccin: falta iniciar!"
    needWP "Simulador de conduccin: es preciso definir PTs antes"
    chgrecprot "Por favor, seleccionar otro protocolo de receptor"
    clrtrvlog "Borrar registro de viaje?"
    frgetGRcs "Olvidar grupo y todos sus elementos?!"
    nmeainuse "Ya se est capturando registro en tiempo real, o se esta leyendo otro fichero NMEA"
    badfile "Error al leer desde fichero"
    RTnoWPname "Los puntos de ruta slo con nombre han dejado de estar soportados"
    distlarge "Distancia demasiado grande!"
    timeconsmg "La operacin puede durar mucho tiempo: seguir?"
    badtimeval "Valor incorrecto para la hora"
    badLAP "LAP incorrecto; lnea"
    lapncnsdrd "LAP no se toma en cuenta"
    undefinedTR   "Trayecto desconocido"
    emptymenu "Men vacio; continuar?"
    cantwrtsymenu "No puedo escribir en fichero de men de smbolos"
    cantwrtmbaks "No puedo escribir fichero de mapas de fondo de usuario"
    abbrevhasspaces "El nombre corto no puede tener espacios"
    getAL   "Obteniendo almanaque"
}

set TXT(RTcompflds) "# PT {$DTUNIT} grados {$ALUNIT} etapa etiq"
set TXT(TRcompflds) "PTR {$DTUNIT} {$DTUNIT} {$ALUNIT} h:m:s {$SPUNIT} grados"
set TXT(starttoend) "Inicio: hasta fin %s $DTUNIT;"
set TXT(startmax) "mx %s $DTUNIT;"
set TXT(WPnearflds) "PT {$DTUNIT} grados"
set TXT(within) "Hasta (${DTUNIT}s)"
set TXT(between) "Entre (${DTUNIT}s)"

array set TXT {
    GMtit   "GPS Manager - versin"
    exit   Salir
    map   Mapa
    load   Leer
    loadfrm   "Leer de"
    save   Guardar
    saveels "Guardar elementos"
    saveto   "Guardar a"
    clear   Limpiar
    clearall   "Limpiar todo"
    newWP   "Nuevo punto"
    newRT   "Nueva ruta"
    newTR   "Nuevo trayecto"
    newGR   "Nuevo grupo"
    import   Importar
    importfrm   "Importar de"
    export   Exportar
    exportels "Exportar elementos"
    exportto   "Exportar a"
    count   Contar
    trueN   "Norte Geograf"
    automagn   "Declin Auto"
    usrdef   "Def Usuario"
    nameWP   Punto
    nameRT   Ruta
    nameTR   Trayecto
    nameGR   Grupo
    namePlot   Grfico
    nameMap   Mapa
    nameRTComp   "Clculo para Ruta"
    nameTRComp   "Clculo para Trayecto"
    GPSrec   "Receptor GPS"
    turnoff   Apagar
    get   Buscar
    put   Colocar
    all   Todo
    select   Escoger
    selection   Eleccin
    options   Opciones
    DMS   GMS
    DMM   GMM
    DDD   GGG
    UTM/UPS   UTM/UPS
    MH    MH
    message   Mensaje
    cancel   Cancelar
    file   Fichero
    ovwrt   Sobreescribir
    app   Anexar
    online   "en lnea"
    offline   "fuera de lnea"
    check   Comprobar
    create   Crear 
    revert   Releer
    colour   color
    grey   gris
    mono   mono
    portr   "horizontal"
    landsc   "apaisado"
    legend   Leyenda
    incscale   "Inclur escala"
    more   "(ms.)"
    waypoint   Punto
    name   Nombre
    created   "Creado en"
    cmmt   Comentario
    withWP  "Con este PT:"
    displ   "Mostrar en mapa"
    startRT "Iniciar RT"
    route   Ruta
    number   Nmero
    numberid "Nmero/Id"
    insb   "Insertar antes"
    insa   "Insertar despues"
    del   Borrar
    repl   "Sustituir por"
    comp   Calcular
    RTcomp   "Clculos para ruta"
    savecomp "Guardar clculos"
    totdst   "Distancia total"
    tottime   "Tiempo total"
    track   Trayecto
    chophd   "Borrar anteriores"
    choptl   "Borrar siguientes"
    incb   "Incluir antes"
    date   Fecha
    newdate   "Nueva fecha para el punto siguiente"
    endprTR   "Fin del trayecto anterior"
    begnxt   "Inicio del siguiente"
    date1st   "Fecha para el primer punto del siguiente"
    TRcomp   "Clculos para trayecto"
    avgsp   "Veloc media"
    maxsp   "Veloc mx"
    minsp   "Veloc mn"
    lat   Lat
    long   Long
    ze   ZE
    zn   ZN
    eastng   x
    nrthng   y
    zone   Zona
    change   Cambiar
    forget   Olvidar
    others   Otros
    opt_Interf "Interfaz de usuario"
    optLANG   Idioma
    optISOLATIN1   "Acentos y smbolos"
    optDELETE   "DEL borra ltimo caracter"
    optMWINDOWSCONF  "Ventana principal"
    optSERIALBAUD "Velocidad transmisin"
    optGPSREC   "Modelo de GPS"
    opt_GPSRecConf   "Parmetros del receptor"
    optACCEPTALLCHARS "Aceptar cualquier caracter"
    optNAMELENGTH   "Longitud mx nombre"
    optINTERVAL "Intervalo de muestreo"
    optCOMMENTLENGTH   "Longitud mx comentarios"
    optMAXWPOINTS   "N mx de puntos"
    optMAXROUTES   "N mx de rutas"
    optMAXWPINROUTE   "N mx de puntos en ruta"
    optMAXTPOINTS   "N mx de puntos en trayecto"
    optCREATIONDATE   "Receptor tiene fecha de creacin"
    optNOLOWERCASE   "Receptor no tiene minsculas"
    optDEFAULTSYMBOL "Smbolo habitual de punto"
    optDEFAULTDISPOPT "Forma habitual de mostrar punto"
    opt_Data "Datos"
    optEQNAMEDATA "Datos con el mismo nombre"
    optKEEPHIDDEN "Mantener datos ocultos"
    optDatum   Datum
    optTimeOffset   "Dif horaria"
    optACCFORMULAE "Frmulas de mayor precisin"
    optASKPROJPARAMS "Confirmar parmetros de proyeccin"
    optBalloonHelp "Globos de ayuda"
    opt_Formats   "Unidades y formatos"
    optDISTUNIT   "Distancia"
    KM    km
    NAUTMILE    "milla nutica"
    STATMILE    "milla terrestre"
    optPositionFormat   "Formato para posiciones"
    optDateFormat   "Formato para fechas"
    opt_Geom   "Geometra de ventanas"
    opt_MapGeom   "Geometra de mapa"
    optMAPWIDTH   "Ancho del mapa"
    optMAPHEIGHT   "Alto del mapa"
    optMAPSCLENGTH   "Longitud escala de mapa"
    optMAPSCALE   "Escala de mapa"
    optMAXMENUITEMS   "N mx de items em menu"
    optLPOSX   "Pos horiz ventana de listas"
    optLPOSY   "Pos vert ventana de listas"
    optMPOSX   "Pos horiz ventana de mapa"
    optMPOSY   "Pos vert ventana de mapa"
    optRPOSX   "Pos horiz ventana de receptor"
    optRPOSY   "Pos vert ventana de receptor"
    optEPOSX   "Pos horiz ventana de error"
    optEPOSY   "Pos vert ventana de error"
    optDPOSX   "Pos horiz dilogo"
    optDPOSY   "Pos vert dilogo"
    optDPOSRTMAP "Ajuste ventana RT/mapa"
    optLISTWIDTH   "Anchura de lista"
    optLISTHEIGHT   "Altura de lista"
    optCOLOUR   Colores
    optCOLOUR,fg   Frente
    optCOLOUR,bg   Fondo
    optCOLOUR,messbg   "Fondo para error"
    optCOLOUR,confbg   "Fondo para confirmacin"
    optCOLOUR,selbg   "Fondo para seleccin"
    optCOLOUR,dialbg   "Fondo para preguntas"
    optCOLOUR,offline   "Receptor fuera de lnea"
    optCOLOUR,online   "Receptor en lnea"
    optCOLOUR,check   "Seleccionado botn"
    optCOLOUR,ballbg   "Fondo para ayuda"
    optCOLOUR,ballfg   "Frente para ayuda"
    optMAPCOLOUR  "Colores de mapa"
    optMAPCOLOUR,mapsel   "Item seleccionado en mapa"
    optMAPCOLOUR,WP   "Puntos en mapa"
    optMAPCOLOUR,RT   "Rutas en mapa"
    optMAPCOLOUR,mkRT "Ruta definida en mapa"
    optMAPCOLOUR,TR   "Trayectos en mapa"
    optMAPCOLOUR,TP   "Puntos de trayecto en mapa"
    optMAPCOLOUR,mapleg   "Legendas en mapa"
    optMAPCOLOUR,anim "Animacin en mapa"
    optMAPCOLOUR,emptygrid  "Sin imagen"
    optMAPCOLOUR,fullgrid   "Con imagen"
    optMAPFONTSIZE "Tamao de fuente para mapa"
    optDEFTRTWIDTH "Grosor lnea ruta"
    optDEFTTRWIDTH "Grosor lnea trayecto"
    opt_Files "Puerto serie y ficheros"
    optDEFSPORT "Puerto serie"
    optSAVESTATE "Guardar estado al salir"
    optDELSTATE "Borrar ficheros de estado"
    optPERMS   "Permisos de fichero"
    optPRINTCMD "Comando para imprimir"
    optPAPERSIZE "Tamao de papel"
    red   Rojo
    green   Verde
    blue   Azul
    owner   Propietario
    permgroup   Grupo
    others   Otros
    fread   Leer
    fwrite   Escr
    fexec   Ejec
    YYYYMMDD   AAAAMMDD
    MMDDYYYY   MMDDAAAA
    DDMMMYYYY   DDMMMAAAA
    YYYY-MM-DD  AAAA-MM-DD
    YYYY/MM/DD  AAAA/MM/DD
    mainwd   "Ventana principal"
    distazim   "Dist y azimut"
    nearestWPs   "PTs prximos"
    fromto   "Desde %s hasta %s"
    degrees   grados
    nameWPDistBear   "dist y azimut"
    nameWPNearest   "PTs prximos"
    inrect   "En rectngulo"
    forthisWP   "para este PT"
    formappedWPs   "para PTs en mapa"
    group   Grupo
    element   Elemento
    insert   Insertar
    joinGR   "Juntar Grupo"
    TRtoRT   "Conversin de tray a ruta"
    TRtoTR   "Simplificacin de trayecto"
    TRRTnpoints   "N de puntos a mantener"
    TRlinedispl   "Mostrar resultados"
    TRTRdispl   "Mostrar trayecto"
    WP   PT
    RT   RT
    TR   TR
    GR   GR
    commrec   "Comunicacin con receptor"
    abort   Desistir
    ACKs   ACKs
    NAKs   NAKs
    packets   paquetes
    unnamed   "(por definir)"
    fromTR    "Desde TR: %s"
    mapload "Geo-ref imagnm"
    loadmback Leer
    savemback "Guardar geo-ref"
    chgmback Cambiar
    clearmback Limpiar
    backgrnd Fondo
    nameMapBkInfo "Info sobre fondo"
    nameMapInfo "Parmetros del mapa"
    mpbkchg "Cambiar fondo"
    mpbkgrcs "Posicin de rejilla"
    nameImage Imagen
    symbol Smbolo
    SYCATgeneral Genrico
    SYCATland Terrestre
    SYCATwater Aqutico
    SYCATaviation Aviacin
    SY1st_aid "Primeros auxilios"
    SYWP_buoy_white "Boya, blanca"
    SYWP_dot "Punto"
    SYairport "Aeropuerto"
    SYamusement_park "Parque de atracciones"
    SYanchor "Ancla"
    SYavn_danger "Peligro (av)"
    SYavn_faf "1st approach fix"
    SYavn_lom "Localizer outer marker"
    SYavn_map "Missed approach point"
    SYavn_ndb "ND beacon"
    SYavn_tacan "TACAN"
    SYavn_vor "VHF omni-range"
    SYavn_vordme "VOR-DME"
    SYavn_vortac "VOR/TACAN"
    SYball "Crculo"
    SYbeach "Playa"
    SYbell "Campana"
    SYboat "Barco"
    SYboat_ramp "Rampa para barcos"
    SYborder "Frontera"
    SYbowling "Bolera"
    SYbridge "Puente"
    SYbuilding "Edificio"
    SYbuoy_amber "Boya, mbar"
    SYbuoy_black "Boya, negra"
    SYbuoy_blue "Boya, azul"
    SYbuoy_green "Boya, verde"
    SYbuoy_green_red "Boya, verde roja"
    SYbuoy_green_white "Boya, verde blanca"
    SYbuoy_orange "Boya, naranja"
    SYbuoy_red "Boya, roja"
    SYbuoy_red_green "Boya, roja verde"
    SYbuoy_red_white "Boya, roja blanca"
    SYbuoy_violet "Boya, violeta"
    SYbuoy_white "Boya, blanca"
    SYbuoy_white_green "Boya, blanca verde"
    SYbuoy_white_red "Boya, blanca roja"
    SYcamping "Camping"
    SYcapitol_city "Ciudad, estrella"
    SYcar "Automovil"
    SYcar_rental "Alquiler de automoviles"
    SYcar_repair "Taller de automovil"
    SYcasino "Casino"
    SYcastle "Castillo"
    SYcemetery "Cementerio"
    SYchapel "Capilla"
    SYchurch "Iglesia"
    SYcircle_x "Crculo con X"
    SYcivil "Instalacin civil"
    SYcontrolled "Area controlada"
    SYcrossing "Cruce"
    SYdam "Presa"
    SYdanger "Peligro"
    SYdeer "Ciervo"
    SYdiamond_green "Diamante, verde"
    SYdiamond_red "Diamante, rojo"
    SYdiver_down_1 "Buceo 1"
    SYdiver_down_2 "Buceo 2"
    SYdollar "Dolar"
    SYdot "Punto"
    SYdrinking_water "Agua potable"
    SYduck "Pato"
    SYelevation "Punto alto"
    SYexit_no_serv "Salida sin servicios"
    SYexit "Salida"
    SYfactory "Fbrica"
    SYfastfood "Comida rpida"
    SYfish "Pez"
    SYfitness "Gimnasia"
    SYflag "Bandera"
    SYfreeway "Autova"
    SYfuel "Gasolinera"
    SYfuel_store "Gasolinera & tienda"
    SYgeocache "Geocache"
    SYgeocache_fnd "Geocache encontrada"
    SYgeo_name_land "Nombre geogr, tierra"
    SYgeo_name_man "Nombre geogr, hombre"
    SYgeo_name_water "Nombre geogr, agua"
    SYglider "Ala delta"
    SYgolf "Golf"
    SYheliport "Helipuerto"
    SYhorn "Claxon"
    SYhouse "Casa"
    SYice_skating "Patinaje sobre hielo"
    SYinfo "Informacin"
    SYintersection "Interseccin"
    SYis_highway "Autopista"
    SYknife_fork "Comida"
    SYladder "Escalera"
    SYlanding "Aterrizaje"
    SYlarge_city "Ciudad (grande)"
    SYlarge_exit_ns "Salida sin servicio (grande)"
    SYlarge_ramp_int "Cruce con barreras (grande)"
    SYlevee "Dique"
    SYlight "Faro"
    SYlodging "Alojamento"
    SYmany_fish "Banco de peces"
    SYmany_tracks "Muchos caminos"
    SYmark_x "Marca, x"
    SYmedium_city "Ciudad, media"
    SYmile_marker "Punto kilomtrico"
    SYmilitary "Instalaciones militares"
    SYmine Mina
    SYMOB "Hombre al agua"
    SYmonument "Monumento"
    SYmountains "Montaas"
    SYmovie "Cine"
    SYmug "Jarra"
    SYmuseum "Museo"
    SYntl_highway "Autopista nacional"
    SYnull "(transparente)"
    SYnull_2 "(vaco)"
    SYoil_field "Campo de petrleo"
    SYparachute "Paracadas"
    SYpark "Parque"
    SYparking "Aparcamiento"
    SYpharmacy "Farmacia"
    SYphone "Telfono"
    SYpicnic "Picnic"
    SYpizza "Pizzera"
    SYpolice "Polica"
    SYpost_office "Correos"
    SYprivate "Campo privado"
    SYradio_beacon "Radio baliza"
    SYramp_int "Cruce con barreras" 
    SYrestricted "Area restringida"
    SYrestrooms "WC"
    SYRV_park "Parque de vehculos recreativos"
    SYscenic "Paisaje"
    SYschool "Colegio"
    SYseaplane "Base de hidroaviones"
    SYshopping_cart "Centro comercial"
    SYshort_tower "Torre, baja"
    SYshowers "Duchas"
    SYskiing "Esqu acutico"
    SYskull "Calavera"
    SYsmall_city "Ciudad, pequea"
    SYsnow_skiing "Esqu de montaa"
    SYsoft_field "Campo suave"
    SYsquare_green "Cuadrado, verde"
    SYsquare_red "Cuadrado, rojo"
    SYst_highway "Autopista estatal"
    SYstadium "Estdio"
    SYstore "Tienda"
    SYstreet_int "Cruce de calles"
    SYsummit "Pico"
    SYswimming "Natacin"
    SYtake_off "Despegar"
    SYtall_tower "Torre, alta"
    SYtheater Teatro
    SYtoll Peaje
    SYtow_truck "Camin-gra"
    SYtraceback "Regreso"
    SYtracks "Caminos"
    SYtrail_head "Inicio de camino"
    SYtree "rbol"
    SYtruck_stop "Parada de camiones"
    SYtunnel "Tnel"
    SYultralight "Ultra-ligero"
    SYus_highway "Autopista EEUU"
    SYweight_station Bscula
    SYwreck "Naufragio"
    SYzoo "Zoolgico"
    psvisible "Slo la parte visible"
    DISPsymbol "Slo smbolo"
    DISPs_name "Simb & nombre"
    DISPs_comment "Simb & comentario"
    DISPname "Slo nombre"
    DISPcomment "Slo comentario"
    dispopt Mostrar
    mapitems "Mostrar en mapa"
    nameIC Icono
    prod Producto
    WPCapac "Mximo de Puntos"
    ICCapac "Mximo de Iconos"
    RTCapac "Mximo de Rutas"
    TRCapac "Mximo de Trayectos"
    protcl "Protocolo"
    ICGraph "Smbolos para iconos"
    WPperRT "Puntos por ruta"
    notinGR "no en (sub-)grupo"
    onlyinGR "slo en (sub-)grupo"
    loadgrels "Leer elementos"
    importgrels "Importar elementos"
    about "Sobre GPSMan..."
    contrib "Con contribuciones de"
    errorsto "En caso de errores, contactar:"
    obsTRToRT "PTs creados por conversin de TR a RT"
    obsTRsimpl "TR obtenido por simplificacin"
    nameLists "Listas"
    nameData "Datos"
    MWCmap "Mapa"
    MWClists "Listas"
    MWCsingle "Ventana nica"
    search "Buscar"
    rmrk "Notas"
    closeto "Prximo a"
    with "Con"
    srchres "ENCONTRADOS"
    database "Base de datos"
    where "Dnde"
    what "Qu"
    list "lista"
    distance "Distancia"
    fromWP "del Punto"
    fromPos "de posicin"
    azimuth "Azimut"
    any "cualquier"
    opening "Abriendo"
    suggested "sugerido"
    another "Otro"
    srchdd1 "Buscar en"
    srchdd2Data "todos los datos"
    srchdd2GR "Grupo(s)"
    from "de"
    started "iniciado en"
    transf  "Transf Coords"
    TRNSFAffine    "Afn"
    TRNSFAffineConf  "Afn Conforme"
    TRNSFNoRot      "Conf sin Rot"
    projection "Proyeccin"
    lat0  "Lat central"
    long0 "Long central"
    lat1  "Lat 1 paralelo"
    lat2  "Lat 2 paralelo"
    latF  "Lat falso origen"
    longF "Long falso origen"
    k0 "Factor de escala"
    PRJUTM "UTM/UPS"
    PRJTM "Transversal de Mercator"
    PRJCMP "Carta Militar Portugal"
    PRJBNG "Cuadrcula Nac Britnica"
    PRJBWI "ndias Occid Britnicas"
    PRJITM "Cuadrcula TM Irlandesa"
    PRJGKK "Cuadrcula Alemana"
    PRJLCC1 "Lambert Cnica Conf 1"
    PRJLCC2 "Lambert Cnica Conf 2"
    PRJKKJP "Cuadrcula Finlandesa Base"
    PRJKKJY "Cuadrcula Finlandesa Unif"
    PRJSEG "Cuadrcula Sueca"
    PRJMerc1 "Mercator 1"
    PRJMerc2 "Mercator 2"
    PRJCS "Cassini-Soldner"
    PRJAPOLY "Policnica Americana"
    PRJStereogr "Estereogrfica"
    PRJTWG "Cuadrcula de Taiwan"
    PRJSOM "Oblcua de Mercator Suiza"
    PRJLV03 "Cuadrcula Suiza LV03"
    PRJIcG "Cuadrcula Islandesa"
    PRJRDG "Cuadrcula Holandesa"
    PRJSchreiber Schreiber
    dontaskagain "Dejar de preguntar"
    rename "Usar nombre diferente"
    oname "Nombre original"
    never "Nunca"
    ask "Preguntar"
    always "Siempre"
    stage "Etapa"
    label "Etiqueta"
    alt "Altura"
    optALTUNIT "Altura"
    locate "Encontrar"
    animation  Animacin
    fast Rpido
    slow Lento
    start Inicio
    pause Pausa
    speed Velocidad
    centred "Mantener centrado"
    state Estado
    animinit "al inicio/final"
    animon "en curso"
    animpause "pausado"
    animabort "saliendo"
    realtimelog "Registro de TR en tiempo real"
    garmin Garmin
    nmea "NMEA 0183"
    stext "Texto simple"
    simul "simulador"
    lowrance Lowrance
    magellan Magellan
    getlog Capturar
    stop Parar
    dolog Registrar
    show Mostrar
    hide Esconder
    posfixerror erro
    posfix_  ?
    posfix2D 2D
    posfix3D 3D
    posfix2D-diff "2D d"
    posfix3D-diff "3D d"
    posfixGPS GPS
    posfixDGPS DGPS
    posfixAuto ok
    posfixsimul simul
    restart Recomenzar
    mkTR "Crear trayecto"
    PVTflds "# t lat long alt fix EPE EPH EPV vel_x vel_y vel_z TRK"
    namePVTData Registrar
    mkavgWP "Crear punto promedio"
    move Mover
    define Definir
    open Abrir
    defs "Definiciones"
    baseproj "Proyeccin de base"
    abbrev Abreviatura
    grid Cuadrcula
    use Usar
    unit Unidad
    feasting "Dist E falsa"
    fnorthing "Dist N falsa"
    bounds "Lmites"
    max "Mx"
    min "Mn"
    easting "Dist E"
    northing "Dist N"
    fixeddatum "datum obligatorio"
    elevation "Perfil"
    usewps "Usar puntos"
    chgpfrmt "Cambiar formato posiciones"
    changegroupsymbol "Cambiar smbolo"
    here Aqu
    atprevwp "En PT anterior"
    prevwp "PT anterior"
    firstwp "Primer PT"
    chglstrs "Editar etapa anterior"
    chgnxtrs "Editar etapa siguiente"
    contnend "Aadir al final"
    closemenu "Cerrar menu"
    ellpsd Elipsoide
    datum Datum
    userdefs "Definiciones propias"
    edmap "Editar sobre mapa"
    actual actual
    rtimelogintv "Intervalo de registro"
    inca "Incluir despus"
    invert "Invertir"
    recwindow "Ventana de receptor"
    volume "Volume"
    latS "Lat S"
    latN "Lat N"
    longW "Long W"
    longE "Long E"
    no No
    computations Clculos
    comparea "Calcular rea"
    cluster Vecinos
    centre  Centro
    mkclusters "Agrupar vecinos"
    quadr Quadrngulo
    dlat "Diferencia en latitud"
    dlong "Diferencia en longitud"
    collcntr "Determinando centros..."
    compclstr "Calculando vecinos..."
    crtgclstrgrs "Creando grupos..."
    chgdatum "Cambiar datum..."
    print Imprimir
    prevctr "Centro anterior"
    printopt "Opciones de impresin"
    chgmfsize "Cambiar tamao fuente mapa"
    cwpsdef "PTs de control para definir ahora"
    nextTP "Prximo punto trayecto"
    generate Generar
    generateall "Generar todos"
    width Grosor
    simplTRto "Simplificar a"
    exstglog "Registro existente"
    contnsly "Continuamente"
    animate "animar"
    animabbrev "anim."
    noanabbr "no anim."
    zelev "inclinacin Z"
    xyelev "inclinacin XY"
    notext "sin leyendas"
    view "Vista"
    sideview "Vista lateral"
    persptv "Perspectiva"
    optMAPCOLOUR,trvtrk "Flecha TRK"
    optMAPCOLOUR,trvtrn "Flechas TRN"
    optMAPCOLOUR,trvcts "Flecha CTS"
    optMAPCOLOUR,trvcts2 "2a flecha CTS"
    optMAPCOLOUR,trvvel_z "Flecha para arriba/abajo"
    optMAPCOLOUR,trvwrnimportant "Aviso importante (nav)"
    optMAPCOLOUR,trvwrnnormal "Aviso (nav)"
    optMAPCOLOUR,trvwrninfo "Informacin (nav)"
    optTRAVELFONTSIZE "Tamao de fuente para viaje"
    travel Viaje
    notravel "Fin de viaje"
    travdisplay "Configurar presentacin"
    travchgdisplay "Cambiar a presentacin %s"
    travdsetup "Configurar presentacin de viaje"
    navMOB "Hombre al agua (MOB)!"
    startnav "Navegar"
    navWP "Ir a PT"
    goback "Regresar"
    follow "Seguir %s"
    exactly "exactamente"
    fromnrst "del punto mas cercano"
    inrvrs "en sentido contrario"
    forgetgoal "Olvidar objetivo"
    suspend "Suspender"
    resume "Recomenzar"
    TRVfix "Fix"
    TRVhour "Tiempo"
    TRVspeed "Veloc"
    TRVpos "Pos"
    TRValt "Alt"
    TRVtrk "TRK"
    TRVnxtWP "Para"
    TRVprvWP "De"
    TRVete "ETE"
    TRVeta "ETA"
    TRVvmg "VMG"
    TRVxtk "XTK"
    TRVcts "CTS"
    TRVtrn "TRN"
    TRVvel_z "Vel vert"
    TRVtrkcts "TRK, CTS"
    TRVdist "Dist"
    TRVc_trkcts "Flechas TRK/CTS"
    TRVc_trn "Flechas TRN"
    TRVc_vel_z "Flechas cima/baixo"
    add "Aadir"
    addlabelled "Aadir con nombre"
    remove "Eliminar"
    mindist "Distancia de llegada"
    chggoal "Pasar a siguiente objetivo"
    chginggoal "Cambiando a siguiente objetivo"
    chggoalhlp "Cuando cambiar de un\nobjetivo al siguiente\nmientras se sigue RT/TR"
    soon pronto
    late tarde
    warnings "Avisos"
    dowarn "Mostrar avisos"
    warnconf "Configurar avisos"
    priority Prioridad
    high alta
    medium media
    low baja
    warnprox "Distancia a PT <"
    warnanchor "Distancia a PT >"
    warnspeed "Velocidad >"
    warntrn "TRN (abs)>"
    warnvspeed "Vel vertical"
    warnxtk "XTK (abs)>"
    fntsize "Tamao de fuente"
    trvhlpbox "Usar botn derecho para reordenar los elementos de abajo"
    trvhlpbxs "Usar botn derecho para reordenar los elementos de la lista"
    trvwarrv "Llegando a %s!"
    trvwleave "Saliendo de %s!"
    trvwspeed "Velocidad > %s!"
    trvwtrn "TRN > %s!"
    trvwvspeed "Vel vert fuera de [%s,%s]!"
    trvwxtk "XTK > %s!"
    trvwnolog "Registro en tiempo real detenido!"
    trvwnopos "Posiciones anteriores no disponibles"
    trvwuwps "RT tiene PT(s) no definidos"
    trvwchg "Yendo ahora hacia %s"
    TP TP
    drivesim "simulador de conduccin"
    startfrom "Comenzar de..."
    outofctrl "Fuera de control!"
    right Derecha
    left Izquierda
    straight "De frente"
    rthlpdsim "Teclas de flecha: girar, des/acelerar\nEspacio: de frente"
    hiddendata "Datos ocultos"
    Ghidden_class Clase
    Ghidden_subclass Subclase
    Ghidden_lnk_ident "Id etapa"
    Ghidden_colour Color
    Ghidden_attrs Atributos
    Ghidden_depth Profundidad
    Ghidden_state Estado
    Ghidden_country Pas
    Ghidden_facility Facility
    Ghidden_city Ciudad
    Ghidden_addr Direccin
    Ghidden_int_road "Cruce de vas"
    Ghidden_dtyp "Mostrar+tipo"
    Ghidden_ete "ETE"
    Ghidden_display "Mostrar?"
    Ghidden_yes S
    Ghidden_no No
    Ghidden_user "Usuario"
    Ghidden_user_symbol "Usuario (slo smbolo)"
    Ghidden_non_user "Interno"
    Ghidden_avn_airport "Aeropuerto"
    Ghidden_avn_inters "Interseccin (av)"
    Ghidden_avn_NDB "NDB"
    Ghidden_avn_VOR "VOR"
    Ghidden_avn_airp_rway "Lmite de pista (aeropuerto)"
    Ghidden_avn_airp_int "Interseccin (aeropuerto)"
    Ghidden_avn_airp_NDB "NDB (aeropuerto)"
    Ghidden_map_pt "Punto (mapa)"
    Ghidden_map_area "rea (mapa)"
    Ghidden_map_int "Interseccin (mapa)"
    Ghidden_map_addr "Direccin (mapa)"
    Ghidden_map_line "Lnea (mapa)"
    Ghidden_locked Bloqueado
    Ghidden_default "Normal"
    Ghidden_black Negro
    Ghidden_white Blanco
    Ghidden_red Rojo
    Ghidden_dark_red "Rojo oscuro"
    Ghidden_green Verde
    Ghidden_dark_green "Verde oscuro"
    Ghidden_blue Azul
    Ghidden_dark_blue "Azul oscuro"
    Ghidden_yellow Amarillo
    Ghidden_dark_yellow "Amarillo oscuro"
    Ghidden_magenta Magenta
    Ghidden_dark_magenta "Magenta oscuro"
    Ghidden_cyan Cyan
    Ghidden_dark_cyan "Cyan oscuro"
    Ghidden_light_gray "Gris claro"
    Ghidden_dark_gray "Gris oscuro"
    Ghidden_line Lnea
    Ghidden_link Etapa
    Ghidden_net Red
    Ghidden_direct Directo
    Ghidden_snap "Discreto(snap)"
    renres "NUEVO NOMBRE"
    forgetGRcs "Olvidar grupo"
    PRJBMN "Cuadrcula Austriaca BMN"
    PRJCTR "Carta Tecnica Reg (I)"
    optDEFMAPPROJ "Proyeccin de mapa"
    optDEFMAPPFRMT "Coordenadas del mapa"
    optMapGuideVersion "versin MapGuide"
    undo Deshacer
    UTMzone zona
    tfwfile  "fichero TFW"
    ok Ok
    GRA   "GradosC"
    newWPatdb "Nuevo punto hacia..."
    PRJLamb93 "Lambert 93"
    PRJLambNTFe "NTF IIet"
    PRJLambNTF "NTF"
    NTFzone zona
    opinprogr "Realizando operacin"
    working "Ejecutando"
    aborted "Abortado!"
    errwarn "Error(es)/aviso(s)!"
    SYbiker "Ciclista"
    SYbox_blue "Caja, azul"
    SYbox_green "Caja, verde"
    SYbox_red "Caja, roja"
    SYflag_pin_blue "Alfiler con bandera, azul"
    SYflag_pin_green "Alfiler con bandera, verde"
    SYflag_pin_red "Alfiler con bandera, rojo"
    SYhouse_2 "Casa 2"
    SYpin_blue "Alfiler, azul"
    SYpin_green "Alfiler, verde"
    SYpin_red "Alfiler, rojo"
    ozimapfile "fichero Ozi Map"
    info "Informacin"
    climbrate "Ritmo de Ascenso"
    optUSESLOWOPWINDOW "Ventana para controlar operaciones lentas"
    optDEFTRECPROTOCOL "Protocolo por defecto"
    optLNSREACT "LNs asociadas responden al ratn"
    BGAfeature  "BGA Caracterstica"
    BGAfindblty "BGA Encontrabilidad"
    BGAairact   "BGA Actividad aerea"
    syhlpbx "Usar botn derecho para\nreordenar los elementos de la lista"
    optDEFMAPPFDATUM "Datum de coordenadas del mapa"
    mkgrp "Crear Grupo"
    dispitems "Elementos mostrados"
    hiditems "Elementos ocultos"
    optAutoNumRts "Numerar Rutas automticamente al enviar"
    Ghidden_transparent Transparente
    Ghidden_temp Temperatura
    Ghidden_time "Marca de tiempo"
    Ghidden_cat Categora
    SYopen_24hr "Abierto 24h"
    SYfhs_facility "Instalacin FHS"
    SYbot_cond "Condiciones fondo"
    SYtide_pred_stn "Estacin prediccin mareas/corrientes"
    SYanchor_prohib "Ancla prohibida"
    SYbeacon "Baliza"
    SYcoast_guard "GuardaCostas"
    SYreef "Arrecife"
    SYweedbed "Lecho de algas"
    SYdropoff "Embarcadero"
    SYdock "Drsena"
    SYmarina "Marina"
    SYbait_tackle "Cebo y aparejo"
    SYstump "Tocn"
    SYcntct_smiley "Sonriente"
    SYcntct_ball_cap "Pelota beisbol"
    SYcntct_big_ears "Orejas grandes"
    SYcntct_spike "Clavo"
    SYcntct_goatee "Perilla"
    SYcntct_afro "Afro"
    SYcntct_dreads "Trencitas"
    SYcntct_female1 "Hembra 1"
    SYcntct_female2 "Hembra 2"
    SYcntct_female3 "Hembra 3"
    SYcntct_ranger "Ranger"
    SYcntct_kung_fu "Kung fu"
    SYcntct_sumo "Sumo"
    SYcntct_pirate "Pirata"
    SYcntct_biker "Ciclista"
    SYcntct_alien "Alien"
    SYcntct_bug "Cucaracha"
    SYcntct_cat "Gato"
    SYcntct_dog "Perro"
    SYcntct_pig "Cerdo"
    SYhydrant "Boca de riego"
    SYcircle_blue "Crculo, azul"
    SYcircle_green "Crculo, verde"
    SYcircle_red "Crculo, rojo"
    SYdiamond_blue "Rombo, azul"
    SYoval_blue "Oval, azul"
    SYoval_green "Oval, verde"
    SYoval_red "Oval, rojo"
    SYrect_blue "Bloque, azul"
    SYrect_green "Bloque, verde"
    SYrect_red "Bloque, rojo"
    SYsquare_blue "Cuadrado, azul"
    SYtriangle_blue "Tringulo, azul"
    SYtriangle_green "Tringulo, verde"
    SYtriangle_red "Tringulo, rojo"
    SYletter_a_blue "A, azul"
    SYletter_a_green "A, verde"
    SYletter_a_red "A, rojo"
    SYletter_b_blue "B, azul"
    SYletter_b_green "B, verde"
    SYletter_b_red "B, rojo"
    SYletter_c_blue "C, azul"
    SYletter_c_green "C, verde"
    SYletter_c_red "C, rojo"
    SYletter_d_blue "D, azul"
    SYletter_d_green "D, verde"
    SYletter_d_red "D, rojo"
    SYnumber_0_blue "0, azul"
    SYnumber_0_green "0, verde"
    SYnumber_0_red "0, rojo"
    SYnumber_1_blue "1, azul"
    SYnumber_1_green "1, verde"
    SYnumber_1_red "1, rojo"
    SYnumber_2_blue "2, azul"
    SYnumber_2_green "2, verde"
    SYnumber_2_red "2, rojo"
    SYnumber_3_blue "3, azul"
    SYnumber_3_green "3, verde"
    SYnumber_3_red "3, rojo"
    SYnumber_4_blue "4, azul"
    SYnumber_4_green "4, verde"
    SYnumber_4_red "4, rojo"
    SYnumber_5_blue "5, azul"
    SYnumber_5_green "5, verde"
    SYnumber_5_red "5, rojo"
    SYnumber_6_blue "6, azul"
    SYnumber_6_green "6, verde"
    SYnumber_6_red "6, rojo"
    SYnumber_7_blue "7, azul"
    SYnumber_7_green "7, verde"
    SYnumber_7_red "7, rojo"
    SYnumber_8_blue "8, azul"
    SYnumber_8_green "8, verde"
    SYnumber_8_red "8, rojo"
    SYnumber_9_blue "9, azul"
    SYnumber_9_green "9, verde"
    SYnumber_9_red "9, rojo"
    numberfrom0 "Configurar contador a 0"
    items "Elementos"
    syusrmenu "Personalizar men de smbolo"
    cfgsymenu "Configurar men de smbolo"
    insmnb   "Inserta submen antes"
    insmna   "Inserta submen despus"
    opensbmn "Abrir submen"
    clssbmn  "Cerrar submen"
    optSUPPORTLAPS "Soporte para Vueltas"
    LAP  LAP
    nameLAP "Vuelta"
    duration "Duracin"
    calrs "Caloras"
    getLAP  "Obteniendo Vueltas"
   fromfile "desde fichero"
   fromdef "desde definicin"
   mbaktoload "Fondo para cargar"
   none "ninguno"
   opt_Fonts "Tamaos de fuentes"
   optFONTSIZE "Tamao fuente por defecto"
   optFIXEDFONTSIZE "Tamao fuente fija"
   optICONSIZE "Tamao de iconos"
   LP   PL
   garmin_usb "Garmin USB"
   optTRNUMBERINTVL "Mostrar en puntos trayecto en mapa"
   optTRINFO "Informacin puntos trayecto para mostrar"
   nameInfo "Informacin"
   nameAL "Almanaque"
   alm_svid "id satlite"
   alm_week "semana"
   alm_datatime "tiempo ref datos"
   alm_clockc1 "cpef corr reloj s"
   alm_clockc2 "coef corr reloj s/s"
   alm_ecc "excentricidad"
   alm_sqrta "raiz cuadr a"
   alm_mnanom "anomala promedio"
   alm_argprgee "arg perigeo"
   alm_rightasc "ascensin recta"
   alm_rtrightasc "veloc ascensin r"
   alm_inclin "inclinacin"
   alm_health "salud"
}

    # the following definitions must be coherent with $TXT
array set INVTXT {
    GMS   DMS
    GMM   DMM
    GGG   DDD
    GradosC GRA
    UTM/UPS   UTM/UPS
    MH   MH
    PT   WP
    RT   RT
    TR   TR
    PL   LP
    LAP  LAP
    GR   GR
}


