/* gpsk31  - PSK31 for Linux with a GTK+ Interface
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 * Copyright (C) 2005 Joop Stakenborg, PG4I
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 */

/*
 * text.C functions for the text widgets on the main window
 */

#include <gtk/gtk.h>
#include "text.h"
#include "globals.h"
#include <stdio.h>

/*
 *  This functions adds an character to the rx window
 */


void put_rx_window (gchar *text, gint txstate)
{
	GtkTextBuffer *buffer;
	GtkTextIter end;
	GtkTextMark *mark;
	GError *err = NULL;

	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (main_screen.rxwindow));
	gtk_text_buffer_get_end_iter (buffer, &end);
	gtk_text_buffer_place_cursor (buffer, &end);

	text = g_convert_with_fallback
		(text, -1, "UTF-8", "ISO-8859-1", ".", NULL, NULL, &err);
	if (!text || err) return;

	if (txstate == 1)
	{
		gtk_text_buffer_insert_with_tags_by_name
	    (buffer, &end, text, -1, "rx_window_color_tx", NULL);
	}
	else
	{
		gtk_text_buffer_insert_with_tags_by_name
	    (buffer, &end, text, -1, "rx_window_color_rx", NULL);
	}
	mark = gtk_text_buffer_get_mark (buffer, "insert");
	gtk_text_view_scroll_to_mark
		(GTK_TEXT_VIEW(main_screen.rxwindow), mark, 0.0, FALSE, 0.0, 1.0);
}

/*
 *   Put a char in the tx window
 */

void put_tx_window (gchar *text)
{
	GtkTextBuffer *buffer;
	GtkTextIter iter, end;
	GtkTextMark *mark;

	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (main_screen.txwindow));
	gtk_text_buffer_get_end_iter (buffer, &end);
	gtk_text_buffer_get_end_iter (buffer, &iter);
	gtk_text_iter_backward_chars (&iter, 1);
	gtk_text_buffer_delete (buffer, &iter, &end);
	gtk_text_buffer_insert_with_tags_by_name
	    (buffer, &iter, text, -1, "tx_window_color", NULL);
	mark = gtk_text_buffer_get_mark (buffer, "insert");
	gtk_text_view_scroll_to_mark
		(GTK_TEXT_VIEW(main_screen.txwindow), mark, 0.0, FALSE, 0.0, 1.0);
}
