/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*

  satpref.h: Implementation of Preferences dialog.

  Copyright (C)  2001-2003  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifndef SATPREF_H
#define SATPREF_H


/* Which numbers to display in
   detailed AOS calculations.
*/
enum sat_pref_aosd_e {
	AOSD_AZ      = 1 << 0,  /* azimuth */
	AOSD_EL      = 1 << 1,  /* elevation */
	AOSD_LAT     = 1 << 2,  /* lattitude */
	AOSD_LON     = 1 << 3,  /* longitude */
	AOSD_ALT     = 1 << 4,  /* altitude */
	AOSD_RAN     = 1 << 5,  /* range */
	AOSD_VEL     = 1 << 6,  /* velocity */
	AOSD_FP      = 1 << 7   /* footprint */
};

typedef enum sat_pref_aosd_e sat_pref_aosd_t;


void satpref_open_cb (GtkWidget *, gpointer);
void satpref_changed (void);


#endif
