/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*

  satpref.c: Implementation of Preferences dialog.

  Copyright (C)  2001-2003  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <gnome.h>
#include <gconf/gconf-client.h>
#include "defaults.h"
#include "timeout.h"
#include "satdata.h"    /* satdata.h needs to be included before engine.h */
#include "engine.h"
#include "satlog.h"
#include "satlist.h"
#include "satpref.h"
#include "satpref-general.h"
#include "satpref-qth.h"
#include "satpref-satlist.h"
#include "satpref-satmap.h"
#include "satpref-satplot.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


GtkWidget *pbox;                                   /* property box */
GtkObject *engadj,*aosnadj,*aosdadj;      /* adjustments to spin buttons */
GtkWidget *engspin,*aosnspin,*aosdspin;  /* spin buttons */
GtkWidget *tlef;                                   /* TLE file selector */

guint mask; /* bit mask for detailed display */

extern GConfClient *client; /* main.c */

/* page numbers in preferences box,
   ie. tabs indices.
*/
enum page_numbers {
	PAGE_GENERAL = 0,
	PAGE_ENGINE,
	PAGE_QTH,
	PAGE_SATLIST,
	PAGE_SATMAP,
	PAGE_SATPLOT,
       	PAGE_AOS,
	PAGE_LOG,
	PAGE_PRINT,
	PAGE_TOTAL
};



/* function prototypes */
static void satpref_apply_cb (GnomePropertyBox *,gint);
static void tog_butt_cb (GtkWidget *, gpointer);
static GtkWidget *satpref_engine (void);
static GtkWidget *satpref_aos (void);
static GtkWidget *satpref_satlog (void);
static GtkWidget *satpref_satprint (void);



void satpref_open_cb (GtkWidget *w, gpointer d)
{
	/* This function is called when the user clicks
	   on the "preferences" button or selects
	   preferences from the menu.
	*/
	GtkWidget *label;
	guint i;

	pbox = gnome_property_box_new ();
	gtk_window_set_title (GTK_WINDOW (pbox), _("Gnome Predict Preferences"));

	/* fix up the notebook */
	gtk_notebook_set_scrollable (GTK_NOTEBOOK (GNOME_PROPERTY_BOX (pbox)->notebook),
				     TRUE);
	gtk_notebook_set_homogeneous_tabs (GTK_NOTEBOOK (GNOME_PROPERTY_BOX (pbox)->notebook),
					   FALSE);
	gtk_notebook_popup_enable (GTK_NOTEBOOK (GNOME_PROPERTY_BOX (pbox)->notebook));

	for ( i=0; i<PAGE_TOTAL; i++ ) {
		switch (i) {
		case PAGE_GENERAL:
			label = gtk_label_new (_("General"));
			gnome_property_box_append_page (GNOME_PROPERTY_BOX (pbox),
							satpref_general (), label);
			break;
		case PAGE_ENGINE:
			label = gtk_label_new (_("Engine"));
			gnome_property_box_append_page (GNOME_PROPERTY_BOX (pbox),
							satpref_engine (), label);
			break;
		case PAGE_QTH:
			label = gtk_label_new (_("Locations"));
			gnome_property_box_append_page (GNOME_PROPERTY_BOX (pbox),
							satpref_qth_create (), label);
			break;
		case PAGE_SATLIST:
			label = gtk_label_new (_("Lists"));
			gnome_property_box_append_page (GNOME_PROPERTY_BOX (pbox),
							satpref_satlist (), label);
			break;
		case PAGE_SATMAP:
			label = gtk_label_new (_("Maps"));
			gnome_property_box_append_page (GNOME_PROPERTY_BOX (pbox),
							satpref_satmap (), label);
			break;
		case PAGE_SATPLOT:
			label = gtk_label_new (_("Track Plot"));
			gnome_property_box_append_page (GNOME_PROPERTY_BOX (pbox),
						       satpref_satplot (), label);
			break;
		case PAGE_AOS:
			label = gtk_label_new (_("Predict"));
			gnome_property_box_append_page (GNOME_PROPERTY_BOX (pbox),
							satpref_aos (), label);
			break;
		case PAGE_LOG:
			label = gtk_label_new (_("Messages"));
			gnome_property_box_append_page (GNOME_PROPERTY_BOX (pbox),
							satpref_satlog(), label);
			break;
		case PAGE_PRINT:
			label = gtk_label_new (_("Printing"));
			gnome_property_box_append_page (GNOME_PROPERTY_BOX (pbox),
							satpref_satprint (), label);
			break;
		default:
		}
	}

	/* connect signals */
	gtk_signal_connect (GTK_OBJECT (pbox), "apply",
			    GTK_SIGNAL_FUNC (satpref_apply_cb), NULL );

	gtk_widget_show_all (pbox);
}


static void
satpref_apply_cb (GnomePropertyBox *pbox, gint page_num)
{
	/* This function is called when the user clicks
	   on the "apply" or "OK" button. It is called
	   for every page that has been changed.
	*/

	switch (page_num) {
	case PAGE_ENGINE: /* Engine */
		/* Engine Timer */
		gconf_client_set_int (client, ENGINE_TIMER_PATH,
				      gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (engspin)),
				      NULL);
		engine_stop ();
		engine_start ();
		
		break;
	case PAGE_QTH:
		satpref_qth_apply ();
		break;
	case PAGE_GENERAL:
		satpref_general_apply ();
		break;
	case PAGE_SATLIST:
		satpref_satlist_apply ();
		break;
	case PAGE_SATMAP:
		satpref_satmap_apply ();
		break;
	case PAGE_SATPLOT:
		satpref_satplot_apply ();
		break;
	case PAGE_AOS:
		/* save number of passes */
		gconf_client_set_int (client, AOS_SIMPLE_NUM_PATH,
				      gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (aosnspin)),
				      NULL);
		/* save time resolution */
		gconf_client_set_int (client, AOS_DETAIL_RES_PATH,
				      gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (aosdspin)),
				      NULL);
		/* save AOS bitmask */
		gconf_client_set_int (client, AOS_DETAIL_MASK_PATH, mask, NULL);
		break;
	default:
		satlog_log (SAT_LOG_CRITICAL, _("Invalid PAGE_NUM in preferences box!"));
	}

	gconf_client_suggest_sync (client, NULL);
}





static GtkWidget
*satpref_engine()
{
	/* This function creates the engine property page */

	GtkWidget *table,*label;
	gint delay;

	table = gtk_table_new (6, 4, TRUE);
	gtk_table_set_col_spacings (GTK_TABLE (table), 2);
	gtk_table_set_row_spacings (GTK_TABLE (table), 2);

	/* engine timer */
	label = gtk_label_new (_("Update every"));
	gtk_misc_set_alignment (GTK_MISC (label), 0.5f, 0.5f);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
	delay = gconf_client_get_int (client, ENGINE_TIMER_PATH, NULL);
	if (!delay)
		delay = ENGINE_DEF_TIMER;
	engadj = gtk_adjustment_new (delay, 10, 1000, 10, 50, 4);
	engspin = gtk_spin_button_new (GTK_ADJUSTMENT (engadj), 0.5, 0);
	gtk_signal_connect (GTK_OBJECT (engspin), "changed",
			    GTK_SIGNAL_FUNC (satpref_changed), NULL);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (engspin), TRUE);
	gtk_table_attach_defaults (GTK_TABLE (table), engspin, 1, 2, 1, 2);
	label = gtk_label_new (_("[msec]"));
	gtk_misc_set_alignment (GTK_MISC (label), 0.5f, 0.5f);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3, 1, 2);

	return table;
}



static GtkWidget
*satpref_aos ()
{
	/* This function creates a preferences widget
	   for AOS/LOS predictions.
	*/
	GtkWidget *tframe,*bframe,*thbox,*btab,*vbox,*label;
	GtkWidget *togaz,*togel,*toglat,*toglon,*togalt,*togran,*togvel,*togfp; /* toggle buttons */

	/* upcoming passes */
	thbox = gtk_hbox_new (FALSE, 10);
	label = gtk_label_new (_("Number of Passes"));
	gtk_misc_set_alignment( GTK_MISC(label), 1.0f, 0.5f );
	gtk_box_pack_start (GTK_BOX (thbox), label, FALSE, FALSE, 0);
	aosnadj = gtk_adjustment_new (gconf_client_get_int (client, AOS_SIMPLE_NUM_PATH, NULL) ?
				      gconf_client_get_int (client, AOS_SIMPLE_NUM_PATH, NULL) :
				      AOS_SIMPLE_DEF_NUM, 5, 50, 1, 5, 1);
	aosnspin = gtk_spin_button_new (GTK_ADJUSTMENT (aosnadj), 0.5, 0 );
	gtk_signal_connect (GTK_OBJECT (aosnspin), "changed",
			    GTK_SIGNAL_FUNC (satpref_changed), NULL );
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (aosnspin), TRUE );
	gtk_box_pack_start (GTK_BOX (thbox), aosnspin, FALSE, FALSE, 0);
	label = gtk_label_new (" (5..50)");
	gtk_misc_set_alignment( GTK_MISC(label), 0.0f, 0.5f );
	gtk_box_pack_start (GTK_BOX (thbox), label, FALSE, FALSE, 0);
	
	/* create frame around the widgets */
	tframe = gtk_frame_new (_(" Upcoming Passes "));
	gtk_frame_set_label_align (GTK_FRAME (tframe), 0.0, 0.5);
	gtk_container_add (GTK_CONTAINER (tframe), thbox);

	/* detailed AOS prediction */
	btab = gtk_table_new (3, 4, TRUE);

	label = gtk_label_new (_("Time resolution"));
	gtk_misc_set_alignment (GTK_MISC(label), 0.5f, 0.5f );
	gtk_table_attach_defaults (GTK_TABLE (btab), label, 1, 2, 0, 1);
	aosdadj = gtk_adjustment_new (gconf_client_get_int (client, AOS_DETAIL_RES_PATH, NULL) ?
				      gconf_client_get_int (client, AOS_DETAIL_RES_PATH, NULL) :
				      AOS_DETAIL_DEF_RES, 1, 600, 1, 60, 1);
	aosdspin = gtk_spin_button_new (GTK_ADJUSTMENT (aosdadj), 0.5, 0 );
	gtk_signal_connect (GTK_OBJECT (aosdspin), "changed",
			    GTK_SIGNAL_FUNC (satpref_changed), NULL );
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (aosdspin), TRUE );
	gtk_table_attach_defaults (GTK_TABLE (btab), aosdspin, 2, 3, 0, 1);
	label = gtk_label_new (_("[sec]"));
	gtk_misc_set_alignment (GTK_MISC (label), 0.5f, 0.5f );
	gtk_table_attach_defaults (GTK_TABLE (btab), label, 3, 4, 0, 1);
	/* get display bitmask */
	mask = gconf_client_get_int (client, AOS_DETAIL_MASK_PATH, NULL) ? 
	       gconf_client_get_int (client, AOS_DETAIL_MASK_PATH, NULL) :
		AOS_DETAIL_DEF_MASK;

	/* check buttons */
	togaz = gtk_check_button_new_with_label (_("Azimuth"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (togaz), mask & AOSD_AZ);
	gtk_signal_connect (GTK_OBJECT (togaz), "toggled",
			    GTK_SIGNAL_FUNC (tog_butt_cb), GUINT_TO_POINTER (AOSD_AZ) );
	gtk_table_attach_defaults (GTK_TABLE (btab), togaz, 0, 1, 1, 2);

	togel = gtk_check_button_new_with_label (_("Elevation"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (togel), mask & AOSD_EL);
	gtk_signal_connect (GTK_OBJECT (togel), "toggled",
			    GTK_SIGNAL_FUNC (tog_butt_cb), GUINT_TO_POINTER (AOSD_EL) );
	gtk_table_attach_defaults (GTK_TABLE (btab), togel, 1, 2, 1, 2);

	toglat = gtk_check_button_new_with_label (_("Latitude"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toglat), mask & AOSD_LAT);
	gtk_signal_connect (GTK_OBJECT (toglat), "toggled",
			    GTK_SIGNAL_FUNC (tog_butt_cb), GUINT_TO_POINTER (AOSD_LAT) );
	gtk_table_attach_defaults (GTK_TABLE (btab), toglat, 2, 3, 1, 2);

	toglon = gtk_check_button_new_with_label (_("Longitude"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toglon), mask & AOSD_LON);
	gtk_signal_connect (GTK_OBJECT (toglon), "toggled",
			    GTK_SIGNAL_FUNC (tog_butt_cb), GUINT_TO_POINTER (AOSD_LON) );
	gtk_table_attach_defaults (GTK_TABLE (btab), toglon, 3, 4, 1, 2);

	togalt = gtk_check_button_new_with_label (_("Altitude"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (togalt), mask & AOSD_ALT);
	gtk_signal_connect (GTK_OBJECT (togalt), "toggled",
			    GTK_SIGNAL_FUNC (tog_butt_cb), GUINT_TO_POINTER (AOSD_ALT) );
	gtk_table_attach_defaults (GTK_TABLE (btab), togalt, 0, 1, 2, 3);

	togran = gtk_check_button_new_with_label (_("Range"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (togran), mask & AOSD_RAN);
	gtk_signal_connect (GTK_OBJECT (togran), "toggled",
			    GTK_SIGNAL_FUNC (tog_butt_cb), GUINT_TO_POINTER (AOSD_RAN) );
	gtk_table_attach_defaults (GTK_TABLE (btab), togran, 1, 2, 2, 3);

	togvel = gtk_check_button_new_with_label (_("Velocity"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (togvel), mask & AOSD_VEL);
	gtk_signal_connect (GTK_OBJECT (togvel), "toggled",
			    GTK_SIGNAL_FUNC (tog_butt_cb), GUINT_TO_POINTER (AOSD_VEL) );
	gtk_table_attach_defaults (GTK_TABLE (btab), togvel, 2, 3, 2, 3);

	togfp = gtk_check_button_new_with_label (_("Footprint"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (togfp), mask & AOSD_FP);
	gtk_signal_connect (GTK_OBJECT (togfp), "toggled",
			    GTK_SIGNAL_FUNC (tog_butt_cb), GUINT_TO_POINTER (AOSD_FP) );
	gtk_table_attach_defaults (GTK_TABLE (btab), togfp, 3, 4, 2, 3);

	bframe = gtk_frame_new (_(" AOS Details "));
	gtk_frame_set_label_align (GTK_FRAME (bframe), 0.0, 0.5);
	gtk_container_add (GTK_CONTAINER (bframe), btab);

	vbox = gtk_vbox_new (FALSE, 5);
	gtk_box_pack_start (GTK_BOX (vbox), tframe, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), bframe, TRUE, TRUE, 0);

	return vbox;
}


static GtkWidget
*satpref_satlog ()
{
	/* This function creates a preferences widget
	   for the satlog.
	*/
	return gtk_label_new (_("To be done..."));
}



static GtkWidget
*satpref_satprint ()
{
	/* This function creates a preferences widget
	   for satprint.
	*/
	return gtk_label_new (_("To be done..."));
}


void satpref_changed()
{
	/* This function is called, when a widget state
	   has changed. It sets the changed flag for the
	   respective pages.
	*/
	gnome_property_box_changed( GNOME_PROPERTY_BOX(pbox) );
}


static void
tog_butt_cb (GtkWidget *tb, gpointer data)
{
	guint tmask;

	tmask = GPOINTER_TO_UINT (data);
	if (mask & tmask) /* turn bit OFF */
		mask &= ~tmask;
	else              /* turn bit ON */
		mask |= tmask;
	/* send notification about change */
	satpref_changed ();
}


