/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  clock.c: Clock and timefunctions for Gnome Predict.

  Copyright (C)  2001-2003  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <gnome.h>
#include <time.h>
#include "satlog.h"
#include "clock.h"

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

/* We display the current time in the AppBar. */
extern GtkWidget *appbar;

gint clock_timer_id = -1;



/* FIXME: SUN/MOON/CLOCK TIME SYNC!!! */
gint clock_timer_callback (gpointer data)
{
	struct tm *utc;
	time_t tim;
	gchar **tmp;
    
	tim = time (NULL);
	utc = gmtime (&tim);
	tmp = g_strsplit (asctime(utc), "\n", 2);
	gnome_appbar_pop (GNOME_APPBAR (appbar));
	gnome_appbar_push (GNOME_APPBAR (appbar),
			   tmp[0] );
	g_strfreev (tmp);

	return TRUE;
}

void clock_timer_start()
{
	if ( clock_timer_id != -1 )
		satlog_log (SAT_LOG_DEBUG, _("Internal ERROR (clock_timer_start)"));
	else
		clock_timer_id = gtk_timeout_add (1000, clock_timer_callback, 
						  NULL);
}

void clock_timer_stop()
{
	if ( clock_timer_id != -1 ) {
		/* we have a real timeout running */
		gtk_timeout_remove (clock_timer_id);
		clock_timer_id = -1;
	}
	else 
		satlog_log (SAT_LOG_DEBUG, _("Internal ERROR (clock_timer_stop)"));
}
