/*
  Gnome-o-Phone - A program for internet telephony
  Copyright (C) 1999  Roland Dreier
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  $Id: thread.c 1.10 Sat, 13 Nov 1999 12:11:37 -0600 dreier $
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>

#include "thread.h"

#include "gphone.h"
#include "gphone-lib.h"

static Program_Status status;
static int Mic_Level, Spk_Level;

G_LOCK_DEFINE(status);
G_LOCK_DEFINE(level);
G_LOCK_DEFINE(sound);

static char * str_status[] = {
  "STAT_IDLE",
  "STAT_WAIT",
  "STAT_CALL",
  "STAT_NEGOTIATE",
  "STAT_TALK",
  "STAT_LISTEN",
  "STAT_TALK_FD",
  "STAT_QUIT",
  "STAT_RINGING",
  "STAT_NO_ANSWER"
};

Program_Status
get_status(void)
{
  Program_Status cur_status;

  G_LOCK(status);
  cur_status = status;
  G_UNLOCK(status);

  return(cur_status);
}

void
set_status(Program_Status new_status)
{
  g_log("GPHONE", G_LOG_LEVEL_DEBUG,
        "changing status : %s -> %s",
        str_status[status], str_status[new_status]);

  G_LOCK(status);
  status = new_status;
  G_UNLOCK(status);
}

int
get_mic_level(void)
{
  int cur_level;

  G_LOCK(level);
  cur_level = Mic_Level;
  G_UNLOCK(level);

  return(cur_level);
}

void
set_mic_level(int new_level)
{
  G_LOCK(level);
  Mic_Level = new_level;
  G_UNLOCK(level);
}

int
get_spk_level(void)
{
  int cur_level;

  G_LOCK(level);
  cur_level = Spk_Level;
  G_UNLOCK(level);

  return(cur_level);
}

void
set_spk_level(int new_level)
{
  G_LOCK(level);
  Spk_Level = new_level;
  G_UNLOCK(level);
}

void
lock_sound(void)
{
  G_LOCK(sound);
}

void
unlock_sound(void)
{
  G_UNLOCK(sound);
}



/*
 * Local variables:
 *  compile-command: "make -k gphone"
 * End:
 */
