/*
  Gnome-o-Phone - A program for internet telephony
  Copyright (C) 1999  Roland Dreier
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  $Id: call-ui.c 1.1 Sat, 11 Dec 1999 23:53:26 -0600 dreier $
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ui.h"

#include <gtk/gtk.h>

#include "thread-queue.h"
#include "request.h"
#include "talk.h"
#include "listen.h"
#include "connection.h"
#include "thread.h"
#include "sound.h"

#include "gphone.h"
#include "gphone-lib.h"

static GtkWidget *Call_Window = NULL;
static GtkWidget *Host_Entry;

static void
destroy(GtkWidget *widget, gpointer data)
{
  Call_Window = NULL;
}

static void
call_button_clicked(GtkWidget *widget, gpointer data)
{
  Request req;

  set_status(STAT_CALL);
  
  req = g_malloc(sizeof *req);
  
  req->type = REQUEST_CALL;
  req->data = g_strdup(gtk_entry_get_text(GTK_ENTRY(Host_Entry)));
  req->data_len = strlen(req->data) + 1;
  
  talk_add_request(req);

  gtk_widget_destroy(GTK_WIDGET(data));
}

static void
cancel_button_clicked(GtkWidget *widget, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(data));
}

void
call_open_window(void)
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *separator;
  GtkWidget *button;
  GtkWidget *label;

  if (Call_Window != NULL) {
    return;
  }

  Call_Window = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(Call_Window), "call");
  gtk_container_set_border_width(GTK_CONTAINER(Call_Window), 10);
  
  gtk_signal_connect(GTK_OBJECT(Call_Window), "destroy",
                     GTK_SIGNAL_FUNC(destroy), NULL);

  vbox = gtk_vbox_new(FALSE, 5);

  hbox = gtk_hbox_new(FALSE, 5);

  label = gtk_label_new("Hostname:");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  Host_Entry = gtk_entry_new();
  gtk_widget_show(Host_Entry);
  gtk_box_pack_start(GTK_BOX(hbox), Host_Entry, TRUE, TRUE, 0);

  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

  separator = gtk_hseparator_new();
  gtk_widget_show(separator);

  gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 0);

  hbox = gtk_hbox_new(TRUE, 5);

  button = gtk_button_new_with_label("Call");
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
                     GTK_SIGNAL_FUNC(call_button_clicked), Call_Window);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label("Cancel");
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
                     GTK_SIGNAL_FUNC(cancel_button_clicked), Call_Window);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

  gtk_container_add(GTK_CONTAINER(Call_Window), vbox);
  gtk_widget_show(vbox);
  gtk_widget_show(Call_Window);
}



/*
 * Local variables:
 *  compile-command: "make -k gphone"
 * End:
 */
