/* 
   Copyright (C) 1999 Kyle R. Burton, All Rights Reserved
   mortis@voicenet.com
   http://www.bgw.org
   http://www.voicenet.com/~mortis

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef _GPERIODIC_H
#define _GPERIODIC_H 

#include <gtk/gtk.h>
#include <libintl.h>
#define _(String) gettext(String)
#ifdef gettext_noop
# define N_(String) gettext_noop (String)
#else
# define N_(String) (String)
#endif

/* structure to hold element data, as initialized from the static
 * table_data.c. */
enum info_types {
  NAME = 0,
  SYMBOL,
  NUMBER,
  WEIGHT,
  DENSITY,
  MELTING,
  BOILING,
  ATOMIC_RADIUS,
  COVALENT_RADIUS,
  IONIC_RADIUS,
  ATOMIC_VOLUME,
  SPECIFIC_HEAT,
  FUSION_HEAT,
  EVAPORATION_HEAT,
  TERMAL_CONDUCTIVITY,
  PAULING,
  ENERGY,
  OXIDATION,
  CONFIGURATION,
  LATTICE,
  LATTICE_CONSTANT,
  MAX_INFO_NR      /* Has to be the last element */
};

struct table_entry {
  char *info[MAX_INFO_NR];
  int   x;      /* x position in the table */
  int   y;      /* y position in the table */
  GdkColor    color;
  GtkStyle    *style;
  GtkWidget   *button;    /* associated gtk button */
  GtkTooltips *tooltip;    /* associated gtk tooltip */
};

struct colorscale {       /* table of maxcolor GkdColors */
  int maxcolor;
  GdkColor *scale;
};

typedef double criterion( struct table_entry *entry );

void dump_table(void);

int parse_table(void);

int interactive_shell(void);

/* debugging macro, does nothing unless _DEBUG is defined... */
#if defined(_DEBUG)
#  define _DBG(a) (a)
#else
#  define _DBG(a)
#endif

#endif

