package servicefabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/servicefabric/mgmt/2019-03-01-preview/servicefabric"

// ArmServicePackageActivationMode enumerates the values for arm service package activation mode.
type ArmServicePackageActivationMode string

const (
	// ExclusiveProcess Indicates the application package activation mode will use exclusive process.
	ExclusiveProcess ArmServicePackageActivationMode = "ExclusiveProcess"
	// SharedProcess Indicates the application package activation mode will use shared process.
	SharedProcess ArmServicePackageActivationMode = "SharedProcess"
)

// PossibleArmServicePackageActivationModeValues returns an array of possible values for the ArmServicePackageActivationMode const type.
func PossibleArmServicePackageActivationModeValues() []ArmServicePackageActivationMode {
	return []ArmServicePackageActivationMode{ExclusiveProcess, SharedProcess}
}

// ArmUpgradeFailureAction enumerates the values for arm upgrade failure action.
type ArmUpgradeFailureAction string

const (
	// Manual Indicates that a manual repair will need to be performed by the administrator if the upgrade
	// fails. Service Fabric will not proceed to the next upgrade domain automatically.
	Manual ArmUpgradeFailureAction = "Manual"
	// Rollback Indicates that a rollback of the upgrade will be performed by Service Fabric if the upgrade
	// fails.
	Rollback ArmUpgradeFailureAction = "Rollback"
)

// PossibleArmUpgradeFailureActionValues returns an array of possible values for the ArmUpgradeFailureAction const type.
func PossibleArmUpgradeFailureActionValues() []ArmUpgradeFailureAction {
	return []ArmUpgradeFailureAction{Manual, Rollback}
}

// ClusterState enumerates the values for cluster state.
type ClusterState string

const (
	// AutoScale ...
	AutoScale ClusterState = "AutoScale"
	// BaselineUpgrade ...
	BaselineUpgrade ClusterState = "BaselineUpgrade"
	// Deploying ...
	Deploying ClusterState = "Deploying"
	// EnforcingClusterVersion ...
	EnforcingClusterVersion ClusterState = "EnforcingClusterVersion"
	// Ready ...
	Ready ClusterState = "Ready"
	// UpdatingInfrastructure ...
	UpdatingInfrastructure ClusterState = "UpdatingInfrastructure"
	// UpdatingUserCertificate ...
	UpdatingUserCertificate ClusterState = "UpdatingUserCertificate"
	// UpdatingUserConfiguration ...
	UpdatingUserConfiguration ClusterState = "UpdatingUserConfiguration"
	// UpgradeServiceUnreachable ...
	UpgradeServiceUnreachable ClusterState = "UpgradeServiceUnreachable"
	// WaitingForNodes ...
	WaitingForNodes ClusterState = "WaitingForNodes"
)

// PossibleClusterStateValues returns an array of possible values for the ClusterState const type.
func PossibleClusterStateValues() []ClusterState {
	return []ClusterState{AutoScale, BaselineUpgrade, Deploying, EnforcingClusterVersion, Ready, UpdatingInfrastructure, UpdatingUserCertificate, UpdatingUserConfiguration, UpgradeServiceUnreachable, WaitingForNodes}
}

// DurabilityLevel enumerates the values for durability level.
type DurabilityLevel string

const (
	// Bronze ...
	Bronze DurabilityLevel = "Bronze"
	// Gold ...
	Gold DurabilityLevel = "Gold"
	// Silver ...
	Silver DurabilityLevel = "Silver"
)

// PossibleDurabilityLevelValues returns an array of possible values for the DurabilityLevel const type.
func PossibleDurabilityLevelValues() []DurabilityLevel {
	return []DurabilityLevel{Bronze, Gold, Silver}
}

// Environment enumerates the values for environment.
type Environment string

const (
	// Linux ...
	Linux Environment = "Linux"
	// Windows ...
	Windows Environment = "Windows"
)

// PossibleEnvironmentValues returns an array of possible values for the Environment const type.
func PossibleEnvironmentValues() []Environment {
	return []Environment{Linux, Windows}
}

// MoveCost enumerates the values for move cost.
type MoveCost string

const (
	// High Specifies the move cost of the service as High. The value is 3.
	High MoveCost = "High"
	// Low Specifies the move cost of the service as Low. The value is 1.
	Low MoveCost = "Low"
	// Medium Specifies the move cost of the service as Medium. The value is 2.
	Medium MoveCost = "Medium"
	// Zero Zero move cost. This value is zero.
	Zero MoveCost = "Zero"
)

// PossibleMoveCostValues returns an array of possible values for the MoveCost const type.
func PossibleMoveCostValues() []MoveCost {
	return []MoveCost{High, Low, Medium, Zero}
}

// PartitionScheme enumerates the values for partition scheme.
type PartitionScheme string

const (
	// Invalid Indicates the partition kind is invalid. All Service Fabric enumerations have the invalid type.
	// The value is zero.
	Invalid PartitionScheme = "Invalid"
	// Named Indicates that the partition is based on string names, and is a NamedPartitionSchemeDescription
	// object. The value is 3
	Named PartitionScheme = "Named"
	// Singleton Indicates that the partition is based on string names, and is a
	// SingletonPartitionSchemeDescription object, The value is 1.
	Singleton PartitionScheme = "Singleton"
	// UniformInt64Range Indicates that the partition is based on Int64 key ranges, and is a
	// UniformInt64RangePartitionSchemeDescription object. The value is 2.
	UniformInt64Range PartitionScheme = "UniformInt64Range"
)

// PossiblePartitionSchemeValues returns an array of possible values for the PartitionScheme const type.
func PossiblePartitionSchemeValues() []PartitionScheme {
	return []PartitionScheme{Invalid, Named, Singleton, UniformInt64Range}
}

// PartitionSchemeBasicPartitionSchemeDescription enumerates the values for partition scheme basic partition
// scheme description.
type PartitionSchemeBasicPartitionSchemeDescription string

const (
	// PartitionSchemeNamed ...
	PartitionSchemeNamed PartitionSchemeBasicPartitionSchemeDescription = "Named"
	// PartitionSchemePartitionSchemeDescription ...
	PartitionSchemePartitionSchemeDescription PartitionSchemeBasicPartitionSchemeDescription = "PartitionSchemeDescription"
	// PartitionSchemeSingleton ...
	PartitionSchemeSingleton PartitionSchemeBasicPartitionSchemeDescription = "Singleton"
	// PartitionSchemeUniformInt64Range ...
	PartitionSchemeUniformInt64Range PartitionSchemeBasicPartitionSchemeDescription = "UniformInt64Range"
)

// PossiblePartitionSchemeBasicPartitionSchemeDescriptionValues returns an array of possible values for the PartitionSchemeBasicPartitionSchemeDescription const type.
func PossiblePartitionSchemeBasicPartitionSchemeDescriptionValues() []PartitionSchemeBasicPartitionSchemeDescription {
	return []PartitionSchemeBasicPartitionSchemeDescription{PartitionSchemeNamed, PartitionSchemePartitionSchemeDescription, PartitionSchemeSingleton, PartitionSchemeUniformInt64Range}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Canceled ...
	Canceled ProvisioningState = "Canceled"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Canceled, Failed, Succeeded, Updating}
}

// ReliabilityLevel enumerates the values for reliability level.
type ReliabilityLevel string

const (
	// ReliabilityLevelBronze ...
	ReliabilityLevelBronze ReliabilityLevel = "Bronze"
	// ReliabilityLevelGold ...
	ReliabilityLevelGold ReliabilityLevel = "Gold"
	// ReliabilityLevelNone ...
	ReliabilityLevelNone ReliabilityLevel = "None"
	// ReliabilityLevelPlatinum ...
	ReliabilityLevelPlatinum ReliabilityLevel = "Platinum"
	// ReliabilityLevelSilver ...
	ReliabilityLevelSilver ReliabilityLevel = "Silver"
)

// PossibleReliabilityLevelValues returns an array of possible values for the ReliabilityLevel const type.
func PossibleReliabilityLevelValues() []ReliabilityLevel {
	return []ReliabilityLevel{ReliabilityLevelBronze, ReliabilityLevelGold, ReliabilityLevelNone, ReliabilityLevelPlatinum, ReliabilityLevelSilver}
}

// ReliabilityLevel1 enumerates the values for reliability level 1.
type ReliabilityLevel1 string

const (
	// ReliabilityLevel1Bronze ...
	ReliabilityLevel1Bronze ReliabilityLevel1 = "Bronze"
	// ReliabilityLevel1Gold ...
	ReliabilityLevel1Gold ReliabilityLevel1 = "Gold"
	// ReliabilityLevel1None ...
	ReliabilityLevel1None ReliabilityLevel1 = "None"
	// ReliabilityLevel1Platinum ...
	ReliabilityLevel1Platinum ReliabilityLevel1 = "Platinum"
	// ReliabilityLevel1Silver ...
	ReliabilityLevel1Silver ReliabilityLevel1 = "Silver"
)

// PossibleReliabilityLevel1Values returns an array of possible values for the ReliabilityLevel1 const type.
func PossibleReliabilityLevel1Values() []ReliabilityLevel1 {
	return []ReliabilityLevel1{ReliabilityLevel1Bronze, ReliabilityLevel1Gold, ReliabilityLevel1None, ReliabilityLevel1Platinum, ReliabilityLevel1Silver}
}

// ServiceCorrelationScheme enumerates the values for service correlation scheme.
type ServiceCorrelationScheme string

const (
	// ServiceCorrelationSchemeAffinity Indicates that this service has an affinity relationship with another
	// service. Provided for backwards compatibility, consider preferring the Aligned or NonAlignedAffinity
	// options. The value is 1.
	ServiceCorrelationSchemeAffinity ServiceCorrelationScheme = "Affinity"
	// ServiceCorrelationSchemeAlignedAffinity Aligned affinity ensures that the primaries of the partitions of
	// the affinitized services are collocated on the same nodes. This is the default and is the same as
	// selecting the Affinity scheme. The value is 2.
	ServiceCorrelationSchemeAlignedAffinity ServiceCorrelationScheme = "AlignedAffinity"
	// ServiceCorrelationSchemeInvalid An invalid correlation scheme. Cannot be used. The value is zero.
	ServiceCorrelationSchemeInvalid ServiceCorrelationScheme = "Invalid"
	// ServiceCorrelationSchemeNonAlignedAffinity Non-Aligned affinity guarantees that all replicas of each
	// service will be placed on the same nodes. Unlike Aligned Affinity, this does not guarantee that replicas
	// of particular role will be collocated. The value is 3.
	ServiceCorrelationSchemeNonAlignedAffinity ServiceCorrelationScheme = "NonAlignedAffinity"
)

// PossibleServiceCorrelationSchemeValues returns an array of possible values for the ServiceCorrelationScheme const type.
func PossibleServiceCorrelationSchemeValues() []ServiceCorrelationScheme {
	return []ServiceCorrelationScheme{ServiceCorrelationSchemeAffinity, ServiceCorrelationSchemeAlignedAffinity, ServiceCorrelationSchemeInvalid, ServiceCorrelationSchemeNonAlignedAffinity}
}

// ServiceKind enumerates the values for service kind.
type ServiceKind string

const (
	// ServiceKindInvalid Indicates the service kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	ServiceKindInvalid ServiceKind = "Invalid"
	// ServiceKindStateful Uses Service Fabric to make its state or part of its state highly available and
	// reliable. The value is 2.
	ServiceKindStateful ServiceKind = "Stateful"
	// ServiceKindStateless Does not use Service Fabric to make its state highly available or reliable. The
	// value is 1.
	ServiceKindStateless ServiceKind = "Stateless"
)

// PossibleServiceKindValues returns an array of possible values for the ServiceKind const type.
func PossibleServiceKindValues() []ServiceKind {
	return []ServiceKind{ServiceKindInvalid, ServiceKindStateful, ServiceKindStateless}
}

// ServiceKindBasicServiceResourceProperties enumerates the values for service kind basic service resource
// properties.
type ServiceKindBasicServiceResourceProperties string

const (
	// ServiceKindServiceResourceProperties ...
	ServiceKindServiceResourceProperties ServiceKindBasicServiceResourceProperties = "ServiceResourceProperties"
	// ServiceKindStateful1 ...
	ServiceKindStateful1 ServiceKindBasicServiceResourceProperties = "Stateful"
	// ServiceKindStateless1 ...
	ServiceKindStateless1 ServiceKindBasicServiceResourceProperties = "Stateless"
)

// PossibleServiceKindBasicServiceResourcePropertiesValues returns an array of possible values for the ServiceKindBasicServiceResourceProperties const type.
func PossibleServiceKindBasicServiceResourcePropertiesValues() []ServiceKindBasicServiceResourceProperties {
	return []ServiceKindBasicServiceResourceProperties{ServiceKindServiceResourceProperties, ServiceKindStateful1, ServiceKindStateless1}
}

// ServiceKindBasicServiceResourceUpdateProperties enumerates the values for service kind basic service
// resource update properties.
type ServiceKindBasicServiceResourceUpdateProperties string

const (
	// ServiceKindBasicServiceResourceUpdatePropertiesServiceKindServiceResourceUpdateProperties ...
	ServiceKindBasicServiceResourceUpdatePropertiesServiceKindServiceResourceUpdateProperties ServiceKindBasicServiceResourceUpdateProperties = "ServiceResourceUpdateProperties"
	// ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateful ...
	ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateful ServiceKindBasicServiceResourceUpdateProperties = "Stateful"
	// ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateless ...
	ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateless ServiceKindBasicServiceResourceUpdateProperties = "Stateless"
)

// PossibleServiceKindBasicServiceResourceUpdatePropertiesValues returns an array of possible values for the ServiceKindBasicServiceResourceUpdateProperties const type.
func PossibleServiceKindBasicServiceResourceUpdatePropertiesValues() []ServiceKindBasicServiceResourceUpdateProperties {
	return []ServiceKindBasicServiceResourceUpdateProperties{ServiceKindBasicServiceResourceUpdatePropertiesServiceKindServiceResourceUpdateProperties, ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateful, ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateless}
}

// ServiceLoadMetricWeight enumerates the values for service load metric weight.
type ServiceLoadMetricWeight string

const (
	// ServiceLoadMetricWeightHigh Specifies the metric weight of the service load as High. The value is 3.
	ServiceLoadMetricWeightHigh ServiceLoadMetricWeight = "High"
	// ServiceLoadMetricWeightLow Specifies the metric weight of the service load as Low. The value is 1.
	ServiceLoadMetricWeightLow ServiceLoadMetricWeight = "Low"
	// ServiceLoadMetricWeightMedium Specifies the metric weight of the service load as Medium. The value is 2.
	ServiceLoadMetricWeightMedium ServiceLoadMetricWeight = "Medium"
	// ServiceLoadMetricWeightZero Disables resource balancing for this metric. This value is zero.
	ServiceLoadMetricWeightZero ServiceLoadMetricWeight = "Zero"
)

// PossibleServiceLoadMetricWeightValues returns an array of possible values for the ServiceLoadMetricWeight const type.
func PossibleServiceLoadMetricWeightValues() []ServiceLoadMetricWeight {
	return []ServiceLoadMetricWeight{ServiceLoadMetricWeightHigh, ServiceLoadMetricWeightLow, ServiceLoadMetricWeightMedium, ServiceLoadMetricWeightZero}
}

// ServicePlacementPolicyType enumerates the values for service placement policy type.
type ServicePlacementPolicyType string

const (
	// ServicePlacementPolicyTypeInvalid Indicates the type of the placement policy is invalid. All Service
	// Fabric enumerations have the invalid type. The value is zero.
	ServicePlacementPolicyTypeInvalid ServicePlacementPolicyType = "Invalid"
	// ServicePlacementPolicyTypeInvalidDomain Indicates that the ServicePlacementPolicyDescription is of type
	// ServicePlacementInvalidDomainPolicyDescription, which indicates that a particular fault or upgrade
	// domain cannot be used for placement of this service. The value is 1.
	ServicePlacementPolicyTypeInvalidDomain ServicePlacementPolicyType = "InvalidDomain"
	// ServicePlacementPolicyTypeNonPartiallyPlaceService Indicates that the ServicePlacementPolicyDescription
	// is of type ServicePlacementNonPartiallyPlaceServicePolicyDescription, which indicates that if possible
	// all replicas of a particular partition of the service should be placed atomically. The value is 5.
	ServicePlacementPolicyTypeNonPartiallyPlaceService ServicePlacementPolicyType = "NonPartiallyPlaceService"
	// ServicePlacementPolicyTypePreferredPrimaryDomain Indicates that the ServicePlacementPolicyDescription is
	// of type ServicePlacementPreferPrimaryDomainPolicyDescription, which indicates that if possible the
	// Primary replica for the partitions of the service should be located in a particular domain as an
	// optimization. The value is 3.
	ServicePlacementPolicyTypePreferredPrimaryDomain ServicePlacementPolicyType = "PreferredPrimaryDomain"
	// ServicePlacementPolicyTypeRequiredDomain Indicates that the ServicePlacementPolicyDescription is of type
	// ServicePlacementRequireDomainDistributionPolicyDescription indicating that the replicas of the service
	// must be placed in a specific domain. The value is 2.
	ServicePlacementPolicyTypeRequiredDomain ServicePlacementPolicyType = "RequiredDomain"
	// ServicePlacementPolicyTypeRequiredDomainDistribution Indicates that the
	// ServicePlacementPolicyDescription is of type ServicePlacementRequireDomainDistributionPolicyDescription,
	// indicating that the system will disallow placement of any two replicas from the same partition in the
	// same domain at any time. The value is 4.
	ServicePlacementPolicyTypeRequiredDomainDistribution ServicePlacementPolicyType = "RequiredDomainDistribution"
)

// PossibleServicePlacementPolicyTypeValues returns an array of possible values for the ServicePlacementPolicyType const type.
func PossibleServicePlacementPolicyTypeValues() []ServicePlacementPolicyType {
	return []ServicePlacementPolicyType{ServicePlacementPolicyTypeInvalid, ServicePlacementPolicyTypeInvalidDomain, ServicePlacementPolicyTypeNonPartiallyPlaceService, ServicePlacementPolicyTypePreferredPrimaryDomain, ServicePlacementPolicyTypeRequiredDomain, ServicePlacementPolicyTypeRequiredDomainDistribution}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeServicePlacementPolicyDescription ...
	TypeServicePlacementPolicyDescription Type = "ServicePlacementPolicyDescription"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeServicePlacementPolicyDescription}
}

// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// UpgradeModeAutomatic ...
	UpgradeModeAutomatic UpgradeMode = "Automatic"
	// UpgradeModeManual ...
	UpgradeModeManual UpgradeMode = "Manual"
)

// PossibleUpgradeModeValues returns an array of possible values for the UpgradeMode const type.
func PossibleUpgradeModeValues() []UpgradeMode {
	return []UpgradeMode{UpgradeModeAutomatic, UpgradeModeManual}
}

// UpgradeMode1 enumerates the values for upgrade mode 1.
type UpgradeMode1 string

const (
	// UpgradeMode1Automatic ...
	UpgradeMode1Automatic UpgradeMode1 = "Automatic"
	// UpgradeMode1Manual ...
	UpgradeMode1Manual UpgradeMode1 = "Manual"
)

// PossibleUpgradeMode1Values returns an array of possible values for the UpgradeMode1 const type.
func PossibleUpgradeMode1Values() []UpgradeMode1 {
	return []UpgradeMode1{UpgradeMode1Automatic, UpgradeMode1Manual}
}

// X509StoreName enumerates the values for x509 store name.
type X509StoreName string

const (
	// AddressBook ...
	AddressBook X509StoreName = "AddressBook"
	// AuthRoot ...
	AuthRoot X509StoreName = "AuthRoot"
	// CertificateAuthority ...
	CertificateAuthority X509StoreName = "CertificateAuthority"
	// Disallowed ...
	Disallowed X509StoreName = "Disallowed"
	// My ...
	My X509StoreName = "My"
	// Root ...
	Root X509StoreName = "Root"
	// TrustedPeople ...
	TrustedPeople X509StoreName = "TrustedPeople"
	// TrustedPublisher ...
	TrustedPublisher X509StoreName = "TrustedPublisher"
)

// PossibleX509StoreNameValues returns an array of possible values for the X509StoreName const type.
func PossibleX509StoreNameValues() []X509StoreName {
	return []X509StoreName{AddressBook, AuthRoot, CertificateAuthority, Disallowed, My, Root, TrustedPeople, TrustedPublisher}
}

// X509StoreName1 enumerates the values for x509 store name 1.
type X509StoreName1 string

const (
	// X509StoreName1AddressBook ...
	X509StoreName1AddressBook X509StoreName1 = "AddressBook"
	// X509StoreName1AuthRoot ...
	X509StoreName1AuthRoot X509StoreName1 = "AuthRoot"
	// X509StoreName1CertificateAuthority ...
	X509StoreName1CertificateAuthority X509StoreName1 = "CertificateAuthority"
	// X509StoreName1Disallowed ...
	X509StoreName1Disallowed X509StoreName1 = "Disallowed"
	// X509StoreName1My ...
	X509StoreName1My X509StoreName1 = "My"
	// X509StoreName1Root ...
	X509StoreName1Root X509StoreName1 = "Root"
	// X509StoreName1TrustedPeople ...
	X509StoreName1TrustedPeople X509StoreName1 = "TrustedPeople"
	// X509StoreName1TrustedPublisher ...
	X509StoreName1TrustedPublisher X509StoreName1 = "TrustedPublisher"
)

// PossibleX509StoreName1Values returns an array of possible values for the X509StoreName1 const type.
func PossibleX509StoreName1Values() []X509StoreName1 {
	return []X509StoreName1{X509StoreName1AddressBook, X509StoreName1AuthRoot, X509StoreName1CertificateAuthority, X509StoreName1Disallowed, X509StoreName1My, X509StoreName1Root, X509StoreName1TrustedPeople, X509StoreName1TrustedPublisher}
}

// ApplicationDeltaHealthPolicy defines a delta health policy used to evaluate the health of an application
// or one of its child entities when upgrading the cluster.
type ApplicationDeltaHealthPolicy struct {
	// DefaultServiceTypeDeltaHealthPolicy - The delta health policy used by default to evaluate the health of a service type when upgrading the cluster.
	DefaultServiceTypeDeltaHealthPolicy *ServiceTypeDeltaHealthPolicy `json:"defaultServiceTypeDeltaHealthPolicy,omitempty"`
	// ServiceTypeDeltaHealthPolicies - The map with service type delta health policy per service type name. The map is empty by default.
	ServiceTypeDeltaHealthPolicies map[string]*ServiceTypeDeltaHealthPolicy `json:"serviceTypeDeltaHealthPolicies"`
}

// MarshalJSON is the custom marshaler for ApplicationDeltaHealthPolicy.
func (adhp ApplicationDeltaHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adhp.DefaultServiceTypeDeltaHealthPolicy != nil {
		objectMap["defaultServiceTypeDeltaHealthPolicy"] = adhp.DefaultServiceTypeDeltaHealthPolicy
	}
	if adhp.ServiceTypeDeltaHealthPolicies != nil {
		objectMap["serviceTypeDeltaHealthPolicies"] = adhp.ServiceTypeDeltaHealthPolicies
	}
	return json.Marshal(objectMap)
}

// ApplicationHealthPolicy defines a health policy used to evaluate the health of an application or one of
// its children entities.
type ApplicationHealthPolicy struct {
	// DefaultServiceTypeHealthPolicy - The health policy used by default to evaluate the health of a service type.
	DefaultServiceTypeHealthPolicy *ServiceTypeHealthPolicy `json:"defaultServiceTypeHealthPolicy,omitempty"`
	// ServiceTypeHealthPolicies - The map with service type health policy per service type name. The map is empty by default.
	ServiceTypeHealthPolicies map[string]*ServiceTypeHealthPolicy `json:"serviceTypeHealthPolicies"`
}

// MarshalJSON is the custom marshaler for ApplicationHealthPolicy.
func (ahp ApplicationHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ahp.DefaultServiceTypeHealthPolicy != nil {
		objectMap["defaultServiceTypeHealthPolicy"] = ahp.DefaultServiceTypeHealthPolicy
	}
	if ahp.ServiceTypeHealthPolicies != nil {
		objectMap["serviceTypeHealthPolicies"] = ahp.ServiceTypeHealthPolicies
	}
	return json.Marshal(objectMap)
}

// ApplicationMetricDescription describes capacity information for a custom resource balancing metric. This
// can be used to limit the total consumption of this metric by the services of this application.
type ApplicationMetricDescription struct {
	// Name - The name of the metric.
	Name *string `json:"name,omitempty"`
	// MaximumCapacity - The maximum node capacity for Service Fabric application.
	// This is the maximum Load for an instance of this application on a single node. Even if the capacity of node is greater than this value, Service Fabric will limit the total load of services within the application on each node to this value.
	// If set to zero, capacity for this metric is unlimited on each node.
	// When creating a new application with application capacity defined, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
	// When updating existing application with application capacity, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
	MaximumCapacity *int64 `json:"maximumCapacity,omitempty"`
	// ReservationCapacity - The node reservation capacity for Service Fabric application.
	// This is the amount of load which is reserved on nodes which have instances of this application.
	// If MinimumNodes is specified, then the product of these values will be the capacity reserved in the cluster for the application.
	// If set to zero, no capacity is reserved for this metric.
	// When setting application capacity or when updating application capacity; this value must be smaller than or equal to MaximumCapacity for each metric.
	ReservationCapacity *int64 `json:"reservationCapacity,omitempty"`
	// TotalApplicationCapacity - The total metric capacity for Service Fabric application.
	// This is the total metric capacity for this application in the cluster. Service Fabric will try to limit the sum of loads of services within the application to this value.
	// When creating a new application with application capacity defined, the product of MaximumNodes and MaximumCapacity must always be smaller than or equal to this value.
	TotalApplicationCapacity *int64 `json:"totalApplicationCapacity,omitempty"`
}

// ApplicationResource the application resource.
type ApplicationResource struct {
	autorest.Response `json:"-"`
	// ApplicationResourceProperties - The application resource properties.
	*ApplicationResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Azure resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Azure resource tags.
	Tags map[string]*string `json:"tags"`
	// Etag - READ-ONLY; Azure resource etag.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationResource.
func (ar ApplicationResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.ApplicationResourceProperties != nil {
		objectMap["properties"] = ar.ApplicationResourceProperties
	}
	if ar.Location != nil {
		objectMap["location"] = ar.Location
	}
	if ar.Tags != nil {
		objectMap["tags"] = ar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationResource struct.
func (ar *ApplicationResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationResourceProperties ApplicationResourceProperties
				err = json.Unmarshal(*v, &applicationResourceProperties)
				if err != nil {
					return err
				}
				ar.ApplicationResourceProperties = &applicationResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ar.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ar.Etag = &etag
			}
		}
	}

	return nil
}

// ApplicationResourceList the list of application resources.
type ApplicationResourceList struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of application list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationResourceProperties the application resource properties.
type ApplicationResourceProperties struct {
	// ProvisioningState - READ-ONLY; The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// TypeName - The application type name as defined in the application manifest.
	TypeName *string `json:"typeName,omitempty"`
	// TypeVersion - The version of the application type as defined in the application manifest.
	TypeVersion *string `json:"typeVersion,omitempty"`
	// Parameters - List of application parameters with overridden values from their default values specified in the application manifest.
	Parameters map[string]*string `json:"parameters"`
	// UpgradePolicy - Describes the policy for a monitored application upgrade.
	UpgradePolicy *ApplicationUpgradePolicy `json:"upgradePolicy,omitempty"`
	// MinimumNodes - The minimum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean that the services of this application will be placed on all of those nodes. If this property is set to zero, no capacity will be reserved. The value of this property cannot be more than the value of the MaximumNodes property.
	MinimumNodes *int64 `json:"minimumNodes,omitempty"`
	// MaximumNodes - The maximum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean that the services of this application will be placed on all of those nodes. By default, the value of this property is zero and it means that the services can be placed on any node.
	MaximumNodes *int64 `json:"maximumNodes,omitempty"`
	// RemoveApplicationCapacity - Remove the current application capacity settings.
	RemoveApplicationCapacity *bool `json:"removeApplicationCapacity,omitempty"`
	// Metrics - List of application capacity metric description.
	Metrics *[]ApplicationMetricDescription `json:"metrics,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationResourceProperties.
func (arp ApplicationResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arp.TypeName != nil {
		objectMap["typeName"] = arp.TypeName
	}
	if arp.TypeVersion != nil {
		objectMap["typeVersion"] = arp.TypeVersion
	}
	if arp.Parameters != nil {
		objectMap["parameters"] = arp.Parameters
	}
	if arp.UpgradePolicy != nil {
		objectMap["upgradePolicy"] = arp.UpgradePolicy
	}
	if arp.MinimumNodes != nil {
		objectMap["minimumNodes"] = arp.MinimumNodes
	}
	if arp.MaximumNodes != nil {
		objectMap["maximumNodes"] = arp.MaximumNodes
	}
	if arp.RemoveApplicationCapacity != nil {
		objectMap["removeApplicationCapacity"] = arp.RemoveApplicationCapacity
	}
	if arp.Metrics != nil {
		objectMap["metrics"] = arp.Metrics
	}
	return json.Marshal(objectMap)
}

// ApplicationResourceUpdate the application resource for patch operations.
type ApplicationResourceUpdate struct {
	// ApplicationResourceUpdateProperties - The application resource properties for patch operations.
	*ApplicationResourceUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Azure resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Azure resource tags.
	Tags map[string]*string `json:"tags"`
	// Etag - READ-ONLY; Azure resource etag.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationResourceUpdate.
func (aru ApplicationResourceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aru.ApplicationResourceUpdateProperties != nil {
		objectMap["properties"] = aru.ApplicationResourceUpdateProperties
	}
	if aru.Location != nil {
		objectMap["location"] = aru.Location
	}
	if aru.Tags != nil {
		objectMap["tags"] = aru.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationResourceUpdate struct.
func (aru *ApplicationResourceUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationResourceUpdateProperties ApplicationResourceUpdateProperties
				err = json.Unmarshal(*v, &applicationResourceUpdateProperties)
				if err != nil {
					return err
				}
				aru.ApplicationResourceUpdateProperties = &applicationResourceUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aru.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aru.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aru.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				aru.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				aru.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				aru.Etag = &etag
			}
		}
	}

	return nil
}

// ApplicationResourceUpdateProperties the application resource properties for patch operations.
type ApplicationResourceUpdateProperties struct {
	// TypeVersion - The version of the application type as defined in the application manifest.
	TypeVersion *string `json:"typeVersion,omitempty"`
	// Parameters - List of application parameters with overridden values from their default values specified in the application manifest.
	Parameters map[string]*string `json:"parameters"`
	// UpgradePolicy - Describes the policy for a monitored application upgrade.
	UpgradePolicy *ApplicationUpgradePolicy `json:"upgradePolicy,omitempty"`
	// MinimumNodes - The minimum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean that the services of this application will be placed on all of those nodes. If this property is set to zero, no capacity will be reserved. The value of this property cannot be more than the value of the MaximumNodes property.
	MinimumNodes *int64 `json:"minimumNodes,omitempty"`
	// MaximumNodes - The maximum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean that the services of this application will be placed on all of those nodes. By default, the value of this property is zero and it means that the services can be placed on any node.
	MaximumNodes *int64 `json:"maximumNodes,omitempty"`
	// RemoveApplicationCapacity - Remove the current application capacity settings.
	RemoveApplicationCapacity *bool `json:"removeApplicationCapacity,omitempty"`
	// Metrics - List of application capacity metric description.
	Metrics *[]ApplicationMetricDescription `json:"metrics,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationResourceUpdateProperties.
func (arup ApplicationResourceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arup.TypeVersion != nil {
		objectMap["typeVersion"] = arup.TypeVersion
	}
	if arup.Parameters != nil {
		objectMap["parameters"] = arup.Parameters
	}
	if arup.UpgradePolicy != nil {
		objectMap["upgradePolicy"] = arup.UpgradePolicy
	}
	if arup.MinimumNodes != nil {
		objectMap["minimumNodes"] = arup.MinimumNodes
	}
	if arup.MaximumNodes != nil {
		objectMap["maximumNodes"] = arup.MaximumNodes
	}
	if arup.RemoveApplicationCapacity != nil {
		objectMap["removeApplicationCapacity"] = arup.RemoveApplicationCapacity
	}
	if arup.Metrics != nil {
		objectMap["metrics"] = arup.Metrics
	}
	return json.Marshal(objectMap)
}

// ApplicationsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationsCreateFuture) Result(client ApplicationsClient) (ar ApplicationResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ApplicationsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ar.Response.Response, err = future.GetResult(sender); err == nil && ar.Response.Response.StatusCode != http.StatusNoContent {
		ar, err = client.CreateResponder(ar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ApplicationsCreateFuture", "Result", ar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationsDeleteFuture) Result(client ApplicationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ApplicationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationsUpdateFuture) Result(client ApplicationsClient) (ar ApplicationResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ApplicationsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ar.Response.Response, err = future.GetResult(sender); err == nil && ar.Response.Response.StatusCode != http.StatusNoContent {
		ar, err = client.UpdateResponder(ar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ApplicationsUpdateFuture", "Result", ar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationTypeResource the application type name resource
type ApplicationTypeResource struct {
	autorest.Response `json:"-"`
	// ApplicationTypeResourceProperties - The application type name properties
	*ApplicationTypeResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Azure resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Azure resource tags.
	Tags map[string]*string `json:"tags"`
	// Etag - READ-ONLY; Azure resource etag.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationTypeResource.
func (atr ApplicationTypeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atr.ApplicationTypeResourceProperties != nil {
		objectMap["properties"] = atr.ApplicationTypeResourceProperties
	}
	if atr.Location != nil {
		objectMap["location"] = atr.Location
	}
	if atr.Tags != nil {
		objectMap["tags"] = atr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationTypeResource struct.
func (atr *ApplicationTypeResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationTypeResourceProperties ApplicationTypeResourceProperties
				err = json.Unmarshal(*v, &applicationTypeResourceProperties)
				if err != nil {
					return err
				}
				atr.ApplicationTypeResourceProperties = &applicationTypeResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				atr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				atr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				atr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				atr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				atr.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				atr.Etag = &etag
			}
		}
	}

	return nil
}

// ApplicationTypeResourceList the list of application type names.
type ApplicationTypeResourceList struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationTypeResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of application type list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationTypeResourceProperties the application type name properties
type ApplicationTypeResourceProperties struct {
	// ProvisioningState - READ-ONLY; The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationTypesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationTypesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationTypesDeleteFuture) Result(client ApplicationTypesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationTypesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ApplicationTypesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationTypeVersionResource an application type version resource for the specified application type
// name resource.
type ApplicationTypeVersionResource struct {
	autorest.Response `json:"-"`
	// ApplicationTypeVersionResourceProperties - The properties of the application type version resource.
	*ApplicationTypeVersionResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Azure resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Azure resource tags.
	Tags map[string]*string `json:"tags"`
	// Etag - READ-ONLY; Azure resource etag.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationTypeVersionResource.
func (atvr ApplicationTypeVersionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atvr.ApplicationTypeVersionResourceProperties != nil {
		objectMap["properties"] = atvr.ApplicationTypeVersionResourceProperties
	}
	if atvr.Location != nil {
		objectMap["location"] = atvr.Location
	}
	if atvr.Tags != nil {
		objectMap["tags"] = atvr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationTypeVersionResource struct.
func (atvr *ApplicationTypeVersionResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationTypeVersionResourceProperties ApplicationTypeVersionResourceProperties
				err = json.Unmarshal(*v, &applicationTypeVersionResourceProperties)
				if err != nil {
					return err
				}
				atvr.ApplicationTypeVersionResourceProperties = &applicationTypeVersionResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				atvr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				atvr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				atvr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				atvr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				atvr.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				atvr.Etag = &etag
			}
		}
	}

	return nil
}

// ApplicationTypeVersionResourceList the list of application type version resources for the specified
// application type name resource.
type ApplicationTypeVersionResourceList struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationTypeVersionResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of application type version list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationTypeVersionResourceProperties the properties of the application type version resource.
type ApplicationTypeVersionResourceProperties struct {
	// ProvisioningState - READ-ONLY; The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// AppPackageURL - The URL to the application package
	AppPackageURL *string `json:"appPackageUrl,omitempty"`
	// DefaultParameterList - READ-ONLY; List of application type parameters that can be overridden when creating or updating the application.
	DefaultParameterList map[string]*string `json:"defaultParameterList"`
}

// MarshalJSON is the custom marshaler for ApplicationTypeVersionResourceProperties.
func (atvrp ApplicationTypeVersionResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atvrp.AppPackageURL != nil {
		objectMap["appPackageUrl"] = atvrp.AppPackageURL
	}
	return json.Marshal(objectMap)
}

// ApplicationTypeVersionsCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationTypeVersionsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationTypeVersionsCreateFuture) Result(client ApplicationTypeVersionsClient) (atvr ApplicationTypeVersionResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationTypeVersionsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ApplicationTypeVersionsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if atvr.Response.Response, err = future.GetResult(sender); err == nil && atvr.Response.Response.StatusCode != http.StatusNoContent {
		atvr, err = client.CreateResponder(atvr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ApplicationTypeVersionsCreateFuture", "Result", atvr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationTypeVersionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationTypeVersionsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationTypeVersionsDeleteFuture) Result(client ApplicationTypeVersionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationTypeVersionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ApplicationTypeVersionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationUpgradePolicy describes the policy for a monitored application upgrade.
type ApplicationUpgradePolicy struct {
	// UpgradeReplicaSetCheckTimeout - The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
	UpgradeReplicaSetCheckTimeout *string `json:"upgradeReplicaSetCheckTimeout,omitempty"`
	// ForceRestart - If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
	ForceRestart *bool `json:"forceRestart,omitempty"`
	// RollingUpgradeMonitoringPolicy - The policy used for monitoring the application upgrade
	RollingUpgradeMonitoringPolicy *ArmRollingUpgradeMonitoringPolicy `json:"rollingUpgradeMonitoringPolicy,omitempty"`
	// ApplicationHealthPolicy - Defines a health policy used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicy *ArmApplicationHealthPolicy `json:"applicationHealthPolicy,omitempty"`
}

// ArmApplicationHealthPolicy defines a health policy used to evaluate the health of an application or one
// of its children entities.
type ArmApplicationHealthPolicy struct {
	// ConsiderWarningAsError - Indicates whether warnings are treated with the same severity as errors.
	ConsiderWarningAsError *bool `json:"considerWarningAsError,omitempty"`
	// MaxPercentUnhealthyDeployedApplications - The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
	// The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
	// This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
	// The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
	MaxPercentUnhealthyDeployedApplications *int32 `json:"maxPercentUnhealthyDeployedApplications,omitempty"`
	// DefaultServiceTypeHealthPolicy - The health policy used by default to evaluate the health of a service type.
	DefaultServiceTypeHealthPolicy *ArmServiceTypeHealthPolicy `json:"defaultServiceTypeHealthPolicy,omitempty"`
	// ServiceTypeHealthPolicyMap - The map with service type health policy per service type name. The map is empty by default.
	ServiceTypeHealthPolicyMap map[string]*ArmServiceTypeHealthPolicy `json:"serviceTypeHealthPolicyMap"`
}

// MarshalJSON is the custom marshaler for ArmApplicationHealthPolicy.
func (aahp ArmApplicationHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aahp.ConsiderWarningAsError != nil {
		objectMap["considerWarningAsError"] = aahp.ConsiderWarningAsError
	}
	if aahp.MaxPercentUnhealthyDeployedApplications != nil {
		objectMap["maxPercentUnhealthyDeployedApplications"] = aahp.MaxPercentUnhealthyDeployedApplications
	}
	if aahp.DefaultServiceTypeHealthPolicy != nil {
		objectMap["defaultServiceTypeHealthPolicy"] = aahp.DefaultServiceTypeHealthPolicy
	}
	if aahp.ServiceTypeHealthPolicyMap != nil {
		objectMap["serviceTypeHealthPolicyMap"] = aahp.ServiceTypeHealthPolicyMap
	}
	return json.Marshal(objectMap)
}

// ArmRollingUpgradeMonitoringPolicy the policy used for monitoring the application upgrade
type ArmRollingUpgradeMonitoringPolicy struct {
	// FailureAction - The activation Mode of the service package. Possible values include: 'Rollback', 'Manual'
	FailureAction ArmUpgradeFailureAction `json:"failureAction,omitempty"`
	// HealthCheckWaitDuration - The amount of time to wait after completing an upgrade domain before applying health policies. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	HealthCheckWaitDuration *string `json:"healthCheckWaitDuration,omitempty"`
	// HealthCheckStableDuration - The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	HealthCheckStableDuration *string `json:"healthCheckStableDuration,omitempty"`
	// HealthCheckRetryTimeout - The amount of time to retry health evaluation when the application or cluster is unhealthy before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	HealthCheckRetryTimeout *string `json:"healthCheckRetryTimeout,omitempty"`
	// UpgradeTimeout - The amount of time the overall upgrade has to complete before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	UpgradeTimeout *string `json:"upgradeTimeout,omitempty"`
	// UpgradeDomainTimeout - The amount of time each upgrade domain has to complete before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	UpgradeDomainTimeout *string `json:"upgradeDomainTimeout,omitempty"`
}

// ArmServiceTypeHealthPolicy represents the health policy used to evaluate the health of services
// belonging to a service type.
type ArmServiceTypeHealthPolicy struct {
	// MaxPercentUnhealthyServices - The maximum percentage of services allowed to be unhealthy before your application is considered in error.
	MaxPercentUnhealthyServices *int32 `json:"maxPercentUnhealthyServices,omitempty"`
	// MaxPercentUnhealthyPartitionsPerService - The maximum percentage of partitions per service allowed to be unhealthy before your application is considered in error.
	MaxPercentUnhealthyPartitionsPerService *int32 `json:"maxPercentUnhealthyPartitionsPerService,omitempty"`
	// MaxPercentUnhealthyReplicasPerPartition - The maximum percentage of replicas per partition allowed to be unhealthy before your application is considered in error.
	MaxPercentUnhealthyReplicasPerPartition *int32 `json:"maxPercentUnhealthyReplicasPerPartition,omitempty"`
}

// AvailableOperationDisplay operation supported by the Service Fabric resource provider
type AvailableOperationDisplay struct {
	// Provider - The name of the provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation that can be performed.
	Operation *string `json:"operation,omitempty"`
	// Description - Operation description
	Description *string `json:"description,omitempty"`
}

// AzureActiveDirectory the settings to enable AAD authentication on the cluster.
type AzureActiveDirectory struct {
	// TenantID - Azure active directory tenant id.
	TenantID *string `json:"tenantId,omitempty"`
	// ClusterApplication - Azure active directory cluster application id.
	ClusterApplication *string `json:"clusterApplication,omitempty"`
	// ClientApplication - Azure active directory client application id.
	ClientApplication *string `json:"clientApplication,omitempty"`
}

// CertificateDescription describes the certificate details.
type CertificateDescription struct {
	// Thumbprint - Thumbprint of the primary certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ThumbprintSecondary - Thumbprint of the secondary certificate.
	ThumbprintSecondary *string `json:"thumbprintSecondary,omitempty"`
	// X509StoreName - The local certificate store location. Possible values include: 'AddressBook', 'AuthRoot', 'CertificateAuthority', 'Disallowed', 'My', 'Root', 'TrustedPeople', 'TrustedPublisher'
	X509StoreName X509StoreName `json:"x509StoreName,omitempty"`
}

// ClientCertificateCommonName describes the client certificate details using common name.
type ClientCertificateCommonName struct {
	// IsAdmin - Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
	IsAdmin *bool `json:"isAdmin,omitempty"`
	// CertificateCommonName - The common name of the client certificate.
	CertificateCommonName *string `json:"certificateCommonName,omitempty"`
	// CertificateIssuerThumbprint - The issuer thumbprint of the client certificate.
	CertificateIssuerThumbprint *string `json:"certificateIssuerThumbprint,omitempty"`
}

// ClientCertificateThumbprint describes the client certificate details using thumbprint.
type ClientCertificateThumbprint struct {
	// IsAdmin - Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
	IsAdmin *bool `json:"isAdmin,omitempty"`
	// CertificateThumbprint - The thumbprint of the client certificate.
	CertificateThumbprint *string `json:"certificateThumbprint,omitempty"`
}

// Cluster the cluster resource
type Cluster struct {
	autorest.Response `json:"-"`
	// ClusterProperties - The cluster resource properties
	*ClusterProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Azure resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Azure resource tags.
	Tags map[string]*string `json:"tags"`
	// Etag - READ-ONLY; Azure resource etag.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				c.Etag = &etag
			}
		}
	}

	return nil
}

// ClusterCodeVersionsListResult the list results of the Service Fabric runtime versions.
type ClusterCodeVersionsListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ClusterCodeVersionsResult `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterCodeVersionsResult the result of the Service Fabric runtime versions
type ClusterCodeVersionsResult struct {
	// ID - The identification of the result
	ID *string `json:"id,omitempty"`
	// Name - The name of the result
	Name *string `json:"name,omitempty"`
	// Type - The result resource type
	Type *string `json:"type,omitempty"`
	// ClusterVersionDetails - The detail of the Service Fabric runtime version result
	*ClusterVersionDetails `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterCodeVersionsResult.
func (ccvr ClusterCodeVersionsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccvr.ID != nil {
		objectMap["id"] = ccvr.ID
	}
	if ccvr.Name != nil {
		objectMap["name"] = ccvr.Name
	}
	if ccvr.Type != nil {
		objectMap["type"] = ccvr.Type
	}
	if ccvr.ClusterVersionDetails != nil {
		objectMap["properties"] = ccvr.ClusterVersionDetails
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterCodeVersionsResult struct.
func (ccvr *ClusterCodeVersionsResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ccvr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ccvr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ccvr.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var clusterVersionDetails ClusterVersionDetails
				err = json.Unmarshal(*v, &clusterVersionDetails)
				if err != nil {
					return err
				}
				ccvr.ClusterVersionDetails = &clusterVersionDetails
			}
		}
	}

	return nil
}

// ClusterHealthPolicy defines a health policy used to evaluate the health of the cluster or of a cluster
// node.
type ClusterHealthPolicy struct {
	// MaxPercentUnhealthyNodes - The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.
	// The percentage represents the maximum tolerated percentage of nodes that can be unhealthy before the cluster is considered in error.
	// If the percentage is respected but there is at least one unhealthy node, the health is evaluated as Warning.
	// The percentage is calculated by dividing the number of unhealthy nodes over the total number of nodes in the cluster.
	// The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
	// In large clusters, some nodes will always be down or out for repairs, so this percentage should be configured to tolerate that.
	MaxPercentUnhealthyNodes *int32 `json:"maxPercentUnhealthyNodes,omitempty"`
	// MaxPercentUnhealthyApplications - The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10.
	// The percentage represents the maximum tolerated percentage of applications that can be unhealthy before the cluster is considered in error.
	// If the percentage is respected but there is at least one unhealthy application, the health is evaluated as Warning.
	// This is calculated by dividing the number of unhealthy applications over the total number of application instances in the cluster, excluding applications of application types that are included in the ApplicationTypeHealthPolicyMap.
	// The computation rounds up to tolerate one failure on small numbers of applications. Default percentage is zero.
	MaxPercentUnhealthyApplications *int32 `json:"maxPercentUnhealthyApplications,omitempty"`
	// ApplicationHealthPolicies - Defines the application health policy map used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicies map[string]*ApplicationHealthPolicy `json:"applicationHealthPolicies"`
}

// MarshalJSON is the custom marshaler for ClusterHealthPolicy.
func (chp ClusterHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if chp.MaxPercentUnhealthyNodes != nil {
		objectMap["maxPercentUnhealthyNodes"] = chp.MaxPercentUnhealthyNodes
	}
	if chp.MaxPercentUnhealthyApplications != nil {
		objectMap["maxPercentUnhealthyApplications"] = chp.MaxPercentUnhealthyApplications
	}
	if chp.ApplicationHealthPolicies != nil {
		objectMap["applicationHealthPolicies"] = chp.ApplicationHealthPolicies
	}
	return json.Marshal(objectMap)
}

// ClusterListResult cluster list results
type ClusterListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Cluster `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterProperties describes the cluster resource properties.
type ClusterProperties struct {
	// AddOnFeatures - The list of add-on features to enable in the cluster.
	AddOnFeatures *[]string `json:"addOnFeatures,omitempty"`
	// AvailableClusterVersions - READ-ONLY; The Service Fabric runtime versions available for this cluster.
	AvailableClusterVersions *[]ClusterVersionDetails `json:"availableClusterVersions,omitempty"`
	// AzureActiveDirectory - The AAD authentication settings of the cluster.
	AzureActiveDirectory *AzureActiveDirectory `json:"azureActiveDirectory,omitempty"`
	// Certificate - The certificate to use for securing the cluster. The certificate provided will be used for node to node security within the cluster, SSL certificate for cluster management endpoint and default admin client.
	Certificate *CertificateDescription `json:"certificate,omitempty"`
	// CertificateCommonNames - Describes a list of server certificates referenced by common name that are used to secure the cluster.
	CertificateCommonNames *ServerCertificateCommonNames `json:"certificateCommonNames,omitempty"`
	// ClientCertificateCommonNames - The list of client certificates referenced by common name that are allowed to manage the cluster.
	ClientCertificateCommonNames *[]ClientCertificateCommonName `json:"clientCertificateCommonNames,omitempty"`
	// ClientCertificateThumbprints - The list of client certificates referenced by thumbprint that are allowed to manage the cluster.
	ClientCertificateThumbprints *[]ClientCertificateThumbprint `json:"clientCertificateThumbprints,omitempty"`
	// ClusterCodeVersion - The Service Fabric runtime version of the cluster. This property can only by set the user when **upgradeMode** is set to 'Manual'. To get list of available Service Fabric versions for new clusters use [ClusterVersion API](./ClusterVersion.md). To get the list of available version for existing clusters use **availableClusterVersions**.
	ClusterCodeVersion *string `json:"clusterCodeVersion,omitempty"`
	// ClusterEndpoint - READ-ONLY; The Azure Resource Provider endpoint. A system service in the cluster connects to this  endpoint.
	ClusterEndpoint *string `json:"clusterEndpoint,omitempty"`
	// ClusterID - READ-ONLY; A service generated unique identifier for the cluster resource.
	ClusterID *string `json:"clusterId,omitempty"`
	// ClusterState - READ-ONLY; The current state of the cluster.
	//   - WaitingForNodes - Indicates that the cluster resource is created and the resource provider is waiting for Service Fabric VM extension to boot up and report to it.
	//   - Deploying - Indicates that the Service Fabric runtime is being installed on the VMs. Cluster resource will be in this state until the cluster boots up and system services are up.
	//   - BaselineUpgrade - Indicates that the cluster is upgrading to establishes the cluster version. This upgrade is automatically initiated when the cluster boots up for the first time.
	//   - UpdatingUserConfiguration - Indicates that the cluster is being upgraded with the user provided configuration.
	//   - UpdatingUserCertificate - Indicates that the cluster is being upgraded with the user provided certificate.
	//   - UpdatingInfrastructure - Indicates that the cluster is being upgraded with the latest Service Fabric runtime version. This happens only when the **upgradeMode** is set to 'Automatic'.
	//   - EnforcingClusterVersion - Indicates that cluster is on a different version than expected and the cluster is being upgraded to the expected version.
	//   - UpgradeServiceUnreachable - Indicates that the system service in the cluster is no longer polling the Resource Provider. Clusters in this state cannot be managed by the Resource Provider.
	//   - AutoScale - Indicates that the ReliabilityLevel of the cluster is being adjusted.
	//   - Ready - Indicates that the cluster is in a stable state.
	// . Possible values include: 'WaitingForNodes', 'Deploying', 'BaselineUpgrade', 'UpdatingUserConfiguration', 'UpdatingUserCertificate', 'UpdatingInfrastructure', 'EnforcingClusterVersion', 'UpgradeServiceUnreachable', 'AutoScale', 'Ready'
	ClusterState ClusterState `json:"clusterState,omitempty"`
	// DiagnosticsStorageAccountConfig - The storage account information for storing Service Fabric diagnostic logs.
	DiagnosticsStorageAccountConfig *DiagnosticsStorageAccountConfig `json:"diagnosticsStorageAccountConfig,omitempty"`
	// EventStoreServiceEnabled - Indicates if the event store service is enabled.
	EventStoreServiceEnabled *bool `json:"eventStoreServiceEnabled,omitempty"`
	// FabricSettings - The list of custom fabric settings to configure the cluster.
	FabricSettings *[]SettingsSectionDescription `json:"fabricSettings,omitempty"`
	// ManagementEndpoint - The http management endpoint of the cluster.
	ManagementEndpoint *string `json:"managementEndpoint,omitempty"`
	// NodeTypes - The list of node types in the cluster.
	NodeTypes *[]NodeTypeDescription `json:"nodeTypes,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the cluster resource. Possible values include: 'Updating', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ReliabilityLevel - The reliability level sets the replica set size of system services. Learn about [ReliabilityLevel](https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity).
	//   - None - Run the System services with a target replica set count of 1. This should only be used for test clusters.
	//   - Bronze - Run the System services with a target replica set count of 3. This should only be used for test clusters.
	//   - Silver - Run the System services with a target replica set count of 5.
	//   - Gold - Run the System services with a target replica set count of 7.
	//   - Platinum - Run the System services with a target replica set count of 9.
	// . Possible values include: 'ReliabilityLevelNone', 'ReliabilityLevelBronze', 'ReliabilityLevelSilver', 'ReliabilityLevelGold', 'ReliabilityLevelPlatinum'
	ReliabilityLevel ReliabilityLevel `json:"reliabilityLevel,omitempty"`
	// ReverseProxyCertificate - The server certificate used by reverse proxy.
	ReverseProxyCertificate *CertificateDescription `json:"reverseProxyCertificate,omitempty"`
	// ReverseProxyCertificateCommonNames - Describes a list of server certificates referenced by common name that are used to secure the cluster.
	ReverseProxyCertificateCommonNames *ServerCertificateCommonNames `json:"reverseProxyCertificateCommonNames,omitempty"`
	// UpgradeDescription - The policy to use when upgrading the cluster.
	UpgradeDescription *ClusterUpgradePolicy `json:"upgradeDescription,omitempty"`
	// UpgradeMode - The upgrade mode of the cluster when new Service Fabric runtime version is available.
	//   - Automatic - The cluster will be automatically upgraded to the latest Service Fabric runtime version as soon as it is available.
	//   - Manual - The cluster will not be automatically upgraded to the latest Service Fabric runtime version. The cluster is upgraded by setting the **clusterCodeVersion** property in the cluster resource.
	// . Possible values include: 'UpgradeModeAutomatic', 'UpgradeModeManual'
	UpgradeMode UpgradeMode `json:"upgradeMode,omitempty"`
	// VMImage - The VM image VMSS has been configured with. Generic names such as Windows or Linux can be used.
	VMImage *string `json:"vmImage,omitempty"`
}

// ClusterPropertiesUpdateParameters describes the cluster resource properties that can be updated during
// PATCH operation.
type ClusterPropertiesUpdateParameters struct {
	// AddOnFeatures - The list of add-on features to enable in the cluster.
	AddOnFeatures *[]string `json:"addOnFeatures,omitempty"`
	// Certificate - The certificate to use for securing the cluster. The certificate provided will be used for  node to node security within the cluster, SSL certificate for cluster management endpoint and default  admin client.
	Certificate *CertificateDescription `json:"certificate,omitempty"`
	// CertificateCommonNames - Describes a list of server certificates referenced by common name that are used to secure the cluster.
	CertificateCommonNames *ServerCertificateCommonNames `json:"certificateCommonNames,omitempty"`
	// ClientCertificateCommonNames - The list of client certificates referenced by common name that are allowed to manage the cluster. This will overwrite the existing list.
	ClientCertificateCommonNames *[]ClientCertificateCommonName `json:"clientCertificateCommonNames,omitempty"`
	// ClientCertificateThumbprints - The list of client certificates referenced by thumbprint that are allowed to manage the cluster. This will overwrite the existing list.
	ClientCertificateThumbprints *[]ClientCertificateThumbprint `json:"clientCertificateThumbprints,omitempty"`
	// ClusterCodeVersion - The Service Fabric runtime version of the cluster. This property can only by set the user when **upgradeMode** is set to 'Manual'. To get list of available Service Fabric versions for new clusters use [ClusterVersion API](./ClusterVersion.md). To get the list of available version for existing clusters use **availableClusterVersions**.
	ClusterCodeVersion *string `json:"clusterCodeVersion,omitempty"`
	// EventStoreServiceEnabled - Indicates if the event store service is enabled.
	EventStoreServiceEnabled *bool `json:"eventStoreServiceEnabled,omitempty"`
	// FabricSettings - The list of custom fabric settings to configure the cluster. This will overwrite the existing list.
	FabricSettings *[]SettingsSectionDescription `json:"fabricSettings,omitempty"`
	// NodeTypes - The list of node types in the cluster. This will overwrite the existing list.
	NodeTypes *[]NodeTypeDescription `json:"nodeTypes,omitempty"`
	// ReliabilityLevel - The reliability level sets the replica set size of system services. Learn about [ReliabilityLevel](https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity).
	//   - None - Run the System services with a target replica set count of 1. This should only be used for test clusters.
	//   - Bronze - Run the System services with a target replica set count of 3. This should only be used for test clusters.
	//   - Silver - Run the System services with a target replica set count of 5.
	//   - Gold - Run the System services with a target replica set count of 7.
	//   - Platinum - Run the System services with a target replica set count of 9.
	// . Possible values include: 'ReliabilityLevel1None', 'ReliabilityLevel1Bronze', 'ReliabilityLevel1Silver', 'ReliabilityLevel1Gold', 'ReliabilityLevel1Platinum'
	ReliabilityLevel ReliabilityLevel1 `json:"reliabilityLevel,omitempty"`
	// ReverseProxyCertificate - The server certificate used by reverse proxy.
	ReverseProxyCertificate *CertificateDescription `json:"reverseProxyCertificate,omitempty"`
	// UpgradeDescription - The policy to use when upgrading the cluster.
	UpgradeDescription *ClusterUpgradePolicy `json:"upgradeDescription,omitempty"`
	// UpgradeMode - The upgrade mode of the cluster when new Service Fabric runtime version is available.
	//   - Automatic - The cluster will be automatically upgraded to the latest Service Fabric runtime version as soon as it is available.
	//   - Manual - The cluster will not be automatically upgraded to the latest Service Fabric runtime version. The cluster is upgraded by setting the **clusterCodeVersion** property in the cluster resource.
	// . Possible values include: 'UpgradeMode1Automatic', 'UpgradeMode1Manual'
	UpgradeMode UpgradeMode1 `json:"upgradeMode,omitempty"`
}

// ClustersCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersCreateFuture) Result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ClustersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ClustersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ClustersCreateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersUpdateFuture) Result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ClustersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ClustersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ClustersUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClusterUpdateParameters cluster update request
type ClusterUpdateParameters struct {
	// ClusterPropertiesUpdateParameters - Describes the cluster resource properties that can be updated during PATCH operation.
	*ClusterPropertiesUpdateParameters `json:"properties,omitempty"`
	// Tags - Cluster update parameters
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ClusterUpdateParameters.
func (cup ClusterUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.ClusterPropertiesUpdateParameters != nil {
		objectMap["properties"] = cup.ClusterPropertiesUpdateParameters
	}
	if cup.Tags != nil {
		objectMap["tags"] = cup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdateParameters struct.
func (cup *ClusterUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterPropertiesUpdateParameters ClusterPropertiesUpdateParameters
				err = json.Unmarshal(*v, &clusterPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				cup.ClusterPropertiesUpdateParameters = &clusterPropertiesUpdateParameters
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cup.Tags = tags
			}
		}
	}

	return nil
}

// ClusterUpgradeDeltaHealthPolicy describes the delta health policies for the cluster upgrade.
type ClusterUpgradeDeltaHealthPolicy struct {
	// MaxPercentDeltaUnhealthyNodes - The maximum allowed percentage of nodes health degradation allowed during cluster upgrades.
	// The delta is measured between the state of the nodes at the beginning of upgrade and the state of the nodes at the time of the health evaluation.
	// The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
	MaxPercentDeltaUnhealthyNodes *int32 `json:"maxPercentDeltaUnhealthyNodes,omitempty"`
	// MaxPercentUpgradeDomainDeltaUnhealthyNodes - The maximum allowed percentage of upgrade domain nodes health degradation allowed during cluster upgrades.
	// The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade and the state of the upgrade domain nodes at the time of the health evaluation.
	// The check is performed after every upgrade domain upgrade completion for all completed upgrade domains to make sure the state of the upgrade domains is within tolerated limits.
	MaxPercentUpgradeDomainDeltaUnhealthyNodes *int32 `json:"maxPercentUpgradeDomainDeltaUnhealthyNodes,omitempty"`
	// MaxPercentDeltaUnhealthyApplications - The maximum allowed percentage of applications health degradation allowed during cluster upgrades.
	// The delta is measured between the state of the applications at the beginning of upgrade and the state of the applications at the time of the health evaluation.
	// The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits. System services are not included in this.
	MaxPercentDeltaUnhealthyApplications *int32 `json:"maxPercentDeltaUnhealthyApplications,omitempty"`
	// ApplicationDeltaHealthPolicies - Defines the application delta health policy map used to evaluate the health of an application or one of its child entities when upgrading the cluster.
	ApplicationDeltaHealthPolicies map[string]*ApplicationDeltaHealthPolicy `json:"applicationDeltaHealthPolicies"`
}

// MarshalJSON is the custom marshaler for ClusterUpgradeDeltaHealthPolicy.
func (cudhp ClusterUpgradeDeltaHealthPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cudhp.MaxPercentDeltaUnhealthyNodes != nil {
		objectMap["maxPercentDeltaUnhealthyNodes"] = cudhp.MaxPercentDeltaUnhealthyNodes
	}
	if cudhp.MaxPercentUpgradeDomainDeltaUnhealthyNodes != nil {
		objectMap["maxPercentUpgradeDomainDeltaUnhealthyNodes"] = cudhp.MaxPercentUpgradeDomainDeltaUnhealthyNodes
	}
	if cudhp.MaxPercentDeltaUnhealthyApplications != nil {
		objectMap["maxPercentDeltaUnhealthyApplications"] = cudhp.MaxPercentDeltaUnhealthyApplications
	}
	if cudhp.ApplicationDeltaHealthPolicies != nil {
		objectMap["applicationDeltaHealthPolicies"] = cudhp.ApplicationDeltaHealthPolicies
	}
	return json.Marshal(objectMap)
}

// ClusterUpgradePolicy describes the policy used when upgrading the cluster.
type ClusterUpgradePolicy struct {
	// ForceRestart - If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
	ForceRestart *bool `json:"forceRestart,omitempty"`
	// UpgradeReplicaSetCheckTimeout - The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	UpgradeReplicaSetCheckTimeout *string `json:"upgradeReplicaSetCheckTimeout,omitempty"`
	// HealthCheckWaitDuration - The length of time to wait after completing an upgrade domain before performing health checks. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	HealthCheckWaitDuration *string `json:"healthCheckWaitDuration,omitempty"`
	// HealthCheckStableDuration - The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	HealthCheckStableDuration *string `json:"healthCheckStableDuration,omitempty"`
	// HealthCheckRetryTimeout - The amount of time to retry health evaluation when the application or cluster is unhealthy before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	HealthCheckRetryTimeout *string `json:"healthCheckRetryTimeout,omitempty"`
	// UpgradeTimeout - The amount of time the overall upgrade has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	UpgradeTimeout *string `json:"upgradeTimeout,omitempty"`
	// UpgradeDomainTimeout - The amount of time each upgrade domain has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	UpgradeDomainTimeout *string `json:"upgradeDomainTimeout,omitempty"`
	// HealthPolicy - The cluster health policy used when upgrading the cluster.
	HealthPolicy *ClusterHealthPolicy `json:"healthPolicy,omitempty"`
	// DeltaHealthPolicy - The cluster delta health policy used when upgrading the cluster.
	DeltaHealthPolicy *ClusterUpgradeDeltaHealthPolicy `json:"deltaHealthPolicy,omitempty"`
}

// ClusterVersionDetails the detail of the Service Fabric runtime version result
type ClusterVersionDetails struct {
	// CodeVersion - The Service Fabric runtime version of the cluster.
	CodeVersion *string `json:"codeVersion,omitempty"`
	// SupportExpiryUtc - The date of expiry of support of the version.
	SupportExpiryUtc *string `json:"supportExpiryUtc,omitempty"`
	// Environment - Indicates if this version is for Windows or Linux operating system. Possible values include: 'Windows', 'Linux'
	Environment Environment `json:"environment,omitempty"`
}

// DiagnosticsStorageAccountConfig the storage account information for storing Service Fabric diagnostic
// logs.
type DiagnosticsStorageAccountConfig struct {
	// StorageAccountName - The Azure storage account name.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	// ProtectedAccountKeyName - The protected diagnostics storage key name.
	ProtectedAccountKeyName *string `json:"protectedAccountKeyName,omitempty"`
	// BlobEndpoint - The blob endpoint of the azure storage account.
	BlobEndpoint *string `json:"blobEndpoint,omitempty"`
	// QueueEndpoint - The queue endpoint of the azure storage account.
	QueueEndpoint *string `json:"queueEndpoint,omitempty"`
	// TableEndpoint - The table endpoint of the azure storage account.
	TableEndpoint *string `json:"tableEndpoint,omitempty"`
}

// EndpointRangeDescription port range details
type EndpointRangeDescription struct {
	// StartPort - Starting port of a range of ports
	StartPort *int32 `json:"startPort,omitempty"`
	// EndPort - End port of a range of ports
	EndPort *int32 `json:"endPort,omitempty"`
}

// ErrorModel the structure of the error.
type ErrorModel struct {
	// Error - The error details.
	Error *ErrorModelError `json:"error,omitempty"`
}

// ErrorModelError the error details.
type ErrorModelError struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
}

// NamedPartitionSchemeDescription describes the named partition scheme of the service.
type NamedPartitionSchemeDescription struct {
	// Count - The number of partitions.
	Count *int32 `json:"Count,omitempty"`
	// Names - Array of size specified by the ‘Count’ parameter, for the names of the partitions.
	Names *[]string `json:"Names,omitempty"`
	// PartitionScheme - Possible values include: 'PartitionSchemePartitionSchemeDescription', 'PartitionSchemeNamed', 'PartitionSchemeSingleton', 'PartitionSchemeUniformInt64Range'
	PartitionScheme PartitionSchemeBasicPartitionSchemeDescription `json:"partitionScheme,omitempty"`
}

// MarshalJSON is the custom marshaler for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	npsd.PartitionScheme = PartitionSchemeNamed
	objectMap := make(map[string]interface{})
	if npsd.Count != nil {
		objectMap["Count"] = npsd.Count
	}
	if npsd.Names != nil {
		objectMap["Names"] = npsd.Names
	}
	if npsd.PartitionScheme != "" {
		objectMap["partitionScheme"] = npsd.PartitionScheme
	}
	return json.Marshal(objectMap)
}

// AsNamedPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsNamedPartitionSchemeDescription() (*NamedPartitionSchemeDescription, bool) {
	return &npsd, true
}

// AsSingletonPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsSingletonPartitionSchemeDescription() (*SingletonPartitionSchemeDescription, bool) {
	return nil, false
}

// AsUniformInt64RangePartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsUniformInt64RangePartitionSchemeDescription() (*UniformInt64RangePartitionSchemeDescription, bool) {
	return nil, false
}

// AsPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsPartitionSchemeDescription() (*PartitionSchemeDescription, bool) {
	return nil, false
}

// AsBasicPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsBasicPartitionSchemeDescription() (BasicPartitionSchemeDescription, bool) {
	return &npsd, true
}

// NodeTypeDescription describes a node type in the cluster, each node type represents sub set of nodes in
// the cluster.
type NodeTypeDescription struct {
	// Name - The name of the node type.
	Name *string `json:"name,omitempty"`
	// PlacementProperties - The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
	PlacementProperties map[string]*string `json:"placementProperties"`
	// Capacities - The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
	Capacities map[string]*string `json:"capacities"`
	// ClientConnectionEndpointPort - The TCP cluster management endpoint port.
	ClientConnectionEndpointPort *int32 `json:"clientConnectionEndpointPort,omitempty"`
	// HTTPGatewayEndpointPort - The HTTP cluster management endpoint port.
	HTTPGatewayEndpointPort *int32 `json:"httpGatewayEndpointPort,omitempty"`
	// DurabilityLevel - The durability level of the node type. Learn about [DurabilityLevel](https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity).
	//   - Bronze - No privileges. This is the default.
	//   - Silver - The infrastructure jobs can be paused for a duration of 10 minutes per UD.
	//   - Gold - The infrastructure jobs can be paused for a duration of 2 hours per UD. Gold durability can be enabled only on full node VM skus like D15_V2, G5 etc.
	// . Possible values include: 'Bronze', 'Silver', 'Gold'
	DurabilityLevel DurabilityLevel `json:"durabilityLevel,omitempty"`
	// ApplicationPorts - The range of ports from which cluster assigned port to Service Fabric applications.
	ApplicationPorts *EndpointRangeDescription `json:"applicationPorts,omitempty"`
	// EphemeralPorts - The range of ephemeral ports that nodes in this node type should be configured with.
	EphemeralPorts *EndpointRangeDescription `json:"ephemeralPorts,omitempty"`
	// IsPrimary - The node type on which system services will run. Only one node type should be marked as primary. Primary node type cannot be deleted or changed for existing clusters.
	IsPrimary *bool `json:"isPrimary,omitempty"`
	// VMInstanceCount - The number of nodes in the node type. This count should match the capacity property in the corresponding VirtualMachineScaleSet resource.
	VMInstanceCount *int32 `json:"vmInstanceCount,omitempty"`
	// ReverseProxyEndpointPort - The endpoint used by reverse proxy.
	ReverseProxyEndpointPort *int32 `json:"reverseProxyEndpointPort,omitempty"`
}

// MarshalJSON is the custom marshaler for NodeTypeDescription.
func (ntd NodeTypeDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ntd.Name != nil {
		objectMap["name"] = ntd.Name
	}
	if ntd.PlacementProperties != nil {
		objectMap["placementProperties"] = ntd.PlacementProperties
	}
	if ntd.Capacities != nil {
		objectMap["capacities"] = ntd.Capacities
	}
	if ntd.ClientConnectionEndpointPort != nil {
		objectMap["clientConnectionEndpointPort"] = ntd.ClientConnectionEndpointPort
	}
	if ntd.HTTPGatewayEndpointPort != nil {
		objectMap["httpGatewayEndpointPort"] = ntd.HTTPGatewayEndpointPort
	}
	if ntd.DurabilityLevel != "" {
		objectMap["durabilityLevel"] = ntd.DurabilityLevel
	}
	if ntd.ApplicationPorts != nil {
		objectMap["applicationPorts"] = ntd.ApplicationPorts
	}
	if ntd.EphemeralPorts != nil {
		objectMap["ephemeralPorts"] = ntd.EphemeralPorts
	}
	if ntd.IsPrimary != nil {
		objectMap["isPrimary"] = ntd.IsPrimary
	}
	if ntd.VMInstanceCount != nil {
		objectMap["vmInstanceCount"] = ntd.VMInstanceCount
	}
	if ntd.ReverseProxyEndpointPort != nil {
		objectMap["reverseProxyEndpointPort"] = ntd.ReverseProxyEndpointPort
	}
	return json.Marshal(objectMap)
}

// OperationListResult describes the result of the request to list Service Fabric resource provider
// operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the Service Fabric resource provider.
	Value *[]OperationResult `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of OperationResult values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() OperationResult {
	if !iter.page.NotDone() {
		return OperationResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of OperationResult values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []OperationResult {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// OperationResult available operation list result
type OperationResult struct {
	// Name - The name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *AvailableOperationDisplay `json:"display,omitempty"`
	// Origin - Origin result
	Origin *string `json:"origin,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BasicPartitionSchemeDescription describes how the service is partitioned.
type BasicPartitionSchemeDescription interface {
	AsNamedPartitionSchemeDescription() (*NamedPartitionSchemeDescription, bool)
	AsSingletonPartitionSchemeDescription() (*SingletonPartitionSchemeDescription, bool)
	AsUniformInt64RangePartitionSchemeDescription() (*UniformInt64RangePartitionSchemeDescription, bool)
	AsPartitionSchemeDescription() (*PartitionSchemeDescription, bool)
}

// PartitionSchemeDescription describes how the service is partitioned.
type PartitionSchemeDescription struct {
	// PartitionScheme - Possible values include: 'PartitionSchemePartitionSchemeDescription', 'PartitionSchemeNamed', 'PartitionSchemeSingleton', 'PartitionSchemeUniformInt64Range'
	PartitionScheme PartitionSchemeBasicPartitionSchemeDescription `json:"partitionScheme,omitempty"`
}

func unmarshalBasicPartitionSchemeDescription(body []byte) (BasicPartitionSchemeDescription, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["partitionScheme"] {
	case string(PartitionSchemeNamed):
		var npsd NamedPartitionSchemeDescription
		err := json.Unmarshal(body, &npsd)
		return npsd, err
	case string(PartitionSchemeSingleton):
		var spsd SingletonPartitionSchemeDescription
		err := json.Unmarshal(body, &spsd)
		return spsd, err
	case string(PartitionSchemeUniformInt64Range):
		var ui6rpsd UniformInt64RangePartitionSchemeDescription
		err := json.Unmarshal(body, &ui6rpsd)
		return ui6rpsd, err
	default:
		var psd PartitionSchemeDescription
		err := json.Unmarshal(body, &psd)
		return psd, err
	}
}
func unmarshalBasicPartitionSchemeDescriptionArray(body []byte) ([]BasicPartitionSchemeDescription, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	psdArray := make([]BasicPartitionSchemeDescription, len(rawMessages))

	for index, rawMessage := range rawMessages {
		psd, err := unmarshalBasicPartitionSchemeDescription(*rawMessage)
		if err != nil {
			return nil, err
		}
		psdArray[index] = psd
	}
	return psdArray, nil
}

// MarshalJSON is the custom marshaler for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	psd.PartitionScheme = PartitionSchemePartitionSchemeDescription
	objectMap := make(map[string]interface{})
	if psd.PartitionScheme != "" {
		objectMap["partitionScheme"] = psd.PartitionScheme
	}
	return json.Marshal(objectMap)
}

// AsNamedPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsNamedPartitionSchemeDescription() (*NamedPartitionSchemeDescription, bool) {
	return nil, false
}

// AsSingletonPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsSingletonPartitionSchemeDescription() (*SingletonPartitionSchemeDescription, bool) {
	return nil, false
}

// AsUniformInt64RangePartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsUniformInt64RangePartitionSchemeDescription() (*UniformInt64RangePartitionSchemeDescription, bool) {
	return nil, false
}

// AsPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsPartitionSchemeDescription() (*PartitionSchemeDescription, bool) {
	return &psd, true
}

// AsBasicPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsBasicPartitionSchemeDescription() (BasicPartitionSchemeDescription, bool) {
	return &psd, true
}

// ProxyResource the resource model definition for proxy-only resource.
type ProxyResource struct {
	// ID - READ-ONLY; Azure resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Azure resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Azure resource tags.
	Tags map[string]*string `json:"tags"`
	// Etag - READ-ONLY; Azure resource etag.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pr.Location != nil {
		objectMap["location"] = pr.Location
	}
	if pr.Tags != nil {
		objectMap["tags"] = pr.Tags
	}
	return json.Marshal(objectMap)
}

// Resource the resource model definition.
type Resource struct {
	// ID - READ-ONLY; Azure resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Azure resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Azure resource tags.
	Tags map[string]*string `json:"tags"`
	// Etag - READ-ONLY; Azure resource etag.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ServerCertificateCommonName describes the server certificate details using common name.
type ServerCertificateCommonName struct {
	// CertificateCommonName - The common name of the server certificate.
	CertificateCommonName *string `json:"certificateCommonName,omitempty"`
	// CertificateIssuerThumbprint - The issuer thumbprint of the server certificate.
	CertificateIssuerThumbprint *string `json:"certificateIssuerThumbprint,omitempty"`
}

// ServerCertificateCommonNames describes a list of server certificates referenced by common name that are
// used to secure the cluster.
type ServerCertificateCommonNames struct {
	// CommonNames - The list of server certificates referenced by common name that are used to secure the cluster.
	CommonNames *[]ServerCertificateCommonName `json:"commonNames,omitempty"`
	// X509StoreName - The local certificate store location. Possible values include: 'X509StoreName1AddressBook', 'X509StoreName1AuthRoot', 'X509StoreName1CertificateAuthority', 'X509StoreName1Disallowed', 'X509StoreName1My', 'X509StoreName1Root', 'X509StoreName1TrustedPeople', 'X509StoreName1TrustedPublisher'
	X509StoreName X509StoreName1 `json:"x509StoreName,omitempty"`
}

// ServiceCorrelationDescription creates a particular correlation between services.
type ServiceCorrelationDescription struct {
	// Scheme - The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName. Possible values include: 'ServiceCorrelationSchemeInvalid', 'ServiceCorrelationSchemeAffinity', 'ServiceCorrelationSchemeAlignedAffinity', 'ServiceCorrelationSchemeNonAlignedAffinity'
	Scheme ServiceCorrelationScheme `json:"scheme,omitempty"`
	// ServiceName - The name of the service that the correlation relationship is established with.
	ServiceName *string `json:"serviceName,omitempty"`
}

// ServiceLoadMetricDescription specifies a metric to load balance a service during runtime.
type ServiceLoadMetricDescription struct {
	// Name - The name of the metric. If the service chooses to report load during runtime, the load metric name should match the name that is specified in Name exactly. Note that metric names are case sensitive.
	Name *string `json:"name,omitempty"`
	// Weight - The service load metric relative weight, compared to other metrics configured for this service, as a number. Possible values include: 'ServiceLoadMetricWeightZero', 'ServiceLoadMetricWeightLow', 'ServiceLoadMetricWeightMedium', 'ServiceLoadMetricWeightHigh'
	Weight ServiceLoadMetricWeight `json:"weight,omitempty"`
	// PrimaryDefaultLoad - Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Primary replica.
	PrimaryDefaultLoad *int32 `json:"primaryDefaultLoad,omitempty"`
	// SecondaryDefaultLoad - Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Secondary replica.
	SecondaryDefaultLoad *int32 `json:"secondaryDefaultLoad,omitempty"`
	// DefaultLoad - Used only for Stateless services. The default amount of load, as a number, that this service creates for this metric.
	DefaultLoad *int32 `json:"defaultLoad,omitempty"`
}

// BasicServicePlacementPolicyDescription describes the policy to be used for placement of a Service Fabric service.
type BasicServicePlacementPolicyDescription interface {
	AsServicePlacementPolicyDescription() (*ServicePlacementPolicyDescription, bool)
}

// ServicePlacementPolicyDescription describes the policy to be used for placement of a Service Fabric service.
type ServicePlacementPolicyDescription struct {
	// Type - Possible values include: 'TypeServicePlacementPolicyDescription'
	Type Type `json:"Type,omitempty"`
}

func unmarshalBasicServicePlacementPolicyDescription(body []byte) (BasicServicePlacementPolicyDescription, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Type"] {
	default:
		var sppd ServicePlacementPolicyDescription
		err := json.Unmarshal(body, &sppd)
		return sppd, err
	}
}
func unmarshalBasicServicePlacementPolicyDescriptionArray(body []byte) ([]BasicServicePlacementPolicyDescription, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sppdArray := make([]BasicServicePlacementPolicyDescription, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sppd, err := unmarshalBasicServicePlacementPolicyDescription(*rawMessage)
		if err != nil {
			return nil, err
		}
		sppdArray[index] = sppd
	}
	return sppdArray, nil
}

// MarshalJSON is the custom marshaler for ServicePlacementPolicyDescription.
func (sppd ServicePlacementPolicyDescription) MarshalJSON() ([]byte, error) {
	sppd.Type = TypeServicePlacementPolicyDescription
	objectMap := make(map[string]interface{})
	if sppd.Type != "" {
		objectMap["Type"] = sppd.Type
	}
	return json.Marshal(objectMap)
}

// AsServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPolicyDescription.
func (sppd ServicePlacementPolicyDescription) AsServicePlacementPolicyDescription() (*ServicePlacementPolicyDescription, bool) {
	return &sppd, true
}

// AsBasicServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPolicyDescription.
func (sppd ServicePlacementPolicyDescription) AsBasicServicePlacementPolicyDescription() (BasicServicePlacementPolicyDescription, bool) {
	return &sppd, true
}

// ServiceResource the service resource.
type ServiceResource struct {
	autorest.Response `json:"-"`
	// BasicServiceResourceProperties - The service resource properties.
	BasicServiceResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Azure resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Azure resource tags.
	Tags map[string]*string `json:"tags"`
	// Etag - READ-ONLY; Azure resource etag.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceResource.
func (sr ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = sr.BasicServiceResourceProperties
	if sr.Location != nil {
		objectMap["location"] = sr.Location
	}
	if sr.Tags != nil {
		objectMap["tags"] = sr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceResource struct.
func (sr *ServiceResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				basicServiceResourceProperties, err := unmarshalBasicServiceResourceProperties(*v)
				if err != nil {
					return err
				}
				sr.BasicServiceResourceProperties = basicServiceResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sr.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sr.Etag = &etag
			}
		}
	}

	return nil
}

// ServiceResourceList the list of service resources.
type ServiceResourceList struct {
	autorest.Response `json:"-"`
	Value             *[]ServiceResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of service list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// BasicServiceResourceProperties the service resource properties.
type BasicServiceResourceProperties interface {
	AsStatefulServiceProperties() (*StatefulServiceProperties, bool)
	AsStatelessServiceProperties() (*StatelessServiceProperties, bool)
	AsServiceResourceProperties() (*ServiceResourceProperties, bool)
}

// ServiceResourceProperties the service resource properties.
type ServiceResourceProperties struct {
	// ProvisioningState - READ-ONLY; The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ServiceTypeName - The name of the service type
	ServiceTypeName *string `json:"serviceTypeName,omitempty"`
	// PartitionDescription - Describes how the service is partitioned.
	PartitionDescription BasicPartitionSchemeDescription `json:"partitionDescription,omitempty"`
	// ServicePackageActivationMode - The activation Mode of the service package. Possible values include: 'SharedProcess', 'ExclusiveProcess'
	ServicePackageActivationMode ArmServicePackageActivationMode `json:"servicePackageActivationMode,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindServiceResourceProperties', 'ServiceKindStateful1', 'ServiceKindStateless1'
	ServiceKind ServiceKindBasicServiceResourceProperties `json:"serviceKind,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string `json:"placementConstraints,omitempty"`
	// CorrelationScheme - A list that describes the correlation of the service with other services.
	CorrelationScheme *[]ServiceCorrelationDescription `json:"correlationScheme,omitempty"`
	// ServiceLoadMetrics - The service load metrics is given as an array of ServiceLoadMetricDescription objects.
	ServiceLoadMetrics *[]ServiceLoadMetricDescription `json:"serviceLoadMetrics,omitempty"`
	// ServicePlacementPolicies - A list that describes the correlation of the service with other services.
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"servicePlacementPolicies,omitempty"`
	// DefaultMoveCost - Specifies the move cost for the service. Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost MoveCost `json:"defaultMoveCost,omitempty"`
}

func unmarshalBasicServiceResourceProperties(body []byte) (BasicServiceResourceProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["serviceKind"] {
	case string(ServiceKindStateful1):
		var ssp StatefulServiceProperties
		err := json.Unmarshal(body, &ssp)
		return ssp, err
	case string(ServiceKindStateless1):
		var ssp StatelessServiceProperties
		err := json.Unmarshal(body, &ssp)
		return ssp, err
	default:
		var srp ServiceResourceProperties
		err := json.Unmarshal(body, &srp)
		return srp, err
	}
}
func unmarshalBasicServiceResourcePropertiesArray(body []byte) ([]BasicServiceResourceProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	srpArray := make([]BasicServiceResourceProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		srp, err := unmarshalBasicServiceResourceProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		srpArray[index] = srp
	}
	return srpArray, nil
}

// MarshalJSON is the custom marshaler for ServiceResourceProperties.
func (srp ServiceResourceProperties) MarshalJSON() ([]byte, error) {
	srp.ServiceKind = ServiceKindServiceResourceProperties
	objectMap := make(map[string]interface{})
	if srp.ServiceTypeName != nil {
		objectMap["serviceTypeName"] = srp.ServiceTypeName
	}
	objectMap["partitionDescription"] = srp.PartitionDescription
	if srp.ServicePackageActivationMode != "" {
		objectMap["servicePackageActivationMode"] = srp.ServicePackageActivationMode
	}
	if srp.ServiceKind != "" {
		objectMap["serviceKind"] = srp.ServiceKind
	}
	if srp.PlacementConstraints != nil {
		objectMap["placementConstraints"] = srp.PlacementConstraints
	}
	if srp.CorrelationScheme != nil {
		objectMap["correlationScheme"] = srp.CorrelationScheme
	}
	if srp.ServiceLoadMetrics != nil {
		objectMap["serviceLoadMetrics"] = srp.ServiceLoadMetrics
	}
	if srp.ServicePlacementPolicies != nil {
		objectMap["servicePlacementPolicies"] = srp.ServicePlacementPolicies
	}
	if srp.DefaultMoveCost != "" {
		objectMap["defaultMoveCost"] = srp.DefaultMoveCost
	}
	return json.Marshal(objectMap)
}

// AsStatefulServiceProperties is the BasicServiceResourceProperties implementation for ServiceResourceProperties.
func (srp ServiceResourceProperties) AsStatefulServiceProperties() (*StatefulServiceProperties, bool) {
	return nil, false
}

// AsStatelessServiceProperties is the BasicServiceResourceProperties implementation for ServiceResourceProperties.
func (srp ServiceResourceProperties) AsStatelessServiceProperties() (*StatelessServiceProperties, bool) {
	return nil, false
}

// AsServiceResourceProperties is the BasicServiceResourceProperties implementation for ServiceResourceProperties.
func (srp ServiceResourceProperties) AsServiceResourceProperties() (*ServiceResourceProperties, bool) {
	return &srp, true
}

// AsBasicServiceResourceProperties is the BasicServiceResourceProperties implementation for ServiceResourceProperties.
func (srp ServiceResourceProperties) AsBasicServiceResourceProperties() (BasicServiceResourceProperties, bool) {
	return &srp, true
}

// UnmarshalJSON is the custom unmarshaler for ServiceResourceProperties struct.
func (srp *ServiceResourceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "provisioningState":
			if v != nil {
				var provisioningState string
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				srp.ProvisioningState = &provisioningState
			}
		case "serviceTypeName":
			if v != nil {
				var serviceTypeName string
				err = json.Unmarshal(*v, &serviceTypeName)
				if err != nil {
					return err
				}
				srp.ServiceTypeName = &serviceTypeName
			}
		case "partitionDescription":
			if v != nil {
				partitionDescription, err := unmarshalBasicPartitionSchemeDescription(*v)
				if err != nil {
					return err
				}
				srp.PartitionDescription = partitionDescription
			}
		case "servicePackageActivationMode":
			if v != nil {
				var servicePackageActivationMode ArmServicePackageActivationMode
				err = json.Unmarshal(*v, &servicePackageActivationMode)
				if err != nil {
					return err
				}
				srp.ServicePackageActivationMode = servicePackageActivationMode
			}
		case "serviceKind":
			if v != nil {
				var serviceKind ServiceKindBasicServiceResourceProperties
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				srp.ServiceKind = serviceKind
			}
		case "placementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				srp.PlacementConstraints = &placementConstraints
			}
		case "correlationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				srp.CorrelationScheme = &correlationScheme
			}
		case "serviceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				srp.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "servicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				srp.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "defaultMoveCost":
			if v != nil {
				var defaultMoveCost MoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				srp.DefaultMoveCost = defaultMoveCost
			}
		}
	}

	return nil
}

// ServiceResourcePropertiesBase the common service resource properties.
type ServiceResourcePropertiesBase struct {
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string `json:"placementConstraints,omitempty"`
	// CorrelationScheme - A list that describes the correlation of the service with other services.
	CorrelationScheme *[]ServiceCorrelationDescription `json:"correlationScheme,omitempty"`
	// ServiceLoadMetrics - The service load metrics is given as an array of ServiceLoadMetricDescription objects.
	ServiceLoadMetrics *[]ServiceLoadMetricDescription `json:"serviceLoadMetrics,omitempty"`
	// ServicePlacementPolicies - A list that describes the correlation of the service with other services.
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"servicePlacementPolicies,omitempty"`
	// DefaultMoveCost - Specifies the move cost for the service. Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost MoveCost `json:"defaultMoveCost,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ServiceResourcePropertiesBase struct.
func (srpb *ServiceResourcePropertiesBase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "placementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				srpb.PlacementConstraints = &placementConstraints
			}
		case "correlationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				srpb.CorrelationScheme = &correlationScheme
			}
		case "serviceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				srpb.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "servicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				srpb.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "defaultMoveCost":
			if v != nil {
				var defaultMoveCost MoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				srpb.DefaultMoveCost = defaultMoveCost
			}
		}
	}

	return nil
}

// ServiceResourceUpdate the service resource for patch operations.
type ServiceResourceUpdate struct {
	// BasicServiceResourceUpdateProperties - The service resource properties for patch operations.
	BasicServiceResourceUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Azure resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Azure resource tags.
	Tags map[string]*string `json:"tags"`
	// Etag - READ-ONLY; Azure resource etag.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceResourceUpdate.
func (sru ServiceResourceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = sru.BasicServiceResourceUpdateProperties
	if sru.Location != nil {
		objectMap["location"] = sru.Location
	}
	if sru.Tags != nil {
		objectMap["tags"] = sru.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceResourceUpdate struct.
func (sru *ServiceResourceUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				basicServiceResourceUpdateProperties, err := unmarshalBasicServiceResourceUpdateProperties(*v)
				if err != nil {
					return err
				}
				sru.BasicServiceResourceUpdateProperties = basicServiceResourceUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sru.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sru.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sru.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sru.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sru.Tags = tags
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sru.Etag = &etag
			}
		}
	}

	return nil
}

// BasicServiceResourceUpdateProperties the service resource properties for patch operations.
type BasicServiceResourceUpdateProperties interface {
	AsStatefulServiceUpdateProperties() (*StatefulServiceUpdateProperties, bool)
	AsStatelessServiceUpdateProperties() (*StatelessServiceUpdateProperties, bool)
	AsServiceResourceUpdateProperties() (*ServiceResourceUpdateProperties, bool)
}

// ServiceResourceUpdateProperties the service resource properties for patch operations.
type ServiceResourceUpdateProperties struct {
	// ServiceKind - Possible values include: 'ServiceKindBasicServiceResourceUpdatePropertiesServiceKindServiceResourceUpdateProperties', 'ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateful', 'ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateless'
	ServiceKind ServiceKindBasicServiceResourceUpdateProperties `json:"serviceKind,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string `json:"placementConstraints,omitempty"`
	// CorrelationScheme - A list that describes the correlation of the service with other services.
	CorrelationScheme *[]ServiceCorrelationDescription `json:"correlationScheme,omitempty"`
	// ServiceLoadMetrics - The service load metrics is given as an array of ServiceLoadMetricDescription objects.
	ServiceLoadMetrics *[]ServiceLoadMetricDescription `json:"serviceLoadMetrics,omitempty"`
	// ServicePlacementPolicies - A list that describes the correlation of the service with other services.
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"servicePlacementPolicies,omitempty"`
	// DefaultMoveCost - Specifies the move cost for the service. Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost MoveCost `json:"defaultMoveCost,omitempty"`
}

func unmarshalBasicServiceResourceUpdateProperties(body []byte) (BasicServiceResourceUpdateProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["serviceKind"] {
	case string(ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateful):
		var ssup StatefulServiceUpdateProperties
		err := json.Unmarshal(body, &ssup)
		return ssup, err
	case string(ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateless):
		var ssup StatelessServiceUpdateProperties
		err := json.Unmarshal(body, &ssup)
		return ssup, err
	default:
		var srup ServiceResourceUpdateProperties
		err := json.Unmarshal(body, &srup)
		return srup, err
	}
}
func unmarshalBasicServiceResourceUpdatePropertiesArray(body []byte) ([]BasicServiceResourceUpdateProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	srupArray := make([]BasicServiceResourceUpdateProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		srup, err := unmarshalBasicServiceResourceUpdateProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		srupArray[index] = srup
	}
	return srupArray, nil
}

// MarshalJSON is the custom marshaler for ServiceResourceUpdateProperties.
func (srup ServiceResourceUpdateProperties) MarshalJSON() ([]byte, error) {
	srup.ServiceKind = ServiceKindBasicServiceResourceUpdatePropertiesServiceKindServiceResourceUpdateProperties
	objectMap := make(map[string]interface{})
	if srup.ServiceKind != "" {
		objectMap["serviceKind"] = srup.ServiceKind
	}
	if srup.PlacementConstraints != nil {
		objectMap["placementConstraints"] = srup.PlacementConstraints
	}
	if srup.CorrelationScheme != nil {
		objectMap["correlationScheme"] = srup.CorrelationScheme
	}
	if srup.ServiceLoadMetrics != nil {
		objectMap["serviceLoadMetrics"] = srup.ServiceLoadMetrics
	}
	if srup.ServicePlacementPolicies != nil {
		objectMap["servicePlacementPolicies"] = srup.ServicePlacementPolicies
	}
	if srup.DefaultMoveCost != "" {
		objectMap["defaultMoveCost"] = srup.DefaultMoveCost
	}
	return json.Marshal(objectMap)
}

// AsStatefulServiceUpdateProperties is the BasicServiceResourceUpdateProperties implementation for ServiceResourceUpdateProperties.
func (srup ServiceResourceUpdateProperties) AsStatefulServiceUpdateProperties() (*StatefulServiceUpdateProperties, bool) {
	return nil, false
}

// AsStatelessServiceUpdateProperties is the BasicServiceResourceUpdateProperties implementation for ServiceResourceUpdateProperties.
func (srup ServiceResourceUpdateProperties) AsStatelessServiceUpdateProperties() (*StatelessServiceUpdateProperties, bool) {
	return nil, false
}

// AsServiceResourceUpdateProperties is the BasicServiceResourceUpdateProperties implementation for ServiceResourceUpdateProperties.
func (srup ServiceResourceUpdateProperties) AsServiceResourceUpdateProperties() (*ServiceResourceUpdateProperties, bool) {
	return &srup, true
}

// AsBasicServiceResourceUpdateProperties is the BasicServiceResourceUpdateProperties implementation for ServiceResourceUpdateProperties.
func (srup ServiceResourceUpdateProperties) AsBasicServiceResourceUpdateProperties() (BasicServiceResourceUpdateProperties, bool) {
	return &srup, true
}

// UnmarshalJSON is the custom unmarshaler for ServiceResourceUpdateProperties struct.
func (srup *ServiceResourceUpdateProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "serviceKind":
			if v != nil {
				var serviceKind ServiceKindBasicServiceResourceUpdateProperties
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				srup.ServiceKind = serviceKind
			}
		case "placementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				srup.PlacementConstraints = &placementConstraints
			}
		case "correlationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				srup.CorrelationScheme = &correlationScheme
			}
		case "serviceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				srup.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "servicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				srup.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "defaultMoveCost":
			if v != nil {
				var defaultMoveCost MoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				srup.DefaultMoveCost = defaultMoveCost
			}
		}
	}

	return nil
}

// ServicesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesCreateFuture) Result(client ServicesClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ServicesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ServicesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.CreateResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ServicesCreateFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesDeleteFuture) Result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ServicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ServicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServicesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesUpdateFuture) Result(client ServicesClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ServicesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ServicesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.UpdateResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ServicesUpdateFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServiceTypeDeltaHealthPolicy represents the delta health policy used to evaluate the health of services
// belonging to a service type when upgrading the cluster.
type ServiceTypeDeltaHealthPolicy struct {
	// MaxPercentDeltaUnhealthyServices - The maximum allowed percentage of services health degradation allowed during cluster upgrades.
	// The delta is measured between the state of the services at the beginning of upgrade and the state of the services at the time of the health evaluation.
	// The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
	MaxPercentDeltaUnhealthyServices *int32 `json:"maxPercentDeltaUnhealthyServices,omitempty"`
}

// ServiceTypeHealthPolicy represents the health policy used to evaluate the health of services belonging
// to a service type.
type ServiceTypeHealthPolicy struct {
	// MaxPercentUnhealthyServices - The maximum percentage of services allowed to be unhealthy before your application is considered in error.
	MaxPercentUnhealthyServices *int32 `json:"maxPercentUnhealthyServices,omitempty"`
}

// SettingsParameterDescription describes a parameter in fabric settings of the cluster.
type SettingsParameterDescription struct {
	// Name - The parameter name of fabric setting.
	Name *string `json:"name,omitempty"`
	// Value - The parameter value of fabric setting.
	Value *string `json:"value,omitempty"`
}

// SettingsSectionDescription describes a section in the fabric settings of the cluster.
type SettingsSectionDescription struct {
	// Name - The section name of the fabric settings.
	Name *string `json:"name,omitempty"`
	// Parameters - The collection of parameters in the section.
	Parameters *[]SettingsParameterDescription `json:"parameters,omitempty"`
}

// SingletonPartitionSchemeDescription describes the partition scheme of a singleton-partitioned, or
// non-partitioned service.
type SingletonPartitionSchemeDescription struct {
	// PartitionScheme - Possible values include: 'PartitionSchemePartitionSchemeDescription', 'PartitionSchemeNamed', 'PartitionSchemeSingleton', 'PartitionSchemeUniformInt64Range'
	PartitionScheme PartitionSchemeBasicPartitionSchemeDescription `json:"partitionScheme,omitempty"`
}

// MarshalJSON is the custom marshaler for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	spsd.PartitionScheme = PartitionSchemeSingleton
	objectMap := make(map[string]interface{})
	if spsd.PartitionScheme != "" {
		objectMap["partitionScheme"] = spsd.PartitionScheme
	}
	return json.Marshal(objectMap)
}

// AsNamedPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsNamedPartitionSchemeDescription() (*NamedPartitionSchemeDescription, bool) {
	return nil, false
}

// AsSingletonPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsSingletonPartitionSchemeDescription() (*SingletonPartitionSchemeDescription, bool) {
	return &spsd, true
}

// AsUniformInt64RangePartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsUniformInt64RangePartitionSchemeDescription() (*UniformInt64RangePartitionSchemeDescription, bool) {
	return nil, false
}

// AsPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsPartitionSchemeDescription() (*PartitionSchemeDescription, bool) {
	return nil, false
}

// AsBasicPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsBasicPartitionSchemeDescription() (BasicPartitionSchemeDescription, bool) {
	return &spsd, true
}

// StatefulServiceProperties the properties of a stateful service resource.
type StatefulServiceProperties struct {
	// HasPersistedState - A flag indicating whether this is a persistent service which stores states on the local disk. If it is then the value of this property is true, if not it is false.
	HasPersistedState *bool `json:"hasPersistedState,omitempty"`
	// TargetReplicaSetSize - The target replica set size as a number.
	TargetReplicaSetSize *int32 `json:"targetReplicaSetSize,omitempty"`
	// MinReplicaSetSize - The minimum replica set size as a number.
	MinReplicaSetSize *int32 `json:"minReplicaSetSize,omitempty"`
	// ReplicaRestartWaitDuration - The duration between when a replica goes down and when a new replica is created, represented in ISO 8601 format (hh:mm:ss.s).
	ReplicaRestartWaitDuration *date.Time `json:"replicaRestartWaitDuration,omitempty"`
	// QuorumLossWaitDuration - The maximum duration for which a partition is allowed to be in a state of quorum loss, represented in ISO 8601 format (hh:mm:ss.s).
	QuorumLossWaitDuration *date.Time `json:"quorumLossWaitDuration,omitempty"`
	// StandByReplicaKeepDuration - The definition on how long StandBy replicas should be maintained before being removed, represented in ISO 8601 format (hh:mm:ss.s).
	StandByReplicaKeepDuration *date.Time `json:"standByReplicaKeepDuration,omitempty"`
	// ProvisioningState - READ-ONLY; The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ServiceTypeName - The name of the service type
	ServiceTypeName *string `json:"serviceTypeName,omitempty"`
	// PartitionDescription - Describes how the service is partitioned.
	PartitionDescription BasicPartitionSchemeDescription `json:"partitionDescription,omitempty"`
	// ServicePackageActivationMode - The activation Mode of the service package. Possible values include: 'SharedProcess', 'ExclusiveProcess'
	ServicePackageActivationMode ArmServicePackageActivationMode `json:"servicePackageActivationMode,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindServiceResourceProperties', 'ServiceKindStateful1', 'ServiceKindStateless1'
	ServiceKind ServiceKindBasicServiceResourceProperties `json:"serviceKind,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string `json:"placementConstraints,omitempty"`
	// CorrelationScheme - A list that describes the correlation of the service with other services.
	CorrelationScheme *[]ServiceCorrelationDescription `json:"correlationScheme,omitempty"`
	// ServiceLoadMetrics - The service load metrics is given as an array of ServiceLoadMetricDescription objects.
	ServiceLoadMetrics *[]ServiceLoadMetricDescription `json:"serviceLoadMetrics,omitempty"`
	// ServicePlacementPolicies - A list that describes the correlation of the service with other services.
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"servicePlacementPolicies,omitempty"`
	// DefaultMoveCost - Specifies the move cost for the service. Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost MoveCost `json:"defaultMoveCost,omitempty"`
}

// MarshalJSON is the custom marshaler for StatefulServiceProperties.
func (ssp StatefulServiceProperties) MarshalJSON() ([]byte, error) {
	ssp.ServiceKind = ServiceKindStateful1
	objectMap := make(map[string]interface{})
	if ssp.HasPersistedState != nil {
		objectMap["hasPersistedState"] = ssp.HasPersistedState
	}
	if ssp.TargetReplicaSetSize != nil {
		objectMap["targetReplicaSetSize"] = ssp.TargetReplicaSetSize
	}
	if ssp.MinReplicaSetSize != nil {
		objectMap["minReplicaSetSize"] = ssp.MinReplicaSetSize
	}
	if ssp.ReplicaRestartWaitDuration != nil {
		objectMap["replicaRestartWaitDuration"] = ssp.ReplicaRestartWaitDuration
	}
	if ssp.QuorumLossWaitDuration != nil {
		objectMap["quorumLossWaitDuration"] = ssp.QuorumLossWaitDuration
	}
	if ssp.StandByReplicaKeepDuration != nil {
		objectMap["standByReplicaKeepDuration"] = ssp.StandByReplicaKeepDuration
	}
	if ssp.ServiceTypeName != nil {
		objectMap["serviceTypeName"] = ssp.ServiceTypeName
	}
	objectMap["partitionDescription"] = ssp.PartitionDescription
	if ssp.ServicePackageActivationMode != "" {
		objectMap["servicePackageActivationMode"] = ssp.ServicePackageActivationMode
	}
	if ssp.ServiceKind != "" {
		objectMap["serviceKind"] = ssp.ServiceKind
	}
	if ssp.PlacementConstraints != nil {
		objectMap["placementConstraints"] = ssp.PlacementConstraints
	}
	if ssp.CorrelationScheme != nil {
		objectMap["correlationScheme"] = ssp.CorrelationScheme
	}
	if ssp.ServiceLoadMetrics != nil {
		objectMap["serviceLoadMetrics"] = ssp.ServiceLoadMetrics
	}
	if ssp.ServicePlacementPolicies != nil {
		objectMap["servicePlacementPolicies"] = ssp.ServicePlacementPolicies
	}
	if ssp.DefaultMoveCost != "" {
		objectMap["defaultMoveCost"] = ssp.DefaultMoveCost
	}
	return json.Marshal(objectMap)
}

// AsStatefulServiceProperties is the BasicServiceResourceProperties implementation for StatefulServiceProperties.
func (ssp StatefulServiceProperties) AsStatefulServiceProperties() (*StatefulServiceProperties, bool) {
	return &ssp, true
}

// AsStatelessServiceProperties is the BasicServiceResourceProperties implementation for StatefulServiceProperties.
func (ssp StatefulServiceProperties) AsStatelessServiceProperties() (*StatelessServiceProperties, bool) {
	return nil, false
}

// AsServiceResourceProperties is the BasicServiceResourceProperties implementation for StatefulServiceProperties.
func (ssp StatefulServiceProperties) AsServiceResourceProperties() (*ServiceResourceProperties, bool) {
	return nil, false
}

// AsBasicServiceResourceProperties is the BasicServiceResourceProperties implementation for StatefulServiceProperties.
func (ssp StatefulServiceProperties) AsBasicServiceResourceProperties() (BasicServiceResourceProperties, bool) {
	return &ssp, true
}

// UnmarshalJSON is the custom unmarshaler for StatefulServiceProperties struct.
func (ssp *StatefulServiceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "hasPersistedState":
			if v != nil {
				var hasPersistedState bool
				err = json.Unmarshal(*v, &hasPersistedState)
				if err != nil {
					return err
				}
				ssp.HasPersistedState = &hasPersistedState
			}
		case "targetReplicaSetSize":
			if v != nil {
				var targetReplicaSetSize int32
				err = json.Unmarshal(*v, &targetReplicaSetSize)
				if err != nil {
					return err
				}
				ssp.TargetReplicaSetSize = &targetReplicaSetSize
			}
		case "minReplicaSetSize":
			if v != nil {
				var minReplicaSetSize int32
				err = json.Unmarshal(*v, &minReplicaSetSize)
				if err != nil {
					return err
				}
				ssp.MinReplicaSetSize = &minReplicaSetSize
			}
		case "replicaRestartWaitDuration":
			if v != nil {
				var replicaRestartWaitDuration date.Time
				err = json.Unmarshal(*v, &replicaRestartWaitDuration)
				if err != nil {
					return err
				}
				ssp.ReplicaRestartWaitDuration = &replicaRestartWaitDuration
			}
		case "quorumLossWaitDuration":
			if v != nil {
				var quorumLossWaitDuration date.Time
				err = json.Unmarshal(*v, &quorumLossWaitDuration)
				if err != nil {
					return err
				}
				ssp.QuorumLossWaitDuration = &quorumLossWaitDuration
			}
		case "standByReplicaKeepDuration":
			if v != nil {
				var standByReplicaKeepDuration date.Time
				err = json.Unmarshal(*v, &standByReplicaKeepDuration)
				if err != nil {
					return err
				}
				ssp.StandByReplicaKeepDuration = &standByReplicaKeepDuration
			}
		case "provisioningState":
			if v != nil {
				var provisioningState string
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				ssp.ProvisioningState = &provisioningState
			}
		case "serviceTypeName":
			if v != nil {
				var serviceTypeName string
				err = json.Unmarshal(*v, &serviceTypeName)
				if err != nil {
					return err
				}
				ssp.ServiceTypeName = &serviceTypeName
			}
		case "partitionDescription":
			if v != nil {
				partitionDescription, err := unmarshalBasicPartitionSchemeDescription(*v)
				if err != nil {
					return err
				}
				ssp.PartitionDescription = partitionDescription
			}
		case "servicePackageActivationMode":
			if v != nil {
				var servicePackageActivationMode ArmServicePackageActivationMode
				err = json.Unmarshal(*v, &servicePackageActivationMode)
				if err != nil {
					return err
				}
				ssp.ServicePackageActivationMode = servicePackageActivationMode
			}
		case "serviceKind":
			if v != nil {
				var serviceKind ServiceKindBasicServiceResourceProperties
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				ssp.ServiceKind = serviceKind
			}
		case "placementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				ssp.PlacementConstraints = &placementConstraints
			}
		case "correlationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				ssp.CorrelationScheme = &correlationScheme
			}
		case "serviceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				ssp.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "servicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				ssp.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "defaultMoveCost":
			if v != nil {
				var defaultMoveCost MoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				ssp.DefaultMoveCost = defaultMoveCost
			}
		}
	}

	return nil
}

// StatefulServiceUpdateProperties the properties of a stateful service resource for patch operations.
type StatefulServiceUpdateProperties struct {
	// TargetReplicaSetSize - The target replica set size as a number.
	TargetReplicaSetSize *int32 `json:"targetReplicaSetSize,omitempty"`
	// MinReplicaSetSize - The minimum replica set size as a number.
	MinReplicaSetSize *int32 `json:"minReplicaSetSize,omitempty"`
	// ReplicaRestartWaitDuration - The duration between when a replica goes down and when a new replica is created, represented in ISO 8601 format (hh:mm:ss.s).
	ReplicaRestartWaitDuration *date.Time `json:"replicaRestartWaitDuration,omitempty"`
	// QuorumLossWaitDuration - The maximum duration for which a partition is allowed to be in a state of quorum loss, represented in ISO 8601 format (hh:mm:ss.s).
	QuorumLossWaitDuration *date.Time `json:"quorumLossWaitDuration,omitempty"`
	// StandByReplicaKeepDuration - The definition on how long StandBy replicas should be maintained before being removed, represented in ISO 8601 format (hh:mm:ss.s).
	StandByReplicaKeepDuration *date.Time `json:"standByReplicaKeepDuration,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicServiceResourceUpdatePropertiesServiceKindServiceResourceUpdateProperties', 'ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateful', 'ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateless'
	ServiceKind ServiceKindBasicServiceResourceUpdateProperties `json:"serviceKind,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string `json:"placementConstraints,omitempty"`
	// CorrelationScheme - A list that describes the correlation of the service with other services.
	CorrelationScheme *[]ServiceCorrelationDescription `json:"correlationScheme,omitempty"`
	// ServiceLoadMetrics - The service load metrics is given as an array of ServiceLoadMetricDescription objects.
	ServiceLoadMetrics *[]ServiceLoadMetricDescription `json:"serviceLoadMetrics,omitempty"`
	// ServicePlacementPolicies - A list that describes the correlation of the service with other services.
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"servicePlacementPolicies,omitempty"`
	// DefaultMoveCost - Specifies the move cost for the service. Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost MoveCost `json:"defaultMoveCost,omitempty"`
}

// MarshalJSON is the custom marshaler for StatefulServiceUpdateProperties.
func (ssup StatefulServiceUpdateProperties) MarshalJSON() ([]byte, error) {
	ssup.ServiceKind = ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateful
	objectMap := make(map[string]interface{})
	if ssup.TargetReplicaSetSize != nil {
		objectMap["targetReplicaSetSize"] = ssup.TargetReplicaSetSize
	}
	if ssup.MinReplicaSetSize != nil {
		objectMap["minReplicaSetSize"] = ssup.MinReplicaSetSize
	}
	if ssup.ReplicaRestartWaitDuration != nil {
		objectMap["replicaRestartWaitDuration"] = ssup.ReplicaRestartWaitDuration
	}
	if ssup.QuorumLossWaitDuration != nil {
		objectMap["quorumLossWaitDuration"] = ssup.QuorumLossWaitDuration
	}
	if ssup.StandByReplicaKeepDuration != nil {
		objectMap["standByReplicaKeepDuration"] = ssup.StandByReplicaKeepDuration
	}
	if ssup.ServiceKind != "" {
		objectMap["serviceKind"] = ssup.ServiceKind
	}
	if ssup.PlacementConstraints != nil {
		objectMap["placementConstraints"] = ssup.PlacementConstraints
	}
	if ssup.CorrelationScheme != nil {
		objectMap["correlationScheme"] = ssup.CorrelationScheme
	}
	if ssup.ServiceLoadMetrics != nil {
		objectMap["serviceLoadMetrics"] = ssup.ServiceLoadMetrics
	}
	if ssup.ServicePlacementPolicies != nil {
		objectMap["servicePlacementPolicies"] = ssup.ServicePlacementPolicies
	}
	if ssup.DefaultMoveCost != "" {
		objectMap["defaultMoveCost"] = ssup.DefaultMoveCost
	}
	return json.Marshal(objectMap)
}

// AsStatefulServiceUpdateProperties is the BasicServiceResourceUpdateProperties implementation for StatefulServiceUpdateProperties.
func (ssup StatefulServiceUpdateProperties) AsStatefulServiceUpdateProperties() (*StatefulServiceUpdateProperties, bool) {
	return &ssup, true
}

// AsStatelessServiceUpdateProperties is the BasicServiceResourceUpdateProperties implementation for StatefulServiceUpdateProperties.
func (ssup StatefulServiceUpdateProperties) AsStatelessServiceUpdateProperties() (*StatelessServiceUpdateProperties, bool) {
	return nil, false
}

// AsServiceResourceUpdateProperties is the BasicServiceResourceUpdateProperties implementation for StatefulServiceUpdateProperties.
func (ssup StatefulServiceUpdateProperties) AsServiceResourceUpdateProperties() (*ServiceResourceUpdateProperties, bool) {
	return nil, false
}

// AsBasicServiceResourceUpdateProperties is the BasicServiceResourceUpdateProperties implementation for StatefulServiceUpdateProperties.
func (ssup StatefulServiceUpdateProperties) AsBasicServiceResourceUpdateProperties() (BasicServiceResourceUpdateProperties, bool) {
	return &ssup, true
}

// UnmarshalJSON is the custom unmarshaler for StatefulServiceUpdateProperties struct.
func (ssup *StatefulServiceUpdateProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "targetReplicaSetSize":
			if v != nil {
				var targetReplicaSetSize int32
				err = json.Unmarshal(*v, &targetReplicaSetSize)
				if err != nil {
					return err
				}
				ssup.TargetReplicaSetSize = &targetReplicaSetSize
			}
		case "minReplicaSetSize":
			if v != nil {
				var minReplicaSetSize int32
				err = json.Unmarshal(*v, &minReplicaSetSize)
				if err != nil {
					return err
				}
				ssup.MinReplicaSetSize = &minReplicaSetSize
			}
		case "replicaRestartWaitDuration":
			if v != nil {
				var replicaRestartWaitDuration date.Time
				err = json.Unmarshal(*v, &replicaRestartWaitDuration)
				if err != nil {
					return err
				}
				ssup.ReplicaRestartWaitDuration = &replicaRestartWaitDuration
			}
		case "quorumLossWaitDuration":
			if v != nil {
				var quorumLossWaitDuration date.Time
				err = json.Unmarshal(*v, &quorumLossWaitDuration)
				if err != nil {
					return err
				}
				ssup.QuorumLossWaitDuration = &quorumLossWaitDuration
			}
		case "standByReplicaKeepDuration":
			if v != nil {
				var standByReplicaKeepDuration date.Time
				err = json.Unmarshal(*v, &standByReplicaKeepDuration)
				if err != nil {
					return err
				}
				ssup.StandByReplicaKeepDuration = &standByReplicaKeepDuration
			}
		case "serviceKind":
			if v != nil {
				var serviceKind ServiceKindBasicServiceResourceUpdateProperties
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				ssup.ServiceKind = serviceKind
			}
		case "placementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				ssup.PlacementConstraints = &placementConstraints
			}
		case "correlationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				ssup.CorrelationScheme = &correlationScheme
			}
		case "serviceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				ssup.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "servicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				ssup.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "defaultMoveCost":
			if v != nil {
				var defaultMoveCost MoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				ssup.DefaultMoveCost = defaultMoveCost
			}
		}
	}

	return nil
}

// StatelessServiceProperties the properties of a stateless service resource.
type StatelessServiceProperties struct {
	// InstanceCount - The instance count.
	InstanceCount *int32 `json:"instanceCount,omitempty"`
	// ProvisioningState - READ-ONLY; The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ServiceTypeName - The name of the service type
	ServiceTypeName *string `json:"serviceTypeName,omitempty"`
	// PartitionDescription - Describes how the service is partitioned.
	PartitionDescription BasicPartitionSchemeDescription `json:"partitionDescription,omitempty"`
	// ServicePackageActivationMode - The activation Mode of the service package. Possible values include: 'SharedProcess', 'ExclusiveProcess'
	ServicePackageActivationMode ArmServicePackageActivationMode `json:"servicePackageActivationMode,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindServiceResourceProperties', 'ServiceKindStateful1', 'ServiceKindStateless1'
	ServiceKind ServiceKindBasicServiceResourceProperties `json:"serviceKind,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string `json:"placementConstraints,omitempty"`
	// CorrelationScheme - A list that describes the correlation of the service with other services.
	CorrelationScheme *[]ServiceCorrelationDescription `json:"correlationScheme,omitempty"`
	// ServiceLoadMetrics - The service load metrics is given as an array of ServiceLoadMetricDescription objects.
	ServiceLoadMetrics *[]ServiceLoadMetricDescription `json:"serviceLoadMetrics,omitempty"`
	// ServicePlacementPolicies - A list that describes the correlation of the service with other services.
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"servicePlacementPolicies,omitempty"`
	// DefaultMoveCost - Specifies the move cost for the service. Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost MoveCost `json:"defaultMoveCost,omitempty"`
}

// MarshalJSON is the custom marshaler for StatelessServiceProperties.
func (ssp StatelessServiceProperties) MarshalJSON() ([]byte, error) {
	ssp.ServiceKind = ServiceKindStateless1
	objectMap := make(map[string]interface{})
	if ssp.InstanceCount != nil {
		objectMap["instanceCount"] = ssp.InstanceCount
	}
	if ssp.ServiceTypeName != nil {
		objectMap["serviceTypeName"] = ssp.ServiceTypeName
	}
	objectMap["partitionDescription"] = ssp.PartitionDescription
	if ssp.ServicePackageActivationMode != "" {
		objectMap["servicePackageActivationMode"] = ssp.ServicePackageActivationMode
	}
	if ssp.ServiceKind != "" {
		objectMap["serviceKind"] = ssp.ServiceKind
	}
	if ssp.PlacementConstraints != nil {
		objectMap["placementConstraints"] = ssp.PlacementConstraints
	}
	if ssp.CorrelationScheme != nil {
		objectMap["correlationScheme"] = ssp.CorrelationScheme
	}
	if ssp.ServiceLoadMetrics != nil {
		objectMap["serviceLoadMetrics"] = ssp.ServiceLoadMetrics
	}
	if ssp.ServicePlacementPolicies != nil {
		objectMap["servicePlacementPolicies"] = ssp.ServicePlacementPolicies
	}
	if ssp.DefaultMoveCost != "" {
		objectMap["defaultMoveCost"] = ssp.DefaultMoveCost
	}
	return json.Marshal(objectMap)
}

// AsStatefulServiceProperties is the BasicServiceResourceProperties implementation for StatelessServiceProperties.
func (ssp StatelessServiceProperties) AsStatefulServiceProperties() (*StatefulServiceProperties, bool) {
	return nil, false
}

// AsStatelessServiceProperties is the BasicServiceResourceProperties implementation for StatelessServiceProperties.
func (ssp StatelessServiceProperties) AsStatelessServiceProperties() (*StatelessServiceProperties, bool) {
	return &ssp, true
}

// AsServiceResourceProperties is the BasicServiceResourceProperties implementation for StatelessServiceProperties.
func (ssp StatelessServiceProperties) AsServiceResourceProperties() (*ServiceResourceProperties, bool) {
	return nil, false
}

// AsBasicServiceResourceProperties is the BasicServiceResourceProperties implementation for StatelessServiceProperties.
func (ssp StatelessServiceProperties) AsBasicServiceResourceProperties() (BasicServiceResourceProperties, bool) {
	return &ssp, true
}

// UnmarshalJSON is the custom unmarshaler for StatelessServiceProperties struct.
func (ssp *StatelessServiceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "instanceCount":
			if v != nil {
				var instanceCount int32
				err = json.Unmarshal(*v, &instanceCount)
				if err != nil {
					return err
				}
				ssp.InstanceCount = &instanceCount
			}
		case "provisioningState":
			if v != nil {
				var provisioningState string
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				ssp.ProvisioningState = &provisioningState
			}
		case "serviceTypeName":
			if v != nil {
				var serviceTypeName string
				err = json.Unmarshal(*v, &serviceTypeName)
				if err != nil {
					return err
				}
				ssp.ServiceTypeName = &serviceTypeName
			}
		case "partitionDescription":
			if v != nil {
				partitionDescription, err := unmarshalBasicPartitionSchemeDescription(*v)
				if err != nil {
					return err
				}
				ssp.PartitionDescription = partitionDescription
			}
		case "servicePackageActivationMode":
			if v != nil {
				var servicePackageActivationMode ArmServicePackageActivationMode
				err = json.Unmarshal(*v, &servicePackageActivationMode)
				if err != nil {
					return err
				}
				ssp.ServicePackageActivationMode = servicePackageActivationMode
			}
		case "serviceKind":
			if v != nil {
				var serviceKind ServiceKindBasicServiceResourceProperties
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				ssp.ServiceKind = serviceKind
			}
		case "placementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				ssp.PlacementConstraints = &placementConstraints
			}
		case "correlationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				ssp.CorrelationScheme = &correlationScheme
			}
		case "serviceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				ssp.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "servicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				ssp.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "defaultMoveCost":
			if v != nil {
				var defaultMoveCost MoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				ssp.DefaultMoveCost = defaultMoveCost
			}
		}
	}

	return nil
}

// StatelessServiceUpdateProperties the properties of a stateless service resource for patch operations.
type StatelessServiceUpdateProperties struct {
	// InstanceCount - The instance count.
	InstanceCount *int32 `json:"instanceCount,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicServiceResourceUpdatePropertiesServiceKindServiceResourceUpdateProperties', 'ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateful', 'ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateless'
	ServiceKind ServiceKindBasicServiceResourceUpdateProperties `json:"serviceKind,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string `json:"placementConstraints,omitempty"`
	// CorrelationScheme - A list that describes the correlation of the service with other services.
	CorrelationScheme *[]ServiceCorrelationDescription `json:"correlationScheme,omitempty"`
	// ServiceLoadMetrics - The service load metrics is given as an array of ServiceLoadMetricDescription objects.
	ServiceLoadMetrics *[]ServiceLoadMetricDescription `json:"serviceLoadMetrics,omitempty"`
	// ServicePlacementPolicies - A list that describes the correlation of the service with other services.
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"servicePlacementPolicies,omitempty"`
	// DefaultMoveCost - Specifies the move cost for the service. Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost MoveCost `json:"defaultMoveCost,omitempty"`
}

// MarshalJSON is the custom marshaler for StatelessServiceUpdateProperties.
func (ssup StatelessServiceUpdateProperties) MarshalJSON() ([]byte, error) {
	ssup.ServiceKind = ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateless
	objectMap := make(map[string]interface{})
	if ssup.InstanceCount != nil {
		objectMap["instanceCount"] = ssup.InstanceCount
	}
	if ssup.ServiceKind != "" {
		objectMap["serviceKind"] = ssup.ServiceKind
	}
	if ssup.PlacementConstraints != nil {
		objectMap["placementConstraints"] = ssup.PlacementConstraints
	}
	if ssup.CorrelationScheme != nil {
		objectMap["correlationScheme"] = ssup.CorrelationScheme
	}
	if ssup.ServiceLoadMetrics != nil {
		objectMap["serviceLoadMetrics"] = ssup.ServiceLoadMetrics
	}
	if ssup.ServicePlacementPolicies != nil {
		objectMap["servicePlacementPolicies"] = ssup.ServicePlacementPolicies
	}
	if ssup.DefaultMoveCost != "" {
		objectMap["defaultMoveCost"] = ssup.DefaultMoveCost
	}
	return json.Marshal(objectMap)
}

// AsStatefulServiceUpdateProperties is the BasicServiceResourceUpdateProperties implementation for StatelessServiceUpdateProperties.
func (ssup StatelessServiceUpdateProperties) AsStatefulServiceUpdateProperties() (*StatefulServiceUpdateProperties, bool) {
	return nil, false
}

// AsStatelessServiceUpdateProperties is the BasicServiceResourceUpdateProperties implementation for StatelessServiceUpdateProperties.
func (ssup StatelessServiceUpdateProperties) AsStatelessServiceUpdateProperties() (*StatelessServiceUpdateProperties, bool) {
	return &ssup, true
}

// AsServiceResourceUpdateProperties is the BasicServiceResourceUpdateProperties implementation for StatelessServiceUpdateProperties.
func (ssup StatelessServiceUpdateProperties) AsServiceResourceUpdateProperties() (*ServiceResourceUpdateProperties, bool) {
	return nil, false
}

// AsBasicServiceResourceUpdateProperties is the BasicServiceResourceUpdateProperties implementation for StatelessServiceUpdateProperties.
func (ssup StatelessServiceUpdateProperties) AsBasicServiceResourceUpdateProperties() (BasicServiceResourceUpdateProperties, bool) {
	return &ssup, true
}

// UnmarshalJSON is the custom unmarshaler for StatelessServiceUpdateProperties struct.
func (ssup *StatelessServiceUpdateProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "instanceCount":
			if v != nil {
				var instanceCount int32
				err = json.Unmarshal(*v, &instanceCount)
				if err != nil {
					return err
				}
				ssup.InstanceCount = &instanceCount
			}
		case "serviceKind":
			if v != nil {
				var serviceKind ServiceKindBasicServiceResourceUpdateProperties
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				ssup.ServiceKind = serviceKind
			}
		case "placementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				ssup.PlacementConstraints = &placementConstraints
			}
		case "correlationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				ssup.CorrelationScheme = &correlationScheme
			}
		case "serviceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				ssup.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "servicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				ssup.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "defaultMoveCost":
			if v != nil {
				var defaultMoveCost MoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				ssup.DefaultMoveCost = defaultMoveCost
			}
		}
	}

	return nil
}

// UniformInt64RangePartitionSchemeDescription describes a partitioning scheme where an integer range is
// allocated evenly across a number of partitions.
type UniformInt64RangePartitionSchemeDescription struct {
	// Count - The number of partitions.
	Count *int32 `json:"Count,omitempty"`
	// LowKey - String indicating the lower bound of the partition key range that
	// should be split between the partition ‘Count’
	LowKey *string `json:"LowKey,omitempty"`
	// HighKey - String indicating the upper bound of the partition key range that
	// should be split between the partition ‘Count’
	HighKey *string `json:"HighKey,omitempty"`
	// PartitionScheme - Possible values include: 'PartitionSchemePartitionSchemeDescription', 'PartitionSchemeNamed', 'PartitionSchemeSingleton', 'PartitionSchemeUniformInt64Range'
	PartitionScheme PartitionSchemeBasicPartitionSchemeDescription `json:"partitionScheme,omitempty"`
}

// MarshalJSON is the custom marshaler for UniformInt64RangePartitionSchemeDescription.
func (ui6rpsd UniformInt64RangePartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	ui6rpsd.PartitionScheme = PartitionSchemeUniformInt64Range
	objectMap := make(map[string]interface{})
	if ui6rpsd.Count != nil {
		objectMap["Count"] = ui6rpsd.Count
	}
	if ui6rpsd.LowKey != nil {
		objectMap["LowKey"] = ui6rpsd.LowKey
	}
	if ui6rpsd.HighKey != nil {
		objectMap["HighKey"] = ui6rpsd.HighKey
	}
	if ui6rpsd.PartitionScheme != "" {
		objectMap["partitionScheme"] = ui6rpsd.PartitionScheme
	}
	return json.Marshal(objectMap)
}

// AsNamedPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for UniformInt64RangePartitionSchemeDescription.
func (ui6rpsd UniformInt64RangePartitionSchemeDescription) AsNamedPartitionSchemeDescription() (*NamedPartitionSchemeDescription, bool) {
	return nil, false
}

// AsSingletonPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for UniformInt64RangePartitionSchemeDescription.
func (ui6rpsd UniformInt64RangePartitionSchemeDescription) AsSingletonPartitionSchemeDescription() (*SingletonPartitionSchemeDescription, bool) {
	return nil, false
}

// AsUniformInt64RangePartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for UniformInt64RangePartitionSchemeDescription.
func (ui6rpsd UniformInt64RangePartitionSchemeDescription) AsUniformInt64RangePartitionSchemeDescription() (*UniformInt64RangePartitionSchemeDescription, bool) {
	return &ui6rpsd, true
}

// AsPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for UniformInt64RangePartitionSchemeDescription.
func (ui6rpsd UniformInt64RangePartitionSchemeDescription) AsPartitionSchemeDescription() (*PartitionSchemeDescription, bool) {
	return nil, false
}

// AsBasicPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for UniformInt64RangePartitionSchemeDescription.
func (ui6rpsd UniformInt64RangePartitionSchemeDescription) AsBasicPartitionSchemeDescription() (BasicPartitionSchemeDescription, bool) {
	return &ui6rpsd, true
}
