indexing

	description:

		"Scanners for Lace parsers"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 1999-2003, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/06/01 17:16:47 $"
	revision: "$Revision: 1.7 $"

class ET_LACE_SCANNER

inherit

	ET_LACE_SCANNER_SKELETON

creation

	make

feature -- Status report

	valid_start_condition (sc: INTEGER): BOOLEAN is
			-- Is `sc' a valid start condition?
		do
			Result := (INITIAL <= sc and sc <= IN_STR)
		end

feature {NONE} -- Implementation

	yy_build_tables is
			-- Build scanner tables.
		do
			yy_nxt ?= yy_nxt_template
			yy_chk ?= yy_chk_template
			yy_base ?= yy_base_template
			yy_def ?= yy_def_template
			yy_ec ?= yy_ec_template
			yy_meta ?= yy_meta_template
			yy_accept ?= yy_accept_template
		end

	yy_execute_action (yy_act: INTEGER) is
			-- Execute semantic action.
		do
if yy_act <= 28 then
if yy_act <= 14 then
if yy_act <= 7 then
if yy_act <= 4 then
if yy_act <= 2 then
if yy_act = 1 then
--|#line 32 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 32")
end
-- Ignore separators
else
--|#line 33 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 33")
end
eif_lineno := eif_lineno + text_count
end
else
if yy_act = 3 then
--|#line 38 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 38")
end
-- Ignore comments
else
--|#line 39 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 39")
end
eif_lineno := eif_lineno + 1
end
end
else
if yy_act <= 6 then
if yy_act = 5 then
--|#line 44 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 44")
end
last_token := Semicolon_code
else
--|#line 45 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 45")
end
last_token := Colon_code
end
else
--|#line 46 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 46")
end
last_token := Comma_code
end
end
else
if yy_act <= 11 then
if yy_act <= 9 then
if yy_act = 8 then
--|#line 47 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 47")
end
last_token := Left_parenthesis_code
else
--|#line 48 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 48")
end
last_token := Right_parenthesis_code
end
else
if yy_act = 10 then
--|#line 53 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 53")
end
last_token := L_ABSTRACT
else
--|#line 54 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 54")
end
last_token := L_ALL
end
end
else
if yy_act <= 13 then
if yy_act = 12 then
--|#line 55 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 55")
end
last_token := L_CLUSTER
else
--|#line 56 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 56")
end
last_token := L_DEFAULT
end
else
--|#line 57 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 57")
end
last_token := L_END
end
end
end
else
if yy_act <= 21 then
if yy_act <= 18 then
if yy_act <= 16 then
if yy_act = 15 then
--|#line 58 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 58")
end
last_token := L_EXCLUDE
else
--|#line 59 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 59")
end
last_token := L_EXTERNAL
end
else
if yy_act = 17 then
--|#line 60 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 60")
end
last_token := L_GENERATE
else
--|#line 61 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 61")
end
last_token := L_LIBRARY
end
end
else
if yy_act <= 20 then
if yy_act = 19 then
--|#line 62 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 62")
end
last_token := L_OPTION
else
--|#line 63 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 63")
end
last_token := L_ROOT
end
else
--|#line 64 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 64")
end
last_token := L_SYSTEM
end
end
else
if yy_act <= 25 then
if yy_act <= 23 then
if yy_act = 22 then
--|#line 69 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 69")
end

				last_token := L_IDENTIFIER
				last_et_identifier_value := new_identifier (text)
			
else
--|#line 77 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 77")
end

				last_token := L_STRERR
			
end
else
if yy_act = 24 then
--|#line 80 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 80")
end

				last_token := L_STRING
				last_et_identifier_value := new_identifier (text_substring (2, text_count - 1))
			
else
--|#line 84 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 84")
end

				if text_count > 1 then
					eif_buffer.append_string (text_substring (2, text_count))
				end
				set_start_condition (IN_STR)
			
end
end
else
if yy_act <= 27 then
if yy_act = 26 then
--|#line 90 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 90")
end
eif_buffer.append_string (text)
else
--|#line 91 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 91")
end
eif_buffer.append_character ('%A')
end
else
--|#line 92 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 92")
end
eif_buffer.append_character ('%B')
end
end
end
end
else
if yy_act <= 42 then
if yy_act <= 35 then
if yy_act <= 32 then
if yy_act <= 30 then
if yy_act = 29 then
--|#line 93 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 93")
end
eif_buffer.append_character ('%C')
else
--|#line 94 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 94")
end
eif_buffer.append_character ('%D')
end
else
if yy_act = 31 then
--|#line 95 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 95")
end
eif_buffer.append_character ('%F')
else
--|#line 96 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 96")
end
eif_buffer.append_character ('%H')
end
end
else
if yy_act <= 34 then
if yy_act = 33 then
--|#line 97 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 97")
end
eif_buffer.append_character ('%L')
else
--|#line 98 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 98")
end
eif_buffer.append_character ('%N')
end
else
--|#line 99 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 99")
end
eif_buffer.append_character ('%Q')
end
end
else
if yy_act <= 39 then
if yy_act <= 37 then
if yy_act = 36 then
--|#line 100 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 100")
end
eif_buffer.append_character ('%R')
else
--|#line 101 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 101")
end
eif_buffer.append_character ('%S')
end
else
if yy_act = 38 then
--|#line 102 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 102")
end
eif_buffer.append_character ('%T')
else
--|#line 103 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 103")
end
eif_buffer.append_character ('%U')
end
end
else
if yy_act <= 41 then
if yy_act = 40 then
--|#line 104 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 104")
end
eif_buffer.append_character ('%V')
else
--|#line 105 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 105")
end
eif_buffer.append_character ('%%')
end
else
--|#line 106 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 106")
end
eif_buffer.append_character ('%'')
end
end
end
else
if yy_act <= 49 then
if yy_act <= 46 then
if yy_act <= 44 then
if yy_act = 43 then
--|#line 107 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 107")
end
eif_buffer.append_character ('%"')
else
--|#line 108 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 108")
end
eif_buffer.append_character ('%(')
end
else
if yy_act = 45 then
--|#line 109 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 109")
end
eif_buffer.append_character ('%)')
else
--|#line 110 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 110")
end
eif_buffer.append_character ('%<')
end
end
else
if yy_act <= 48 then
if yy_act = 47 then
--|#line 111 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 111")
end
eif_buffer.append_character ('%>')
else
--|#line 112 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 112")
end

			code_ := text_substring (3, text_count - 1).to_integer
			if (code_ > Platform.Maximum_character_code) then
				last_token := L_STRERR
				set_start_condition (INITIAL)
			else
				eif_buffer.append_character (INTEGER_.to_character (code_))
			end
		
end
else
--|#line 125 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 125")
end
eif_lineno := eif_lineno + 1
end
end
else
if yy_act <= 53 then
if yy_act <= 51 then
if yy_act = 50 then
--|#line 126 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 126")
end

			if text_count > 1 then
				eif_buffer.append_string (text_substring (1, text_count - 1))
			end
			if eif_buffer.count > 0 then
				last_token := L_STRING
				str_ := STRING_.make (eif_buffer.count)
				str_.append_string (eif_buffer)
				eif_buffer.wipe_out
				last_et_identifier_value := new_identifier (str_)
			else
				last_token := L_STRERR
			end
			set_start_condition (INITIAL)
		
else
--|#line 143 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 143")
end
eif_buffer.append_character (text_item (2))
end
else
if yy_act = 52 then
--|#line 145 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 145")
end
	-- Catch-all rules (no backing up)
							last_token := L_STRERR
							set_start_condition (INITIAL)
						
else
--|#line 146 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 146")
end
	-- Catch-all rules (no backing up)
							last_token := L_STRERR
							set_start_condition (INITIAL)
						
end
end
else
if yy_act <= 55 then
if yy_act = 54 then
--|#line 147 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 147")
end
	-- Catch-all rules (no backing up)
							last_token := L_STRERR
							set_start_condition (INITIAL)
						
else
--|#line 157 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 157")
end
last_token := text_item (1).code
end
else
--|#line 0 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 0")
end
last_token := yyError_token
fatal_error ("scanner jammed")
end
end
end
end
end
		end

	yy_execute_eof_action (yy_sc: INTEGER) is
			-- Execute EOF semantic action.
		do
			inspect yy_sc
when 0 then
--|#line 0 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 0")
end
terminate
when 1 then
--|#line 0 "et_lace_scanner.l"
debug ("GELEX")
	std.error.put_line ("Executing scanner user-code from file 'et_lace_scanner.l' at line 0")
end
	-- Catch-all rules (no backing up)
							last_token := L_STRERR
							set_start_condition (INITIAL)
						
			else
				terminate
			end
		end

feature {NONE} -- Table templates

	yy_nxt_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    6,    7,    8,    9,    6,    6,   10,   11,   12,
			   13,    6,    6,   14,   15,    6,    6,   16,   17,   18,
			   19,   20,   17,   21,   17,   17,   17,   22,   17,   17,
			   23,   17,   17,   24,   25,   17,   17,   17,   17,   17,
			    6,   16,   17,   18,   19,   17,   22,   17,   24,   25,
			   17,   17,   27,   28,   29,   27,   28,   29,   36,   38,
			   76,   40,   77,   88,   51,   78,   83,   37,   85,   51,
			   41,   35,   89,   88,   51,   76,  101,   90,   38,   40,
			   78,   77,   36,   85,   83,  129,   37,   49,   50,   51,
			   52,   53,   54,   55,   56,   49,   49,   57,   49,   49,

			   49,   58,   59,   60,   61,   62,   63,   49,   64,   49,
			   65,   49,   49,   66,   49,   67,   49,   49,   68,   69,
			   70,   71,   72,   73,   49,   49,   49,   49,   49,   49,
			   49,   49,   49,   49,   49,   49,   49,   49,   79,   80,
			   81,   84,   87,   91,   92,   93,  126,   94,   26,   26,
			   26,  123,   97,   99,  108,  100,   82,   87,   91,   92,
			  102,   79,  103,   80,   81,   84,   94,   97,   99,   93,
			  100,   82,  104,  105,  106,  102,  107,  103,  108,  111,
			  113,  114,  115,  116,  118,  120,  117,  104,  105,  106,
			  124,  107,  119,  121,  128,  122,  125,  127,  112,  113,

			  115,  117,  118,  111,   32,  114,   32,  116,  121,  120,
			  122,  125,  127,  128,  124,   47,  110,   47,   34,   34,
			   34,  109,   98,   96,   95,   75,   90,   48,   86,   75,
			   74,   31,   30,   48,   46,   45,   44,   43,   42,   39,
			   34,   33,   31,   30,  130,    5,  130,  130,  130,  130,
			  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
			  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
			  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
			  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
			  130,  130,  130,  130,  130,  130,  130>>)
		end

	yy_chk_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    3,    3,    3,    4,    4,    4,   16,   18,
			   36,   20,   37,   50,   50,   38,   42,   16,   44,   51,
			   20,  133,   51,   88,   88,   36,   90,   90,   18,   20,
			   38,   37,   16,   44,   42,  125,   16,   29,   29,   29,
			   29,   29,   29,   29,   29,   29,   29,   29,   29,   29,

			   29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
			   29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
			   29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
			   29,   29,   29,   29,   29,   29,   29,   29,   39,   40,
			   41,   43,   46,   76,   78,   79,  117,   81,  131,  131,
			  131,  114,   84,   86,   97,   87,   41,   46,   76,   78,
			   91,   39,   92,   40,   41,   43,   81,   84,   86,   79,
			   87,   41,   93,   94,   95,   91,   96,   92,   97,  102,
			  104,  105,  106,  107,  109,  111,  108,   93,   94,   95,
			  115,   96,  110,  112,  124,  113,  116,  120,  103,  104,

			  106,  108,  109,  102,  132,  105,  132,  107,  112,  111,
			  113,  116,  120,  124,  115,  134,  100,  134,  135,  135,
			  135,   98,   85,   83,   82,   75,   57,   47,   45,   34,
			   32,   31,   30,   26,   25,   24,   23,   22,   21,   19,
			   13,    9,    8,    7,    5,  130,  130,  130,  130,  130,
			  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
			  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
			  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
			  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
			  130,  130,  130,  130,  130,  130,  130>>)
		end

	yy_base_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    0,    0,   49,   52,  244,  245,  241,  239,  237,
			  245,  245,  245,  230,  245,  245,   40,    0,   32,  218,
			   32,  217,  212,  205,  205,  195,  229,  245,  245,   86,
			  230,  228,  226,  245,  226,    0,   26,   35,   29,  116,
			  119,  121,   37,  123,   33,  198,  108,  223,  245,  245,
			   61,   67,  245,  245,  245,  245,  245,  214,  245,  245,
			  245,  245,  245,  245,  245,  245,  245,  245,  245,  245,
			  245,  245,  245,  245,  245,  223,  108,    0,  110,  128,
			    0,  120,  203,  202,  119,  197,  118,  120,   71,  245,
			   65,  127,  127,  136,  137,  141,  143,  137,  191,    0,

			  195,  245,  162,  177,  153,  161,  153,  166,  153,  155,
			  164,  166,  160,  160,  130,  173,  161,  107,    0,    0,
			  162,    0,    0,    0,  167,   64,    0,    0,    0,    0,
			  245,  147,  203,   68,  214,  217>>)
		end

	yy_def_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,  130,    1,  131,  131,  130,  130,  130,  130,  132,
			  130,  130,  130,  130,  130,  130,  133,  133,  133,  133,
			  133,  133,  133,  133,  133,  133,  134,  130,  130,  130,
			  130,  130,  132,  130,  135,  133,  133,  133,  133,  133,
			  133,  133,  133,  133,  133,  133,  133,  134,  130,  130,
			  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
			  130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
			  130,  130,  130,  130,  130,  130,  133,  133,  133,  133,
			  133,  133,  133,  133,  133,  133,  133,  133,  130,  130,
			  130,  133,  133,  133,  133,  133,  133,  133,  133,  133,

			  133,  130,  133,  133,  133,  133,  133,  133,  133,  133,
			  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,
			  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,
			    0,  130,  130,  130,  130,  130>>)
		end

	yy_ec_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    2,
			    3,    1,    1,    2,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    2,    1,    4,    1,    1,    5,    1,    6,
			    7,    8,    1,    1,    9,   10,    1,   11,   12,   12,
			   12,   12,   12,   12,   12,   12,   12,   12,   13,   14,
			   15,    1,   16,    1,    1,   17,   18,   19,   20,   21,
			   22,   23,   24,   25,   26,   26,   27,   28,   29,   30,
			   31,   32,   33,   34,   35,   36,   37,   26,   38,   39,
			   26,    1,    1,    1,    1,   40,    1,   41,   42,   43,

			   44,   21,   45,   23,   26,   25,   26,   26,   46,   28,
			   47,   30,   31,   26,   48,   49,   50,   51,   26,   26,
			   38,   39,   26,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1>>)
		end

	yy_meta_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    2,    1,    2,    1,    1,    1,    1,
			    1,    1,    3,    1,    1,    1,    1,    3,    3,    3,
			    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
			    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
			    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
			    3,    3>>)
		end

	yy_accept_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    0,    0,    0,    0,   57,   55,    1,    2,   25,
			    8,    9,    7,   55,    6,    5,   22,   22,   22,   22,
			   22,   22,   22,   22,   22,   22,   26,   52,   50,   52,
			    1,    2,   25,   23,    3,   22,   22,   22,   22,   22,
			   22,   22,   22,   22,   22,   22,   22,   26,   50,   51,
			   51,   53,   43,   41,   42,   44,   45,   51,   46,   47,
			   27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
			   37,   38,   39,   40,   24,    4,   22,   11,   22,   22,
			   14,   22,   22,   22,   22,   22,   22,   22,    0,   49,
			   54,   22,   22,   22,   22,   22,   22,   22,   22,   20,

			   22,   48,   22,   22,   22,   22,   22,   22,   22,   22,
			   22,   22,   22,   22,   22,   22,   22,   22,   19,   21,
			   22,   12,   13,   15,   22,   22,   18,   10,   16,   17,
			    0>>)
		end

feature {NONE} -- Constants

	yyJam_base: INTEGER is 245
			-- Position in `yy_nxt'/`yy_chk' tables
			-- where default jam table starts

	yyJam_state: INTEGER is 130
			-- State id corresponding to jam state

	yyTemplate_mark: INTEGER is 131
			-- Mark between normal states and templates

	yyNull_equiv_class: INTEGER is 1
			-- Equivalence code for NULL character

	yyReject_used: BOOLEAN is false
			-- Is `reject' called?

	yyVariable_trail_context: BOOLEAN is false
			-- Is there a regular expression with
			-- both leading and trailing parts having
			-- variable length?

	yyReject_or_variable_trail_context: BOOLEAN is false
			-- Is `reject' called or is there a
			-- regular expression with both leading
			-- and trailing parts having variable length?

	yyNb_rules: INTEGER is 56
			-- Number of rules

	yyEnd_of_buffer: INTEGER is 57
			-- End of buffer rule code

	yyLine_used: BOOLEAN is false
			-- Are line and column numbers used?

	yyPosition_used: BOOLEAN is false
			-- Is `position' used?

	INITIAL: INTEGER is 0
	IN_STR: INTEGER is 1
			-- Start condition codes

feature -- User-defined features



end
