indexing

	description:

		"Eiffel deferred-procedures"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 1999-2002, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/10/21 16:05:06 $"
	revision: "$Revision: 1.11 $"

class ET_DEFERRED_PROCEDURE

inherit

	ET_PROCEDURE
		undefine
			is_deferred
		end

	ET_DEFERRED_ROUTINE

creation

	make

feature {NONE} -- Initialization

	make (a_name: like name_item; args: like arguments; an_obsolete: like obsolete_message;
		a_preconditions: like preconditions; a_postconditions: like postconditions;
		a_clients: like clients; a_class: like implementation_class) is
			-- Create a new deferred procedure.
		require
			a_name_not_void: a_name /= Void
			a_clients_not_void: a_clients /= Void
			a_class_not_void: a_class /= Void
		do
			name_item := a_name
			arguments := args
			is_keyword := tokens.is_keyword
			obsolete_message := an_obsolete
			preconditions := a_preconditions
			deferred_keyword := tokens.deferred_keyword
			postconditions := a_postconditions
			end_keyword := tokens.end_keyword
			clients := a_clients
			implementation_class := a_class
		ensure
			name_item_set: name_item = a_name
			arguments_set: arguments = args
			obsolete_message_set: obsolete_message = an_obsolete
			preconditions_set: preconditions = a_preconditions
			postconditions_set: postconditions = a_postconditions
			clients_set: clients = a_clients
			implementation_class_set: implementation_class = a_class
		end

feature -- Duplication

	new_synonym (a_name: like name_item): like Current is
			-- Synonym feature
		do
			create Result.make (a_name, arguments, obsolete_message, preconditions,
				postconditions, clients, implementation_class)
			Result.set_is_keyword (is_keyword)
			Result.set_deferred_keyword (deferred_keyword)
			Result.set_end_keyword (end_keyword)
			Result.set_semicolon (semicolon)
			Result.set_feature_clause (feature_clause)
			Result.set_synonym (Current)
		end

feature -- Conversion

	renamed_feature (a_name: like name): like Current is
			-- Renamed version of current feature
		do
			create Result.make (a_name, arguments, obsolete_message, preconditions,
				postconditions, clients, implementation_class)
			Result.set_is_keyword (is_keyword)
			Result.set_deferred_keyword (deferred_keyword)
			Result.set_end_keyword (end_keyword)
			Result.set_version (version)
			Result.set_frozen_keyword (frozen_keyword)
			Result.set_semicolon (semicolon)
			Result.set_feature_clause (feature_clause)
			Result.set_first_seed (first_seed)
			Result.set_other_seeds (other_seeds)
			Result.set_cat_keyword (cat_keyword)
		end

feature -- Processing

	process (a_processor: ET_AST_PROCESSOR) is
			-- Process current node.
		do
			a_processor.process_deferred_procedure (Current)
		end

end
