indexing

	description:

		"Routines that ought to be in class CHARACTER"

	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 2002, Berend de Boer and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 12:49:18 $"
	revision: "$Revision: 1.3 $"

class KL_CHARACTER_ROUTINES

inherit

	KL_SHARED_PLATFORM

feature -- Access

	next (c: CHARACTER): CHARACTER is
			-- Next character
		require
			c_small_enough: c.code < Platform.Maximum_character_code
		do



			Result := c.next

		ensure
			definition: Result.code = c.code + 1
		end

	previous (c: CHARACTER): CHARACTER is
			-- Previous character
		require
			c_small_enough: c.code > Platform.Minimum_character_code
		do



			Result := c.previous

		ensure
			definition: Result.code = c.code - 1
		end

	as_lower (c: CHARACTER): CHARACTER is
			-- Lower-case version of character `c'
		do

			Result := c.lower







		end

	as_upper (c: CHARACTER): CHARACTER is
			-- Upper-case version of character `c'
		do

			Result := c.upper







		end

end
