indexing

	description:

		"Character buffers"

	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 2001, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/04/06 17:49:41 $"
	revision: "$Revision: 1.11 $"

class KL_CHARACTER_BUFFER

inherit

	KI_CHARACTER_BUFFER

		undefine
			copy, is_equal, out

		redefine

			as_special,


			append_substring_to_string,

			fill_from_string, fill_from_stream,
			move_left, move_right
		end


	STRING
		rename
			make as string_make,
			make_from_string as string_make_from_string,
			put as string_put,
			item as string_item,
			substring as string_substring,
			count as string_count,
			resize as string_resize,
			area as string_area
		end

	KL_SHARED_OPERATING_SYSTEM
		export
			{NONE} all
		undefine
			copy, is_equal, out
		end


creation

	make, make_from_string

feature {NONE} -- Initialization

	make (n: INTEGER) is
			-- Create a new character buffer being able
			-- to contain `n' characters.
		do

			string_make (n)
			set_count (n)














		end

feature -- Access

	item (i: INTEGER): CHARACTER is
			-- Item at position `i'
		do

			Result := string_item (i)



		end

	substring (s, e: INTEGER): STRING is
			-- New string made up of characters held in
			-- buffer between indexes `s' and `e'

		local
			nb: INTEGER








		do
			if e < s then
					-- Empty string



				create Result.make (0)

			else

				nb := e - s + 1
				create Result.make (nb)
				Result.set_count (nb)
				Result.subcopy (Current, s, e, 1)





















			end
		end

feature -- Measurement





	count: INTEGER is
			-- Number of characters in buffer
		do

			Result := string_count



		end



feature -- Conversion

	as_special: SPECIAL [CHARACTER] is
			-- 'SPECIAL [CHARACTER]' version of current character buffer;
			-- May return void in some descendants, and the result may share
			-- the internal data with `Current'
		do
			if not operating_system.is_dotnet then
				Result := string_area
			end
		end


feature -- Element change

	put (v: CHARACTER; i: INTEGER) is
			-- Replace character at position `i' by `v'.
		do

			string_put (v, i)



		end


	append_substring_to_string (s, e: INTEGER; a_string: STRING) is
			-- Append string made up of characters held in buffer
			-- between indexes `s' and `e' to `a_string'.

		local
			i, nb: INTEGER
			old_count, new_count: INTEGER
		do
			if s <= e then
				nb := e - s + 1
				old_count := a_string.count
				new_count := old_count + nb
				if new_count > a_string.capacity then
					a_string.resize (new_count)
				end
				a_string.set_count (new_count)
				if a_string.same_type (dummy_string) then
					a_string.subcopy (Current, s, e, old_count + 1)
				else
					from i := s until i > e loop
						a_string.append_character (string_item (i))
						i := i + 1
					end
				end
			end



















		end


	fill_from_string (a_string: STRING; pos: INTEGER) is
			-- Copy characters of `a_string' to buffer
			-- starting at position `pos'.
		local
			nb: INTEGER



		do
			nb := a_string.count
			if nb > 0 then

				area.subcopy (a_string, 1, nb, pos)








			end
		end

	fill_from_stream (a_stream: KI_CHARACTER_INPUT_STREAM; pos, nb: INTEGER): INTEGER is
			-- Fill buffer, starting at position `pos', with
			-- at most `nb' characters read from `a_stream'.
			-- Return the number of characters actually read.
		do



			Result := a_stream.read_to_string (area, pos, nb)

		end

	move_left (old_pos, new_pos: INTEGER; nb: INTEGER) is
			-- Copy `nb' characters from `old_pos' to
			-- `new_pos' in buffer.




		do
			if nb > 0 then

				area.subcopy (Current, old_pos, old_pos + nb - 1, new_pos)









			end
		end

	move_right (old_pos, new_pos: INTEGER; nb: INTEGER) is
			-- Copy `nb' characters from `old_pos' to
			-- `new_pos' in buffer.




		do
			if nb > 0 then

				area.subcopy (Current, old_pos, old_pos + nb - 1, new_pos)








			end
		end

feature -- Resizing

	resize (n: INTEGER) is
			-- Resize buffer so that it contains `n' characters.
			-- Do not lose any previously entered characters.












		do
			string_resize (n)
			set_count (n)















		end

feature {NONE} -- Implementation


	area: STRING is
			-- Implementation
		do
			Result := Current
		end











invariant

	area_not_void: area /= Void




end
