/* Copyright (c) 2001, ISHIKAWA 'pyon' YUICHIRO. All Rigths Reserved. */
/*
 * Copyright (c) 2001, ISHIKAWA 'pyon' YUICHIRO.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   1.Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *
 *   2.Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 *   3.Neither the name of the ISHIKAWA 'pyon' YUICHIRO nor the names of its
 *     contributors may be used to endorse or promote products derived from
 *     this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#include <glib.h>

#include <arpa/inet.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <time.h>

#include "./ipmsg.h"

#define POST	(6210) 

/* Send message */
int
ipmsg_send_msg(IPMsgPacket *msg_packet)
{
  char	*msg;	/* Command of IP Messenger */
  int	rslt;
  int	soc;
  struct in_addr	in_addr;
  struct sockaddr_in	dest_addr;

/*  printf("Function 'ipmsg_send_msg()' in\n"); */

  /* Command string of IP Messenger */
  msg = g_strdup_printf("%d:%li:%s:%s:%li:%s",
	  msg_packet->version,
	  time(NULL),
	  msg_packet->username,
	  msg_packet->hostname,
	  IPMSG_SENDMSG,
	  msg_packet->additional_part);
/*  printf("Msg: %s\n", msg); */

/*  printf("Destination: %s\n", msg_packet->destination_ip); */
  rslt = inet_aton(msg_packet->destination_ip, &in_addr);
  if (rslt == 0)
    return -1;
/*  else
    printf("Success: Convert to IP Address."); */

  soc = socket(PF_INET, SOCK_DGRAM, 0);
  if (socket < 0)
    return -1;
/*  else
    printf("Success: Open socket."); */

  memset(&dest_addr, 0, sizeof(dest_addr));
  dest_addr.sin_family = PF_INET;
  dest_addr.sin_port = htons(POST);
  memcpy(&(dest_addr.sin_addr), &in_addr, sizeof(dest_addr.sin_addr));

  rslt = sendto(soc, msg, (strlen(msg) + 1), 0,
		(struct sockaddr *)&dest_addr,
		sizeof(dest_addr));
  if (rslt < 0)
    return -1;
/*  else
    printf("Success: Send message."); */

/*  printf("Function 'ipmsg_send_msg()' out\n"); */

  g_free(msg);

  return 0;
}
