;;; ignore.scm: ignore messages from bad buddies
;;; author: M.P.Anand Babu <ab@gnu.org.in>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA

;;; example:
;;; define an ignore list like below in your ~/.gnuyahoo/gnuyahoo.scm
;;; (define ignore '(fat_ugly_girl my_wife over_70s))

;;; NOTE:
;;; 'ignore.scm' is dependent on 'history.scm'

(if (defined? 'ignore)
    '()
    (begin
      (define ignore '())))

(define (ignore-buddy from msg)
  "ignore message from buddy"
  (and (list-index ignore (string->symbol from))
       (history "ignore" from msg)
       (gy-send-message-no-hook from "You are ignored")
       (gy-hook-return)))

(add-hook! gy-message-receive-hook ignore-buddy)

;;; Dynamic command with help support
(gy-register-command! '("?ignore" "?ignore ignore-buddy-list\n\t- ignore a list of buddies"))
(define (?ignore args-list)
  (set! ignore (append ignore args-list)))


