/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#include <stdio.h>
#include <stdlib.h>

#include "lib.h"
#include "list.h"

void fre_gl(Gnut_List **x, int bugnum)
{
  GD_S(5, "fre_gl x="); GD_P(5, x); GD_S(5, "\n");

  yfre((void **) x, bugnum);
}

Gnut_List * gnut_list_unlink(Gnut_List *list, void *data, Gnut_List **unlinked)
{
  Gnut_List *tmp;
  Gnut_List *prev;

  GD_S(5, "gnut_list.unlink list="); GD_P(5, list); GD_S(5, " data=");
  GD_P(5, data); GD_S(5, "\n");

  prev = 0;
  tmp = list;
  *unlinked = 0;
  while (tmp) {
    if (tmp->data == data) {
      if (prev) {
	prev->next = tmp->next;
      }

      if (list == tmp) {
	list = list->next;
      }

      *unlinked = tmp;
      break;
    }
    prev = tmp;
    tmp = tmp->next;
  }

  GD_S(5, "gnut_list.unlink new list="); GD_P(5, list); GD_S(5, "\n");

  return list;
}

/* Gnut_List * gnut_list.remove(Gnut_List *list, void *data)
 *
 * removes the first occurence of data in list. It does NOT try
 * to call xfr.ee on the data block.
 * returns the pointer to the new head of the list, does not indicate
 * whether the data was actually found */
int glr_err1 = 0;
Gnut_List * gnut_list_remove(Gnut_List *list, void *data, int tracking_number)
{
  Gnut_List *tmp;
  Gnut_List *prev;
  int flag;

  GD_S(5, "gnut_list.remove list="); GD_P(5, list); GD_S(5, " data=");
  GD_P(5, data); GD_S(5, "\n");

  flag = 0;
  prev = 0;
  tmp = list;
  while (tmp) {
    GD_S(5, "glr prev="); GD_P(5, prev); GD_S(5, " tmp="); GD_P(5, tmp);
    GD_S(5," tmp->next="); GD_P(5, tmp->next); GD_S(5," tmp->data=");
    GD_P(5, tmp->data); GD_S(5, "\n");

    if (tmp->data == data) {
      /* Found it! */
      flag=1;
      /* Remove from list by changing previous element's next-pointer
       * (unless we're the first) */
      if (prev) {
	prev->next = tmp->next;
      }
      /* If we are the first, update our copy of the list head pointer */
      if (list==tmp) {
	list = list->next;
      }

      tmp->next = 0;

      GD_S(5, "glr tmp="); GD_P(5, tmp); GD_S(5, " &tmp=="); GD_P(5, &tmp);
      GD_S(5, "\n");

      fre_gl(&tmp, 151);

      break;
    }
    prev = tmp;
    tmp = tmp->next;
  }

  if (flag == 0) {
    int l;

    l = 0;
    if (glr_err1) {
      l = 1;
    } else {
      glr_err1 = 1;
    }
    GD_S(l, "gnut_list.remove "); GD_I(l, tracking_number);
    GD_S(l, " item not found\n");
  }

  GD_S(5, "gnut_list.remove new list="); GD_P(5, list); GD_S(5, "\n");

  return list;
}
  
/* Gnut_List * gnut_list.prepend(Gnut_List *list, void *data)
 *
 * prepends data into the given list; returns the new head pointer */
Gnut_List * gnut_list_prepend(Gnut_List *list, void *data)
{
  Gnut_List *gltmp;

  GD_S(5, "gnut_list.prepend list="); GD_P(5, list); GD_S(5, " data=");
  GD_P(5, data); GD_S(5, "\n");

  gltmp = (Gnut_List *) ymaloc(sizeof(Gnut_List), 366);
  if (gltmp) {
    gltmp->data = data;
    gltmp->next = list;

    GD_S(5, "gnut_list.prepend  new list="); GD_P(5, gltmp); GD_S(5, "\n");

    return gltmp;
  }
  /* else */
  return list;
}

/* Returns pointer to data of first item in a list */
void * gnut_list_head(Gnut_List *list)
{
  if (list) {
    return(list->data);
  }
  return 0;
}

Gnut_List * gnut_list_append(Gnut_List *list, void *data, int tracking_number)
{
  Gnut_List *gltmp;
  Gnut_List *glnew;

  glnew = (Gnut_List *) ymaloc(sizeof(Gnut_List), tracking_number);
  if (glnew) {
    glnew->data = data;
    glnew->next = 0;

    if (list == 0) {
      return glnew;
    } else {
      gltmp = list;
      while(gltmp->next) {
        gltmp = gltmp->next;
      }
      gltmp->next = glnew;
      return list;
    }
  }
  /* else */
  return list;
}

/* Gnut_List * gnut_list_next(Gnut_List *list)
 *
 * convenience function to return next item in list */
Gnut_List * gnut_list_next(Gnut_List *list)
{
  return list->next;
}

/* void gnut_list.foreach(Gnut_List * list, void (*GFunc)(void *, void *),
         void *userdata)
 
   for each element in list, call GFunc. But if GFunc returns a -1, stop
   walking through the list immediately */
int gnut_list_foreach(Gnut_List *list, int (*GFunc)(void *,void *),
      void *userdata)
{
  Gnut_List *gltmp;
  
  GD_S(5, "gnut_list_foreach list="); GD_P(5, list); GD_S(5, "\n");
  for (gltmp=list; gltmp; gltmp=gltmp->next) {
    if ((*GFunc)(gltmp->data, userdata)==-1) {
      /* callback function told us to stop walking */
      return -1;
    }
  }
  GD_S(5, "gnut_list_foreach returning\n");
  return 0;
}

/* Gnut_List * gnut_list.fre(Gnut_List *list)
 *
 * fr.ee all list items and deal.locate (xfr.ee) all data blocks
 * in a list; return a null head pointer */
Gnut_List * gnut_list_fre(Gnut_List *list)
{
  Gnut_List *gltmp, *gltmp2;

  GD_S(5, "gnut_list.fre list="); GD_P(5, list); GD_S(5, "\n");
  for (gltmp=list; gltmp; gltmp=gltmp2) {
    GD_S(5, "gnut_list_fre gltmp="); GD_P(5, gltmp); GD_S(5, " gltmp->next=");
    GD_P(5, gltmp->next); GD_S(5, "\n");

    gltmp2 = gltmp->next;
    fre_v(&(gltmp->data), 152);
    fre_gl(&gltmp, 153);
  }
  
  GD_S(5, "gnut_list.fre returning\n");
  return 0;
}

/* int gnut_list_size(Gnut_List *list)
 *
 * returns the number of items stored in list */
int gnut_list_size(Gnut_List *list)
{
  Gnut_List *glt;
  int i;

  GD_S(5, "gnut_list_size list="); GD_P(5, list); GD_S(5, "\n");

  for (i=0,glt=list; glt; glt=glt->next) {
    GD_S(5, "gnut_list_size i="); GD_I(5, i); GD_S(5, " glt="); GD_P(5, glt);
    GD_S(5, " glt->next="); GD_P(5, glt->next); GD_S(5, "\n");
    i++;
  }

  GD_S(5, "gnut_list_size returning: "); GD_I(5, i); GD_S(5, "\n");

  return i;
}

/* gnut_list_seek looks through a list to see if a given void * data
 * is in the list. */
int gnut_list_seek(Gnut_List *list, void *dat)
{
  int rv;
  Gnut_List *glt;

  rv = 0;
  glt = list;
  while(glt && (rv == 0)) {
    if (glt->data == dat) {
      rv = 1;
    } else {
      glt = glt->next;
    }
  }

  return rv;
}
