/* Josh Pieper, (c) 2000 */

/* This file is distributed under the GPL, see file COPYING for details */

#ifndef GNUT_CONNECTION_H
#define GNUT_CONNECTION_H

#include "td.h"
#include "lib.h"
#include "queue.h"
#include "host.h"
#include "protocol.h"
#include "threads.h"

extern pthread_mutex_t  query_packet_mutex;
extern pthread_mutex_t  qrepl_mutex;

#define TYPE_UNSPEC 0
#define TYPE_OUTGOING  1
#define TYPE_INCOMING  2

#define TYPE_UPLOAD 1
#define TYPE_DOWNLOAD 2
#define TYPE_SEND_PUSH 3
#define TYPE_RECV_PUSH 4

#define STATE_UNCON -1

#define STATE_CONNECTING 1
#define STATE_NEGOTIATING 2
#define STATE_CONNECTED 3
#define STATE_CLEANABLE 4
#define STATE_DEAD 5
#define STATE_ERROR 6
#define STATE_QUEUED 7
#define STATE_RETRY_WAIT 8

#define BACKLOG_MAX 100
#define BAD_PACKET_MAX 100

#ifdef __cplusplus
extern "C" {
#endif

  extern uint32 con_num_queries;
  extern uint32 con_num_responses;
  extern uint32 con_num_messages;
  extern uint32 con_num_sent;

  void fre_gc(gcs **x, int bugnum);
  int send_to_one(gcs *gc, gnutella_packet *gpa);
  int send_to_all(gnutella_packet *gpa);
  int send_to_all_except(gcs *gc, gnutella_packet *gpa, int no_drop);

  int gnut_connection_net_totals(uint32 *messages, uint32 *sent,
				 float64 *rcv_bytes, float64 *snt_bytes,
				 float64 *blacklisted);

  gcs * gnut_connection_new();
  int gnut_connection_delete(gcs *gc);
  int connection_loop(gcs *gc);
  int gnut_connection_find(uchar ip[4], uint16 port);
  int gnut_connection_find_ptr(gcs *);
  /* need connection enumeration functions */

  int gnut_connection_enumerate( int (*a)(gcs *));
  int gnut_connection_num();
  int gnut_connection_kill_oldest();
  long droprate(long drop, long recv);
  int gnut_connection_kill_worst(int interact);

  int eqhd_flageval(uint8 validbyte, uint8 flagbyte, uint8 mask);
  void parse_eqhd(uint8 *einfo, int32 infolen,
		  uint8 *ip, uint32 speed,
		  int16 *type, int16 *rating);
  char name_tok_cb(GnutSearch *s, void *data);
  int connection_handle_packet(gcs *gc, gnutella_packet *gpa);

#ifdef __cplusplus
}
#endif

#endif
